/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.integration.test.unit.internal;

import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.platform.discovery.core.api.ISearchContext;
import org.eclipse.platform.discovery.core.internal.ContextStructuredSelection;
import org.eclipse.platform.discovery.integration.internal.viewcustomization.IConfigurableContributedAction;
import org.eclipse.platform.discovery.integration.internal.viewcustomization.SaveInFavoritesMenuAction;
import org.eclipse.platform.discovery.runtime.api.ISearchParameters;
import org.eclipse.platform.discovery.testutils.utils.jmock.Mock;
import org.eclipse.platform.discovery.testutils.utils.jmock.MockObjectTestCase;
import org.eclipse.platform.discovery.ui.api.ISearchFavoritesViewCustomization;
import org.eclipse.platform.discovery.util.api.env.IDiscoveryEnvironment;
import org.eclipse.platform.discovery.util.api.env.IErrorHandler;
import org.eclipse.platform.discovery.util.api.longop.ILongOperationRunner;
import org.jmock.core.Constraint;

public class SaveInFavoritesMenuActionTest
extends MockObjectTestCase {
    private SaveInFavoritesMenuAction action;
    private Mock<IConfigurableContributedAction> contributedAction;
    private IStructuredSelection selection;
    private Mock<ISearchContext> searchContext;
    private Mock<IDiscoveryEnvironment> environment;
    private Mock<ILongOperationRunner> operationRunner;
    private Mock<IErrorHandler> errorHandler;
    private Mock<ISearchParameters> searchParams;
    private Object objectToAdd;
    private Mock<ISearchFavoritesViewCustomization> sbCustomization;

    protected void setUp() throws Exception {
        this.objectToAdd = new Object();
        this.searchParams = this.mock(ISearchParameters.class);
        this.searchContext = this.mock(ISearchContext.class);
        this.searchContext.stubs().method("searchParameters").will(this.returnValue(this.searchParams.proxy()));
        this.selection = new ContextStructuredSelection(Arrays.asList(this.objectToAdd), (ISearchContext)this.searchContext.proxy());
        this.sbCustomization = this.mock(ISearchFavoritesViewCustomization.class);
        this.sbCustomization.stubs().method("itemsFor").with((Constraint)this.eq(this.objectToAdd)).will(this.returnValue(new HashSet<Object>(Arrays.asList(this.objectToAdd))));
        this.operationRunner = this.mock(ILongOperationRunner.class);
        this.errorHandler = this.mock(IErrorHandler.class);
        this.environment = this.mock(IDiscoveryEnvironment.class);
        this.environment.stubs().method("operationRunner").will(this.returnValue(this.operationRunner.proxy()));
        this.environment.stubs().method("errorHandler").will(this.returnValue(this.errorHandler.proxy()));
        this.contributedAction = this.mock(IConfigurableContributedAction.class);
        this.setupMenuAction();
    }

    private void setupMenuAction() {
        this.action = new SaveInFavoritesMenuAction((IConfigurableContributedAction)this.contributedAction.proxy(), (ISelection)this.selection, (ISearchContext)this.searchContext.proxy(), Arrays.asList((ISearchFavoritesViewCustomization)this.sbCustomization.proxy()), (IDiscoveryEnvironment)this.environment.proxy());
    }

    public void testIsAvailable() {
        SaveInFavoritesMenuActionTest.assertTrue((boolean)this.action.isAvailable());
        this.sbCustomization.reset();
        this.sbCustomization.stubs().method("itemsFor").with((Constraint)this.eq(this.objectToAdd)).will(this.returnValue(new HashSet()));
        SaveInFavoritesMenuActionTest.assertFalse((boolean)this.action.isAvailable());
    }

    public void testAddItems() {
        this.contributedAction.expects(this.once()).method("setErrorHandler").with((Constraint)this.eq(this.errorHandler.proxy()));
        this.contributedAction.expects(this.once()).method("setSearchContext").with((Constraint)this.eq(this.searchContext.proxy()));
        this.contributedAction.expects(this.once()).method("perform").with((Constraint)this.eq(this.operationRunner.proxy()), (Constraint)this.collectionContaining(this.objectToAdd));
        this.action.run();
    }
}

