/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.databinding.observable;

import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.ChangeSupport;
import org.eclipse.core.databinding.observable.DisposeEvent;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.ObservableTracker;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.StaleEvent;
import org.eclipse.core.runtime.Assert;

public abstract class AbstractObservable
extends ChangeSupport
implements IObservable {
    private final Realm realm;
    private boolean disposed = false;

    public AbstractObservable(Realm realm) {
        Assert.isNotNull((Object)realm, (String)"Realm cannot be null");
        this.realm = realm;
        ObservableTracker.observableCreated(this);
    }

    public Realm getRealm() {
        return this.realm;
    }

    protected void fireChange() {
        this.checkRealm();
        if (this.genericListenerList != null) {
            this.genericListenerList.fireEvent(new ChangeEvent(this));
        }
    }

    protected void fireStale() {
        this.checkRealm();
        if (this.staleListenerList != null) {
            this.staleListenerList.fireEvent(new StaleEvent(this));
        }
    }

    public synchronized boolean isDisposed() {
        return this.disposed;
    }

    public synchronized void dispose() {
        if (!this.disposed) {
            this.disposed = true;
            this.fireDispose(new DisposeEvent(this));
            this.genericListenerList = null;
            this.staleListenerList = null;
            this.disposeListenerList = null;
        }
    }

    protected void checkRealm() {
        Assert.isTrue((boolean)this.getRealm().isCurrent(), (String)"This operation must be run within the observable's realm");
    }
}

