/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.examples.ui.midi.adapters;

import javax.sound.midi.Sequencer;
import javax.sound.midi.Track;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.examples.core.midi.launcher.ClockControl;
import org.eclipse.debug.examples.core.midi.launcher.LengthControl;
import org.eclipse.debug.examples.core.midi.launcher.MidiLaunch;
import org.eclipse.debug.examples.core.midi.launcher.SequencerControl;
import org.eclipse.debug.examples.core.midi.launcher.TempoControl;
import org.eclipse.debug.internal.ui.model.elements.ElementContentProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdate;

public class SequencerContentProvider
extends ElementContentProvider {
    protected int getChildCount(Object element, IPresentationContext context, IViewerUpdate monitor) throws CoreException {
        if ("org.eclipse.debug.ui.DebugView".equals(context.getId())) {
            return this.getTracks((MidiLaunch)element).length;
        }
        if ("org.eclipse.debug.ui.VariableView".equals(context.getId())) {
            if (((MidiLaunch)element).isTerminated()) {
                return 0;
            }
            return 3;
        }
        return 0;
    }

    protected Object[] getChildren(Object parent, int index, int length, IPresentationContext context, IViewerUpdate monitor) throws CoreException {
        if ("org.eclipse.debug.ui.DebugView".equals(context.getId())) {
            return this.getElements(this.getTracks((MidiLaunch)parent), index, length);
        }
        if ("org.eclipse.debug.ui.VariableView".equals(context.getId())) {
            return this.getElements(this.getControls((MidiLaunch)parent), index, length);
        }
        return EMPTY;
    }

    public SequencerControl[] getControls(MidiLaunch launch) {
        return new SequencerControl[]{new TempoControl(launch), new ClockControl(launch), new LengthControl(launch)};
    }

    public Track[] getTracks(MidiLaunch launch) {
        Sequencer sequencer = launch.getSequencer();
        if (sequencer != null && sequencer.isOpen()) {
            return sequencer.getSequence().getTracks();
        }
        return new Track[0];
    }

    protected boolean supportsContextId(String id) {
        return "org.eclipse.debug.ui.DebugView".equals(id) || "org.eclipse.debug.ui.VariableView".equals(id);
    }
}

