/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.contextlaunching;

import com.ibm.icu.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchesListener;
import org.eclipse.debug.core.ILaunchesListener2;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.ILaunchHistoryChangedListener;
import org.eclipse.debug.internal.ui.ILaunchLabelChangedListener;
import org.eclipse.debug.internal.ui.contextlaunching.ContextMessages;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationManager;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchShortcutExtension;
import org.eclipse.debug.internal.ui.stringsubstitution.SelectedResourceManager;
import org.eclipse.debug.ui.ILaunchGroup;
import org.eclipse.jface.action.CoolBarManager;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ToolBarContributionItem;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.activities.WorkbenchActivityHelper;
import org.eclipse.ui.internal.WorkbenchWindow;

public class LaunchingResourceManager
implements IPropertyChangeListener,
IWindowListener,
ISelectionListener,
ILaunchHistoryChangedListener,
ILaunchesListener2 {
    private ListenerList fLabelListeners = new ListenerList();
    private HashMap fToolbars = new HashMap();
    private HashMap fCurrentLabels = new HashMap();
    private boolean fUpdateLabel = true;
    private HashSet fWindows = new HashSet();
    private HashMap fConfigCache = new HashMap();
    private HashMap fExtCache = new HashMap();
    private static final String EMPTY_STRING = "";
    private MouseTrackAdapter fMouseListener = new MouseTrackAdapter(){

        public void mouseEnter(MouseEvent e) {
            if (LaunchingResourceManager.this.fUpdateLabel) {
                LaunchingResourceManager.this.fUpdateLabel = false;
                LaunchingResourceManager.this.fCurrentLabels.clear();
                Job job = new Job(this, "Compute launch button tooltip"){
                    final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    protected IStatus run(IProgressMonitor monitor) {
                        1.access$0(this.this$1).computeLabels();
                        LaunchingResourceManager.access$3(1.access$0(this.this$1)).clear();
                        LaunchingResourceManager.access$4(1.access$0(this.this$1)).clear();
                        return Status.OK_STATUS;
                    }
                };
                job.setSystem(true);
                job.schedule();
            }
        }

        static /* synthetic */ LaunchingResourceManager access$0(1 var0) {
            return var0.LaunchingResourceManager.this;
        }
    };

    public static boolean isContextLaunchEnabled() {
        return DebugUIPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.debug.ui.UseContextualLaunch");
    }

    public static boolean isContextLaunchEnabled(String launchgroupid) {
        return LaunchingResourceManager.isContextLaunchEnabled() && !"org.eclipse.ui.externaltools.launchGroup".equals(launchgroupid);
    }

    public void addLaunchLabelUpdateListener(ILaunchLabelChangedListener listener) {
        this.fLabelListeners.add((Object)listener);
    }

    public void removeLaunchLabelChangedListener(ILaunchLabelChangedListener listener) {
        this.fLabelListeners.remove((Object)listener);
    }

    public String getLaunchLabel(ILaunchGroup group) {
        return (String)this.fCurrentLabels.get(group);
    }

    protected boolean shouldCheckParent() {
        return DebugUIPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.debug.ui.LaunchParentProject");
    }

    protected boolean shouldLaunchLast() {
        return DebugUIPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.debug.ui.LaunchLastIfNotLaunchable");
    }

    protected void computeLabels() {
        ILaunchGroup group = null;
        ILaunchConfiguration config = null;
        String label = null;
        Object[] listeners = this.fLabelListeners.getListeners();
        SelectedResourceManager srm = SelectedResourceManager.getDefault();
        IStructuredSelection selection = srm.getCurrentSelection();
        List shortcuts = null;
        IResource resource = srm.getSelectedResource();
        int i = 0;
        while (i < listeners.length) {
            group = ((ILaunchLabelChangedListener)listeners[i]).getLaunchGroup();
            if (group != null) {
                if (LaunchingResourceManager.isContextLaunchEnabled(group.getIdentifier())) {
                    shortcuts = this.getShortcutsForSelection(selection, group.getMode());
                    if (resource == null) {
                        resource = this.getLaunchableResource(shortcuts, selection);
                    }
                    label = this.getLabel(selection, resource, shortcuts, group);
                } else {
                    config = DebugUIPlugin.getDefault().getLaunchConfigurationManager().getFilteredLastLaunch(group.getIdentifier());
                    if (config != null) {
                        label = this.appendLaunched(config);
                    }
                }
                this.fCurrentLabels.put(group, label);
                label = null;
            }
            ++i;
        }
        this.notifyLabelChanged();
    }

    protected void notifyLabelChanged() {
        Object[] listeners = this.fLabelListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((ILaunchLabelChangedListener)listeners[i]).labelChanged();
            ++i;
        }
    }

    private String appendLaunched(ILaunchConfiguration config) {
        ILaunch[] launches = DebugPlugin.getDefault().getLaunchManager().getLaunches();
        boolean launched = false;
        ILaunchConfiguration tmp = null;
        int i = 0;
        while (i < launches.length) {
            tmp = launches[i].getLaunchConfiguration();
            if (tmp != null && !launches[i].isTerminated() && tmp.equals(config)) {
                launched = true;
                break;
            }
            ++i;
        }
        if (launched) {
            return MessageFormat.format((String)ContextMessages.LaunchingResourceManager_0, (Object[])new String[]{config.getName()});
        }
        return config.getName();
    }

    protected String getlastLaunchedLabel(ILaunchGroup group) {
        ILaunchConfiguration config = DebugUIPlugin.getDefault().getLaunchConfigurationManager().getFilteredLastLaunch(group.getIdentifier());
        if (config != null) {
            return this.appendLaunched(config);
        }
        return EMPTY_STRING;
    }

    protected String getLabel(IStructuredSelection selection, IResource resource, List shortcuts, ILaunchGroup group) {
        int esize;
        List sc = this.pruneShortcuts(shortcuts, resource, group.getMode());
        LaunchConfigurationManager lcm = DebugUIPlugin.getDefault().getLaunchConfigurationManager();
        ILaunchConfiguration config = lcm.isSharedConfig(resource);
        if (config != null) {
            return this.appendLaunched(config);
        }
        List configs = this.getParticipatingLaunchConfigurations(selection, resource, sc, group.getMode());
        int csize = configs.size();
        if (csize == 1) {
            return this.appendLaunched((ILaunchConfiguration)configs.get(0));
        }
        if (csize > 1) {
            config = lcm.getMRUConfiguration(configs, group, resource);
            if (config != null) {
                return this.appendLaunched(config);
            }
            return ContextMessages.ContextRunner_14;
        }
        List exts = (List)this.fExtCache.get(resource);
        if (exts == null && resource != null) {
            this.fExtCache.put(resource, sc);
        }
        if ((esize = sc.size()) == 0) {
            if (resource != null && this.shouldCheckParent()) {
                IProject project = resource.getProject();
                if (project != null && !project.equals((Object)resource)) {
                    return this.getLabel(selection, (IResource)project, sc, group);
                }
            } else {
                if (this.shouldLaunchLast() || resource == null) {
                    return this.getlastLaunchedLabel(group);
                }
                return ContextMessages.ContextRunner_15;
            }
        }
        if (esize == 1) {
            if (resource != null) {
                return resource.getName();
            }
            return MessageFormat.format((String)ContextMessages.LaunchingResourceManager_1, (Object[])new String[]{((LaunchShortcutExtension)sc.get(0)).getLabel()});
        }
        return ContextMessages.ContextRunner_14;
    }

    protected List pruneShortcuts(List shortcuts, IResource resource, String mode) {
        List list = new ArrayList(shortcuts);
        if (resource == null) {
            LaunchShortcutExtension ext = null;
            ListIterator iter = list.listIterator();
            while (iter.hasNext()) {
                ext = (LaunchShortcutExtension)iter.next();
                if (ext.isParticipant()) continue;
                iter.remove();
            }
        } else {
            list = this.getShortcutsForSelection((IStructuredSelection)new StructuredSelection((Object)resource), mode);
        }
        return list;
    }

    public IResource getLaunchableResource(List shortcuts, IStructuredSelection selection) {
        if (selection != null && !selection.isEmpty()) {
            ArrayList<IResource> resources = new ArrayList<IResource>();
            IResource resource = null;
            Object o = selection.getFirstElement();
            LaunchShortcutExtension ext = null;
            Iterator iter = shortcuts.iterator();
            while (iter.hasNext()) {
                ext = (LaunchShortcutExtension)iter.next();
                resource = o instanceof IEditorPart ? ext.getLaunchableResource((IEditorPart)o) : ext.getLaunchableResource((ISelection)selection);
                if (resource == null || resources.contains(resource)) continue;
                resources.add(resource);
                resource = null;
            }
            if (resources.size() > 0) {
                return (IResource)resources.get(0);
            }
        }
        return null;
    }

    public List getShortcutsForSelection(IStructuredSelection selection, String mode) {
        ArrayList<LaunchShortcutExtension> list = new ArrayList<LaunchShortcutExtension>();
        List sc = DebugUIPlugin.getDefault().getLaunchConfigurationManager().getLaunchShortcuts();
        ArrayList<IEditorInput> ctxt = new ArrayList<IEditorInput>();
        ctxt.addAll(selection.toList());
        Object o = selection.getFirstElement();
        if (o instanceof IEditorPart) {
            ctxt.set(0, ((IEditorPart)o).getEditorInput());
        }
        EvaluationContext context = new EvaluationContext(null, ctxt);
        context.addVariable("selection", ctxt);
        LaunchShortcutExtension ext = null;
        Iterator iter = sc.iterator();
        while (iter.hasNext()) {
            ext = (LaunchShortcutExtension)iter.next();
            try {
                if (!ext.evalEnablementExpression((IEvaluationContext)context, ext.getContextualLaunchEnablementExpression()) || !ext.getModes().contains(mode) || WorkbenchActivityHelper.filterItem((Object)ext) || list.contains(ext)) continue;
                list.add(ext);
            }
            catch (CoreException coreException) {}
        }
        return list;
    }

    public List getParticipatingLaunchConfigurations(IStructuredSelection selection, IResource resource, List shortcuts, String mode) {
        HashSet<ILaunchConfiguration> configs = new HashSet<ILaunchConfiguration>();
        int voteDefault = 0;
        if (selection != null) {
            Object o = selection.getFirstElement();
            LaunchShortcutExtension ext = null;
            ILaunchConfiguration[] cfgs = null;
            int i = 0;
            while (i < shortcuts.size()) {
                ext = (LaunchShortcutExtension)shortcuts.get(i);
                cfgs = o instanceof IEditorPart ? ext.getLaunchConfigurations((IEditorPart)o) : ext.getLaunchConfigurations((ISelection)selection);
                if (cfgs == null) {
                    Set types = ext.getAssociatedConfigurationTypes();
                    this.addAllToList(configs, DebugUIPlugin.getDefault().getLaunchConfigurationManager().getApplicableLaunchConfigurations(types.toArray(new String[types.size()]), resource));
                    ++voteDefault;
                } else if (cfgs.length > 0) {
                    int j = 0;
                    while (j < cfgs.length) {
                        configs.add(cfgs[j]);
                        ++j;
                    }
                }
                ++i;
            }
        }
        if (voteDefault == shortcuts.size()) {
            this.addAllToList(configs, DebugUIPlugin.getDefault().getLaunchConfigurationManager().getApplicableLaunchConfigurations(null, resource));
        }
        Iterator iterator = configs.iterator();
        while (iterator.hasNext()) {
            ILaunchConfiguration config = (ILaunchConfiguration)iterator.next();
            try {
                Set modes = config.getModes();
                modes.add(mode);
                if (config.getType().supportsModeCombination(modes)) continue;
                iterator.remove();
            }
            catch (CoreException coreException) {}
        }
        return new ArrayList(configs);
    }

    private void addAllToList(Collection list, Object[] values) {
        if (list == null || values == null) {
            return;
        }
        int i = 0;
        while (i < values.length) {
            list.add(values[i]);
            ++i;
        }
    }

    public void startup() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench != null) {
            workbench.addWindowListener((IWindowListener)this);
            IWorkbenchWindow[] workbenchWindows = workbench.getWorkbenchWindows();
            int i = 0;
            while (i < workbenchWindows.length) {
                this.windowOpened(workbenchWindows[i]);
                ++i;
            }
        }
        DebugUIPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        DebugUIPlugin.getDefault().getLaunchConfigurationManager().addLaunchHistoryListener(this);
        DebugPlugin.getDefault().getLaunchManager().addLaunchListener((ILaunchesListener)this);
    }

    public void shutdown() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench != null) {
            workbench.removeWindowListener((IWindowListener)this);
        }
        DebugUIPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        DebugUIPlugin.getDefault().getLaunchConfigurationManager().removeLaunchHistoryListener(this);
        DebugPlugin.getDefault().getLaunchManager().removeLaunchListener((ILaunchesListener)this);
        Iterator iter = this.fWindows.iterator();
        while (iter.hasNext()) {
            ((IWorkbenchWindow)iter.next()).getSelectionService().removeSelectionListener((ISelectionListener)this);
        }
        IWorkbenchWindow window = null;
        this.fUpdateLabel = false;
        Iterator iter2 = this.fToolbars.keySet().iterator();
        while (iter2.hasNext()) {
            window = (IWorkbenchWindow)iter2.next();
            final ToolBar bar = (ToolBar)this.fToolbars.get(window);
            if (bar == null || bar.isDisposed()) continue;
            final MouseTrackAdapter listener = this.fMouseListener;
            DebugUIPlugin.getStandardDisplay().asyncExec(new Runnable(){

                public void run() {
                    bar.removeMouseTrackListener((MouseTrackListener)listener);
                }
            });
        }
        this.fWindows.clear();
        this.fToolbars.clear();
        this.fLabelListeners.clear();
        this.fCurrentLabels.clear();
    }

    public void windowActivated(IWorkbenchWindow window) {
        if (!this.fToolbars.containsKey(window)) {
            this.addMouseListener(window);
        }
    }

    public void windowClosed(IWorkbenchWindow window) {
        ToolBar bar = (ToolBar)this.fToolbars.remove(window);
        if (bar != null && !bar.isDisposed()) {
            bar.removeMouseTrackListener((MouseTrackListener)this.fMouseListener);
        }
        if (this.fWindows.remove(window)) {
            window.getSelectionService().removeSelectionListener((ISelectionListener)this);
        }
    }

    public void windowDeactivated(IWorkbenchWindow window) {
    }

    public void windowOpened(IWorkbenchWindow window) {
        if (this.fWindows.add(window)) {
            window.getSelectionService().addSelectionListener((ISelectionListener)this);
        }
    }

    private void addMouseListener(IWorkbenchWindow window) {
        ToolBarManager tmgr;
        ToolBar bar;
        IContributionItem item;
        CoolBarManager cmgr = ((WorkbenchWindow)window).getCoolBarManager();
        if (cmgr != null && (item = cmgr.find("org.eclipse.debug.ui.launchActionSet")) instanceof ToolBarContributionItem && (bar = (tmgr = (ToolBarManager)((ToolBarContributionItem)item).getToolBarManager()).getControl()) != null && !bar.isDisposed()) {
            bar.addMouseTrackListener((MouseTrackListener)this.fMouseListener);
            this.fToolbars.put(window, bar);
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("org.eclipse.debug.ui.UseContextualLaunch") || event.getProperty().equals("org.eclipse.debug.ui.LaunchLastIfNotLaunchable")) {
            if (LaunchingResourceManager.isContextLaunchEnabled()) {
                this.windowActivated(DebugUIPlugin.getActiveWorkbenchWindow());
            }
            this.fUpdateLabel = true;
        }
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (LaunchingResourceManager.isContextLaunchEnabled()) {
            this.fUpdateLabel = true;
        }
    }

    public void launchHistoryChanged() {
        this.fUpdateLabel = true;
    }

    public void launchesTerminated(ILaunch[] launches) {
        this.fUpdateLabel = true;
    }

    public void launchesAdded(ILaunch[] launches) {
        this.fUpdateLabel = true;
    }

    public void launchesChanged(ILaunch[] launches) {
    }

    public void launchesRemoved(ILaunch[] launches) {
        int i = 0;
        while (i < launches.length) {
            if (!launches[i].isTerminated()) {
                this.fUpdateLabel = true;
                return;
            }
            ++i;
        }
    }

    static /* synthetic */ HashMap access$3(LaunchingResourceManager launchingResourceManager) {
        return launchingResourceManager.fConfigCache;
    }

    static /* synthetic */ HashMap access$4(LaunchingResourceManager launchingResourceManager) {
        return launchingResourceManager.fExtCache;
    }
}

