/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.jmx.internal.client.ui.mbeaninfoview;

import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import org.eclipse.equinox.jmx.common.ContributionProxy;
import org.eclipse.equinox.jmx.internal.client.ui.invocationView.InvocationView;
import org.eclipse.equinox.jmx.internal.client.ui.mbeaninfoview.MBeanInfoViewMessages;
import org.eclipse.equinox.jmx.internal.client.ui.mbeaninfoview.MBeanInfoViewPart;
import org.eclipse.equinox.jmx.internal.client.ui.viewsupport.ViewUtil;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IWorkbenchPart;

public class MBeanOpTable {
    private TableViewer fViewer;

    public MBeanOpTable(Composite parent, final MBeanInfoViewPart beanView) {
        Table opTable = beanView.getToolkit().createTable(parent, 8456964);
        this.createColumns(opTable);
        opTable.setLayoutData((Object)new GridData(1808));
        opTable.setLinesVisible(true);
        opTable.setHeaderVisible(true);
        opTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.item == null || e.item.getData() == null) {
                    return;
                }
                InvocationView view = ViewUtil.getInvocationView();
                view.selectionChanged((IWorkbenchPart)beanView, (ISelection)new StructuredSelection(e.item.getData()));
            }
        });
        this.fViewer = new TableViewer(opTable);
        this.fViewer.setContentProvider((IContentProvider)new MBeanOpContentProvider());
        this.fViewer.setLabelProvider((IBaseLabelProvider)new MBeanOpLabelProvider());
        this.fViewer.addFilter((ViewerFilter)new MBeanOpViewerFilter());
    }

    private void createColumns(final Table opTable) {
        TableColumn blankCol = new TableColumn(opTable, 0);
        blankCol.setText("");
        blankCol.setWidth(20);
        final TableColumn returnType = new TableColumn(opTable, 0);
        returnType.setText(MBeanInfoViewMessages.MBeanOpTable_returnType);
        returnType.setWidth(100);
        final TableColumn opName = new TableColumn(opTable, 0);
        opName.setText(MBeanInfoViewMessages.MBeanOpTable_name);
        opName.setWidth(150);
        final TableColumn params = new TableColumn(opTable, 0);
        params.setText(MBeanInfoViewMessages.MBeanOpTable_params);
        params.setWidth(300);
        Listener sortListener = new Listener(){

            public void handleEvent(Event e) {
                int colIndex;
                TableColumn sortColumn = opTable.getSortColumn();
                TableColumn currentColumn = (TableColumn)e.widget;
                int dir = opTable.getSortDirection();
                if (sortColumn == currentColumn) {
                    dir = dir == 128 ? 1024 : 128;
                } else {
                    opTable.setSortColumn(currentColumn);
                    dir = 128;
                }
                if (currentColumn == returnType) {
                    colIndex = 1;
                } else if (currentColumn == opName) {
                    colIndex = 2;
                } else if (currentColumn == params) {
                    colIndex = 3;
                } else {
                    return;
                }
                opTable.setSortDirection(dir);
                MBeanOpTable.this.fViewer.setSorter((ViewerSorter)new MBeanOpViewerSorter(dir, colIndex));
            }
        };
        returnType.addListener(13, sortListener);
        opName.addListener(13, sortListener);
        params.addListener(13, sortListener);
        opTable.setSortColumn(opName);
        opTable.setSortDirection(128);
    }

    protected void setInput(ContributionProxy input) {
        if (input == null || input.getMBeanInfo() == null) {
            this.fViewer.setInput(null);
        } else {
            this.fViewer.setInput((Object)input.getMBeanInfo().getOperations());
        }
    }

    protected class MBeanOpContentProvider
    implements IStructuredContentProvider {
        private MBeanOperationInfo[] fOps;

        protected MBeanOpContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (this.fOps == null) {
                return new Object[0];
            }
            return this.fOps;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.fOps = (MBeanOperationInfo[])newInput;
        }
    }

    protected class MBeanOpLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        protected MBeanOpLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (!(element instanceof MBeanOperationInfo)) {
                return super.getText(element);
            }
            MBeanOperationInfo info = (MBeanOperationInfo)element;
            switch (columnIndex) {
                case 0: {
                    return "";
                }
                case 1: {
                    return info.getReturnType() != null ? info.getReturnType() : "void";
                }
                case 2: {
                    return info.getName();
                }
                case 3: {
                    MBeanParameterInfo[] params = info.getSignature();
                    StringBuffer sb = new StringBuffer();
                    int j = 0;
                    while (j < params.length) {
                        String type = params[j].getType();
                        if (j != 0) {
                            sb.append(", ");
                        }
                        sb.append(type);
                        sb.append('(');
                        sb.append(params[j].getName());
                        sb.append(')');
                        ++j;
                    }
                    return sb.toString();
                }
            }
            return this.getText(element);
        }
    }

    protected class MBeanOpViewerFilter
    extends ViewerFilter {
        protected MBeanOpViewerFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof MBeanOperationInfo) {
                MBeanOperationInfo info = (MBeanOperationInfo)element;
                return !info.getName().equals("getChildContributions") && !info.getName().equals("createProxy");
            }
            return false;
        }
    }

    protected class MBeanOpViewerSorter
    extends ViewerSorter {
        int fDirection;
        int fIndex;

        protected MBeanOpViewerSorter(int direction, int index) {
            this.fDirection = direction == 128 ? -1 : 1;
            this.fIndex = index;
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            if (e1 instanceof MBeanOperationInfo && e2 instanceof MBeanOperationInfo) {
                MBeanOperationInfo op1 = (MBeanOperationInfo)e1;
                MBeanOperationInfo op2 = (MBeanOperationInfo)e2;
                switch (this.fIndex) {
                    case 1: {
                        String a1 = op1.getReturnType();
                        String a2 = op2.getReturnType();
                        int p = a1.lastIndexOf(46);
                        if (p != -1) {
                            a1 = a1.substring(p + 1);
                        }
                        if ((p = a2.lastIndexOf(46)) != -1) {
                            a2 = a2.substring(p + 1);
                        }
                        return this.fDirection * a1.compareTo(a2);
                    }
                    case 2: {
                        return this.fDirection * op1.getName().compareTo(op2.getName());
                    }
                    case 3: {
                        MBeanParameterInfo[] info1 = op1.getSignature();
                        MBeanParameterInfo[] info2 = op2.getSignature();
                        if (info2.length == 0) {
                            return this.fDirection;
                        }
                        if (info1.length == 0) {
                            return -this.fDirection;
                        }
                        return this.fDirection * info1[0].getType().compareTo(info2[0].getType());
                    }
                }
            }
            return this.fDirection * super.compare(viewer, e1, e2);
        }
    }
}

