/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.internal.repository.comparator;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.internal.p2.publisher.eclipse.FeatureParser;
import org.eclipse.equinox.p2.internal.repository.comparator.java.ClassFormatException;
import org.eclipse.equinox.p2.internal.repository.comparator.java.Disassembler;
import org.eclipse.equinox.p2.internal.repository.comparator.java.Messages;
import org.eclipse.equinox.p2.internal.repository.comparator.java.Utility;
import org.eclipse.equinox.p2.publisher.eclipse.Feature;
import org.eclipse.equinox.p2.publisher.eclipse.FeatureEntry;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.tools.comparator.IArtifactComparator;
import org.eclipse.osgi.util.NLS;

public class JarComparator
implements IArtifactComparator {
    private static final String LINE_SEPARATOR = "\n";
    private static final String CLASS_EXTENSION = ".class";
    private static final String JAR_EXTENSION = ".jar";
    private static final String PROPERTIES_EXTENSION = ".properties";
    private static final String MAPPINGS_EXTENSION = ".mappings";
    private static final String PLUGIN_ID = "org.eclipse.equinox.p2.repository.tools";
    private static final String DESTINATION_ARTIFACT_PREFIX = "destinationartifact";
    private static final String SUFFIX_JAR = ".jar";
    private static final String SOURCE_ARTIFACT_PREFIX = "sourceartifact";
    private static final String OSGI_BUNDLE_CLASSIFIER = "osgi.bundle";
    private static final String FEATURE_CLASSIFIER = "org.eclipse.update.feature";
    private static final String META_INF = "meta-inf/";
    private static final String DSA_EXT = ".dsa";
    private static final String RSA_EXT = ".rsa";
    private static final String SF_EXT = ".sf";
    private String sourceLocation;
    private String destinationLocation;
    private String descriptorString;

    public IStatus compare(IArtifactRepository source, IArtifactDescriptor sourceDescriptor, IArtifactRepository destination, IArtifactDescriptor destinationDescriptor) {
        String classifier2;
        this.sourceLocation = URIUtil.toUnencodedString((URI)sourceDescriptor.getRepository().getLocation());
        this.destinationLocation = URIUtil.toUnencodedString((URI)destinationDescriptor.getRepository().getLocation());
        this.descriptorString = sourceDescriptor.toString();
        String classifier1 = sourceDescriptor.getArtifactKey().getClassifier();
        if (!classifier1.equals(classifier2 = destinationDescriptor.getArtifactKey().getClassifier()) || !OSGI_BUNDLE_CLASSIFIER.equals(classifier1) && !FEATURE_CLASSIFIER.equals(classifier1)) {
            return Status.OK_STATUS;
        }
        File firstTempFile = null;
        File secondTempFile = null;
        try {
            firstTempFile = this.getLocalJarFile(source, sourceDescriptor, SOURCE_ARTIFACT_PREFIX);
            secondTempFile = this.getLocalJarFile(destination, destinationDescriptor, DESTINATION_ARTIFACT_PREFIX);
            if (classifier1.equals(OSGI_BUNDLE_CLASSIFIER)) {
                IStatus iStatus = this.compare(firstTempFile, secondTempFile);
                return iStatus;
            }
            if (classifier1.equals(FEATURE_CLASSIFIER)) {
                IStatus iStatus = this.compareFeatures(firstTempFile, secondTempFile);
                return iStatus;
            }
        }
        catch (CoreException e) {
            IStatus iStatus = e.getStatus();
            return iStatus;
        }
        finally {
            if (firstTempFile != null) {
                firstTempFile.delete();
            }
            if (secondTempFile != null) {
                secondTempFile.delete();
            }
        }
        return Status.OK_STATUS;
    }

    public IStatus compareFeatures(File sourceFile, File destinationFile) {
        FeatureParser parser = new FeatureParser();
        Feature feature1 = parser.parse(sourceFile);
        Feature feature2 = parser.parse(destinationFile);
        MultiStatus parent = new MultiStatus(PLUGIN_ID, 0, NLS.bind((String)Messages.differentEntry, (Object[])new String[]{this.descriptorString, this.sourceLocation, this.destinationLocation}), null);
        if (!feature1.getId().equals(feature2.getId())) {
            parent.add(this.newErrorStatus(NLS.bind((String)Messages.featureIdsDontMatch, (Object)feature1.getId(), (Object)feature2.getId())));
        }
        if (!feature1.getVersion().equals(feature2.getVersion())) {
            parent.add(this.newErrorStatus(NLS.bind((String)Messages.featureVersionsDontMatch, (Object)feature1.getVersion(), (Object)feature2.getVersion())));
        }
        HashMap<FeatureEntry, FeatureEntry> entryMap = new HashMap<FeatureEntry, FeatureEntry>();
        FeatureEntry[] entries = feature1.getEntries();
        int i = 0;
        while (i < entries.length) {
            entryMap.put(entries[i], entries[i]);
            ++i;
        }
        entries = feature2.getEntries();
        if (entries.length != entryMap.size()) {
            parent.add(this.newErrorStatus(Messages.featureSize));
        }
        i = 0;
        while (i < entries.length) {
            FeatureEntry firstEntry = (FeatureEntry)entryMap.get(entries[i]);
            if (firstEntry == null) {
                parent.add(this.newErrorStatus(NLS.bind((String)Messages.featureEntry, (Object)entries[i])));
            } else {
                if (firstEntry.isOptional() != entries[i].isOptional()) {
                    parent.add(this.newErrorStatus(NLS.bind((String)Messages.featureEntryOptional, (Object)entries[i])));
                }
                if (firstEntry.isUnpack() != entries[i].isUnpack()) {
                    parent.add(this.newErrorStatus(NLS.bind((String)Messages.featureEntryUnpack, (Object)entries[i])));
                }
                if (firstEntry.isRequires() && firstEntry.getMatch() != null && !firstEntry.getMatch().equals(entries[i].getMatch())) {
                    parent.add(this.newErrorStatus(NLS.bind((String)Messages.featureEntryMatch, (Object)entries[i])));
                }
                if (firstEntry.getFilter() != null && !firstEntry.getFilter().equals(entries[i].getFilter())) {
                    parent.add(this.newErrorStatus(NLS.bind((String)Messages.featureEntryFilter, (Object)entries[i])));
                }
            }
            ++i;
        }
        return parent.getChildren().length == 0 ? Status.OK_STATUS : parent;
    }

    /*
     * Exception decompiling
     */
    public IStatus compare(File sourceFile, File destinationFile) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 10[DOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private IStatus compareManifest(InputStream firstStream, InputStream secondStream) throws IOException {
        Manifest manifest = new Manifest(firstStream);
        Manifest manifest2 = new Manifest(secondStream);
        if (manifest == null || manifest2 == null) {
            return Status.OK_STATUS;
        }
        Attributes attributes = manifest.getMainAttributes();
        Attributes attributes2 = manifest2.getMainAttributes();
        if (attributes.size() != attributes2.size()) {
            return this.newErrorStatus(NLS.bind((String)Messages.manifestDifferentSize, (Object)String.valueOf(Math.abs(attributes.size() - attributes2.size()))));
        }
        Iterator<Map.Entry<Object, Object>> iterator = attributes.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Object, Object> entry = iterator.next();
            Object value2 = attributes2.get(entry.getKey());
            if (value2 == null) {
                return this.newErrorStatus(NLS.bind((String)Messages.manifestMissingEntry, (Object)entry.getKey()));
            }
            if (value2.equals(entry.getValue())) continue;
            return this.newErrorStatus(NLS.bind((String)Messages.manifestDifferentValue, (Object)entry.getKey()));
        }
        return Status.OK_STATUS;
    }

    private IStatus compareClasses(String entryName, InputStream stream1, long size1, InputStream stream2, long size2) throws ClassFormatException, IOException {
        String contentsFile2;
        Disassembler disassembler = new Disassembler();
        byte[] firstEntryClassFileBytes = Utility.getInputStreamAsByteArray(stream1, (int)size1);
        byte[] secondEntryClassFileBytes = Utility.getInputStreamAsByteArray(stream2, (int)size2);
        String contentsFile1 = disassembler.disassemble(firstEntryClassFileBytes, LINE_SEPARATOR, 9);
        if (!contentsFile1.equals(contentsFile2 = disassembler.disassemble(secondEntryClassFileBytes, LINE_SEPARATOR, 9))) {
            return this.newErrorStatus(NLS.bind((String)Messages.classesDifferent, (Object)entryName));
        }
        return Status.OK_STATUS;
    }

    private IStatus compareNestedJars(InputStream stream1, long size1, InputStream stream2, long size2, String entry) throws IOException {
        File firstTempFile = this.getLocalJarFile(stream1, entry, size1);
        File secondTempFile = this.getLocalJarFile(stream2, entry, size2);
        try {
            IStatus iStatus = this.compare(firstTempFile, secondTempFile);
            return iStatus;
        }
        finally {
            if (firstTempFile != null) {
                firstTempFile.delete();
            }
            if (secondTempFile != null) {
                secondTempFile.delete();
            }
        }
    }

    private IStatus compareProperties(String entryName, InputStream stream1, InputStream stream2) {
        Properties props1 = this.loadProperties(stream1);
        Properties props2 = this.loadProperties(stream2);
        if (props1.size() != props2.size()) {
            return this.newErrorStatus(NLS.bind((String)Messages.propertiesSizesDifferent, (Object)entryName, (Object)String.valueOf(Math.abs(props1.size() - props2.size()))));
        }
        props1.keys();
        Iterator<Object> iterator = props1.keySet().iterator();
        while (iterator.hasNext()) {
            String prop2;
            String key = (String)iterator.next();
            if (!props2.containsKey(key)) {
                return this.newErrorStatus(NLS.bind((String)Messages.missingProperty, (Object)key, (Object)entryName));
            }
            String prop1 = props1.getProperty(key);
            if (prop1.equals(prop2 = props2.getProperty(key))) continue;
            if (prop1.length() < 10 && prop2.length() < 10) {
                return this.newErrorStatus(NLS.bind((String)Messages.differentPropertyValueFull, (Object[])new String[]{entryName, key, prop1, prop2}));
            }
            return this.newErrorStatus(NLS.bind((String)Messages.differentPropertyValueFull, (Object)entryName, (Object)key));
        }
        return Status.OK_STATUS;
    }

    private IStatus compareBytes(String entryName, InputStream firstStream, long size1, InputStream secondStream, long size2) throws IOException {
        byte[] secondBytes;
        byte[] firstBytes = Utility.getInputStreamAsByteArray(firstStream, (int)size1);
        if (!Arrays.equals(firstBytes, secondBytes = Utility.getInputStreamAsByteArray(secondStream, (int)size2))) {
            return this.newErrorStatus(NLS.bind((String)Messages.binaryFilesDifferent, (Object)entryName));
        }
        return Status.OK_STATUS;
    }

    private Properties loadProperties(InputStream input) {
        Properties result = new Properties();
        try {
            result.load(input);
        }
        catch (IOException iOException) {}
        return result;
    }

    private String normalize(String entryName) {
        StringBuffer buffer = new StringBuffer();
        char[] chars = entryName.toCharArray();
        int i = 0;
        int max = chars.length;
        while (i < max) {
            char currentChar = chars[i];
            if (!Character.isJavaIdentifierPart(currentChar)) {
                buffer.append('_');
            } else {
                buffer.append(currentChar);
            }
            ++i;
        }
        return String.valueOf(buffer);
    }

    private IStatus newErrorStatus(String message, Exception e) {
        return new Status(4, PLUGIN_ID, message, (Throwable)e);
    }

    private IStatus newErrorStatus(String message) {
        return this.newErrorStatus(message, null);
    }

    private File getLocalJarFile(IArtifactRepository repository, IArtifactDescriptor descriptor, String prefix) throws CoreException {
        File file = null;
        BufferedOutputStream stream = null;
        try {
            try {
                file = File.createTempFile(prefix, ".jar");
                stream = new BufferedOutputStream(new FileOutputStream(file));
                IStatus status = repository.getArtifact(descriptor, (OutputStream)stream, (IProgressMonitor)new NullProgressMonitor());
                if (!status.isOK()) {
                    throw new CoreException(status);
                }
                stream.flush();
            }
            catch (FileNotFoundException e) {
                throw new CoreException(this.newErrorStatus("FileNotFoundException", e));
            }
            catch (IOException e) {
                throw new CoreException(this.newErrorStatus("IOException", e));
            }
        }
        catch (Throwable throwable) {
            Utility.close(stream);
            throw throwable;
        }
        Utility.close(stream);
        return file;
    }

    private File getLocalJarFile(InputStream inputStream, String entry, long size) throws IOException {
        byte[] firstEntryClassFileBytes = Utility.getInputStreamAsByteArray(inputStream, (int)size);
        File tempFile = null;
        BufferedOutputStream stream = null;
        try {
            tempFile = File.createTempFile(SOURCE_ARTIFACT_PREFIX + this.normalize(entry), ".jar");
            stream = new BufferedOutputStream(new FileOutputStream(tempFile));
            stream.write(firstEntryClassFileBytes);
            stream.flush();
        }
        catch (Throwable throwable) {
            Utility.close(stream);
            throw throwable;
        }
        Utility.close(stream);
        return tempFile;
    }

    private boolean isSigningEntry(String entry) {
        return entry.startsWith(META_INF) && (entry.endsWith(SF_EXT) || entry.endsWith(RSA_EXT) || entry.endsWith(DSA_EXT));
    }
}

