/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.admin;

import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.internal.p2.ui.ProvUI;
import org.eclipse.equinox.internal.p2.ui.ProvUIImages;
import org.eclipse.equinox.internal.p2.ui.ProvUIProvisioningListener;
import org.eclipse.equinox.internal.p2.ui.admin.ProvAdminUIMessages;
import org.eclipse.equinox.internal.p2.ui.admin.ProvView;
import org.eclipse.equinox.internal.p2.ui.model.IRepositoryElement;
import org.eclipse.equinox.internal.p2.ui.viewers.RepositoryContentProvider;
import org.eclipse.equinox.internal.p2.ui.viewers.StructuredViewerProvisioningListener;
import org.eclipse.equinox.p2.operations.RepositoryTracker;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.dialogs.PropertyDialogAction;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class RepositoriesView
extends ProvView {
    private Action addRepositoryAction;
    private Action removeRepositoryAction;
    private PropertyDialogAction propertiesAction;
    private StructuredViewerProvisioningListener listener;

    @Override
    protected void addListeners() {
        super.addListeners();
        this.listener = new StructuredViewerProvisioningListener(((Object)((Object)this)).getClass().getName(), (StructuredViewer)this.viewer, this.getListenerEventTypes()){

            protected void refreshViewer() {
                RepositoriesView.this.refreshAll(false);
            }
        };
        ProvUI.addProvisioningListener((ProvUIProvisioningListener)this.listener);
    }

    @Override
    protected void removeListeners() {
        super.removeListeners();
        ProvUI.removeProvisioningListener((ProvUIProvisioningListener)this.listener);
    }

    @Override
    protected void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.addRepositoryAction);
        manager.add((IAction)this.removeRepositoryAction);
        manager.add((IAction)this.propertiesAction);
    }

    @Override
    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.addRepositoryAction);
        if (this.removeRepositoryAction.isEnabled()) {
            manager.add((IAction)this.removeRepositoryAction);
        }
        if (this.propertiesAction.isEnabled()) {
            manager.add((IContributionItem)new Separator());
            manager.add((IAction)this.propertiesAction);
        }
    }

    @Override
    protected void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.addRepositoryAction);
        manager.add((IAction)this.removeRepositoryAction);
    }

    @Override
    protected void makeActions() {
        super.makeActions();
        this.addRepositoryAction = new AddRepositoryAction();
        this.removeRepositoryAction = new RemoveRepositoryAction();
        this.getViewSite().getActionBars().setGlobalActionHandler(ActionFactory.DELETE.getId(), (IAction)this.removeRepositoryAction);
        this.propertiesAction = new PropertyDialogAction((IShellProvider)this.getSite(), (ISelectionProvider)this.viewer);
        this.getViewSite().getActionBars().setGlobalActionHandler(ActionFactory.PROPERTIES.getId(), (IAction)this.propertiesAction);
        IStructuredSelection selection = this.getSelection();
        if (selection.size() == 1 && this.isRepository(selection.getFirstElement())) {
            this.propertiesAction.setEnabled(true);
            this.removeRepositoryAction.setEnabled(true);
        } else {
            this.propertiesAction.setEnabled(false);
            this.removeRepositoryAction.setEnabled(false);
        }
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection ss = (IStructuredSelection)event.getSelection();
                RepositoriesView.this.selectionChanged(ss);
            }
        });
    }

    @Override
    protected IAction getDoubleClickAction() {
        return this.propertiesAction;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected void selectionChanged(IStructuredSelection selection) {
        if (selection.size() != 1) ** GOTO lbl-1000
        try {
            v0 = Class.forName("org.eclipse.equinox.p2.metadata.IInstallableUnit");
        }
        catch (ClassNotFoundException v1) {
            throw new NoClassDefFoundError(v1.getMessage());
        }
        if (ProvUI.getAdapter((Object)selection.getFirstElement(), v0) != null || this.isRepository(selection.getFirstElement())) {
            v2 = true;
        } else lbl-1000:
        // 2 sources

        {
            v2 = false;
        }
        this.propertiesAction.setEnabled(v2);
        enabled = false;
        selectionArray = selection.toArray();
        i = 0;
        while (i < selectionArray.length) {
            if (!this.isRepository(selectionArray[i])) {
                enabled = false;
                break;
            }
            enabled = true;
            ++i;
        }
        this.removeRepositoryAction.setEnabled(enabled);
    }

    @Override
    protected IContentProvider getContentProvider() {
        return new RepositoryContentProvider();
    }

    protected abstract RepositoryTracker getRepositoryTracker();

    protected abstract int openAddRepositoryDialog(Shell var1);

    protected abstract String getAddCommandLabel();

    protected abstract String getAddCommandTooltip();

    protected String getRemoveCommandLabel() {
        return ProvAdminUIMessages.RepositoriesView_RemoveCommandLabel;
    }

    protected abstract String getRemoveCommandTooltip();

    protected boolean isRepository(Object element) {
        return element instanceof IRepositoryElement;
    }

    protected abstract int getListenerEventTypes();

    @Override
    protected List<String> getVisualProperties() {
        List<String> list = super.getVisualProperties();
        list.add("org.eclipse.equinox.internal.provisional.p2.ui.admin.hideSystemRepos");
        return list;
    }

    @Override
    protected void refreshUnderlyingModel() {
        Class<?> clazz;
        try {
            clazz = Class.forName("org.eclipse.ui.progress.IWorkbenchSiteProgressService");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        IWorkbenchSiteProgressService service = (IWorkbenchSiteProgressService)this.getSite().getAdapter(clazz);
        if (service != null) {
            try {
                service.run(true, false, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) {
                        RepositoriesView.this.getRepositoryTracker().refreshRepositories(RepositoriesView.this.getRepositoryTracker().getKnownRepositories(RepositoriesView.this.getProvisioningUI().getSession()), RepositoriesView.this.getProvisioningUI().getSession(), monitor);
                    }
                });
            }
            catch (InvocationTargetException e) {
                ProvUI.handleException((Throwable)e, null, (int)2);
            }
            catch (InterruptedException interruptedException) {}
        } else {
            this.getRepositoryTracker().refreshRepositories(this.getRepositoryTracker().getKnownRepositories(this.getProvisioningUI().getSession()), this.getProvisioningUI().getSession(), (IProgressMonitor)new NullProgressMonitor());
        }
    }

    private class AddRepositoryAction
    extends Action {
        AddRepositoryAction() {
            this.setText(RepositoriesView.this.getAddCommandLabel());
            this.setToolTipText(RepositoriesView.this.getAddCommandTooltip());
            this.setImageDescriptor(ProvUIImages.getImageDescriptor((String)"obj/artifact_repo_obj.gif"));
        }

        public void run() {
            Object[] elements = ((ITreeContentProvider)RepositoriesView.this.viewer.getContentProvider()).getElements(RepositoriesView.this.getInput());
            ArrayList<URI> urls = new ArrayList<URI>();
            int i = 0;
            while (i < elements.length) {
                if (elements[i] instanceof IRepositoryElement) {
                    urls.add(((IRepositoryElement)elements[i]).getLocation());
                }
                ++i;
            }
            RepositoriesView.this.openAddRepositoryDialog(RepositoriesView.this.getShell());
        }
    }

    private class RemoveRepositoryAction
    extends Action {
        RemoveRepositoryAction() {
            this.setText(RepositoriesView.this.getRemoveCommandLabel());
            this.setToolTipText(RepositoriesView.this.getRemoveCommandTooltip());
            this.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_DELETE"));
            this.setDisabledImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_DELETE_DISABLED"));
        }

        public void run() {
            RepositoryTracker tracker = RepositoriesView.this.getRepositoryTracker();
            Object[] elements = RepositoriesView.this.getSelection().toArray();
            ArrayList<URI> uris = new ArrayList<URI>(elements.length);
            int i = 0;
            while (i < elements.length) {
                if (elements[i] instanceof IRepositoryElement) {
                    uris.add(((IRepositoryElement)elements[i]).getLocation());
                }
                ++i;
            }
            tracker.removeRepositories(uris.toArray(new URI[uris.size()]), RepositoriesView.this.getProvisioningUI().getSession());
        }
    }
}

