/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.admin.dialogs;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.ui.admin.ProfileFactory;
import org.eclipse.equinox.internal.p2.ui.admin.ProvAdminUIMessages;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProfileGroup {
    Text id;
    Text location;
    Text cache;
    Text name;
    Text description;
    Text environments;
    Text nl;
    IProfile profile;

    public ProfileGroup(final Composite parent, IProfile profile, ModifyListener listener) {
        this.profile = profile;
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.widthHint = 350;
        composite.setLayoutData((Object)data);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        Label label = new Label(composite, 0);
        label.setText(ProvAdminUIMessages.ProfileGroup_ID);
        this.id = new Text(composite, 2048);
        this.id.setLayoutData((Object)gd);
        this.setEditable((Control)this.id, profile == null, listener);
        label = new Label(composite, 0);
        label.setText(ProvAdminUIMessages.ProfileGroup_InstallFolder);
        this.location = new Text(composite, 2048);
        this.location.setLayoutData((Object)new GridData(768));
        this.setEditable((Control)this.location, profile == null, listener);
        Button locationButton = new Button(composite, 8);
        locationButton.setText(ProvAdminUIMessages.ProfileGroup_Browse);
        locationButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                DirectoryDialog dialog = new DirectoryDialog(parent.getShell(), 65536);
                dialog.setMessage(ProvAdminUIMessages.ProfileGroup_SelectProfileMessage);
                String dir = dialog.open();
                if (dir != null) {
                    ProfileGroup.this.location.setText(dir);
                }
            }
        });
        this.setEditable((Control)locationButton, profile == null, listener);
        label = new Label(composite, 0);
        label.setText(ProvAdminUIMessages.ProfileGroup_Cache);
        this.cache = new Text(composite, 2048);
        this.cache.setLayoutData((Object)new GridData(768));
        this.setEditable((Control)this.cache, profile == null, listener);
        locationButton = new Button(composite, 8);
        locationButton.setText(ProvAdminUIMessages.ProfileGroup_Browse2);
        locationButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                DirectoryDialog dialog = new DirectoryDialog(parent.getShell(), 65536);
                dialog.setMessage(ProvAdminUIMessages.ProfileGroup_SelectBundlePoolCache);
                String dir = dialog.open();
                if (dir != null) {
                    ProfileGroup.this.cache.setText(dir);
                }
            }
        });
        this.setEditable((Control)locationButton, profile == null, listener);
        label = new Label(composite, 0);
        label.setText(ProvAdminUIMessages.ProfileGroup_Name);
        this.name = new Text(composite, 2048);
        this.name.setLayoutData((Object)gd);
        this.setEditable((Control)this.name, profile == null, listener);
        label = new Label(composite, 0);
        label.setText(ProvAdminUIMessages.ProfileGroup_Description);
        this.description = new Text(composite, 2048);
        this.description.setLayoutData((Object)gd);
        this.setEditable((Control)this.description, profile == null, listener);
        label = new Label(composite, 0);
        label.setText(ProvAdminUIMessages.ProfileGroup_Flavor);
        label = new Label(composite, 0);
        label.setText(ProvAdminUIMessages.ProfileGroup_Environments);
        this.environments = new Text(composite, 2048);
        this.environments.setLayoutData((Object)gd);
        this.setEditable((Control)this.environments, profile == null, listener);
        label = new Label(composite, 0);
        label.setText(ProvAdminUIMessages.ProfileGroup_NL);
        this.nl = new Text(composite, 2048);
        this.nl.setLayoutData((Object)gd);
        this.setEditable((Control)this.nl, profile == null, listener);
        this.initializeFields();
    }

    private void initializeFields() {
        if (this.profile == null) {
            this.location.setText(ProfileFactory.getDefaultLocation());
            this.environments.setText(ProfileFactory.getDefaultEnvironments());
            this.nl.setText(ProfileFactory.getDefaultNL());
        } else {
            String value = this.profile.getProfileId();
            if (value == null) {
                value = "";
            }
            this.id.setText(value);
            value = this.profile.getProperty("org.eclipse.equinox.p2.installFolder");
            if (value != null) {
                this.location.setText(value);
            }
            if ((value = this.profile.getProperty("org.eclipse.equinox.p2.cache")) != null) {
                this.cache.setText(value);
            }
            if ((value = this.profile.getProperty("org.eclipse.equinox.p2.name")) != null) {
                this.name.setText(value);
            }
            if ((value = this.profile.getProperty("org.eclipse.equinox.p2.description")) != null) {
                this.description.setText(value);
            }
            if ((value = this.profile.getProperty("org.eclipse.equinox.p2.environments")) != null) {
                this.environments.setText(value);
            }
            if ((value = this.profile.getProperty("org.eclipse.equinox.p2.nl")) != null) {
                this.nl.setText(value);
            }
        }
    }

    public Map<String, String> getProfileProperties() {
        if (this.profile == null) {
            HashMap<String, String> profileProperties = new HashMap<String, String>();
            String value = this.location.getText().trim();
            if (value.length() > 0) {
                profileProperties.put("org.eclipse.equinox.p2.installFolder", value);
            }
            if ((value = this.cache.getText().trim()).length() > 0) {
                profileProperties.put("org.eclipse.equinox.p2.cache", value);
            }
            if ((value = this.name.getText().trim()).length() > 0) {
                profileProperties.put("org.eclipse.equinox.p2.name", value);
            }
            if ((value = this.description.getText().trim()).length() > 0) {
                profileProperties.put("org.eclipse.equinox.p2.description", value);
            }
            if ((value = this.environments.getText().trim()).length() > 0) {
                profileProperties.put("org.eclipse.equinox.p2.environments", value);
            }
            if ((value = this.nl.getText().trim()).length() > 0) {
                profileProperties.put("org.eclipse.equinox.p2.nl", value);
            }
            return profileProperties;
        }
        return this.profile.getProperties();
    }

    public Composite getComposite() {
        if (this.id == null) {
            return null;
        }
        return this.id.getParent();
    }

    public IProfile getProfile() {
        return this.profile;
    }

    public String getProfileId() {
        if (this.profile != null) {
            return this.profile.getProfileId();
        }
        return this.id.getText().trim();
    }

    public IStatus verify() {
        if (this.id.getText().trim().length() == 0) {
            return new Status(4, "org.eclipse.equinox.internal.provisional.p2.ui.admin", 0, ProvAdminUIMessages.ProfileGroup_ProfileIDRequired, null);
        }
        if (this.location.getText().trim().length() == 0) {
            return new Status(4, "org.eclipse.equinox.internal.provisional.p2.ui.admin", 0, ProvAdminUIMessages.ProfileGroup_ProfileInstallFolderRequired, null);
        }
        return new Status(0, "org.eclipse.equinox.internal.provisional.p2.ui.admin", 0, "", null);
    }

    private void setEditable(Control control, boolean editable, ModifyListener listener) {
        if (control instanceof Text) {
            Text text = (Text)control;
            text.setEditable(editable);
            if (listener != null && editable) {
                text.addModifyListener(listener);
            }
        } else {
            control.setEnabled(editable);
        }
    }
}

