/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.javaeditor.saveparticipant;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.internal.corext.fix.CleanUpPostSaveListener;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.fix.CleanUpSaveParticipantPreferenceConfiguration;
import org.eclipse.jdt.internal.ui.javaeditor.saveparticipant.IPostSaveListener;
import org.eclipse.jdt.internal.ui.javaeditor.saveparticipant.ISaveParticipantPreferenceConfiguration;
import org.eclipse.jdt.internal.ui.javaeditor.saveparticipant.SaveParticipantDescriptor;
import org.eclipse.jdt.internal.ui.javaeditor.saveparticipant.SaveParticipantMessages;

public final class SaveParticipantRegistry {
    private static final IPostSaveListener[] EMPTY_ARRAY = new IPostSaveListener[0];
    private Map fDescriptors;

    public synchronized SaveParticipantDescriptor[] getSaveParticipantDescriptors() {
        this.ensureRegistered();
        return this.fDescriptors.values().toArray(new SaveParticipantDescriptor[this.fDescriptors.size()]);
    }

    public synchronized SaveParticipantDescriptor getSaveParticipantDescriptor(String id) {
        this.ensureRegistered();
        return (SaveParticipantDescriptor)this.fDescriptors.get(id);
    }

    private void ensureRegistered() {
        if (this.fDescriptors == null) {
            this.reloadDescriptors();
        }
    }

    private void reloadDescriptors() {
        HashMap<String, 1> map = new HashMap<String, 1>();
        SaveParticipantDescriptor desc = new SaveParticipantDescriptor(new CleanUpPostSaveListener()){

            public ISaveParticipantPreferenceConfiguration createPreferenceConfiguration() {
                return new CleanUpSaveParticipantPreferenceConfiguration();
            }
        };
        map.put(desc.getId(), desc);
        this.fDescriptors = map;
    }

    public void dispose() {
    }

    public synchronized boolean hasSettingsInScope(IScopeContext context) {
        this.ensureRegistered();
        Iterator iterator = this.fDescriptors.values().iterator();
        while (iterator.hasNext()) {
            SaveParticipantDescriptor descriptor = (SaveParticipantDescriptor)iterator.next();
            if (!descriptor.getPreferenceConfiguration().hasSettingsInScope(context)) continue;
            return true;
        }
        return false;
    }

    public IPostSaveListener[] getEnabledPostSaveListeners(IProject project) {
        return this.getEnabledPostSaveListeners((IScopeContext)new ProjectScope(project));
    }

    public synchronized IPostSaveListener[] getEnabledPostSaveListeners(IScopeContext context) {
        this.ensureRegistered();
        ArrayList<IPostSaveListener> result = null;
        Iterator iterator = this.fDescriptors.values().iterator();
        while (iterator.hasNext()) {
            SaveParticipantDescriptor descriptor = (SaveParticipantDescriptor)iterator.next();
            if (!descriptor.getPreferenceConfiguration().isEnabled(context)) continue;
            if (result == null) {
                result = new ArrayList<IPostSaveListener>();
            }
            result.add(descriptor.getPostSaveListener());
        }
        if (result == null) {
            return EMPTY_ARRAY;
        }
        return result.toArray(new IPostSaveListener[result.size()]);
    }

    public static boolean isChangedRegionsRequired(final ICompilationUnit unit) throws CoreException {
        String message = SaveParticipantMessages.SaveParticipantRegistry_needsChangedRegionFailed;
        final MultiStatus errorStatus = new MultiStatus("org.eclipse.jdt.ui", 10007, message, null);
        IPostSaveListener[] listeners = JavaPlugin.getDefault().getSaveParticipantRegistry().getEnabledPostSaveListeners(unit.getJavaProject().getProject());
        try {
            final boolean[] result = new boolean[1];
            int i = 0;
            while (i < listeners.length) {
                final IPostSaveListener listener = listeners[i];
                SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                    public void run() throws Exception {
                        if (listener.needsChangedRegions(unit)) {
                            result[0] = true;
                        }
                    }

                    public void handleException(Throwable ex) {
                        String msg = Messages.format("The save participant ''{0}'' caused an exception.", new String[]{listener.getId()});
                        JavaPlugin.log((IStatus)new Status(4, "org.eclipse.jdt.ui", 10006, msg, ex));
                        String participantName = listener.getName();
                        msg = Messages.format(SaveParticipantMessages.SaveParticipantRegistry_needsChangedRegionCausedException, new String[]{participantName, ex.toString()});
                        errorStatus.add((IStatus)new Status(4, "org.eclipse.jdt.ui", 10007, msg, null));
                    }
                });
                if (result[0]) {
                    return true;
                }
                ++i;
            }
        }
        finally {
            if (!errorStatus.isOK()) {
                throw new CoreException((IStatus)errorStatus);
            }
        }
        return false;
    }
}

