/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IBufferFactory;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.IWorkingCopy;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.corext.javadoc.JavaDocLocations;
import org.eclipse.jdt.internal.corext.refactoring.reorg.JavaElementTransfer;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaUIMessages;
import org.eclipse.jdt.internal.ui.SharedImages;
import org.eclipse.jdt.internal.ui.dialogs.FilteredTypesSelectionDialog;
import org.eclipse.jdt.internal.ui.dialogs.MainTypeSelectionDialog;
import org.eclipse.jdt.internal.ui.dialogs.MultiMainTypeSelectionDialog;
import org.eclipse.jdt.internal.ui.dialogs.PackageSelectionDialog;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jdt.internal.ui.util.BusyIndicatorRunnableContext;
import org.eclipse.jdt.ui.ISharedImages;
import org.eclipse.jdt.ui.IWorkingCopyManager;
import org.eclipse.jdt.ui.dialogs.TypeSelectionExtension;
import org.eclipse.jdt.ui.text.IColorManager;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.texteditor.IDocumentProvider;

public final class JavaUI {
    private static ISharedImages fgSharedImages = null;
    public static final String ID_PLUGIN = "org.eclipse.jdt.ui";
    public static final String ID_PERSPECTIVE = "org.eclipse.jdt.ui.JavaPerspective";
    public static final String ID_HIERARCHYPERSPECTIVE = "org.eclipse.jdt.ui.JavaHierarchyPerspective";
    public static final String ID_ACTION_SET = "org.eclipse.jdt.ui.JavaActionSet";
    public static final String ID_ELEMENT_CREATION_ACTION_SET = "org.eclipse.jdt.ui.JavaElementCreationActionSet";
    public static final String ID_CODING_ACTION_SET = "org.eclipse.jdt.ui.CodingActionSet";
    public static final String ID_OPEN_ACTION_SET = "org.eclipse.jdt.ui.A_OpenActionSet";
    public static final String ID_SEARCH_ACTION_SET = "org.eclipse.jdt.ui.SearchActionSet";
    public static final String ID_CU_EDITOR = "org.eclipse.jdt.ui.CompilationUnitEditor";
    public static final String ID_CF_EDITOR = "org.eclipse.jdt.ui.ClassFileEditor";
    public static final String ID_SNIPPET_EDITOR = "org.eclipse.jdt.ui.SnippetEditor";
    public static final String ID_PACKAGES = "org.eclipse.jdt.ui.PackageExplorer";
    public static final String ID_TYPE_HIERARCHY = "org.eclipse.jdt.ui.TypeHierarchy";
    public static final String ID_SOURCE_VIEW = "org.eclipse.jdt.ui.SourceView";
    public static final String ID_JAVADOC_VIEW = "org.eclipse.jdt.ui.JavadocView";
    public static String ID_BROWSING_PERSPECTIVE = "org.eclipse.jdt.ui.JavaBrowsingPerspective";
    public static String ID_PROJECTS_VIEW = "org.eclipse.jdt.ui.ProjectsView";
    public static String ID_PACKAGES_VIEW = "org.eclipse.jdt.ui.PackagesView";
    public static String ID_TYPES_VIEW = "org.eclipse.jdt.ui.TypesView";
    public static String ID_MEMBERS_VIEW = "org.eclipse.jdt.ui.MembersView";
    public static final String ID_USER_LIBRARY_PREFERENCE_PAGE = "org.eclipse.jdt.ui.preferences.UserLibraryPreferencePage";
    public static final String ID_CLASSPATH_VARIABLES_PREFERENCE_PAGE = "org.eclipse.jdt.ui.preferences.ClasspathVariablesPreferencePage";
    public static final String ATTR_CMDLINE = "org.eclipse.jdt.ui.launcher.cmdLine";
    private static final int DEPRECATED_CONSIDER_TYPES = 6;
    static /* synthetic */ Class class$0;

    private JavaUI() {
    }

    public static ISharedImages getSharedImages() {
        if (fgSharedImages == null) {
            fgSharedImages = new SharedImages();
        }
        return fgSharedImages;
    }

    public static SelectionDialog createPackageDialog(Shell parent, IJavaProject project, int style, String filter) throws JavaModelException {
        Assert.isTrue(((style | 8 | 0x20) == 40 ? 1 : 0) != 0);
        IPackageFragmentRoot[] roots = null;
        roots = (style & 0x20) != 0 ? project.getAllPackageFragmentRoots() : project.getPackageFragmentRoots();
        List<IPackageFragmentRoot> consideredRoots = null;
        if ((style & 8) != 0) {
            consideredRoots = Arrays.asList(roots);
        } else {
            consideredRoots = new ArrayList<IPackageFragmentRoot>(roots.length);
            int i = 0;
            while (i < roots.length) {
                IPackageFragmentRoot root = roots[i];
                if (root.getKind() != 2) {
                    consideredRoots.add(root);
                }
                ++i;
            }
        }
        IJavaSearchScope searchScope = SearchEngine.createJavaSearchScope((IJavaElement[])consideredRoots.toArray(new IJavaElement[consideredRoots.size()]));
        BusyIndicatorRunnableContext context = new BusyIndicatorRunnableContext();
        if (style == 0 || style == 32) {
            return JavaUI.createPackageDialog(parent, context, searchScope, false, true, filter);
        }
        return JavaUI.createPackageDialog(parent, context, searchScope, false, false, filter);
    }

    public static SelectionDialog createPackageDialog(Shell parent, IRunnableContext context, IJavaSearchScope scope, boolean multipleSelection, boolean removeDuplicates, String filter) {
        int flag = removeDuplicates ? 1 : 0;
        PackageSelectionDialog dialog = new PackageSelectionDialog(parent, context, flag, scope);
        dialog.setFilter(filter);
        dialog.setIgnoreCase(false);
        dialog.setMultipleSelection(multipleSelection);
        return dialog;
    }

    public static SelectionDialog createPackageDialog(Shell parent, IJavaProject project, int style) throws JavaModelException {
        return JavaUI.createPackageDialog(parent, project, style, "");
    }

    public static SelectionDialog createPackageDialog(Shell parent, IPackageFragmentRoot root, String filter) throws JavaModelException {
        IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{root});
        BusyIndicatorRunnableContext context = new BusyIndicatorRunnableContext();
        return JavaUI.createPackageDialog(parent, context, scope, false, true, filter);
    }

    public static SelectionDialog createPackageDialog(Shell parent, IPackageFragmentRoot root) throws JavaModelException {
        return JavaUI.createPackageDialog(parent, root, "");
    }

    public static SelectionDialog createTypeDialog(Shell parent, IRunnableContext context, IProject project, int style, boolean multipleSelection) throws JavaModelException {
        IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaProject[]{JavaCore.create((IProject)project)});
        return JavaUI.createTypeDialog(parent, context, scope, style, multipleSelection);
    }

    public static SelectionDialog createTypeDialog(Shell parent, IRunnableContext context, IJavaSearchScope scope, int style, boolean multipleSelection) throws JavaModelException {
        return JavaUI.createTypeDialog(parent, context, scope, style, multipleSelection, "");
    }

    public static SelectionDialog createTypeDialog(Shell parent, IRunnableContext context, IJavaSearchScope scope, int style, boolean multipleSelection, String filter) throws JavaModelException {
        return JavaUI.createTypeDialog(parent, context, scope, style, multipleSelection, filter, null);
    }

    public static SelectionDialog createTypeDialog(Shell parent, IRunnableContext context, IJavaSearchScope scope, int style, boolean multipleSelection, String filter, TypeSelectionExtension extension) throws JavaModelException {
        int elementKinds = 0;
        if (style == 256) {
            elementKinds = 0;
        } else if (style == 4) {
            elementKinds = 6;
        } else if (style == 2) {
            elementKinds = 5;
        } else if (style == 64) {
            elementKinds = 8;
        } else if (style == 128) {
            elementKinds = 7;
        } else if (style == 512) {
            elementKinds = 10;
        } else if (style == 1024) {
            elementKinds = 9;
        } else if (style == 6) {
            elementKinds = 10;
        } else {
            throw new IllegalArgumentException("Invalid style constant.");
        }
        FilteredTypesSelectionDialog dialog = new FilteredTypesSelectionDialog(parent, multipleSelection, context, scope, elementKinds, extension);
        dialog.setMessage(JavaUIMessages.JavaUI_defaultDialogMessage);
        dialog.setInitialPattern(filter);
        return dialog;
    }

    public static SelectionDialog createMainTypeDialog(Shell parent, IRunnableContext context, IJavaSearchScope scope, int style, boolean multipleSelection, String filter) {
        if (multipleSelection) {
            MultiMainTypeSelectionDialog dialog = new MultiMainTypeSelectionDialog(parent, context, scope, style);
            dialog.setFilter(filter);
            return dialog;
        }
        MainTypeSelectionDialog dialog = new MainTypeSelectionDialog(parent, context, scope, style);
        dialog.setFilter(filter);
        return dialog;
    }

    public static SelectionDialog createMainTypeDialog(Shell parent, IRunnableContext context, IJavaSearchScope scope, int style, boolean multipleSelection) {
        return JavaUI.createMainTypeDialog(parent, context, scope, style, multipleSelection, "");
    }

    public static IEditorPart openInEditor(IJavaElement element) throws JavaModelException, PartInitException {
        return JavaUI.openInEditor(element, true, true);
    }

    public static IEditorPart openInEditor(IJavaElement element, boolean activate, boolean reveal) throws JavaModelException, PartInitException {
        if (!(element instanceof ISourceReference)) {
            return null;
        }
        IEditorPart part = EditorUtility.openInEditor(element, activate);
        if (reveal && part != null) {
            EditorUtility.revealInEditor(part, element);
        }
        return part;
    }

    public static void revealInEditor(IEditorPart part, ISourceReference element) {
        if (element instanceof IJavaElement) {
            JavaUI.revealInEditor(part, (IJavaElement)element);
        }
    }

    public static void revealInEditor(IEditorPart part, IJavaElement element) {
        EditorUtility.revealInEditor(part, element);
    }

    public static IWorkingCopyManager getWorkingCopyManager() {
        return JavaPlugin.getDefault().getWorkingCopyManager();
    }

    public static IJavaElement getEditorInputJavaElement(IEditorInput editorInput) {
        ICompilationUnit je = JavaPlugin.getDefault().getWorkingCopyManager().getWorkingCopy(editorInput);
        if (je != null) {
            return je;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jdt.core.IJavaElement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (IJavaElement)editorInput.getAdapter((Class)clazz);
    }

    public static ITypeRoot getEditorInputTypeRoot(IEditorInput editorInput) {
        IJavaElement je;
        ICompilationUnit cu = JavaPlugin.getDefault().getWorkingCopyManager().getWorkingCopy(editorInput);
        if (cu != null) {
            return cu;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jdt.core.IJavaElement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((je = (IJavaElement)editorInput.getAdapter((Class)clazz)) instanceof ITypeRoot) {
            return (ITypeRoot)je;
        }
        return null;
    }

    public static IWorkingCopy[] getSharedWorkingCopies() {
        return JavaCore.getSharedWorkingCopies((IBufferFactory)JavaUI.getBufferFactory());
    }

    public static IWorkingCopy[] getSharedWorkingCopiesOnClasspath() {
        IWorkingCopy[] wcs = JavaUI.getSharedWorkingCopies();
        ArrayList<IWorkingCopy> result = new ArrayList<IWorkingCopy>(wcs.length);
        int i = 0;
        while (i < wcs.length) {
            IJavaElement je;
            IWorkingCopy wc = wcs[i];
            if (wc instanceof IJavaElement && (je = (IJavaElement)wc).getJavaProject().isOnClasspath(je)) {
                result.add(wc);
            }
            ++i;
        }
        return result.toArray(new IWorkingCopy[result.size()]);
    }

    public static IBufferFactory getBufferFactory() {
        return JavaPlugin.getDefault().getBufferFactory();
    }

    public static IDocumentProvider getDocumentProvider() {
        return JavaPlugin.getDefault().getCompilationUnitDocumentProvider();
    }

    public static void setLibraryJavadocLocation(IPath archivePath, URL url) {
    }

    public static void setLibraryJavadocLocations(IPath[] archivePaths, URL[] urls) {
    }

    public static URL getLibraryJavadocLocation(IPath archivePath) {
        return null;
    }

    public static URL getLibraryJavadocLocation(IClasspathEntry entry) {
        return JavaDocLocations.getLibraryJavadocLocation(entry);
    }

    public static void setProjectJavadocLocation(IJavaProject project, URL url) {
        JavaDocLocations.setProjectJavadocLocation(project, url);
    }

    public static URL getProjectJavadocLocation(IJavaProject project) {
        return JavaDocLocations.getProjectJavadocLocation(project);
    }

    public static URL getJavadocBaseLocation(IJavaElement element) throws JavaModelException {
        return JavaDocLocations.getJavadocBaseLocation(element);
    }

    public static URL getJavadocLocation(IJavaElement element, boolean includeAnchor) throws JavaModelException {
        return JavaDocLocations.getJavadocLocation(element, includeAnchor);
    }

    public static Transfer getJavaElementClipboardTransfer() {
        return JavaElementTransfer.getInstance();
    }

    public static IColorManager getColorManager() {
        return JavaPlugin.getDefault().getJavaTextTools().getColorManager();
    }
}

