/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.jmx.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.jmx.internal.Activator;
import org.eclipse.osgi.service.pluginconversion.PluginConversionException;
import org.eclipse.osgi.service.pluginconversion.PluginConverter;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.PlatformAdmin;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.StateObjectFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

public class BundleUtils {
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public static Set computeDependencies(Bundle bundle, BundleContext bundleContext) throws PluginConversionException, CoreException, IOException {
        HashMap disjointSets = new HashMap();
        Bundle[] installedBundles = bundleContext.getBundles();
        int i = 0;
        while (i < installedBundles.length) {
            BundleDescription desc = BundleUtils.getBundleDescription(installedBundles[i], bundleContext);
            if (desc != null) {
                ArrayList<String> descDeps = new ArrayList<String>();
                disjointSets.put(desc.getName(), descDeps);
                BundleSpecification[] specs = desc.getRequiredBundles();
                int j = 0;
                while (j < specs.length) {
                    descDeps.add(specs[j].getName());
                    ++j;
                }
            }
            ++i;
        }
        HashSet<String> bundleDeps = new HashSet<String>();
        BundleDescription rootDesc = BundleUtils.getBundleDescription(bundle, bundleContext);
        BundleSpecification[] rootSpecs = rootDesc.getRequiredBundles();
        int i2 = 0;
        while (i2 < rootSpecs.length) {
            bundleDeps.add(rootSpecs[i2].getName());
            List specDeps = (List)disjointSets.get(rootSpecs[i2].getName());
            if (specDeps != null) {
                BundleUtils.mergeDependencies(bundleDeps, specDeps, disjointSets);
            }
            ++i2;
        }
        return bundleDeps;
    }

    private static void mergeDependencies(Set bundleDeps, List deps, Map disjointSets) {
        if (deps != null) {
            bundleDeps.addAll(deps);
            Iterator iter = deps.iterator();
            while (iter.hasNext()) {
                String name = (String)iter.next();
                BundleUtils.mergeDependencies(bundleDeps, (List)disjointSets.get(name), disjointSets);
            }
        }
    }

    public static BundleDescription getBundleDescription(Bundle bundle, BundleContext bundleContext) throws PluginConversionException, CoreException, IOException {
        boolean hasBundleStructure;
        String bundleRootLoc;
        int protoIdx = (bundleRootLoc = BundleUtils.getBundleRoot(bundle)).indexOf("file:");
        if ((bundleRootLoc = bundleRootLoc.substring(protoIdx == -1 ? 0 : protoIdx + 5)).endsWith("jar!/")) {
            bundleRootLoc = bundleRootLoc.substring(0, bundleRootLoc.length() - 2);
        }
        File bundleLocation = new File(bundleRootLoc);
        Dictionary manifest = BundleUtils.loadManifest(bundleLocation);
        long bundleId = bundle.getBundleId();
        boolean bl = hasBundleStructure = manifest != null && manifest.get("Bundle-SymbolicName") != null;
        if (!hasBundleStructure) {
            if (!(bundleLocation.isFile() || new File(bundleLocation, "plugin.xml").exists() || new File(bundleLocation, "fragment.xml").exists())) {
                return null;
            }
            PluginConverter converter = BundleUtils.acquirePluginConverter(bundleContext);
            manifest = converter.convertManifest(bundleLocation, false, null, false, null);
            if (manifest == null || "Bundle-SymbolicName" == null) {
                return null;
            }
        }
        try {
            return BundleUtils.getBundleDescription(manifest, bundleLocation, bundleId);
        }
        catch (BundleException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getBundleRoot(Bundle bundle) throws IOException {
        URL url = FileLocator.find((Bundle)bundle, (IPath)new Path("/"), null);
        URL resolvedUrl = FileLocator.resolve((URL)url);
        return resolvedUrl.getPath();
    }

    public static BundleDescription getBundleDescription(Dictionary manifest, File bundleLocation, long bundleId) throws BundleException {
        ServiceReference platformAdminReference;
        BundleContext context = Activator.getBundleContext();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.osgi.service.resolver.PlatformAdmin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((platformAdminReference = context.getServiceReference(clazz.getName())) == null) {
            return null;
        }
        PlatformAdmin admin = (PlatformAdmin)context.getService(platformAdminReference);
        StateObjectFactory stateObjectFactory = admin.getFactory();
        State state = stateObjectFactory.createState(false);
        BundleDescription descriptor = stateObjectFactory.createBundleDescription(state, manifest, bundleLocation.getAbsolutePath(), bundleId);
        context.ungetService(platformAdminReference);
        return descriptor;
    }

    public static Dictionary loadManifest(File bundleLocation) throws IOException {
        Properties properties;
        ZipFile jarFile = null;
        InputStream manifestStream = null;
        try {
            String extension = new Path(bundleLocation.getName()).getFileExtension();
            bundleLocation = new File(bundleLocation.getAbsolutePath());
            if (extension != null && (extension.equals("jar") || extension.equals("jar!")) && bundleLocation.isFile()) {
                jarFile = new ZipFile(bundleLocation, 1);
                ZipEntry manifestEntry = jarFile.getEntry("META-INF/MANIFEST.MF");
                if (manifestEntry != null) {
                    manifestStream = jarFile.getInputStream(manifestEntry);
                }
            } else {
                File file = new File(bundleLocation, "META-INF/MANIFEST.MF");
                if (file.exists()) {
                    manifestStream = new FileInputStream(file);
                }
            }
        }
        catch (IOException iOException) {}
        if (manifestStream == null) {
            return null;
        }
        try {
            Manifest m = new Manifest(manifestStream);
            properties = BundleUtils.manifestToProperties(m.getMainAttributes());
        }
        catch (Throwable throwable) {
            try {
                manifestStream.close();
            }
            catch (IOException iOException) {}
            try {
                if (jarFile != null) {
                    jarFile.close();
                }
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            manifestStream.close();
        }
        catch (IOException iOException) {}
        try {
            if (jarFile != null) {
                jarFile.close();
            }
        }
        catch (IOException iOException) {}
        return properties;
    }

    public static Properties manifestToProperties(Attributes d) {
        Iterator<Object> iter = d.keySet().iterator();
        Properties result = new Properties();
        while (iter.hasNext()) {
            Attributes.Name key = (Attributes.Name)iter.next();
            ((Hashtable)result).put(key.toString(), d.get(key));
        }
        return result;
    }

    public static PluginConverter acquirePluginConverter(BundleContext bundleContext) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.osgi.service.pluginconversion.PluginConverter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ServiceTracker tracker = new ServiceTracker(bundleContext, clazz.getName(), null);
        tracker.open();
        PluginConverter converter = (PluginConverter)tracker.getService();
        tracker.close();
        return converter;
    }
}

