/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.exports;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.pde.internal.core.target.TargetDefinition;
import org.eclipse.pde.internal.core.target.TargetPlatformService;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.SWTFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class TargetDefinitionExportWizardPage
extends WizardPage {
    private static final String PAGE_ID = "org.eclipse.pde.target.exportPage";
    private Button fBrowseButton = null;
    private Combo fDestinationCombo = null;
    private Button fClearDestinationButton = null;

    protected TargetDefinitionExportWizardPage() {
        super(PAGE_ID);
        this.setPageComplete(false);
        this.setTitle(PDEUIMessages.ExportActiveTargetDefinition);
        this.setMessage(PDEUIMessages.ExportActiveTargetDefinition_message);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        container.setLayout((Layout)layout);
        this.createExportDirectoryControl(container);
        this.setControl((Control)container);
        Dialog.applyDialogFont((Control)container);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)container, "org.eclipse.pde.doc.user.target_export_wizard");
    }

    private void createExportDirectoryControl(Composite parent) {
        parent.setLayout((Layout)new GridLayout(3, false));
        parent.setLayoutData((Object)new GridData(768));
        new Label(parent, 0).setText(PDEUIMessages.ExportTargetCurrentTarget);
        Label l = new Label(parent, 0);
        try {
            TargetDefinition definition = (TargetDefinition)TargetPlatformService.getDefault().getWorkspaceTargetHandle().getTargetDefinition();
            l.setText(definition.getName());
        }
        catch (CoreException coreException) {}
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        l.setLayoutData((Object)gd);
        new Label(parent, 0).setText(PDEUIMessages.ExportTargetChooseFolder);
        this.fDestinationCombo = SWTFactory.createCombo(parent, 2048, 1, null);
        this.fDestinationCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TargetDefinitionExportWizardPage.this.controlChanged();
            }
        });
        this.fBrowseButton = new Button(parent, 8);
        this.fBrowseButton.setText(PDEUIMessages.ExportTargetBrowse);
        this.fBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dialog = new DirectoryDialog(TargetDefinitionExportWizardPage.this.getShell());
                dialog.setText(PDEUIMessages.ExportTargetSelectDestination);
                dialog.setMessage(PDEUIMessages.ExportTargetSpecifyDestination);
                String dir = TargetDefinitionExportWizardPage.this.fDestinationCombo.getText();
                dialog.setFilterPath(dir);
                dir = dialog.open();
                if (dir == null || dir.equals("")) {
                    return;
                }
                TargetDefinitionExportWizardPage.this.fDestinationCombo.setText(dir);
                TargetDefinitionExportWizardPage.this.controlChanged();
            }
        });
        this.fClearDestinationButton = new Button(parent, 32);
        this.fClearDestinationButton.setText(PDEUIMessages.ExportTargetClearDestination);
        gd = new GridData();
        gd.horizontalSpan = 2;
        gd.horizontalIndent = 15;
        this.fClearDestinationButton.setLayoutData((Object)gd);
    }

    public String getDestinationDirectory() {
        return this.fDestinationCombo.getText();
    }

    public boolean isClearDestinationDirectory() {
        return this.fClearDestinationButton.getSelection();
    }

    public void controlChanged() {
        this.setPageComplete(this.validate());
    }

    protected boolean validate() {
        this.setMessage(null);
        if (this.fDestinationCombo.getText().equals("")) {
            this.setMessage(PDEUIMessages.ExportTargetError_ChooseDestination, 4);
            return false;
        }
        if (!this.isValidLocation(this.fDestinationCombo.getText().trim())) {
            this.setMessage(PDEUIMessages.ExportTargetError_validPath, 4);
            return false;
        }
        return true;
    }

    protected void initializeCombo(IDialogSettings settings, String key, Combo combo) {
        int i = 0;
        while (i < 6) {
            String curr = settings.get(String.valueOf(key) + String.valueOf(i));
            if (curr != null && combo.indexOf(curr) == -1) {
                combo.add(curr);
            }
            ++i;
        }
        if (combo.getItemCount() > 0) {
            combo.setText(combo.getItem(0));
        }
    }

    protected void saveCombo(IDialogSettings settings, String key, Combo combo) {
        if (combo.getText().trim().length() > 0) {
            settings.put(String.valueOf(key) + String.valueOf(0), combo.getText().trim());
            String[] items = combo.getItems();
            int nEntries = Math.min(items.length, 5);
            int i = 0;
            while (i < nEntries) {
                settings.put(String.valueOf(key) + String.valueOf(i + 1), items[i].trim());
                ++i;
            }
        }
    }

    protected boolean isValidLocation(String location) {
        try {
            String destinationPath = new File(location).getCanonicalPath();
            return destinationPath != null && destinationPath.length() != 0;
        }
        catch (IOException iOException) {
            return false;
        }
    }
}

