/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class MessageBox
extends Dialog {
    String message = "";
    int handle;

    public MessageBox(Shell parent) {
        this(parent, 65570);
    }

    public MessageBox(Shell parent, int style) {
        super(parent, MessageBox.checkStyle(parent, MessageBox.checkStyle(style)));
        this.checkSubclass();
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String string) {
        if (string == null) {
            this.error(4);
        }
        this.message = string;
    }

    public int open() {
        int pixbufs;
        int parentHandle = this.parent != null ? this.parent.topHandle() : 0;
        int dialogFlags = 2;
        if ((this.style & 0x38000) != 0) {
            dialogFlags |= 1;
        }
        int messageType = 0;
        if ((this.style & 8) != 0) {
            messageType = 1;
        }
        if ((this.style & 4) != 0) {
            messageType = 2;
        }
        if ((this.style & 1) != 0) {
            messageType = 3;
        }
        byte[] buffer = Converter.wcsToMbcs(null, this.fixPercent(this.message), true);
        this.handle = OS.gtk_message_dialog_new(parentHandle, dialogFlags, messageType, 0, buffer);
        if (this.handle == 0) {
            SWT.error(2);
        }
        if (parentHandle != 0 && (pixbufs = OS.gtk_window_get_icon_list(parentHandle)) != 0) {
            OS.gtk_window_set_icon_list(this.handle, pixbufs);
            OS.g_list_free(pixbufs);
        }
        Display display = this.parent != null ? this.parent.getDisplay() : Display.getCurrent();
        this.createButtons(display.getDismissalAlignment());
        buffer = Converter.wcsToMbcs(null, this.title, true);
        OS.gtk_window_set_title(this.handle, buffer);
        display.addIdleProc();
        Dialog oldModal = null;
        if (OS.GTK_VERSION >= OS.VERSION(2, 10, 0)) {
            int group = OS.gtk_window_get_group(0);
            OS.gtk_window_group_add_window(group, this.handle);
        }
        if (OS.gtk_window_get_modal(this.handle)) {
            oldModal = display.getModalDialog();
            display.setModalDialog(this);
        }
        int signalId = 0;
        int hookId = 0;
        if ((this.style & 0x4000000) != 0) {
            signalId = OS.g_signal_lookup(OS.map, OS.GTK_TYPE_WIDGET());
            hookId = OS.g_signal_add_emission_hook(signalId, 0, display.emissionProc, this.handle, 0);
        }
        int response = OS.gtk_dialog_run(this.handle);
        if ((this.style & 0x4000000) != 0) {
            OS.g_signal_remove_emission_hook(signalId, hookId);
        }
        if (OS.gtk_window_get_modal(this.handle)) {
            display.setModalDialog(oldModal);
        }
        display.removeIdleProc();
        OS.gtk_widget_destroy(this.handle);
        return response;
    }

    private void createButtons(int alignment) {
        if (alignment == 16384) {
            if ((this.style & 0x20) != 0) {
                OS.gtk_dialog_add_button(this.handle, Converter.wcsToMbcs(null, "gtk-ok", true), 32);
            }
            if ((this.style & 0x200) != 0) {
                OS.gtk_dialog_add_button(this.handle, Converter.wcsToMbcs(null, SWT.getMessage("SWT_Abort"), true), 512);
            }
            if ((this.style & 0x400) != 0) {
                OS.gtk_dialog_add_button(this.handle, Converter.wcsToMbcs(null, SWT.getMessage("SWT_Retry"), true), 1024);
            }
            if ((this.style & 0x40) != 0) {
                OS.gtk_dialog_add_button(this.handle, Converter.wcsToMbcs(null, "gtk-yes", true), 64);
            }
            if ((this.style & 0x80) != 0) {
                OS.gtk_dialog_add_button(this.handle, Converter.wcsToMbcs(null, "gtk-no", true), 128);
            }
            if ((this.style & 0x800) != 0) {
                OS.gtk_dialog_add_button(this.handle, Converter.wcsToMbcs(null, SWT.getMessage("SWT_Ignore"), true), 2048);
            }
            if ((this.style & 0x100) != 0) {
                OS.gtk_dialog_add_button(this.handle, Converter.wcsToMbcs(null, "gtk-cancel", true), 256);
            }
        } else {
            if ((this.style & 0x100) != 0) {
                OS.gtk_dialog_add_button(this.handle, Converter.wcsToMbcs(null, "gtk-cancel", true), 256);
            }
            if ((this.style & 0x20) != 0) {
                OS.gtk_dialog_add_button(this.handle, Converter.wcsToMbcs(null, "gtk-ok", true), 32);
            }
            if ((this.style & 0x80) != 0) {
                OS.gtk_dialog_add_button(this.handle, Converter.wcsToMbcs(null, "gtk-no", true), 128);
            }
            if ((this.style & 0x40) != 0) {
                OS.gtk_dialog_add_button(this.handle, Converter.wcsToMbcs(null, "gtk-yes", true), 64);
            }
            if ((this.style & 0x800) != 0) {
                OS.gtk_dialog_add_button(this.handle, Converter.wcsToMbcs(null, SWT.getMessage("SWT_Ignore"), true), 2048);
            }
            if ((this.style & 0x400) != 0) {
                OS.gtk_dialog_add_button(this.handle, Converter.wcsToMbcs(null, SWT.getMessage("SWT_Retry"), true), 1024);
            }
            if ((this.style & 0x200) != 0) {
                OS.gtk_dialog_add_button(this.handle, Converter.wcsToMbcs(null, SWT.getMessage("SWT_Abort"), true), 512);
            }
        }
    }

    private static int checkStyle(int style) {
        int mask = 4064;
        int bits = style & mask;
        if (bits == 32 || bits == 256 || bits == 288) {
            return style;
        }
        if (bits == 64 || bits == 128 || bits == 192 || bits == 448) {
            return style;
        }
        if (bits == 1280 || bits == 3584) {
            return style;
        }
        style = style & ~mask | 0x20;
        return style;
    }

    char[] fixPercent(String string) {
        int length = string.length();
        char[] text = new char[length];
        string.getChars(0, length, text, 0);
        int i = 0;
        int j = 0;
        char[] result = new char[length * 2];
        while (i < length) {
            switch (text[i]) {
                case '%': {
                    result[j++] = 37;
                }
            }
            result[j++] = text[i++];
        }
        return result;
    }
}

