/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GdkEventButton;
import org.eclipse.swt.internal.gtk.GdkEventExpose;
import org.eclipse.swt.internal.gtk.GdkEventKey;
import org.eclipse.swt.internal.gtk.GdkRectangle;
import org.eclipse.swt.internal.gtk.GtkCellRendererClass;
import org.eclipse.swt.internal.gtk.GtkRequisition;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.ImageList;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.TypedListener;

public class Table
extends Composite {
    int modelHandle;
    int checkRenderer;
    int itemCount;
    int columnCount;
    int lastIndexOf;
    int sortDirection;
    int ignoreCell;
    TableItem[] items;
    TableColumn[] columns;
    TableItem currentItem;
    TableColumn sortColumn;
    ImageList imageList;
    ImageList headerImageList;
    boolean firstCustomDraw;
    int drawState;
    int drawFlags;
    GdkColor drawForeground;
    boolean ownerDraw;
    boolean ignoreSize;
    boolean ignoreAccessibility;
    static final int CHECKED_COLUMN = 0;
    static final int GRAYED_COLUMN = 1;
    static final int FOREGROUND_COLUMN = 2;
    static final int BACKGROUND_COLUMN = 3;
    static final int FONT_COLUMN = 4;
    static final int FIRST_COLUMN = 5;
    static final int CELL_PIXBUF = 0;
    static final int CELL_TEXT = 1;
    static final int CELL_FOREGROUND = 2;
    static final int CELL_BACKGROUND = 3;
    static final int CELL_FONT = 4;
    static final int CELL_TYPES = 5;

    public Table(Composite parent, int style) {
        super(parent, Table.checkStyle(style));
    }

    void _addListener(int eventType, Listener listener) {
        super._addListener(eventType, listener);
        if (!this.ownerDraw) {
            switch (eventType) {
                case 40: 
                case 41: 
                case 42: {
                    this.ownerDraw = true;
                    this.recreateRenderers();
                }
            }
        }
    }

    TableItem _getItem(int index) {
        if ((this.style & 0x10000000) == 0) {
            return this.items[index];
        }
        if (this.items[index] != null) {
            return this.items[index];
        }
        this.items[index] = new TableItem(this, 0, index, false);
        return this.items[index];
    }

    static int checkStyle(int style) {
        if ((style & 0x10) == 0) {
            style |= 0x300;
        }
        return Table.checkBits(style |= 0x10000, 4, 2, 0, 0, 0, 0);
    }

    int cellDataProc(int tree_column, int cell, int tree_model, int iter, int data) {
        boolean isPixbuf;
        if (cell == this.ignoreCell) {
            return 0;
        }
        int path = OS.gtk_tree_model_get_path(tree_model, iter);
        int[] index = new int[1];
        OS.memmove(index, OS.gtk_tree_path_get_indices(path), 4);
        TableItem item = this._getItem(index[0]);
        OS.gtk_tree_path_free(path);
        if (item != null) {
            OS.g_object_set_qdata(cell, Display.SWT_OBJECT_INDEX2, item.handle);
        }
        if (!(isPixbuf = OS.GTK_IS_CELL_RENDERER_PIXBUF(cell)) && !OS.GTK_IS_CELL_RENDERER_TEXT(cell)) {
            return 0;
        }
        int modelIndex = -1;
        boolean customDraw = false;
        if (this.columnCount == 0) {
            modelIndex = 5;
            customDraw = this.firstCustomDraw;
        } else {
            TableColumn column = (TableColumn)this.display.getWidget(tree_column);
            if (column != null) {
                modelIndex = column.modelIndex;
                customDraw = column.customDraw;
            }
        }
        if (modelIndex == -1) {
            return 0;
        }
        boolean setData = false;
        if ((this.style & 0x10000000) != 0) {
            if (OS.GTK_VERSION < OS.VERSION(2, 3, 2)) {
                OS.gtk_widget_realize(this.handle);
                GdkRectangle visible = new GdkRectangle();
                OS.gtk_tree_view_get_visible_rect(this.handle, visible);
                GdkRectangle area = new GdkRectangle();
                path = OS.gtk_tree_model_get_path(tree_model, iter);
                OS.gtk_tree_view_get_cell_area(this.handle, path, tree_column, area);
                OS.gtk_tree_path_free(path);
                if (area.y + area.height < 0 || area.y + visible.y > visible.y + visible.height) {
                    if (this.imageList != null && this.imageList.pixbufs.length > 0 && isPixbuf) {
                        OS.g_object_set(cell, OS.pixbuf, this.imageList.pixbufs[0], 0);
                    }
                    return 0;
                }
            }
            if (!item.cached) {
                this.lastIndexOf = index[0];
                setData = this.checkData(item);
            }
        }
        int[] ptr = new int[1];
        if (setData) {
            ptr[0] = 0;
            if (isPixbuf) {
                OS.gtk_tree_model_get(tree_model, iter, modelIndex + 0, ptr, -1);
                OS.g_object_set(cell, OS.pixbuf, ptr[0], 0);
            } else {
                OS.gtk_tree_model_get(tree_model, iter, modelIndex + 1, ptr, -1);
                if (ptr[0] != 0) {
                    OS.g_object_set(cell, OS.text, ptr[0], 0);
                    OS.g_free(ptr[0]);
                }
            }
        }
        if (customDraw) {
            if (OS.GTK_VERSION > OS.VERSION(2, 2, 1) && !this.ownerDraw) {
                ptr[0] = 0;
                OS.gtk_tree_model_get(tree_model, iter, modelIndex + 3, ptr, -1);
                if (ptr[0] != 0) {
                    OS.g_object_set(cell, OS.cell_background_gdk, ptr[0], 0);
                }
            }
            if (!isPixbuf) {
                ptr[0] = 0;
                OS.gtk_tree_model_get(tree_model, iter, modelIndex + 2, ptr, -1);
                if (ptr[0] != 0) {
                    OS.g_object_set(cell, OS.foreground_gdk, ptr[0], 0);
                }
                ptr[0] = 0;
                OS.gtk_tree_model_get(tree_model, iter, modelIndex + 4, ptr, -1);
                if (ptr[0] != 0) {
                    OS.g_object_set(cell, OS.font_desc, ptr[0], 0);
                }
            }
        }
        if (setData) {
            this.ignoreCell = cell;
            this.setScrollWidth(tree_column, item);
            this.ignoreCell = 0;
        }
        return 0;
    }

    boolean checkData(TableItem item) {
        if (item.cached) {
            return true;
        }
        if ((this.style & 0x10000000) != 0) {
            item.cached = true;
            Event event = new Event();
            event.item = item;
            event.index = this.indexOf(item);
            int mask = 17;
            int signal_id = OS.g_signal_lookup(OS.row_changed, OS.gtk_tree_model_get_type());
            OS.g_signal_handlers_block_matched(this.modelHandle, mask, signal_id, 0, 0, 0, this.handle);
            this.currentItem = item;
            this.sendEvent(36, event);
            this.currentItem = null;
            if (this.isDisposed()) {
                return false;
            }
            OS.g_signal_handlers_unblock_matched(this.modelHandle, mask, signal_id, 0, 0, 0, this.handle);
            if (item.isDisposed()) {
                return false;
            }
        }
        return true;
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    int calculateWidth(int column, int iter) {
        OS.gtk_tree_view_column_cell_set_cell_data(column, this.modelHandle, iter, false, false);
        int width = 0;
        int[] w = new int[1];
        OS.gtk_widget_style_get(this.handle, OS.focus_line_width, w, 0);
        width += 2 * w[0];
        int list = OS.gtk_tree_view_column_get_cell_renderers(column);
        if (list == 0) {
            return 0;
        }
        int temp = list;
        while (temp != 0) {
            int renderer = OS.g_list_data(temp);
            if (renderer != 0) {
                OS.gtk_cell_renderer_get_size(renderer, this.handle, null, null, null, w, null);
                width += w[0];
            }
            temp = OS.g_list_next(temp);
        }
        OS.g_list_free(list);
        if (OS.GTK_VERSION >= OS.VERSION(2, 12, 0) && OS.gtk_tree_view_get_rules_hint(this.handle)) {
            OS.gtk_widget_style_get(this.handle, OS.grid_line_width, w, 0);
            width += 2 * w[0];
        }
        return width;
    }

    public void clear(int index) {
        TableItem item;
        this.checkWidget();
        if (index < 0 || index >= this.itemCount) {
            this.error(6);
        }
        if ((item = this.items[index]) != null) {
            item.clear();
        }
    }

    public void clear(int start, int end) {
        this.checkWidget();
        if (start > end) {
            return;
        }
        if (start < 0 || start > end || end >= this.itemCount) {
            this.error(6);
        }
        if (start == 0 && end == this.itemCount - 1) {
            this.clearAll();
        } else {
            int i = start;
            while (i <= end) {
                TableItem item = this.items[i];
                if (item != null) {
                    item.clear();
                }
                ++i;
            }
        }
    }

    public void clear(int[] indices) {
        this.checkWidget();
        if (indices == null) {
            this.error(4);
        }
        if (indices.length == 0) {
            return;
        }
        int i = 0;
        while (i < indices.length) {
            if (indices[i] < 0 || indices[i] >= this.itemCount) {
                this.error(6);
            }
            ++i;
        }
        i = 0;
        while (i < indices.length) {
            TableItem item = this.items[indices[i]];
            if (item != null) {
                item.clear();
            }
            ++i;
        }
    }

    public void clearAll() {
        this.checkWidget();
        int i = 0;
        while (i < this.itemCount) {
            TableItem item = this.items[i];
            if (item != null) {
                item.clear();
            }
            ++i;
        }
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        if (wHint != -1 && wHint < 0) {
            wHint = 0;
        }
        if (hHint != -1 && hHint < 0) {
            hHint = 0;
        }
        Point size = this.computeNativeSize(this.handle, wHint, hHint, changed);
        Rectangle trim = this.computeTrim(0, 0, size.x, size.y);
        size.x = trim.width;
        size.y = trim.height;
        return size;
    }

    void createColumn(TableColumn column, int index) {
        boolean useVirtual;
        int columnHandle;
        int modelIndex = 5;
        if (this.columnCount != 0) {
            int modelLength = OS.gtk_tree_model_get_n_columns(this.modelHandle);
            boolean[] usedColumns = new boolean[modelLength];
            int i = 0;
            while (i < this.columnCount) {
                int columnIndex = this.columns[i].modelIndex;
                int j = 0;
                while (j < 5) {
                    usedColumns[columnIndex + j] = true;
                    ++j;
                }
                ++i;
            }
            while (modelIndex < modelLength) {
                if (!usedColumns[modelIndex]) break;
                ++modelIndex;
            }
            if (modelIndex == modelLength) {
                int oldModel = this.modelHandle;
                int[] types = this.getColumnTypes(this.columnCount + 4);
                int newModel = OS.gtk_list_store_newv(types.length, types);
                if (newModel == 0) {
                    this.error(2);
                }
                int[] ptr = new int[1];
                int i2 = 0;
                while (i2 < this.itemCount) {
                    int newItem = OS.g_malloc(OS.GtkTreeIter_sizeof());
                    if (newItem == 0) {
                        this.error(2);
                    }
                    OS.gtk_list_store_append(newModel, newItem);
                    TableItem item = this.items[i2];
                    if (item != null) {
                        int oldItem = item.handle;
                        int j = 0;
                        while (j < modelLength) {
                            OS.gtk_tree_model_get(oldModel, oldItem, j, ptr, -1);
                            OS.gtk_list_store_set(newModel, newItem, j, ptr[0], -1);
                            if (types[j] == OS.G_TYPE_STRING()) {
                                OS.g_free(ptr[0]);
                            }
                            ++j;
                        }
                        OS.gtk_list_store_remove(oldModel, oldItem);
                        OS.g_free(oldItem);
                        item.handle = newItem;
                    } else {
                        OS.g_free(newItem);
                    }
                    ++i2;
                }
                OS.gtk_tree_view_set_model(this.handle, newModel);
                OS.g_object_unref(oldModel);
                this.modelHandle = newModel;
            }
        }
        if ((columnHandle = OS.gtk_tree_view_column_new()) == 0) {
            this.error(2);
        }
        if (index == 0 && this.columnCount > 0) {
            TableColumn checkColumn = this.columns[0];
            this.createRenderers(checkColumn.handle, checkColumn.modelIndex, false, checkColumn.style);
        }
        this.createRenderers(columnHandle, modelIndex, index == 0, column == null ? 0 : column.style);
        boolean bl = useVirtual = (this.style & 0x10000000) != 0 && OS.GTK_VERSION >= OS.VERSION(2, 3, 2);
        if (!useVirtual && this.columnCount == 0) {
            OS.gtk_tree_view_column_set_sizing(columnHandle, 0);
        } else {
            OS.gtk_tree_view_column_set_sizing(columnHandle, 2);
            if (this.columnCount != 0) {
                OS.gtk_tree_view_column_set_visible(columnHandle, false);
            }
        }
        OS.gtk_tree_view_column_set_resizable(columnHandle, true);
        OS.gtk_tree_view_column_set_clickable(columnHandle, true);
        OS.gtk_tree_view_column_set_min_width(columnHandle, 0);
        OS.gtk_tree_view_insert_column(this.handle, columnHandle, index);
        if (column != null) {
            column.handle = columnHandle;
            column.modelIndex = modelIndex;
        }
        if (!this.searchEnabled()) {
            if (OS.GTK_VERSION >= OS.VERSION(2, 6, 5)) {
                OS.gtk_tree_view_set_search_column(this.handle, -1);
            } else {
                OS.gtk_tree_view_set_enable_search(this.handle, false);
            }
        } else {
            int firstColumn = this.columnCount == 0 ? 5 : this.columns[0].modelIndex;
            OS.gtk_tree_view_set_search_column(this.handle, firstColumn + 1);
        }
    }

    void createHandle(int index) {
        this.state |= 8;
        this.fixedHandle = OS.g_object_new(this.display.gtk_fixed_get_type(), 0);
        if (this.fixedHandle == 0) {
            this.error(2);
        }
        OS.gtk_fixed_set_has_window(this.fixedHandle, true);
        this.scrolledHandle = OS.gtk_scrolled_window_new(0, 0);
        if (this.scrolledHandle == 0) {
            this.error(2);
        }
        int[] types = this.getColumnTypes(1);
        this.modelHandle = OS.gtk_list_store_newv(types.length, types);
        if (this.modelHandle == 0) {
            this.error(2);
        }
        this.handle = OS.gtk_tree_view_new_with_model(this.modelHandle);
        if (this.handle == 0) {
            this.error(2);
        }
        if ((this.style & 0x20) != 0) {
            this.checkRenderer = OS.gtk_cell_renderer_toggle_new();
            if (this.checkRenderer == 0) {
                this.error(2);
            }
            OS.g_object_ref(this.checkRenderer);
        }
        this.createColumn(null, 0);
        OS.gtk_container_add(this.fixedHandle, this.scrolledHandle);
        OS.gtk_container_add(this.scrolledHandle, this.handle);
        int mode = (this.style & 2) != 0 ? 3 : 2;
        int selectionHandle = OS.gtk_tree_view_get_selection(this.handle);
        OS.gtk_tree_selection_set_mode(selectionHandle, mode);
        OS.gtk_tree_view_set_headers_visible(this.handle, false);
        int hsp = (this.style & 0x100) != 0 ? 1 : 2;
        int vsp = (this.style & 0x200) != 0 ? 1 : 2;
        OS.gtk_scrolled_window_set_policy(this.scrolledHandle, hsp, vsp);
        if ((this.style & 0x800) != 0) {
            OS.gtk_scrolled_window_set_shadow_type(this.scrolledHandle, 3);
        }
        if ((this.style & 0x10000000) != 0 && OS.GTK_VERSION >= OS.VERSION(2, 3, 2)) {
            OS.g_object_set(this.handle, OS.fixed_height_mode, true, 0);
        }
        if (!this.searchEnabled()) {
            if (OS.GTK_VERSION >= OS.VERSION(2, 6, 5)) {
                OS.gtk_tree_view_set_search_column(this.handle, -1);
            } else {
                OS.gtk_tree_view_set_enable_search(this.handle, false);
            }
        }
    }

    void createItem(TableColumn column, int index) {
        int imageHandle;
        int labelHandle;
        if (index < 0 || index > this.columnCount) {
            this.error(6);
        }
        if (this.columnCount == 0) {
            column.handle = OS.gtk_tree_view_get_column(this.handle, 0);
            OS.gtk_tree_view_column_set_sizing(column.handle, 2);
            OS.gtk_tree_view_column_set_visible(column.handle, false);
            column.modelIndex = 5;
            this.createRenderers(column.handle, column.modelIndex, true, column.style);
            column.customDraw = this.firstCustomDraw;
            this.firstCustomDraw = false;
        } else {
            this.createColumn(column, index);
        }
        int boxHandle = OS.gtk_hbox_new(false, 3);
        if (boxHandle == 0) {
            this.error(2);
        }
        if ((labelHandle = OS.gtk_label_new_with_mnemonic(null)) == 0) {
            this.error(2);
        }
        if ((imageHandle = OS.gtk_image_new()) == 0) {
            this.error(2);
        }
        OS.gtk_container_add(boxHandle, imageHandle);
        OS.gtk_container_add(boxHandle, labelHandle);
        OS.gtk_widget_show(boxHandle);
        OS.gtk_widget_show(labelHandle);
        column.labelHandle = labelHandle;
        column.imageHandle = imageHandle;
        OS.gtk_tree_view_column_set_widget(column.handle, boxHandle);
        int widget = OS.gtk_widget_get_parent(boxHandle);
        while (widget != this.handle) {
            if (OS.GTK_IS_BUTTON(widget)) {
                column.buttonHandle = widget;
                break;
            }
            widget = OS.gtk_widget_get_parent(widget);
        }
        if (this.columnCount == this.columns.length) {
            TableColumn[] newColumns = new TableColumn[this.columns.length + 4];
            System.arraycopy(this.columns, 0, newColumns, 0, this.columns.length);
            this.columns = newColumns;
        }
        System.arraycopy(this.columns, index, this.columns, index + 1, this.columnCount++ - index);
        this.columns[index] = column;
        if ((this.state & 0x4000) != 0) {
            column.setFontDescription(this.getFontDescription());
        }
        if (this.columnCount >= 1) {
            int i = 0;
            while (i < this.itemCount) {
                Font[] cellFont;
                TableItem item = this.items[i];
                if (item != null && (cellFont = item.cellFont) != null) {
                    Font[] temp = new Font[this.columnCount];
                    System.arraycopy(cellFont, 0, temp, 0, index);
                    System.arraycopy(cellFont, index, temp, index + 1, this.columnCount - index - 1);
                    item.cellFont = temp;
                }
                ++i;
            }
        }
        if (!this.isVisible()) {
            OS.gtk_container_resize_children(this.handle);
        }
    }

    void createItem(TableItem item, int index) {
        if (index < 0 || index > this.itemCount) {
            this.error(6);
        }
        if (this.itemCount == this.items.length) {
            int length = this.drawCount <= 0 ? this.items.length + 4 : Math.max(4, this.items.length * 3 / 2);
            TableItem[] newItems = new TableItem[length];
            System.arraycopy(this.items, 0, newItems, 0, this.items.length);
            this.items = newItems;
        }
        item.handle = OS.g_malloc(OS.GtkTreeIter_sizeof());
        if (item.handle == 0) {
            this.error(2);
        }
        if (index == this.itemCount) {
            OS.gtk_list_store_append(this.modelHandle, item.handle);
        } else {
            OS.gtk_list_store_insert(this.modelHandle, item.handle, index);
        }
        System.arraycopy(this.items, index, this.items, index + 1, this.itemCount++ - index);
        this.items[index] = item;
    }

    void createRenderers(int columnHandle, int modelIndex, boolean check, int columnStyle) {
        int textRenderer;
        int pixbufRenderer;
        OS.gtk_tree_view_column_clear(columnHandle);
        if ((this.style & 0x20) != 0 && check) {
            OS.gtk_tree_view_column_pack_start(columnHandle, this.checkRenderer, false);
            OS.gtk_tree_view_column_add_attribute(columnHandle, this.checkRenderer, OS.active, 0);
            if (OS.GTK_VERSION >= OS.VERSION(2, 2, 0)) {
                OS.gtk_tree_view_column_add_attribute(columnHandle, this.checkRenderer, OS.inconsistent, 1);
            }
            if (OS.GTK_VERSION > OS.VERSION(2, 2, 1) && !this.ownerDraw) {
                OS.gtk_tree_view_column_add_attribute(columnHandle, this.checkRenderer, OS.cell_background_gdk, 3);
            }
            if (this.ownerDraw) {
                OS.gtk_tree_view_column_set_cell_data_func(columnHandle, this.checkRenderer, this.display.cellDataProc, this.handle, 0);
                OS.g_object_set_qdata(this.checkRenderer, Display.SWT_OBJECT_INDEX1, columnHandle);
            }
        }
        int n = pixbufRenderer = this.ownerDraw ? OS.g_object_new(this.display.gtk_cell_renderer_pixbuf_get_type(), 0) : OS.gtk_cell_renderer_pixbuf_new();
        if (pixbufRenderer == 0) {
            this.error(2);
        }
        int n2 = textRenderer = this.ownerDraw ? OS.g_object_new(this.display.gtk_cell_renderer_text_get_type(), 0) : OS.gtk_cell_renderer_text_new();
        if (textRenderer == 0) {
            this.error(2);
        }
        if (this.ownerDraw) {
            OS.g_object_set_qdata(pixbufRenderer, Display.SWT_OBJECT_INDEX1, columnHandle);
            OS.g_object_set_qdata(textRenderer, Display.SWT_OBJECT_INDEX1, columnHandle);
        }
        if ((this.style & 0x20) != 0 && check) {
            OS.g_object_set(pixbufRenderer, OS.mode, 1, 0);
        }
        if ((columnStyle & 0x20000) != 0) {
            OS.g_object_set(textRenderer, OS.xalign, 1.0f, 0);
            OS.gtk_tree_view_column_pack_end(columnHandle, textRenderer, true);
            OS.gtk_tree_view_column_pack_end(columnHandle, pixbufRenderer, false);
            OS.gtk_tree_view_column_set_alignment(columnHandle, 1.0f);
        } else if ((columnStyle & 0x1000000) != 0) {
            OS.g_object_set(textRenderer, OS.xalign, 0.5f, 0);
            OS.gtk_tree_view_column_pack_start(columnHandle, pixbufRenderer, false);
            OS.gtk_tree_view_column_pack_end(columnHandle, textRenderer, true);
            OS.gtk_tree_view_column_set_alignment(columnHandle, 0.5f);
        } else {
            OS.gtk_tree_view_column_pack_start(columnHandle, pixbufRenderer, false);
            OS.gtk_tree_view_column_pack_start(columnHandle, textRenderer, true);
            OS.gtk_tree_view_column_set_alignment(columnHandle, 0.0f);
        }
        OS.gtk_tree_view_column_add_attribute(columnHandle, pixbufRenderer, OS.pixbuf, modelIndex + 0);
        if (OS.GTK_VERSION > OS.VERSION(2, 2, 1) && !this.ownerDraw) {
            OS.gtk_tree_view_column_add_attribute(columnHandle, pixbufRenderer, OS.cell_background_gdk, 3);
            OS.gtk_tree_view_column_add_attribute(columnHandle, textRenderer, OS.cell_background_gdk, 3);
        }
        OS.gtk_tree_view_column_add_attribute(columnHandle, textRenderer, OS.text, modelIndex + 1);
        OS.gtk_tree_view_column_add_attribute(columnHandle, textRenderer, OS.foreground_gdk, 2);
        OS.gtk_tree_view_column_add_attribute(columnHandle, textRenderer, OS.font_desc, 4);
        boolean customDraw = this.firstCustomDraw;
        if (this.columnCount != 0) {
            int i = 0;
            while (i < this.columnCount) {
                if (this.columns[i].handle == columnHandle) {
                    customDraw = this.columns[i].customDraw;
                    break;
                }
                ++i;
            }
        }
        if ((this.style & 0x10000000) != 0 || customDraw || this.ownerDraw) {
            OS.gtk_tree_view_column_set_cell_data_func(columnHandle, textRenderer, this.display.cellDataProc, this.handle, 0);
            OS.gtk_tree_view_column_set_cell_data_func(columnHandle, pixbufRenderer, this.display.cellDataProc, this.handle, 0);
        }
    }

    void createWidget(int index) {
        super.createWidget(index);
        this.items = new TableItem[4];
        this.columns = new TableColumn[4];
        this.columnCount = 0;
        this.itemCount = 0;
    }

    GdkColor defaultBackground() {
        return this.display.COLOR_LIST_BACKGROUND;
    }

    GdkColor defaultForeground() {
        return this.display.COLOR_LIST_FOREGROUND;
    }

    void deregister() {
        super.deregister();
        this.display.removeWidget(OS.gtk_tree_view_get_selection(this.handle));
        if (this.checkRenderer != 0) {
            this.display.removeWidget(this.checkRenderer);
        }
        this.display.removeWidget(this.modelHandle);
    }

    public void deselect(int index) {
        this.checkWidget();
        if (index < 0 || index >= this.itemCount) {
            return;
        }
        boolean fixColumn = this.showFirstColumn();
        int selection = OS.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(selection, 16, 0, 0, 0, 0, 6);
        OS.gtk_tree_selection_unselect_iter(selection, this._getItem((int)index).handle);
        OS.g_signal_handlers_unblock_matched(selection, 16, 0, 0, 0, 0, 6);
        if (fixColumn) {
            this.hideFirstColumn();
        }
    }

    public void deselect(int start, int end) {
        this.checkWidget();
        boolean fixColumn = this.showFirstColumn();
        int selection = OS.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(selection, 16, 0, 0, 0, 0, 6);
        int index = start;
        while (index <= end) {
            if (index >= 0 && index < this.itemCount) {
                OS.gtk_tree_selection_unselect_iter(selection, this._getItem((int)index).handle);
            }
            ++index;
        }
        OS.g_signal_handlers_unblock_matched(selection, 16, 0, 0, 0, 0, 6);
        if (fixColumn) {
            this.hideFirstColumn();
        }
    }

    public void deselect(int[] indices) {
        this.checkWidget();
        if (indices == null) {
            this.error(4);
        }
        boolean fixColumn = this.showFirstColumn();
        int selection = OS.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(selection, 16, 0, 0, 0, 0, 6);
        int i = 0;
        while (i < indices.length) {
            int index = indices[i];
            if (index >= 0 && index < this.itemCount) {
                OS.gtk_tree_selection_unselect_iter(selection, this._getItem((int)index).handle);
            }
            ++i;
        }
        OS.g_signal_handlers_unblock_matched(selection, 16, 0, 0, 0, 0, 6);
        if (fixColumn) {
            this.hideFirstColumn();
        }
    }

    public void deselectAll() {
        this.checkWidget();
        boolean fixColumn = this.showFirstColumn();
        int selection = OS.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(selection, 16, 0, 0, 0, 0, 6);
        OS.gtk_tree_selection_unselect_all(selection);
        OS.g_signal_handlers_unblock_matched(selection, 16, 0, 0, 0, 0, 6);
        if (fixColumn) {
            this.hideFirstColumn();
        }
    }

    void destroyItem(TableColumn column) {
        int index = 0;
        while (index < this.columnCount) {
            if (this.columns[index] == column) break;
            ++index;
        }
        if (index == this.columnCount) {
            return;
        }
        int columnHandle = column.handle;
        if (this.columnCount == 1) {
            this.firstCustomDraw = column.customDraw;
        }
        System.arraycopy(this.columns, index + 1, this.columns, index, --this.columnCount - index);
        this.columns[this.columnCount] = null;
        OS.gtk_tree_view_remove_column(this.handle, columnHandle);
        if (this.columnCount == 0) {
            int oldModel = this.modelHandle;
            int[] types = this.getColumnTypes(1);
            int newModel = OS.gtk_list_store_newv(types.length, types);
            if (newModel == 0) {
                this.error(2);
            }
            int[] ptr = new int[1];
            int i = 0;
            while (i < this.itemCount) {
                int newItem = OS.g_malloc(OS.GtkTreeIter_sizeof());
                if (newItem == 0) {
                    this.error(2);
                }
                OS.gtk_list_store_append(newModel, newItem);
                TableItem item = this.items[i];
                if (item != null) {
                    int oldItem = item.handle;
                    int j = 0;
                    while (j < 5) {
                        OS.gtk_tree_model_get(oldModel, oldItem, j, ptr, -1);
                        OS.gtk_list_store_set(newModel, newItem, j, ptr[0], -1);
                        ++j;
                    }
                    OS.gtk_tree_model_get(oldModel, oldItem, column.modelIndex + 0, ptr, -1);
                    OS.gtk_list_store_set(newModel, newItem, 5, ptr[0], -1);
                    OS.gtk_tree_model_get(oldModel, oldItem, column.modelIndex + 1, ptr, -1);
                    OS.gtk_list_store_set(newModel, newItem, 6, ptr[0], -1);
                    OS.g_free(ptr[0]);
                    OS.gtk_tree_model_get(oldModel, oldItem, column.modelIndex + 2, ptr, -1);
                    OS.gtk_list_store_set(newModel, newItem, 7, ptr[0], -1);
                    OS.gtk_tree_model_get(oldModel, oldItem, column.modelIndex + 3, ptr, -1);
                    OS.gtk_list_store_set(newModel, newItem, 8, ptr[0], -1);
                    OS.gtk_tree_model_get(oldModel, oldItem, column.modelIndex + 4, ptr, -1);
                    OS.gtk_list_store_set(newModel, newItem, 9, ptr[0], -1);
                    OS.gtk_list_store_remove(oldModel, oldItem);
                    OS.g_free(oldItem);
                    item.handle = newItem;
                } else {
                    OS.g_free(newItem);
                }
                ++i;
            }
            OS.gtk_tree_view_set_model(this.handle, newModel);
            OS.g_object_unref(oldModel);
            this.modelHandle = newModel;
            this.createColumn(null, 0);
        } else {
            int i = 0;
            while (i < this.itemCount) {
                TableItem item = this.items[i];
                if (item != null) {
                    int iter = item.handle;
                    int modelIndex = column.modelIndex;
                    OS.gtk_list_store_set(this.modelHandle, iter, modelIndex + 0, 0, -1);
                    OS.gtk_list_store_set(this.modelHandle, iter, modelIndex + 1, 0, -1);
                    OS.gtk_list_store_set(this.modelHandle, iter, modelIndex + 2, 0, -1);
                    OS.gtk_list_store_set(this.modelHandle, iter, modelIndex + 3, 0, -1);
                    OS.gtk_list_store_set(this.modelHandle, iter, modelIndex + 4, 0, -1);
                    Font[] cellFont = item.cellFont;
                    if (cellFont != null) {
                        if (this.columnCount == 0) {
                            item.cellFont = null;
                        } else {
                            Font[] temp = new Font[this.columnCount];
                            System.arraycopy(cellFont, 0, temp, 0, index);
                            System.arraycopy(cellFont, index + 1, temp, index, this.columnCount - index);
                            item.cellFont = temp;
                        }
                    }
                }
                ++i;
            }
            if (index == 0) {
                TableColumn checkColumn = this.columns[0];
                this.createRenderers(checkColumn.handle, checkColumn.modelIndex, true, checkColumn.style);
            }
        }
        if (!this.searchEnabled()) {
            if (OS.GTK_VERSION >= OS.VERSION(2, 6, 5)) {
                OS.gtk_tree_view_set_search_column(this.handle, -1);
            } else {
                OS.gtk_tree_view_set_enable_search(this.handle, false);
            }
        } else {
            int firstColumn = this.columnCount == 0 ? 5 : this.columns[0].modelIndex;
            OS.gtk_tree_view_set_search_column(this.handle, firstColumn + 1);
        }
    }

    void destroyItem(TableItem item) {
        int index = 0;
        while (index < this.itemCount) {
            if (this.items[index] == item) break;
            ++index;
        }
        if (index == this.itemCount) {
            return;
        }
        int selection = OS.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(selection, 16, 0, 0, 0, 0, 6);
        OS.gtk_list_store_remove(this.modelHandle, item.handle);
        OS.g_signal_handlers_unblock_matched(selection, 16, 0, 0, 0, 0, 6);
        System.arraycopy(this.items, index + 1, this.items, index, --this.itemCount - index);
        this.items[this.itemCount] = null;
        if (this.itemCount == 0) {
            this.resetCustomDraw();
        }
    }

    boolean dragDetect(int x, int y, boolean filter, boolean[] consume) {
        boolean dragDetect;
        boolean selected = false;
        if (filter) {
            int[] path = new int[1];
            if (OS.gtk_tree_view_get_path_at_pos(this.handle, x, y, path, null, null, null)) {
                if (path[0] != 0) {
                    int selection = OS.gtk_tree_view_get_selection(this.handle);
                    if (OS.gtk_tree_selection_path_is_selected(selection, path[0])) {
                        selected = true;
                    }
                    OS.gtk_tree_path_free(path[0]);
                }
            } else {
                return false;
            }
        }
        if ((dragDetect = super.dragDetect(x, y, filter, consume)) && selected && consume != null) {
            consume[0] = true;
        }
        return dragDetect;
    }

    int eventWindow() {
        return this.paintWindow();
    }

    boolean fixAccessibility() {
        return OS.GTK_VERSION >= OS.VERSION(2, 12, 0);
    }

    void fixChildren(Shell newShell, Shell oldShell, Decorations newDecorations, Decorations oldDecorations, Menu[] menus) {
        super.fixChildren(newShell, oldShell, newDecorations, oldDecorations, menus);
        int i = 0;
        while (i < this.columnCount) {
            TableColumn column = this.columns[i];
            if (column.toolTipText != null) {
                column.setToolTipText(oldShell, null);
                column.setToolTipText(newShell, column.toolTipText);
            }
            ++i;
        }
    }

    GdkColor getBackgroundColor() {
        return this.getBaseColor();
    }

    public Rectangle getClientArea() {
        this.checkWidget();
        this.forceResize();
        OS.gtk_widget_realize(this.handle);
        int fixedWindow = OS.GTK_WIDGET_WINDOW(this.fixedHandle);
        int binWindow = OS.gtk_tree_view_get_bin_window(this.handle);
        int[] binX = new int[1];
        int[] binY = new int[1];
        OS.gdk_window_get_origin(binWindow, binX, binY);
        int[] fixedX = new int[1];
        int[] fixedY = new int[1];
        OS.gdk_window_get_origin(fixedWindow, fixedX, fixedY);
        int clientHandle = this.clientHandle();
        int width = (this.state & 0x200) != 0 ? 0 : OS.GTK_WIDGET_WIDTH(clientHandle);
        int height = (this.state & 0x400) != 0 ? 0 : OS.GTK_WIDGET_HEIGHT(clientHandle);
        return new Rectangle(fixedX[0] - binX[0], fixedY[0] - binY[0], width, height);
    }

    int getClientWidth() {
        int[] w = new int[1];
        int[] h = new int[1];
        OS.gtk_widget_realize(this.handle);
        OS.gdk_drawable_get_size(OS.gtk_tree_view_get_bin_window(this.handle), w, h);
        return w[0];
    }

    public TableColumn getColumn(int index) {
        this.checkWidget();
        if (index < 0 || index >= this.columnCount) {
            this.error(6);
        }
        return this.columns[index];
    }

    public int getColumnCount() {
        this.checkWidget();
        return this.columnCount;
    }

    int[] getColumnTypes(int columnCount) {
        int[] types = new int[5 + columnCount * 5];
        types[0] = OS.G_TYPE_BOOLEAN();
        types[1] = OS.G_TYPE_BOOLEAN();
        types[2] = OS.GDK_TYPE_COLOR();
        types[3] = OS.GDK_TYPE_COLOR();
        types[4] = OS.PANGO_TYPE_FONT_DESCRIPTION();
        int i = 5;
        while (i < types.length) {
            types[i + 0] = OS.GDK_TYPE_PIXBUF();
            types[i + 1] = OS.G_TYPE_STRING();
            types[i + 2] = OS.GDK_TYPE_COLOR();
            types[i + 3] = OS.GDK_TYPE_COLOR();
            types[i + 4] = OS.PANGO_TYPE_FONT_DESCRIPTION();
            i += 5;
        }
        return types;
    }

    public int[] getColumnOrder() {
        this.checkWidget();
        if (this.columnCount == 0) {
            return new int[0];
        }
        int list = OS.gtk_tree_view_get_columns(this.handle);
        if (list == 0) {
            return new int[0];
        }
        int i = 0;
        int count = OS.g_list_length(list);
        int[] order = new int[count];
        int temp = list;
        while (temp != 0) {
            int column = OS.g_list_data(temp);
            if (column != 0) {
                int j = 0;
                while (j < this.columnCount) {
                    if (this.columns[j].handle == column) {
                        order[i++] = j;
                        break;
                    }
                    ++j;
                }
            }
            temp = OS.g_list_next(temp);
        }
        OS.g_list_free(list);
        return order;
    }

    public TableColumn[] getColumns() {
        this.checkWidget();
        TableColumn[] result = new TableColumn[this.columnCount];
        System.arraycopy(this.columns, 0, result, 0, this.columnCount);
        return result;
    }

    TableItem getFocusItem() {
        int[] path = new int[1];
        OS.gtk_tree_view_get_cursor(this.handle, path, null);
        if (path[0] == 0) {
            return null;
        }
        TableItem item = null;
        int indices = OS.gtk_tree_path_get_indices(path[0]);
        if (indices != 0) {
            int[] index = new int[]{-1};
            OS.memmove(index, indices, 4);
            item = this._getItem(index[0]);
        }
        OS.gtk_tree_path_free(path[0]);
        return item;
    }

    GdkColor getForegroundColor() {
        return this.getTextColor();
    }

    public int getGridLineWidth() {
        this.checkWidget();
        return 0;
    }

    public int getHeaderHeight() {
        this.checkWidget();
        if (!OS.gtk_tree_view_get_headers_visible(this.handle)) {
            return 0;
        }
        if (this.columnCount > 0) {
            GtkRequisition requisition = new GtkRequisition();
            int height = 0;
            int i = 0;
            while (i < this.columnCount) {
                int buttonHandle = this.columns[i].buttonHandle;
                if (buttonHandle != 0) {
                    OS.gtk_widget_size_request(buttonHandle, requisition);
                    height = Math.max(height, requisition.height);
                }
                ++i;
            }
            return height;
        }
        OS.gtk_widget_realize(this.handle);
        int fixedWindow = OS.GTK_WIDGET_WINDOW(this.fixedHandle);
        int binWindow = OS.gtk_tree_view_get_bin_window(this.handle);
        int[] binY = new int[1];
        OS.gdk_window_get_origin(binWindow, null, binY);
        int[] fixedY = new int[1];
        OS.gdk_window_get_origin(fixedWindow, null, fixedY);
        return binY[0] - fixedY[0];
    }

    public boolean getHeaderVisible() {
        this.checkWidget();
        return OS.gtk_tree_view_get_headers_visible(this.handle);
    }

    public TableItem getItem(int index) {
        this.checkWidget();
        if (index < 0 || index >= this.itemCount) {
            this.error(6);
        }
        return this._getItem(index);
    }

    public TableItem getItem(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        int[] path = new int[1];
        OS.gtk_widget_realize(this.handle);
        if (!OS.gtk_tree_view_get_path_at_pos(this.handle, point.x, point.y, path, null, null, null)) {
            return null;
        }
        if (path[0] == 0) {
            return null;
        }
        int indices = OS.gtk_tree_path_get_indices(path[0]);
        TableItem item = null;
        if (indices != 0) {
            int[] index = new int[1];
            OS.memmove(index, indices, 4);
            item = this._getItem(index[0]);
        }
        OS.gtk_tree_path_free(path[0]);
        return item;
    }

    public int getItemCount() {
        this.checkWidget();
        return this.itemCount;
    }

    public int getItemHeight() {
        this.checkWidget();
        if (this.itemCount == 0) {
            int column = OS.gtk_tree_view_get_column(this.handle, 0);
            int[] w = new int[1];
            int[] h = new int[1];
            this.ignoreSize = true;
            OS.gtk_tree_view_column_cell_get_size(column, null, null, null, w, h);
            this.ignoreSize = false;
            return h[0];
        }
        int height = 0;
        int iter = OS.g_malloc(OS.GtkTreeIter_sizeof());
        OS.gtk_tree_model_get_iter_first(this.modelHandle, iter);
        int columnCount = Math.max(1, this.columnCount);
        int i = 0;
        while (i < columnCount) {
            int column = OS.gtk_tree_view_get_column(this.handle, i);
            OS.gtk_tree_view_column_cell_set_cell_data(column, this.modelHandle, iter, false, false);
            int[] w = new int[1];
            int[] h = new int[1];
            OS.gtk_tree_view_column_cell_get_size(column, null, null, null, w, h);
            height = Math.max(height, h[0]);
            ++i;
        }
        OS.g_free(iter);
        return height;
    }

    public TableItem[] getItems() {
        this.checkWidget();
        TableItem[] result = new TableItem[this.itemCount];
        if ((this.style & 0x10000000) != 0) {
            int i = 0;
            while (i < this.itemCount) {
                result[i] = this._getItem(i);
                ++i;
            }
        } else {
            System.arraycopy(this.items, 0, result, 0, this.itemCount);
        }
        return result;
    }

    public boolean getLinesVisible() {
        this.checkWidget();
        return OS.gtk_tree_view_get_rules_hint(this.handle);
    }

    int getPixbufRenderer(int column) {
        int list = OS.gtk_tree_view_column_get_cell_renderers(column);
        if (list == 0) {
            return 0;
        }
        int count = OS.g_list_length(list);
        int pixbufRenderer = 0;
        int i = 0;
        while (i < count) {
            int renderer = OS.g_list_nth_data(list, i);
            if (OS.GTK_IS_CELL_RENDERER_PIXBUF(renderer)) {
                pixbufRenderer = renderer;
                break;
            }
            ++i;
        }
        OS.g_list_free(list);
        return pixbufRenderer;
    }

    public TableItem[] getSelection() {
        this.checkWidget();
        int selection = OS.gtk_tree_view_get_selection(this.handle);
        if (OS.GTK_VERSION < OS.VERSION(2, 2, 0)) {
            this.display.treeSelectionLength = 0;
            this.display.treeSelection = new int[this.itemCount];
            OS.gtk_tree_selection_selected_foreach(selection, this.display.treeSelectionProc, this.handle);
            TableItem[] result = new TableItem[this.display.treeSelectionLength];
            int i = 0;
            while (i < result.length) {
                result[i] = this._getItem(this.display.treeSelection[i]);
                ++i;
            }
            return result;
        }
        int[] model = OS.GTK_VERSION < OS.VERSION(2, 2, 4) ? new int[1] : null;
        int list = OS.gtk_tree_selection_get_selected_rows(selection, model);
        if (list != 0) {
            int count = OS.g_list_length(list);
            int[] treeSelection = new int[count];
            int length = 0;
            int i = 0;
            while (i < count) {
                int data = OS.g_list_nth_data(list, i);
                int indices = OS.gtk_tree_path_get_indices(data);
                if (indices != 0) {
                    int[] index = new int[1];
                    OS.memmove(index, indices, 4);
                    treeSelection[length] = index[0];
                    ++length;
                }
                ++i;
            }
            OS.g_list_free(list);
            TableItem[] result = new TableItem[length];
            int i2 = 0;
            while (i2 < result.length) {
                result[i2] = this._getItem(treeSelection[i2]);
                ++i2;
            }
            return result;
        }
        return new TableItem[0];
    }

    public int getSelectionCount() {
        this.checkWidget();
        int selection = OS.gtk_tree_view_get_selection(this.handle);
        if (OS.GTK_VERSION < OS.VERSION(2, 2, 0)) {
            this.display.treeSelectionLength = 0;
            this.display.treeSelection = null;
            OS.gtk_tree_selection_selected_foreach(selection, this.display.treeSelectionProc, this.handle);
            return this.display.treeSelectionLength;
        }
        return OS.gtk_tree_selection_count_selected_rows(selection);
    }

    public int getSelectionIndex() {
        int[] model;
        this.checkWidget();
        if (OS.GTK_VERSION < OS.VERSION(2, 2, 0)) {
            this.display.treeSelectionLength = 0;
            this.display.treeSelection = new int[this.itemCount];
            int selection = OS.gtk_tree_view_get_selection(this.handle);
            OS.gtk_tree_selection_selected_foreach(selection, this.display.treeSelectionProc, this.handle);
            if (this.display.treeSelectionLength == 0) {
                return -1;
            }
            return this.display.treeSelection[0];
        }
        int selection = OS.gtk_tree_view_get_selection(this.handle);
        int list = OS.gtk_tree_selection_get_selected_rows(selection, model = OS.GTK_VERSION < OS.VERSION(2, 2, 4) ? new int[1] : null);
        if (list != 0) {
            int count = OS.g_list_length(list);
            int[] index = new int[1];
            int i = 0;
            while (i < count) {
                int data = OS.g_list_nth_data(list, i);
                int indices = OS.gtk_tree_path_get_indices(data);
                if (indices != 0) {
                    OS.memmove(index, indices, 4);
                    break;
                }
                ++i;
            }
            OS.g_list_free(list);
            return index[0];
        }
        return -1;
    }

    public int[] getSelectionIndices() {
        this.checkWidget();
        int selection = OS.gtk_tree_view_get_selection(this.handle);
        if (OS.GTK_VERSION < OS.VERSION(2, 2, 0)) {
            this.display.treeSelectionLength = 0;
            this.display.treeSelection = new int[this.itemCount];
            OS.gtk_tree_selection_selected_foreach(selection, this.display.treeSelectionProc, this.handle);
            if (this.display.treeSelectionLength == this.display.treeSelection.length) {
                return this.display.treeSelection;
            }
            int[] result = new int[this.display.treeSelectionLength];
            System.arraycopy(this.display.treeSelection, 0, result, 0, this.display.treeSelectionLength);
            return result;
        }
        int[] model = OS.GTK_VERSION < OS.VERSION(2, 2, 4) ? new int[1] : null;
        int list = OS.gtk_tree_selection_get_selected_rows(selection, model);
        if (list != 0) {
            int count = OS.g_list_length(list);
            int[] treeSelection = new int[count];
            int length = 0;
            int i = 0;
            while (i < count) {
                int data = OS.g_list_nth_data(list, i);
                int indices = OS.gtk_tree_path_get_indices(data);
                if (indices != 0) {
                    int[] index = new int[1];
                    OS.memmove(index, indices, 4);
                    treeSelection[length] = index[0];
                    ++length;
                }
                ++i;
            }
            OS.g_list_free(list);
            int[] result = new int[length];
            System.arraycopy(treeSelection, 0, result, 0, length);
            return result;
        }
        return new int[0];
    }

    public TableColumn getSortColumn() {
        this.checkWidget();
        return this.sortColumn;
    }

    public int getSortDirection() {
        this.checkWidget();
        return this.sortDirection;
    }

    int getTextRenderer(int column) {
        int list = OS.gtk_tree_view_column_get_cell_renderers(column);
        if (list == 0) {
            return 0;
        }
        int count = OS.g_list_length(list);
        int textRenderer = 0;
        int i = 0;
        while (i < count) {
            int renderer = OS.g_list_nth_data(list, i);
            if (OS.GTK_IS_CELL_RENDERER_TEXT(renderer)) {
                textRenderer = renderer;
                break;
            }
            ++i;
        }
        OS.g_list_free(list);
        return textRenderer;
    }

    public int getTopIndex() {
        this.checkWidget();
        int[] path = new int[1];
        OS.gtk_widget_realize(this.handle);
        if (!OS.gtk_tree_view_get_path_at_pos(this.handle, 1, 1, path, null, null, null)) {
            return 0;
        }
        if (path[0] == 0) {
            return 0;
        }
        int indices = OS.gtk_tree_path_get_indices(path[0]);
        int[] index = new int[1];
        if (indices != 0) {
            OS.memmove(index, indices, 4);
        }
        OS.gtk_tree_path_free(path[0]);
        return index[0];
    }

    int gtk_button_press_event(int widget, int event) {
        int selection;
        int[] path;
        GdkEventButton gdkEvent = new GdkEventButton();
        OS.memmove(gdkEvent, event, GdkEventButton.sizeof);
        if (gdkEvent.window != OS.gtk_tree_view_get_bin_window(this.handle)) {
            return 0;
        }
        int result = super.gtk_button_press_event(widget, event);
        if (result != 0) {
            return result;
        }
        int button = gdkEvent.button;
        if (button == 3 && gdkEvent.type == 4 && OS.gtk_tree_view_get_path_at_pos(this.handle, (int)gdkEvent.x, (int)gdkEvent.y, path = new int[1], null, null, null) && path[0] != 0) {
            selection = OS.gtk_tree_view_get_selection(this.handle);
            if (OS.gtk_tree_selection_path_is_selected(selection, path[0])) {
                result = 1;
            }
            OS.gtk_tree_path_free(path[0]);
        }
        if ((this.style & 4) != 0 && this.getSelectionCount() == 0 && OS.gtk_tree_view_get_path_at_pos(this.handle, (int)gdkEvent.x, (int)gdkEvent.y, path = new int[1], null, null, null) && path[0] != 0) {
            selection = OS.gtk_tree_view_get_selection(this.handle);
            OS.g_signal_handlers_block_matched(selection, 16, 0, 0, 0, 0, 6);
            OS.gtk_tree_view_set_cursor(this.handle, path[0], 0, false);
            OS.g_signal_handlers_unblock_matched(selection, 16, 0, 0, 0, 0, 6);
            OS.gtk_tree_path_free(path[0]);
        }
        if (!OS.GTK_WIDGET_HAS_FOCUS(this.handle)) {
            OS.gtk_widget_grab_focus(this.handle);
        }
        return result;
    }

    int gtk_button_release_event(int widget, int event) {
        int window = OS.GDK_EVENT_WINDOW(event);
        if (window != OS.gtk_tree_view_get_bin_window(this.handle)) {
            return 0;
        }
        return super.gtk_button_release_event(widget, event);
    }

    int gtk_changed(int widget) {
        TableItem item = this.getFocusItem();
        if (item != null) {
            Event event = new Event();
            event.item = item;
            this.sendSelectionEvent(13, event, false);
        }
        return 0;
    }

    int gtk_expose_event(int widget, int eventPtr) {
        Control control;
        if ((this.state & 0x40) != 0) {
            return 0;
        }
        if (((this.state & 0x8000) != 0 || this.backgroundImage != null) && (control = this.findBackgroundControl()) != null) {
            GdkEventExpose gdkEvent = new GdkEventExpose();
            OS.memmove(gdkEvent, eventPtr, GdkEventExpose.sizeof);
            int window = OS.gtk_tree_view_get_bin_window(this.handle);
            if (window == gdkEvent.window) {
                int[] width = new int[1];
                int[] height = new int[1];
                OS.gdk_drawable_get_size(window, width, height);
                int bottom = 0;
                if (this.itemCount != 0) {
                    int iter = OS.g_malloc(OS.GtkTreeIter_sizeof());
                    OS.gtk_tree_model_iter_nth_child(this.modelHandle, iter, 0, this.itemCount - 1);
                    int path = OS.gtk_tree_model_get_path(this.modelHandle, iter);
                    GdkRectangle rect = new GdkRectangle();
                    OS.gtk_tree_view_get_cell_area(this.handle, path, 0, rect);
                    bottom = rect.y + rect.height;
                    OS.gtk_tree_path_free(path);
                    OS.g_free(iter);
                }
                if (height[0] > bottom) {
                    this.drawBackground(control, window, gdkEvent.region, 0, bottom, width[0], height[0] - bottom);
                }
            }
        }
        return super.gtk_expose_event(widget, eventPtr);
    }

    int gtk_key_press_event(int widget, int eventPtr) {
        int result = super.gtk_key_press_event(widget, eventPtr);
        if (result != 0) {
            return result;
        }
        if (OS.GTK_VERSION < OS.VERSION(2, 2, 0)) {
            GdkEventKey keyEvent = new GdkEventKey();
            OS.memmove(keyEvent, eventPtr, GdkEventKey.sizeof);
            int key = keyEvent.keyval;
            switch (key) {
                case 65293: 
                case 65421: {
                    Event event = new Event();
                    event.item = this.getFocusItem();
                    this.sendSelectionEvent(14, event, false);
                }
            }
        }
        return result;
    }

    int gtk_popup_menu(int widget) {
        int result = super.gtk_popup_menu(widget);
        return OS.GTK_VERSION < OS.VERSION(2, 6, 5) ? 1 : result;
    }

    int gtk_motion_notify_event(int widget, int event) {
        int window = OS.GDK_EVENT_WINDOW(event);
        if (window != OS.gtk_tree_view_get_bin_window(this.handle)) {
            return 0;
        }
        return super.gtk_motion_notify_event(widget, event);
    }

    int gtk_row_activated(int tree, int path, int column) {
        TableItem item = null;
        int indices = OS.gtk_tree_path_get_indices(path);
        if (indices != 0) {
            int[] index = new int[]{-1};
            OS.memmove(index, indices, 4);
            item = this._getItem(index[0]);
        }
        Event event = new Event();
        event.item = item;
        this.sendSelectionEvent(14, event, false);
        return 0;
    }

    int gtk_row_deleted(int model, int path) {
        if (this.ignoreAccessibility) {
            OS.g_signal_stop_emission_by_name(model, OS.row_deleted);
        }
        return 0;
    }

    int gtk_row_inserted(int model, int path, int iter) {
        if (this.ignoreAccessibility) {
            OS.g_signal_stop_emission_by_name(model, OS.row_inserted);
        }
        return 0;
    }

    int gtk_start_interactive_search(int widget) {
        if (!this.searchEnabled()) {
            OS.g_signal_stop_emission_by_name(widget, OS.start_interactive_search);
            return 1;
        }
        return 0;
    }

    int gtk_toggled(int renderer, int pathStr) {
        int path = OS.gtk_tree_path_new_from_string(pathStr);
        if (path == 0) {
            return 0;
        }
        int indices = OS.gtk_tree_path_get_indices(path);
        if (indices != 0) {
            int[] index = new int[1];
            OS.memmove(index, indices, 4);
            TableItem item = this._getItem(index[0]);
            item.setChecked(!item.getChecked());
            Event event = new Event();
            event.detail = 32;
            event.item = item;
            this.sendSelectionEvent(13, event, false);
        }
        OS.gtk_tree_path_free(path);
        return 0;
    }

    void gtk_widget_size_request(int widget, GtkRequisition requisition) {
        int columns;
        if (this.columnCount == 0) {
            super.gtk_widget_size_request(widget, requisition);
            return;
        }
        int list = columns = OS.gtk_tree_view_get_columns(this.handle);
        boolean fixVisible = columns != 0;
        while (list != 0) {
            int column = OS.g_list_data(list);
            if (OS.gtk_tree_view_column_get_visible(column)) {
                fixVisible = false;
                break;
            }
            list = OS.g_list_next(list);
        }
        int columnHandle = 0;
        if (fixVisible) {
            columnHandle = OS.g_list_data(columns);
            OS.gtk_tree_view_column_set_visible(columnHandle, true);
        }
        super.gtk_widget_size_request(widget, requisition);
        if (fixVisible) {
            OS.gtk_tree_view_column_set_visible(columnHandle, false);
        }
        if (columns != 0) {
            OS.g_list_free(columns);
        }
    }

    void hideFirstColumn() {
        int firstColumn = OS.gtk_tree_view_get_column(this.handle, 0);
        OS.gtk_tree_view_column_set_visible(firstColumn, false);
    }

    void hookEvents() {
        super.hookEvents();
        int selection = OS.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_connect_closure(selection, OS.changed, this.display.closures[6], false);
        OS.g_signal_connect_closure(this.handle, OS.row_activated, this.display.closures[41], false);
        if (this.checkRenderer != 0) {
            OS.g_signal_connect_closure(this.checkRenderer, OS.toggled, this.display.closures[53], false);
        }
        OS.g_signal_connect_closure(this.handle, OS.start_interactive_search, this.display.closures[69], false);
        if (this.fixAccessibility()) {
            OS.g_signal_connect_closure(this.modelHandle, OS.row_inserted, this.display.closures[64], true);
            OS.g_signal_connect_closure(this.modelHandle, OS.row_deleted, this.display.closures[65], true);
        }
    }

    public int indexOf(TableColumn column) {
        this.checkWidget();
        if (column == null) {
            this.error(4);
        }
        int i = 0;
        while (i < this.columnCount) {
            if (this.columns[i] == column) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int indexOf(TableItem item) {
        this.checkWidget();
        if (item == null) {
            this.error(4);
        }
        if (1 <= this.lastIndexOf && this.lastIndexOf < this.itemCount - 1) {
            if (this.items[this.lastIndexOf] == item) {
                return this.lastIndexOf;
            }
            if (this.items[this.lastIndexOf + 1] == item) {
                return ++this.lastIndexOf;
            }
            if (this.items[this.lastIndexOf - 1] == item) {
                return --this.lastIndexOf;
            }
        }
        if (this.lastIndexOf < this.itemCount / 2) {
            int i = 0;
            while (i < this.itemCount) {
                if (this.items[i] == item) {
                    this.lastIndexOf = i;
                    return this.lastIndexOf;
                }
                ++i;
            }
        } else {
            int i = this.itemCount - 1;
            while (i >= 0) {
                if (this.items[i] == item) {
                    this.lastIndexOf = i;
                    return this.lastIndexOf;
                }
                --i;
            }
        }
        return -1;
    }

    public boolean isSelected(int index) {
        this.checkWidget();
        int selection = OS.gtk_tree_view_get_selection(this.handle);
        byte[] buffer = Converter.wcsToMbcs(null, Integer.toString(index), true);
        int path = OS.gtk_tree_path_new_from_string(buffer);
        boolean answer = OS.gtk_tree_selection_path_is_selected(selection, path);
        OS.gtk_tree_path_free(path);
        return answer;
    }

    boolean mnemonicHit(char key) {
        int i = 0;
        while (i < this.columnCount) {
            int labelHandle = this.columns[i].labelHandle;
            if (labelHandle != 0 && this.mnemonicHit(labelHandle, key)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    boolean mnemonicMatch(char key) {
        int i = 0;
        while (i < this.columnCount) {
            int labelHandle = this.columns[i].labelHandle;
            if (labelHandle != 0 && this.mnemonicMatch(labelHandle, key)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    int paintWindow() {
        OS.gtk_widget_realize(this.handle);
        return OS.gtk_tree_view_get_bin_window(this.handle);
    }

    void recreateRenderers() {
        if (this.checkRenderer != 0) {
            this.display.removeWidget(this.checkRenderer);
            OS.g_object_unref(this.checkRenderer);
            int n = this.checkRenderer = this.ownerDraw ? OS.g_object_new(this.display.gtk_cell_renderer_toggle_get_type(), 0) : OS.gtk_cell_renderer_toggle_new();
            if (this.checkRenderer == 0) {
                this.error(2);
            }
            OS.g_object_ref(this.checkRenderer);
            this.display.addWidget(this.checkRenderer, this);
            OS.g_signal_connect_closure(this.checkRenderer, OS.toggled, this.display.closures[53], false);
        }
        if (this.columnCount == 0) {
            this.createRenderers(OS.gtk_tree_view_get_column(this.handle, 0), 5, true, 0);
        } else {
            int i = 0;
            while (i < this.columnCount) {
                TableColumn column = this.columns[i];
                this.createRenderers(column.handle, column.modelIndex, i == 0, column.style);
                ++i;
            }
        }
    }

    void redrawBackgroundImage() {
        Control control = this.findBackgroundControl();
        if (control != null && control.backgroundImage != null) {
            this.redrawWidget(0, 0, 0, 0, true, false, false);
        }
    }

    void register() {
        super.register();
        this.display.addWidget(OS.gtk_tree_view_get_selection(this.handle), this);
        if (this.checkRenderer != 0) {
            this.display.addWidget(this.checkRenderer, this);
        }
        this.display.addWidget(this.modelHandle, this);
    }

    void releaseChildren(boolean destroy) {
        int i;
        if (this.items != null) {
            i = 0;
            while (i < this.itemCount) {
                TableItem item = this.items[i];
                if (item != null && !item.isDisposed()) {
                    item.release(false);
                }
                ++i;
            }
            this.items = null;
        }
        if (this.columns != null) {
            i = 0;
            while (i < this.columnCount) {
                TableColumn column = this.columns[i];
                if (column != null && !column.isDisposed()) {
                    column.release(false);
                }
                ++i;
            }
            this.columns = null;
        }
        super.releaseChildren(destroy);
    }

    void releaseWidget() {
        super.releaseWidget();
        if (this.modelHandle != 0) {
            OS.g_object_unref(this.modelHandle);
        }
        this.modelHandle = 0;
        if (this.checkRenderer != 0) {
            OS.g_object_unref(this.checkRenderer);
        }
        this.checkRenderer = 0;
        if (this.imageList != null) {
            this.imageList.dispose();
        }
        if (this.headerImageList != null) {
            this.headerImageList.dispose();
        }
        this.headerImageList = null;
        this.imageList = null;
        this.currentItem = null;
    }

    public void remove(int index) {
        this.checkWidget();
        if (index < 0 || index >= this.itemCount) {
            this.error(15);
        }
        int iter = OS.g_malloc(OS.GtkTreeIter_sizeof());
        TableItem item = this.items[index];
        boolean disposed = false;
        if (item != null) {
            disposed = item.isDisposed();
            if (!disposed) {
                OS.memmove(iter, item.handle, OS.GtkTreeIter_sizeof());
                item.release(false);
            }
        } else {
            OS.gtk_tree_model_iter_nth_child(this.modelHandle, iter, 0, index);
        }
        if (!disposed) {
            int selection = OS.gtk_tree_view_get_selection(this.handle);
            OS.g_signal_handlers_block_matched(selection, 16, 0, 0, 0, 0, 6);
            OS.gtk_list_store_remove(this.modelHandle, iter);
            OS.g_signal_handlers_unblock_matched(selection, 16, 0, 0, 0, 0, 6);
            System.arraycopy(this.items, index + 1, this.items, index, --this.itemCount - index);
            this.items[this.itemCount] = null;
        }
        OS.g_free(iter);
    }

    public void remove(int start, int end) {
        this.checkWidget();
        if (start > end) {
            return;
        }
        if (start < 0 || start > end || end >= this.itemCount) {
            this.error(6);
        }
        int selection = OS.gtk_tree_view_get_selection(this.handle);
        int iter = OS.g_malloc(OS.GtkTreeIter_sizeof());
        if (iter == 0) {
            this.error(2);
        }
        if (this.fixAccessibility()) {
            this.ignoreAccessibility = true;
        }
        int index = end;
        while (index >= start) {
            OS.gtk_tree_model_iter_nth_child(this.modelHandle, iter, 0, index);
            TableItem item = this.items[index];
            if (item != null && !item.isDisposed()) {
                item.release(false);
            }
            OS.g_signal_handlers_block_matched(selection, 16, 0, 0, 0, 0, 6);
            OS.gtk_list_store_remove(this.modelHandle, iter);
            OS.g_signal_handlers_unblock_matched(selection, 16, 0, 0, 0, 0, 6);
            --index;
        }
        if (this.fixAccessibility()) {
            this.ignoreAccessibility = false;
            OS.g_object_notify(this.handle, OS.model);
        }
        OS.g_free(iter);
        index = end + 1;
        System.arraycopy(this.items, index, this.items, start, this.itemCount - index);
        int i = this.itemCount - (index - start);
        while (i < this.itemCount) {
            this.items[i] = null;
            ++i;
        }
        this.itemCount -= index - start;
    }

    public void remove(int[] indices) {
        this.checkWidget();
        if (indices == null) {
            this.error(4);
        }
        if (indices.length == 0) {
            return;
        }
        int[] newIndices = new int[indices.length];
        System.arraycopy(indices, 0, newIndices, 0, indices.length);
        this.sort(newIndices);
        int start = newIndices[newIndices.length - 1];
        int end = newIndices[0];
        if (start < 0 || start > end || end >= this.itemCount) {
            this.error(6);
        }
        int selection = OS.gtk_tree_view_get_selection(this.handle);
        int last = -1;
        int iter = OS.g_malloc(OS.GtkTreeIter_sizeof());
        if (iter == 0) {
            this.error(2);
        }
        if (this.fixAccessibility()) {
            this.ignoreAccessibility = true;
        }
        int i = 0;
        while (i < newIndices.length) {
            int index = newIndices[i];
            if (index != last) {
                TableItem item = this.items[index];
                boolean disposed = false;
                if (item != null) {
                    disposed = item.isDisposed();
                    if (!disposed) {
                        OS.memmove(iter, item.handle, OS.GtkTreeIter_sizeof());
                        item.release(false);
                    }
                } else {
                    OS.gtk_tree_model_iter_nth_child(this.modelHandle, iter, 0, index);
                }
                if (!disposed) {
                    OS.g_signal_handlers_block_matched(selection, 16, 0, 0, 0, 0, 6);
                    OS.gtk_list_store_remove(this.modelHandle, iter);
                    OS.g_signal_handlers_unblock_matched(selection, 16, 0, 0, 0, 0, 6);
                    System.arraycopy(this.items, index + 1, this.items, index, --this.itemCount - index);
                    this.items[this.itemCount] = null;
                }
                last = index;
            }
            ++i;
        }
        if (this.fixAccessibility()) {
            this.ignoreAccessibility = false;
            OS.g_object_notify(this.handle, OS.model);
        }
        OS.g_free(iter);
    }

    public void removeAll() {
        this.checkWidget();
        int index = this.itemCount - 1;
        while (index >= 0) {
            TableItem item = this.items[index];
            if (item != null && !item.isDisposed()) {
                item.release(false);
            }
            --index;
        }
        this.items = new TableItem[4];
        this.itemCount = 0;
        int selection = OS.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(selection, 16, 0, 0, 0, 0, 6);
        if (this.fixAccessibility()) {
            this.ignoreAccessibility = true;
        }
        OS.gtk_list_store_clear(this.modelHandle);
        if (this.fixAccessibility()) {
            this.ignoreAccessibility = false;
            OS.g_object_notify(this.handle, OS.model);
        }
        OS.g_signal_handlers_unblock_matched(selection, 16, 0, 0, 0, 0, 6);
        this.resetCustomDraw();
        if (!this.searchEnabled()) {
            if (OS.GTK_VERSION >= OS.VERSION(2, 6, 5)) {
                OS.gtk_tree_view_set_search_column(this.handle, -1);
            } else {
                OS.gtk_tree_view_set_enable_search(this.handle, false);
            }
        } else {
            int firstColumn = this.columnCount == 0 ? 5 : this.columns[0].modelIndex;
            OS.gtk_tree_view_set_search_column(this.handle, firstColumn + 1);
        }
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    int rendererGetSizeProc(int cell, int widget, int cell_area, int x_offset, int y_offset, int width, int height) {
        int g_class = OS.g_type_class_peek_parent(OS.G_OBJECT_GET_CLASS(cell));
        GtkCellRendererClass klass = new GtkCellRendererClass();
        OS.memmove(klass, g_class);
        int result = OS.call(klass.get_size, cell, this.handle, cell_area, x_offset, y_offset, width, height);
        if (!this.ignoreSize && OS.GTK_IS_CELL_RENDERER_TEXT(cell)) {
            int iter = OS.g_object_get_qdata(cell, Display.SWT_OBJECT_INDEX2);
            TableItem item = null;
            if (iter != 0) {
                int path = OS.gtk_tree_model_get_path(this.modelHandle, iter);
                int[] buffer = new int[1];
                OS.memmove(buffer, OS.gtk_tree_path_get_indices(path), 4);
                int index = buffer[0];
                item = this._getItem(index);
                OS.gtk_tree_path_free(path);
            }
            if (item != null) {
                int columnIndex = 0;
                if (this.columnCount > 0) {
                    int columnHandle = OS.g_object_get_qdata(cell, Display.SWT_OBJECT_INDEX1);
                    int i = 0;
                    while (i < this.columnCount) {
                        if (this.columns[i].handle == columnHandle) {
                            columnIndex = i;
                            break;
                        }
                        ++i;
                    }
                }
                if (this.hooks(41)) {
                    int[] contentWidth = new int[1];
                    int[] contentHeight = new int[1];
                    if (width != 0) {
                        OS.memmove(contentWidth, width, 4);
                    }
                    if (height != 0) {
                        OS.memmove(contentHeight, height, 4);
                    }
                    Image image = item.getImage(columnIndex);
                    int imageWidth = 0;
                    if (image != null) {
                        Rectangle bounds = image.getBounds();
                        imageWidth = bounds.width;
                    }
                    contentWidth[0] = contentWidth[0] + imageWidth;
                    GC gc = new GC(this);
                    gc.setFont(item.getFont(columnIndex));
                    Event event = new Event();
                    event.item = item;
                    event.index = columnIndex;
                    event.gc = gc;
                    event.width = contentWidth[0];
                    event.height = contentHeight[0];
                    this.sendEvent(41, event);
                    gc.dispose();
                    contentWidth[0] = event.width - imageWidth;
                    if (contentHeight[0] < event.height) {
                        contentHeight[0] = event.height;
                    }
                    if (width != 0) {
                        OS.memmove(width, contentWidth, 4);
                    }
                    if (height != 0) {
                        OS.memmove(height, contentHeight, 4);
                    }
                }
            }
        }
        return result;
    }

    int rendererRenderProc(int cell, int window, int widget, int background_area, int cell_area, int expose_area, int flags) {
        int path;
        TableItem item = null;
        int iter = OS.g_object_get_qdata(cell, Display.SWT_OBJECT_INDEX2);
        if (iter != 0) {
            int path2 = OS.gtk_tree_model_get_path(this.modelHandle, iter);
            int[] buffer = new int[1];
            OS.memmove(buffer, OS.gtk_tree_path_get_indices(path2), 4);
            int index = buffer[0];
            item = this._getItem(index);
            OS.gtk_tree_path_free(path2);
        }
        int columnHandle = OS.g_object_get_qdata(cell, Display.SWT_OBJECT_INDEX1);
        int columnIndex = 0;
        if (this.columnCount > 0) {
            int i = 0;
            while (i < this.columnCount) {
                if (this.columns[i].handle == columnHandle) {
                    columnIndex = i;
                    break;
                }
                ++i;
            }
        }
        if (item != null && (OS.GTK_IS_CELL_RENDERER_TOGGLE(cell) || OS.GTK_IS_CELL_RENDERER_PIXBUF(cell) && (columnIndex != 0 || (this.style & 0x20) == 0))) {
            int textRenderer;
            Control control;
            this.drawFlags = flags;
            this.drawState = 16;
            int[] ptr = new int[1];
            OS.gtk_tree_model_get(this.modelHandle, item.handle, 3, ptr, -1);
            if (ptr[0] == 0) {
                int modelIndex = this.columnCount == 0 ? 5 : this.columns[columnIndex].modelIndex;
                OS.gtk_tree_model_get(this.modelHandle, item.handle, modelIndex + 3, ptr, -1);
            }
            if (ptr[0] != 0) {
                this.drawState |= 8;
            }
            if ((flags & 1) != 0) {
                this.drawState |= 2;
            }
            if ((flags & 0x10) != 0) {
                this.drawState |= 4;
            }
            GdkRectangle rect = new GdkRectangle();
            path = OS.gtk_tree_model_get_path(this.modelHandle, iter);
            OS.gtk_tree_view_get_background_area(this.handle, path, columnHandle, rect);
            OS.gtk_tree_path_free(path);
            if ((this.drawState & 2) == 0 && ((this.state & 0x8000) != 0 || this.backgroundImage != null) && (control = this.findBackgroundControl()) != null) {
                this.drawBackground(control, window, 0, rect.x, rect.y, rect.width, rect.height);
            }
            if ((textRenderer = this.getTextRenderer(columnHandle)) != 0) {
                OS.gtk_cell_renderer_get_size(textRenderer, this.handle, null, null, null, null, null);
            }
            if (this.hooks(40)) {
                boolean wasSelected;
                boolean bl = wasSelected = (this.drawState & 2) != 0;
                if (wasSelected) {
                    Control control2 = this.findBackgroundControl();
                    if (control2 == null) {
                        control2 = this;
                    }
                    this.drawBackground(control2, window, 0, rect.x, rect.y, rect.width, rect.height);
                }
                GC gc = new GC(this);
                if ((this.drawState & 2) != 0) {
                    gc.setBackground(this.display.getSystemColor(26));
                    gc.setForeground(this.display.getSystemColor(27));
                } else {
                    gc.setBackground(item.getBackground(columnIndex));
                    gc.setForeground(item.getForeground(columnIndex));
                }
                gc.setFont(item.getFont(columnIndex));
                if ((this.style & 0x8000000) != 0) {
                    rect.x = this.getClientWidth() - rect.width - rect.x;
                }
                gc.setClipping(rect.x, rect.y, rect.width, rect.height);
                Event event = new Event();
                event.item = item;
                event.index = columnIndex;
                event.gc = gc;
                event.x = rect.x;
                event.y = rect.y;
                event.width = rect.width;
                event.height = rect.height;
                event.detail = this.drawState;
                this.sendEvent(40, event);
                this.drawForeground = null;
                this.drawState = event.doit ? event.detail : 0;
                this.drawFlags &= 0xFFFFFFEE;
                if ((this.drawState & 2) != 0) {
                    this.drawFlags |= 1;
                }
                if ((this.drawState & 4) != 0) {
                    this.drawFlags |= 0x10;
                }
                if ((this.drawState & 2) != 0) {
                    int style = OS.gtk_widget_get_style(widget);
                    byte[] detail = Converter.wcsToMbcs(null, "cell_odd", true);
                    OS.gtk_paint_flat_box(style, window, 3, 0, rect, widget, detail, rect.x, rect.y, rect.width, rect.height);
                } else if (wasSelected) {
                    this.drawForeground = gc.getForeground().handle;
                }
                gc.dispose();
            }
        }
        int result = 0;
        if ((this.drawState & 8) != 0 && (this.drawState & 2) == 0) {
            GC gc = new GC(this);
            gc.setBackground(item.getBackground(columnIndex));
            GdkRectangle rect = new GdkRectangle();
            OS.memmove(rect, background_area, GdkRectangle.sizeof);
            gc.fillRectangle(rect.x, rect.y, rect.width, rect.height);
            gc.dispose();
        }
        if ((this.drawState & 0x10) != 0 || OS.GTK_IS_CELL_RENDERER_TOGGLE(cell)) {
            int g_class = OS.g_type_class_peek_parent(OS.G_OBJECT_GET_CLASS(cell));
            GtkCellRendererClass klass = new GtkCellRendererClass();
            OS.memmove(klass, g_class);
            if (this.drawForeground != null && OS.GTK_IS_CELL_RENDERER_TEXT(cell)) {
                OS.g_object_set(cell, OS.foreground_gdk, this.drawForeground, 0);
            }
            result = OS.call(klass.render, cell, window, this.handle, background_area, cell_area, expose_area, this.drawFlags);
        }
        if (item != null && OS.GTK_IS_CELL_RENDERER_TEXT(cell) && this.hooks(42)) {
            GdkRectangle rect = new GdkRectangle();
            path = OS.gtk_tree_model_get_path(this.modelHandle, iter);
            OS.gtk_tree_view_get_background_area(this.handle, path, columnHandle, rect);
            OS.gtk_tree_path_free(path);
            this.ignoreSize = true;
            int[] contentX = new int[1];
            int[] contentWidth = new int[1];
            OS.gtk_cell_renderer_get_size(cell, this.handle, null, null, null, contentWidth, null);
            OS.gtk_tree_view_column_cell_get_position(columnHandle, cell, contentX, null);
            this.ignoreSize = false;
            Image image = item.getImage(columnIndex);
            int imageWidth = 0;
            if (image != null) {
                Rectangle bounds = image.getBounds();
                imageWidth = bounds.width;
            }
            contentX[0] = contentX[0] - imageWidth;
            contentWidth[0] = contentWidth[0] + imageWidth;
            GC gc = new GC(this);
            if ((this.drawState & 2) != 0) {
                gc.setBackground(this.display.getSystemColor(26));
                gc.setForeground(this.display.getSystemColor(27));
            } else {
                gc.setBackground(item.getBackground(columnIndex));
                Color foreground = this.drawForeground != null ? Color.gtk_new(this.display, this.drawForeground) : item.getForeground(columnIndex);
                gc.setForeground(foreground);
            }
            gc.setFont(item.getFont(columnIndex));
            if ((this.style & 0x8000000) != 0) {
                rect.x = this.getClientWidth() - rect.width - rect.x;
            }
            gc.setClipping(rect.x, rect.y, rect.width, rect.height);
            Event event = new Event();
            event.item = item;
            event.index = columnIndex;
            event.gc = gc;
            event.x = rect.x + contentX[0];
            event.y = rect.y;
            event.width = contentWidth[0];
            event.height = rect.height;
            event.detail = this.drawState;
            this.sendEvent(42, event);
            gc.dispose();
        }
        return result;
    }

    void resetCustomDraw() {
        if ((this.style & 0x10000000) != 0 || this.ownerDraw) {
            return;
        }
        int end = Math.max(1, this.columnCount);
        int i = 0;
        while (i < end) {
            boolean customDraw;
            boolean bl = customDraw = this.columnCount != 0 ? this.columns[i].customDraw : this.firstCustomDraw;
            if (customDraw) {
                int column = OS.gtk_tree_view_get_column(this.handle, i);
                int textRenderer = this.getTextRenderer(column);
                OS.gtk_tree_view_column_set_cell_data_func(column, textRenderer, 0, 0, 0);
                if (this.columnCount != 0) {
                    this.columns[i].customDraw = false;
                }
            }
            ++i;
        }
        this.firstCustomDraw = false;
    }

    void reskinChildren(int flags) {
        int i;
        if (this.items != null) {
            i = 0;
            while (i < this.itemCount) {
                TableItem item = this.items[i];
                if (item != null) {
                    item.reskin(flags);
                }
                ++i;
            }
        }
        if (this.columns != null) {
            i = 0;
            while (i < this.columnCount) {
                TableColumn column = this.columns[i];
                if (!column.isDisposed()) {
                    column.reskin(flags);
                }
                ++i;
            }
        }
        super.reskinChildren(flags);
    }

    boolean searchEnabled() {
        if ((this.style & 0x10000000) != 0) {
            return false;
        }
        if (OS.GTK_VERSION < OS.VERSION(2, 6, 0)) {
            int mask = 229376;
            Shell shell = this.getShell();
            if ((shell.style & mask) != 0) {
                return false;
            }
        }
        return true;
    }

    public void select(int index) {
        this.checkWidget();
        if (index < 0 || index >= this.itemCount) {
            return;
        }
        boolean fixColumn = this.showFirstColumn();
        int selection = OS.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(selection, 16, 0, 0, 0, 0, 6);
        TableItem item = this._getItem(index);
        OS.gtk_tree_selection_select_iter(selection, item.handle);
        if ((this.style & 4) != 0) {
            int path = OS.gtk_tree_model_get_path(this.modelHandle, item.handle);
            OS.gtk_tree_view_set_cursor(this.handle, path, 0, false);
            OS.gtk_tree_path_free(path);
        }
        OS.g_signal_handlers_unblock_matched(selection, 16, 0, 0, 0, 0, 6);
        if (fixColumn) {
            this.hideFirstColumn();
        }
    }

    public void select(int start, int end) {
        this.checkWidget();
        if (end < 0 || start > end || (this.style & 4) != 0 && start != end) {
            return;
        }
        if (this.itemCount == 0 || start >= this.itemCount) {
            return;
        }
        start = Math.max(0, start);
        end = Math.min(end, this.itemCount - 1);
        boolean fixColumn = this.showFirstColumn();
        int selection = OS.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(selection, 16, 0, 0, 0, 0, 6);
        int index = start;
        while (index <= end) {
            TableItem item = this._getItem(index);
            OS.gtk_tree_selection_select_iter(selection, item.handle);
            if ((this.style & 4) != 0) {
                int path = OS.gtk_tree_model_get_path(this.modelHandle, item.handle);
                OS.gtk_tree_view_set_cursor(this.handle, path, 0, false);
                OS.gtk_tree_path_free(path);
            }
            ++index;
        }
        OS.g_signal_handlers_unblock_matched(selection, 16, 0, 0, 0, 0, 6);
        if (fixColumn) {
            this.hideFirstColumn();
        }
    }

    public void select(int[] indices) {
        int length;
        this.checkWidget();
        if (indices == null) {
            this.error(4);
        }
        if ((length = indices.length) == 0 || (this.style & 4) != 0 && length > 1) {
            return;
        }
        boolean fixColumn = this.showFirstColumn();
        int selection = OS.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(selection, 16, 0, 0, 0, 0, 6);
        int i = 0;
        while (i < length) {
            int index = indices[i];
            if (index >= 0 && index < this.itemCount) {
                TableItem item = this._getItem(index);
                OS.gtk_tree_selection_select_iter(selection, item.handle);
                if ((this.style & 4) != 0) {
                    int path = OS.gtk_tree_model_get_path(this.modelHandle, item.handle);
                    OS.gtk_tree_view_set_cursor(this.handle, path, 0, false);
                    OS.gtk_tree_path_free(path);
                }
            }
            ++i;
        }
        OS.g_signal_handlers_unblock_matched(selection, 16, 0, 0, 0, 0, 6);
        if (fixColumn) {
            this.hideFirstColumn();
        }
    }

    public void selectAll() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return;
        }
        boolean fixColumn = this.showFirstColumn();
        int selection = OS.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(selection, 16, 0, 0, 0, 0, 6);
        OS.gtk_tree_selection_select_all(selection);
        OS.g_signal_handlers_unblock_matched(selection, 16, 0, 0, 0, 0, 6);
        if (fixColumn) {
            this.hideFirstColumn();
        }
    }

    void selectFocusIndex(int index) {
        if (index < 0 || index >= this.itemCount) {
            return;
        }
        TableItem item = this._getItem(index);
        int path = OS.gtk_tree_model_get_path(this.modelHandle, item.handle);
        int selection = OS.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(selection, 16, 0, 0, 0, 0, 6);
        OS.gtk_tree_view_set_cursor(this.handle, path, 0, false);
        OS.gtk_tree_selection_select_iter(selection, item.handle);
        OS.g_signal_handlers_unblock_matched(selection, 16, 0, 0, 0, 0, 6);
        OS.gtk_tree_path_free(path);
    }

    void setBackgroundColor(GdkColor color) {
        super.setBackgroundColor(color);
        OS.gtk_widget_modify_base(this.handle, 0, color);
    }

    void setBackgroundPixmap(int pixmap) {
        this.ownerDraw = true;
        this.recreateRenderers();
    }

    int setBounds(int x, int y, int width, int height, boolean move, boolean resize) {
        int result = super.setBounds(x, y, width, height, move, resize);
        OS.gtk_widget_realize(this.handle);
        if (OS.GTK_VERSION < OS.VERSION(2, 6, 0) && this.itemCount == 0) {
            this.redraw(false);
        }
        return result;
    }

    public void setColumnOrder(int[] order) {
        this.checkWidget();
        if (order == null) {
            this.error(4);
        }
        if (this.columnCount == 0) {
            if (order.length > 0) {
                this.error(5);
            }
            return;
        }
        if (order.length != this.columnCount) {
            this.error(5);
        }
        boolean[] seen = new boolean[this.columnCount];
        int i = 0;
        while (i < order.length) {
            int index = order[i];
            if (index < 0 || index >= this.columnCount) {
                this.error(6);
            }
            if (seen[index]) {
                this.error(5);
            }
            seen[index] = true;
            ++i;
        }
        i = 0;
        while (i < order.length) {
            int column = this.columns[order[i]].handle;
            int baseColumn = i == 0 ? 0 : this.columns[order[i - 1]].handle;
            OS.gtk_tree_view_move_column_after(this.handle, column, baseColumn);
            ++i;
        }
    }

    void setFontDescription(int font) {
        super.setFontDescription(font);
        TableColumn[] columns = this.getColumns();
        int i = 0;
        while (i < columns.length) {
            if (columns[i] != null) {
                columns[i].setFontDescription(font);
            }
            ++i;
        }
    }

    public void setHeaderVisible(boolean show) {
        this.checkWidget();
        OS.gtk_tree_view_set_headers_visible(this.handle, show);
    }

    public void setItemCount(int count) {
        boolean isVirtual;
        this.checkWidget();
        count = Math.max(0, count);
        if (count == this.itemCount) {
            return;
        }
        boolean bl = isVirtual = (this.style & 0x10000000) != 0;
        if (!isVirtual) {
            this.setRedraw(false);
        }
        this.remove(count, this.itemCount - 1);
        int length = Math.max(4, (count + 3) / 4 * 4);
        TableItem[] newItems = new TableItem[length];
        System.arraycopy(this.items, 0, newItems, 0, this.itemCount);
        this.items = newItems;
        if (isVirtual) {
            int iter = OS.g_malloc(OS.GtkTreeIter_sizeof());
            if (iter == 0) {
                this.error(2);
            }
            if (this.fixAccessibility()) {
                this.ignoreAccessibility = true;
            }
            int i = this.itemCount;
            while (i < count) {
                OS.gtk_list_store_append(this.modelHandle, iter);
                ++i;
            }
            if (this.fixAccessibility()) {
                this.ignoreAccessibility = false;
                OS.g_object_notify(this.handle, OS.model);
            }
            OS.g_free(iter);
            this.itemCount = count;
        } else {
            int i = this.itemCount;
            while (i < count) {
                new TableItem(this, 0, i, true);
                ++i;
            }
        }
        if (!isVirtual) {
            this.setRedraw(true);
        }
    }

    public void setLinesVisible(boolean show) {
        this.checkWidget();
        OS.gtk_tree_view_set_rules_hint(this.handle, show);
        if (OS.GTK_VERSION >= OS.VERSION(2, 12, 0)) {
            OS.gtk_tree_view_set_grid_lines(this.handle, show ? 2 : 0);
        }
    }

    void setParentBackground() {
        this.ownerDraw = true;
        this.recreateRenderers();
    }

    void setParentWindow(int widget) {
        int window = this.eventWindow();
        OS.gtk_widget_set_parent_window(widget, window);
    }

    public void setRedraw(boolean redraw) {
        this.checkWidget();
        super.setRedraw(redraw);
        if (redraw && this.drawCount == 0 && this.items.length > 4 && this.items.length - this.itemCount > 3) {
            int length = Math.max(4, (this.itemCount + 3) / 4 * 4);
            TableItem[] newItems = new TableItem[length];
            System.arraycopy(this.items, 0, newItems, 0, this.itemCount);
            this.items = newItems;
        }
    }

    void setScrollWidth(int column, TableItem item) {
        int itemWidth;
        if (this.columnCount != 0 || this.currentItem == item) {
            return;
        }
        if ((this.style & 0x10000000) != 0 && OS.GTK_VERSION < OS.VERSION(2, 3, 2)) {
            return;
        }
        int width = OS.gtk_tree_view_column_get_fixed_width(column);
        if (width < (itemWidth = this.calculateWidth(column, item.handle))) {
            OS.gtk_tree_view_column_set_fixed_width(column, itemWidth);
        }
    }

    public void setSortColumn(TableColumn column) {
        this.checkWidget();
        if (column != null && column.isDisposed()) {
            this.error(5);
        }
        if (this.sortColumn != null && !this.sortColumn.isDisposed()) {
            OS.gtk_tree_view_column_set_sort_indicator(this.sortColumn.handle, false);
        }
        this.sortColumn = column;
        if (this.sortColumn != null && this.sortDirection != 0) {
            OS.gtk_tree_view_column_set_sort_indicator(this.sortColumn.handle, true);
            OS.gtk_tree_view_column_set_sort_order(this.sortColumn.handle, this.sortDirection == 1024 ? 0 : 1);
        }
    }

    public void setSortDirection(int direction) {
        this.checkWidget();
        if (direction != 128 && direction != 1024 && direction != 0) {
            return;
        }
        this.sortDirection = direction;
        if (this.sortColumn == null || this.sortColumn.isDisposed()) {
            return;
        }
        if (this.sortDirection == 0) {
            OS.gtk_tree_view_column_set_sort_indicator(this.sortColumn.handle, false);
        } else {
            OS.gtk_tree_view_column_set_sort_indicator(this.sortColumn.handle, true);
            OS.gtk_tree_view_column_set_sort_order(this.sortColumn.handle, this.sortDirection == 1024 ? 0 : 1);
        }
    }

    public void setSelection(int index) {
        this.checkWidget();
        boolean fixColumn = this.showFirstColumn();
        this.deselectAll();
        this.selectFocusIndex(index);
        this.showSelection();
        if (fixColumn) {
            this.hideFirstColumn();
        }
    }

    public void setSelection(int start, int end) {
        this.checkWidget();
        this.deselectAll();
        if (end < 0 || start > end || (this.style & 4) != 0 && start != end) {
            return;
        }
        if (this.itemCount == 0 || start >= this.itemCount) {
            return;
        }
        boolean fixColumn = this.showFirstColumn();
        start = Math.max(0, start);
        end = Math.min(end, this.itemCount - 1);
        this.selectFocusIndex(start);
        if ((this.style & 2) != 0) {
            this.select(start, end);
        }
        this.showSelection();
        if (fixColumn) {
            this.hideFirstColumn();
        }
    }

    public void setSelection(int[] indices) {
        this.checkWidget();
        if (indices == null) {
            this.error(4);
        }
        this.deselectAll();
        int length = indices.length;
        if (length == 0 || (this.style & 4) != 0 && length > 1) {
            return;
        }
        boolean fixColumn = this.showFirstColumn();
        this.selectFocusIndex(indices[0]);
        if ((this.style & 2) != 0) {
            this.select(indices);
        }
        this.showSelection();
        if (fixColumn) {
            this.hideFirstColumn();
        }
    }

    public void setSelection(TableItem item) {
        if (item == null) {
            this.error(4);
        }
        this.setSelection(new TableItem[]{item});
    }

    public void setSelection(TableItem[] items) {
        this.checkWidget();
        if (items == null) {
            this.error(4);
        }
        boolean fixColumn = this.showFirstColumn();
        this.deselectAll();
        int length = items.length;
        if (length != 0 && ((this.style & 4) == 0 || length <= 1)) {
            boolean first = true;
            int i = 0;
            while (i < length) {
                int index = this.indexOf(items[i]);
                if (index != -1) {
                    if (first) {
                        first = false;
                        this.selectFocusIndex(index);
                    } else {
                        this.select(index);
                    }
                }
                ++i;
            }
            this.showSelection();
        }
        if (fixColumn) {
            this.hideFirstColumn();
        }
    }

    public void setTopIndex(int index) {
        this.checkWidget();
        if (index < 0 || index >= this.itemCount) {
            return;
        }
        int path = OS.gtk_tree_model_get_path(this.modelHandle, this._getItem((int)index).handle);
        OS.gtk_tree_view_scroll_to_cell(this.handle, path, 0, true, 0.0f, 0.0f);
        if (OS.GTK_VERSION < OS.VERSION(2, 8, 0)) {
            OS.gtk_widget_realize(this.handle);
            GdkRectangle cellRect = new GdkRectangle();
            OS.gtk_tree_view_get_cell_area(this.handle, path, 0, cellRect);
            int[] tx = new int[1];
            int[] ty = new int[1];
            OS.gtk_tree_view_widget_to_tree_coords(this.handle, cellRect.x, cellRect.y, tx, ty);
            OS.gtk_tree_view_scroll_to_point(this.handle, -1, ty[0]);
        }
        OS.gtk_tree_path_free(path);
    }

    public void showColumn(TableColumn column) {
        this.checkWidget();
        if (column == null) {
            this.error(4);
        }
        if (column.isDisposed()) {
            this.error(5);
        }
        if (column.parent != this) {
            return;
        }
        OS.gtk_widget_realize(this.handle);
        GdkRectangle cellRect = new GdkRectangle();
        OS.gtk_tree_view_get_cell_area(this.handle, 0, column.handle, cellRect);
        GdkRectangle visibleRect = new GdkRectangle();
        OS.gtk_tree_view_get_visible_rect(this.handle, visibleRect);
        if (cellRect.x < visibleRect.x) {
            OS.gtk_tree_view_scroll_to_point(this.handle, cellRect.x, -1);
        } else {
            int width = Math.min(visibleRect.width, cellRect.width);
            if (cellRect.x + width > visibleRect.x + visibleRect.width) {
                int tree_x = cellRect.x + width - visibleRect.width;
                OS.gtk_tree_view_scroll_to_point(this.handle, tree_x, -1);
            }
        }
    }

    boolean showFirstColumn() {
        int columnCount = Math.max(1, this.columnCount);
        int i = 0;
        while (i < columnCount) {
            int column = OS.gtk_tree_view_get_column(this.handle, i);
            if (OS.gtk_tree_view_column_get_visible(column)) {
                return false;
            }
            ++i;
        }
        int firstColumn = OS.gtk_tree_view_get_column(this.handle, 0);
        OS.gtk_tree_view_column_set_visible(firstColumn, true);
        return true;
    }

    public void showItem(TableItem item) {
        this.checkWidget();
        if (item == null) {
            this.error(4);
        }
        if (item.isDisposed()) {
            this.error(5);
        }
        if (item.parent != this) {
            return;
        }
        this.showItem(item.handle);
    }

    void showItem(int iter) {
        int path = OS.gtk_tree_model_get_path(this.modelHandle, iter);
        OS.gtk_widget_realize(this.handle);
        GdkRectangle visibleRect = new GdkRectangle();
        OS.gtk_tree_view_get_visible_rect(this.handle, visibleRect);
        GdkRectangle cellRect = new GdkRectangle();
        OS.gtk_tree_view_get_cell_area(this.handle, path, 0, cellRect);
        int[] tx = new int[1];
        int[] ty = new int[1];
        OS.gtk_tree_view_widget_to_tree_coords(this.handle, cellRect.x, cellRect.y, tx, ty);
        if (ty[0] < visibleRect.y) {
            OS.gtk_tree_view_scroll_to_cell(this.handle, path, 0, true, 0.0f, 0.0f);
            OS.gtk_tree_view_scroll_to_point(this.handle, -1, ty[0]);
        } else {
            int height = Math.min(visibleRect.height, cellRect.height);
            if (ty[0] + height > visibleRect.y + visibleRect.height) {
                OS.gtk_tree_view_scroll_to_cell(this.handle, path, 0, true, 1.0f, 0.0f);
                ty[0] = ty[0] + (cellRect.height - visibleRect.height);
                OS.gtk_tree_view_scroll_to_point(this.handle, -1, ty[0]);
            }
        }
        OS.gtk_tree_path_free(path);
    }

    public void showSelection() {
        this.checkWidget();
        TableItem[] selection = this.getSelection();
        if (selection.length == 0) {
            return;
        }
        TableItem item = selection[0];
        this.showItem(item.handle);
    }

    int treeSelectionProc(int model, int path, int iter, int[] selection, int length) {
        int indices;
        if (selection != null && (indices = OS.gtk_tree_path_get_indices(path)) != 0) {
            int[] index = new int[1];
            OS.memmove(index, indices, 4);
            selection[length] = index[0];
        }
        return 0;
    }

    void updateScrollBarValue(ScrollBar bar) {
        super.updateScrollBarValue(bar);
        int parentHandle = this.parentingHandle();
        int list = OS.gtk_container_get_children(parentHandle);
        if (list == 0) {
            return;
        }
        int temp = list;
        while (temp != 0) {
            int widget = OS.g_list_data(temp);
            if (widget != 0) {
                OS.gtk_widget_queue_resize(widget);
            }
            temp = OS.g_list_next(temp);
        }
        OS.g_list_free(list);
    }

    int windowProc(int handle, int arg0, int user_data) {
        switch (user_data) {
            case 19: {
                Control control;
                if (this.itemCount != 0 || (this.state & 0x40) != 0 || (this.state & 0x8000) == 0 && this.backgroundImage == null || (control = this.findBackgroundControl()) == null) break;
                GdkEventExpose gdkEvent = new GdkEventExpose();
                OS.memmove(gdkEvent, arg0, GdkEventExpose.sizeof);
                int window = OS.gtk_tree_view_get_bin_window(handle);
                if (window != gdkEvent.window) break;
                this.drawBackground(control, window, gdkEvent.region, gdkEvent.area_x, gdkEvent.area_y, gdkEvent.area_width, gdkEvent.area_height);
            }
        }
        return super.windowProc(handle, arg0, user_data);
    }
}

