/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.internal.motif.OS;
import org.eclipse.swt.widgets.Display;

public class ImageTransfer
extends ByteArrayTransfer {
    private static ImageTransfer _instance = new ImageTransfer();
    private static final String PIXMAP = "PIXMAP";
    private static final int PIXMAP_ID = ImageTransfer.registerType("PIXMAP");

    private ImageTransfer() {
    }

    public static ImageTransfer getInstance() {
        return _instance;
    }

    public void javaToNative(Object object, TransferData transferData) {
        ImageData imgData;
        if (!this.checkImage(object) || !this.isSupportedType(transferData)) {
            DND.error(2003);
        }
        if ((imgData = (ImageData)object) == null) {
            SWT.error(4);
        }
        Image image = new Image((Device)Display.getCurrent(), imgData);
        int pixmap = image.pixmap;
        int pValue = OS.XtMalloc(4);
        if (pValue == 0) {
            return;
        }
        OS.memmove(pValue, new int[]{pixmap}, 4);
        transferData.type = PIXMAP_ID;
        transferData.format = 32;
        transferData.length = 1;
        transferData.pValue = pValue;
        transferData.result = 1;
    }

    public Object nativeToJava(TransferData transferData) {
        if (!this.isSupportedType(transferData) || transferData.pValue == 0) {
            return null;
        }
        int length = transferData.length;
        if (length == 0) {
            return null;
        }
        int[] pixmap = new int[1];
        OS.memmove(pixmap, transferData.pValue, length * 4);
        Image image = Image.motif_new(Display.getCurrent(), 0, pixmap[0], 0);
        ImageData imgData = image.getImageData();
        image.dispose();
        return imgData;
    }

    protected int[] getTypeIds() {
        return new int[]{PIXMAP_ID};
    }

    protected String[] getTypeNames() {
        return new String[]{PIXMAP};
    }

    boolean checkImage(Object object) {
        return object != null && object instanceof ImageData;
    }

    protected boolean validate(Object object) {
        return this.checkImage(object);
    }
}

