/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.internal.Converter;

public class FileTransfer
extends ByteArrayTransfer {
    private static FileTransfer _instance = new FileTransfer();
    private static final String TYPENAME = "files";
    private static final int TYPEID = FileTransfer.registerType("files");

    private FileTransfer() {
    }

    public static FileTransfer getInstance() {
        return _instance;
    }

    public void javaToNative(Object object, TransferData transferData) {
        if (!this.checkFile(object) || !this.isSupportedType(transferData)) {
            DND.error(2003);
        }
        String[] files = (String[])object;
        String nativeFormat = "";
        int i = 0;
        int length = files.length;
        while (i < length) {
            nativeFormat = String.valueOf(nativeFormat) + "file:" + files[i] + "\r";
            ++i;
        }
        byte[] buffer = Converter.wcsToMbcs(null, nativeFormat, true);
        super.javaToNative(buffer, transferData);
    }

    public Object nativeToJava(TransferData transferData) {
        byte[] data = (byte[])super.nativeToJava(transferData);
        if (data == null) {
            return null;
        }
        char[] unicode = Converter.mbcsToWcs(null, data);
        String string = new String(unicode);
        int start = string.indexOf("file:");
        if (start == -1) {
            return null;
        }
        start += 5;
        String[] fileNames = new String[]{};
        while (start < string.length()) {
            int end = string.indexOf("\r", start);
            if (end == -1) {
                end = string.length() - 1;
            }
            String fileName = string.substring(start, end);
            String[] newFileNames = new String[fileNames.length + 1];
            System.arraycopy(fileNames, 0, newFileNames, 0, fileNames.length);
            newFileNames[fileNames.length] = fileName;
            fileNames = newFileNames;
            start = string.indexOf("file:", end);
            if (start == -1) break;
            start += 5;
        }
        return fileNames;
    }

    protected String[] getTypeNames() {
        return new String[]{TYPENAME};
    }

    protected int[] getTypeIds() {
        return new int[]{TYPEID};
    }

    boolean checkFile(Object object) {
        if (object == null || !(object instanceof String[]) || ((String[])object).length == 0) {
            return false;
        }
        String[] strings = (String[])object;
        int i = 0;
        while (i < strings.length) {
            if (strings[i] == null || strings[i].length() == 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected boolean validate(Object object) {
        return this.checkFile(object);
    }
}

