/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal;

import java.io.UnsupportedEncodingException;

public final class Converter {
    public static final byte[] NullByteArray = new byte[1];
    public static final byte[] EmptyByteArray = new byte[0];
    public static final char[] EmptyCharArray = new char[0];

    public static String defaultCodePage() {
        return "UTF8";
    }

    public static char[] mbcsToWcs(String codePage, byte[] buffer) {
        try {
            return new String(buffer, Converter.defaultCodePage()).toCharArray();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return EmptyCharArray;
        }
    }

    public static byte[] wcsToMbcs(String codePage, String string, boolean terminate) {
        try {
            if (!terminate) {
                return string.getBytes(Converter.defaultCodePage());
            }
            byte[] buffer1 = string.getBytes(Converter.defaultCodePage());
            byte[] buffer2 = new byte[buffer1.length + 1];
            System.arraycopy(buffer1, 0, buffer2, 0, buffer1.length);
            return buffer2;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return terminate ? NullByteArray : EmptyByteArray;
        }
    }

    public static byte[] wcsToMbcs(String codePage, char[] buffer, boolean terminate) {
        try {
            if (!terminate) {
                return new String(buffer).getBytes(Converter.defaultCodePage());
            }
            byte[] buffer1 = new String(buffer).getBytes(Converter.defaultCodePage());
            byte[] buffer2 = new byte[buffer1.length + 1];
            System.arraycopy(buffer1, 0, buffer2, 0, buffer1.length);
            return buffer2;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return terminate ? NullByteArray : EmptyByteArray;
        }
    }
}

