/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ExpandListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.ExpandItem;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.TypedListener;

public class ExpandBar
extends Composite {
    ExpandItem[] items = new ExpandItem[4];
    int itemCount;
    ExpandItem focusItem;
    int spacing;
    int yCurrentScroll;
    Font font;
    Color foreground;
    Listener listener = new Listener(){

        public void handleEvent(Event event) {
            switch (event.type) {
                case 12: {
                    ExpandBar.this.onDispose(event);
                    break;
                }
                case 3: {
                    ExpandBar.this.onMouseDown(event);
                    break;
                }
                case 4: {
                    ExpandBar.this.onMouseUp(event);
                    break;
                }
                case 9: {
                    ExpandBar.this.onPaint(event);
                    break;
                }
                case 11: {
                    ExpandBar.this.onResize();
                    break;
                }
                case 1: {
                    ExpandBar.this.onKeyDown(event);
                    break;
                }
                case 15: {
                    ExpandBar.this.onFocus();
                    break;
                }
                case 16: {
                    ExpandBar.this.onFocus();
                    break;
                }
                case 31: {
                    ExpandBar.this.onTraverse(event);
                }
            }
        }
    };
    boolean inDispose;

    public ExpandBar(Composite parent, int style) {
        super(parent, ExpandBar.checkStyle(style));
        this.addListener(12, this.listener);
        this.addListener(3, this.listener);
        this.addListener(4, this.listener);
        this.addListener(9, this.listener);
        this.addListener(11, this.listener);
        this.addListener(1, this.listener);
        this.addListener(15, this.listener);
        this.addListener(16, this.listener);
        this.addListener(31, this.listener);
        ScrollBar verticalBar = this.getVerticalBar();
        if (verticalBar != null) {
            verticalBar.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    ExpandBar.this.onScroll(event);
                }
            });
        }
    }

    public void addExpandListener(ExpandListener listener) {
        this.checkWidget();
        if (listener == null) {
            ExpandBar.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(17, typedListener);
        this.addListener(18, typedListener);
    }

    static int checkStyle(int style) {
        return style & 0xFFFFFEFF;
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            ExpandBar.error(43);
        }
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        int height = 0;
        int width = 0;
        if ((wHint == -1 || hHint == -1) && this.itemCount > 0) {
            height += this.spacing;
            GC gc = new GC(this);
            int i = 0;
            while (i < this.itemCount) {
                ExpandItem item = this.items[i];
                height += item.getHeaderHeight();
                if (item.expanded) {
                    height += item.height;
                }
                height += this.spacing;
                width = Math.max(width, item.getPreferredWidth(gc));
                ++i;
            }
            gc.dispose();
        }
        if (width == 0) {
            width = 64;
        }
        if (height == 0) {
            height = 64;
        }
        if (wHint != -1) {
            width = wHint;
        }
        if (hHint != -1) {
            height = hHint;
        }
        Rectangle trim = this.computeTrim(0, 0, width, height);
        return new Point(trim.width, trim.height);
    }

    void createItem(ExpandItem item, int style, int index) {
        if (index < 0 || index > this.itemCount) {
            ExpandBar.error(6);
        }
        if (this.itemCount == this.items.length) {
            ExpandItem[] newItems = new ExpandItem[this.itemCount + 4];
            System.arraycopy(this.items, 0, newItems, 0, this.items.length);
            this.items = newItems;
        }
        System.arraycopy(this.items, index, this.items, index + 1, this.itemCount - index);
        this.items[index] = item;
        ++this.itemCount;
        if (this.focusItem == null) {
            this.focusItem = item;
        }
        item.width = Math.max(0, this.getClientArea().width - this.spacing * 2);
        this.layoutItems(index, true);
    }

    void destroyItem(ExpandItem item) {
        if (this.inDispose) {
            return;
        }
        int index = 0;
        while (index < this.itemCount) {
            if (this.items[index] == item) break;
            ++index;
        }
        if (index == this.itemCount) {
            return;
        }
        if (item == this.focusItem) {
            int focusIndex;
            int n = focusIndex = index > 0 ? index - 1 : 1;
            if (focusIndex < this.itemCount) {
                this.focusItem = this.items[focusIndex];
                this.focusItem.redraw();
            } else {
                this.focusItem = null;
            }
        }
        System.arraycopy(this.items, index + 1, this.items, index, --this.itemCount - index);
        this.items[this.itemCount] = null;
        item.redraw();
        this.layoutItems(index, true);
    }

    int getBandHeight() {
        if (this.font == null) {
            return 24;
        }
        GC gc = new GC(this);
        FontMetrics metrics = gc.getFontMetrics();
        gc.dispose();
        return Math.max(24, metrics.getHeight());
    }

    public Color getForeground() {
        this.checkWidget();
        if (this.foreground == null) {
            Display display = this.getDisplay();
            return display.getSystemColor(30);
        }
        return this.foreground;
    }

    public ExpandItem getItem(int index) {
        this.checkWidget();
        if (index < 0 || index >= this.itemCount) {
            ExpandBar.error(6);
        }
        return this.items[index];
    }

    public int getItemCount() {
        this.checkWidget();
        return this.itemCount;
    }

    public ExpandItem[] getItems() {
        this.checkWidget();
        ExpandItem[] result = new ExpandItem[this.itemCount];
        System.arraycopy(this.items, 0, result, 0, this.itemCount);
        return result;
    }

    public int getSpacing() {
        this.checkWidget();
        return this.spacing;
    }

    public int indexOf(ExpandItem item) {
        this.checkWidget();
        if (item == null) {
            ExpandBar.error(4);
        }
        int i = 0;
        while (i < this.itemCount) {
            if (this.items[i] == item) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    void layoutItems(int index, boolean setScrollbar) {
        if (index < this.itemCount) {
            ExpandItem item;
            int y = this.spacing - this.yCurrentScroll;
            int i = 0;
            while (i < index) {
                item = this.items[i];
                if (item.expanded) {
                    y += item.height;
                }
                y += item.getHeaderHeight() + this.spacing;
                ++i;
            }
            i = index;
            while (i < this.itemCount) {
                item = this.items[i];
                item.setBounds(this.spacing, y, 0, 0, true, false);
                if (item.expanded) {
                    y += item.height;
                }
                y += item.getHeaderHeight() + this.spacing;
                ++i;
            }
        }
        if (setScrollbar) {
            this.setScrollbar();
        }
    }

    public void removeExpandListener(ExpandListener listener) {
        this.checkWidget();
        if (listener == null) {
            ExpandBar.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(17, listener);
        this.eventTable.unhook(18, listener);
    }

    void reskinChildren(int flags) {
        if (this.items != null) {
            int i = 0;
            while (i < this.items.length) {
                ExpandItem item = this.items[i];
                if (item != null) {
                    item.reskin(flags);
                }
                ++i;
            }
        }
        super.reskinChildren(flags);
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.font = font;
        this.layoutItems(0, true);
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        this.foreground = color;
    }

    void setScrollbar() {
        if (this.itemCount == 0) {
            return;
        }
        ScrollBar verticalBar = this.getVerticalBar();
        if (verticalBar == null) {
            return;
        }
        int height = this.getClientArea().height;
        ExpandItem item = this.items[this.itemCount - 1];
        int maxHeight = item.y + this.getBandHeight() + this.spacing;
        if (item.expanded) {
            maxHeight += item.height;
        }
        if (this.yCurrentScroll > 0 && height > maxHeight) {
            this.yCurrentScroll = Math.max(0, this.yCurrentScroll + maxHeight - height);
            this.layoutItems(0, false);
        }
        int selection = Math.min(this.yCurrentScroll, maxHeight += this.yCurrentScroll);
        int increment = verticalBar.getIncrement();
        int pageIncrement = verticalBar.getPageIncrement();
        verticalBar.setValues(selection, 0, maxHeight, height, increment, pageIncrement);
        verticalBar.setVisible(maxHeight > height);
    }

    public void setSpacing(int spacing) {
        this.checkWidget();
        if (spacing < 0) {
            return;
        }
        if (spacing == this.spacing) {
            return;
        }
        this.spacing = spacing;
        int width = Math.max(0, this.getClientArea().width - spacing * 2);
        int i = 0;
        while (i < this.itemCount) {
            ExpandItem item = this.items[i];
            if (item.width != width) {
                item.setBounds(0, 0, width, item.height, false, true);
            }
            ++i;
        }
        this.layoutItems(0, true);
        this.redraw();
    }

    void showItem(ExpandItem item) {
        Control control = item.control;
        if (control != null && !control.isDisposed()) {
            control.setVisible(item.expanded);
        }
        item.redraw();
        int index = this.indexOf(item);
        this.layoutItems(index + 1, true);
    }

    void onDispose(Event event) {
        this.removeListener(12, this.listener);
        this.notifyListeners(12, event);
        event.type = 0;
        this.inDispose = true;
        int i = 0;
        while (i < this.itemCount) {
            this.items[i].dispose();
            ++i;
        }
        this.items = null;
        this.font = null;
        this.foreground = null;
        this.focusItem = null;
    }

    void onFocus() {
        if (this.focusItem != null) {
            this.focusItem.redraw();
        }
    }

    void onKeyDown(Event event) {
        if (this.focusItem == null) {
            return;
        }
        switch (event.keyCode) {
            case 13: 
            case 32: {
                Event ev = new Event();
                ev.item = this.focusItem;
                this.sendEvent(this.focusItem.expanded ? 18 : 17, ev);
                this.focusItem.expanded = !this.focusItem.expanded;
                this.showItem(this.focusItem);
                break;
            }
            case 0x1000001: {
                int focusIndex = this.indexOf(this.focusItem);
                if (focusIndex <= 0) break;
                this.focusItem.redraw();
                this.focusItem = this.items[focusIndex - 1];
                this.focusItem.redraw();
                break;
            }
            case 0x1000002: {
                int focusIndex = this.indexOf(this.focusItem);
                if (focusIndex >= this.itemCount - 1) break;
                this.focusItem.redraw();
                this.focusItem = this.items[focusIndex + 1];
                this.focusItem.redraw();
            }
        }
    }

    void onMouseDown(Event event) {
        if (event.button != 1) {
            return;
        }
        int x = event.x;
        int y = event.y;
        int i = 0;
        while (i < this.itemCount) {
            boolean hover;
            ExpandItem item = this.items[i];
            boolean bl = hover = item.x <= x && x < item.x + item.width && item.y <= y && y < item.y + this.getBandHeight();
            if (hover && item != this.focusItem) {
                this.focusItem.redraw();
                this.focusItem = item;
                this.focusItem.redraw();
                this.forceFocus();
                break;
            }
            ++i;
        }
    }

    void onMouseUp(Event event) {
        boolean hover;
        if (event.button != 1) {
            return;
        }
        if (this.focusItem == null) {
            return;
        }
        int x = event.x;
        int y = event.y;
        boolean bl = hover = this.focusItem.x <= x && x < this.focusItem.x + this.focusItem.width && this.focusItem.y <= y && y < this.focusItem.y + this.getBandHeight();
        if (hover) {
            Event ev = new Event();
            ev.item = this.focusItem;
            this.notifyListeners(this.focusItem.expanded ? 18 : 17, ev);
            this.focusItem.expanded = !this.focusItem.expanded;
            this.showItem(this.focusItem);
        }
    }

    void onPaint(Event event) {
        boolean hasFocus = this.isFocusControl();
        int i = 0;
        while (i < this.itemCount) {
            ExpandItem item = this.items[i];
            item.drawItem(event.gc, hasFocus && item == this.focusItem);
            ++i;
        }
    }

    void onResize() {
        Rectangle rect = this.getClientArea();
        int width = Math.max(0, rect.width - this.spacing * 2);
        int i = 0;
        while (i < this.itemCount) {
            ExpandItem item = this.items[i];
            item.setBounds(0, 0, width, item.height, false, true);
            ++i;
        }
        this.setScrollbar();
    }

    void onScroll(Event event) {
        ScrollBar verticalBar = this.getVerticalBar();
        if (verticalBar != null) {
            this.yCurrentScroll = verticalBar.getSelection();
            this.layoutItems(0, false);
        }
    }

    void onTraverse(Event event) {
        switch (event.detail) {
            case 8: 
            case 16: {
                event.doit = true;
            }
        }
    }
}

