/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.photon.OS;
import org.eclipse.swt.internal.photon.PhRect_t;
import org.eclipse.swt.widgets.Composite;

public class Group
extends Composite {
    String text = "";

    public Group(Composite parent, int style) {
        super(parent, Group.checkStyle(style));
    }

    static int checkStyle(int style) {
        return (style |= 0x80000) & 0xFFFFFCFF;
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        Point size;
        this.checkWidget();
        Point titleSize = this.getTitleSize();
        if (this.layout != null) {
            size = this.layout.computeSize(this, wHint, hHint, changed |= (this.state & 0x200) != 0);
            this.state &= 0xFFFFFDFF;
        } else {
            size = this.minimumSize();
        }
        int width = size.x;
        int height = size.y;
        if (width == 0) {
            width = 64;
        }
        if (height == 0) {
            height = 64;
        }
        if (wHint != -1) {
            width = wHint;
        }
        if (hHint != -1) {
            height = hHint;
        }
        Rectangle trim = this.computeTrim(0, 0, width, height);
        width = Math.max(trim.width, titleSize.x + 6);
        height = trim.height + titleSize.y;
        return new Point(width, height);
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            Group.error(43);
        }
    }

    void createHandle(int index) {
        this.state |= 8;
        int clazz = this.display.PtContainer;
        int parentHandle = this.parent.parentingHandle();
        int[] nArray = new int[3];
        nArray[0] = 1008;
        nArray[2] = 0x3F00000;
        int[] args = nArray;
        this.handle = OS.PtCreateWidget(clazz, parentHandle, args.length / 3, args);
        if (this.handle == 0) {
            Group.error(2);
        }
    }

    byte[] defaultFont() {
        return this.display.GROUP_FONT;
    }

    public String getText() {
        this.checkWidget();
        return this.text;
    }

    Point getTitleSize() {
        int length;
        int width = 0;
        int height = 0;
        int[] nArray = new int[9];
        nArray[0] = 10007;
        nArray[3] = 10008;
        nArray[6] = 10005;
        int[] args = nArray;
        OS.PtGetResources(this.handle, args.length / 3, args);
        PhRect_t rect = new PhRect_t();
        int str = args[1];
        if (str != 0 && (length = OS.strlen(str)) > 0) {
            OS.PfExtentText(rect, null, args[4], str, length);
        }
        int inset = 4;
        width = inset + rect.lr_x - rect.ul_x + 1;
        height = inset + rect.lr_y - rect.ul_y + 1;
        return new Point(width, height);
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            Group.error(4);
        }
        this.text = string;
        int flags = 768;
        char[] text = new char[string.length()];
        string.getChars(0, text.length, text, 0);
        this.fixMnemonic(text);
        byte[] buffer = Converter.wcsToMbcs(null, text, true);
        int ptr = OS.malloc(buffer.length);
        OS.memmove(ptr, buffer, buffer.length);
        int[] nArray = new int[6];
        nArray[0] = 10007;
        nArray[1] = ptr;
        nArray[3] = 10005;
        nArray[4] = string.length() == 0 ? 0 : flags;
        nArray[5] = flags;
        int[] args = nArray;
        OS.PtSetResources(this.handle, args.length / 3, args);
        OS.free(ptr);
    }

    int widgetClass() {
        return OS.PtContainer();
    }
}

