/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TaskBar;

public class TaskItem
extends Item {
    TaskBar parent;
    Shell shell;
    int progress;
    int progressState = -1;
    Image overlayImage;
    String overlayText = "";
    Menu menu;
    static final int PROGRESS_MAX = 100;

    TaskItem(TaskBar parent, int style) {
        super(parent, style);
        this.parent = parent;
        parent.createItem(this, -1);
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            TaskItem.error(43);
        }
    }

    void destroyWidget() {
        this.parent.destroyItem(this);
        this.releaseHandle();
    }

    public Menu getMenu() {
        this.checkWidget();
        return this.menu;
    }

    public Image getOverlayImage() {
        this.checkWidget();
        return this.overlayImage;
    }

    public String getOverlayText() {
        this.checkWidget();
        return this.overlayText;
    }

    public TaskBar getParent() {
        this.checkWidget();
        return this.parent;
    }

    public int getProgress() {
        this.checkWidget();
        return this.progress;
    }

    public int getProgressState() {
        this.checkWidget();
        return this.progressState;
    }

    void releaseHandle() {
        super.releaseHandle();
        this.parent = null;
    }

    void releaseWidget() {
        super.releaseWidget();
        this.overlayImage = null;
        this.overlayText = null;
    }

    public void setMenu(Menu menu) {
        this.checkWidget();
        if (menu != null) {
            if (menu.isDisposed()) {
                SWT.error(5);
            }
            if ((menu.style & 8) == 0) {
                TaskItem.error(37);
            }
        }
        this.menu = menu;
    }

    public void setOverlayImage(Image overlayImage) {
        this.checkWidget();
        if (overlayImage != null && overlayImage.isDisposed()) {
            TaskItem.error(5);
        }
        this.overlayImage = overlayImage;
    }

    public void setOverlayText(String overlayText) {
        this.checkWidget();
        if (overlayText == null) {
            TaskItem.error(4);
        }
        this.overlayText = overlayText;
    }

    public void setProgressState(int progressState) {
        this.checkWidget();
        if (this.progressState == progressState) {
            return;
        }
        this.progressState = progressState;
    }

    public void setProgress(int progress) {
        this.checkWidget();
        progress = Math.max(0, Math.min(progress, 100));
        if (this.progress == progress) {
            return;
        }
        this.progress = progress;
    }
}

