/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.internal.carbon.AlertStdCFStringAlertParamRec;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class MessageBox
extends Dialog {
    String message = "";

    public MessageBox(Shell parent) {
        this(parent, 65570);
    }

    public MessageBox(Shell parent, int style) {
        super(parent, MessageBox.checkStyle(parent, MessageBox.checkStyle(style)));
        this.checkSubclass();
    }

    static int checkStyle(int style) {
        int mask = 4064;
        int bits = style & mask;
        if (bits == 32 || bits == 256 || bits == 288) {
            return style;
        }
        if (bits == 64 || bits == 128 || bits == 192 || bits == 448) {
            return style;
        }
        if (bits == 1280 || bits == 3584) {
            return style;
        }
        style = style & ~mask | 0x20;
        return style;
    }

    int createCFString(String id) {
        String string = SWT.getMessage(id);
        char[] buffer = new char[string.length()];
        string.getChars(0, buffer.length, buffer, 0);
        return OS.CFStringCreateWithCharacters(0, buffer, buffer.length);
    }

    public String getMessage() {
        return this.message;
    }

    public int open() {
        char[] buffer;
        int alertType = 3;
        if ((this.style & 1) != 0) {
            alertType = 0;
        }
        if ((this.style & 2) != 0) {
            alertType = 1;
        }
        if ((this.style & 4) != 0) {
            alertType = 1;
        }
        if ((this.style & 8) != 0) {
            alertType = 2;
        }
        if ((this.style & 0x10) != 0) {
            alertType = 1;
        }
        int error = 0;
        int explanation = 0;
        String errorString = this.title;
        String explanationString = this.message;
        if (errorString != null) {
            buffer = new char[errorString.length()];
            errorString.getChars(0, buffer.length, buffer, 0);
            error = OS.CFStringCreateWithCharacters(0, buffer, buffer.length);
        }
        if (explanationString != null) {
            buffer = new char[explanationString.length()];
            explanationString.getChars(0, buffer.length, buffer, 0);
            explanation = OS.CFStringCreateWithCharacters(0, buffer, buffer.length);
        }
        AlertStdCFStringAlertParamRec param = new AlertStdCFStringAlertParamRec();
        param.version = 1;
        param.position = (short)28682;
        int defaultStr = 0;
        int cancelStr = 0;
        int otherStr = 0;
        int mask = 4064;
        int bits = this.style & mask;
        switch (bits) {
            case 32: {
                param.defaultButton = 1;
                param.defaultText = -1;
                break;
            }
            case 256: {
                param.defaultButton = 1;
                param.defaultText = defaultStr = this.createCFString("SWT_Cancel");
                break;
            }
            case 288: {
                param.defaultButton = 1;
                param.defaultText = -1;
                param.cancelButton = (short)2;
                param.cancelText = -1;
                break;
            }
            case 64: {
                param.defaultButton = 1;
                param.defaultText = defaultStr = this.createCFString("SWT_Yes");
                break;
            }
            case 128: {
                param.cancelButton = 1;
                param.cancelText = defaultStr = this.createCFString("SWT_No");
                break;
            }
            case 192: {
                param.defaultButton = 1;
                param.defaultText = defaultStr = this.createCFString("SWT_Yes");
                param.cancelButton = (short)2;
                param.cancelText = cancelStr = this.createCFString("SWT_No");
                break;
            }
            case 448: {
                param.defaultButton = 1;
                param.defaultText = defaultStr = this.createCFString("SWT_Yes");
                param.otherText = cancelStr = this.createCFString("SWT_No");
                param.cancelButton = (short)2;
                param.cancelText = -1;
                break;
            }
            case 1280: {
                param.defaultButton = 1;
                param.defaultText = defaultStr = this.createCFString("SWT_Retry");
                param.cancelButton = (short)2;
                param.cancelText = -1;
                break;
            }
            case 3584: {
                param.defaultButton = 1;
                param.defaultText = defaultStr = this.createCFString("SWT_Abort");
                param.otherText = cancelStr = this.createCFString("SWT_Retry");
                param.cancelButton = (short)2;
                param.cancelText = otherStr = this.createCFString("SWT_Ignore");
            }
        }
        int[] dialogRef = new int[1];
        OS.CreateStandardAlert((short)alertType, error, explanation, param, dialogRef);
        if (error != 0) {
            OS.CFRelease(error);
        }
        if (explanation != 0) {
            OS.CFRelease(explanation);
        }
        if (defaultStr != 0) {
            OS.CFRelease(defaultStr);
        }
        if (cancelStr != 0) {
            OS.CFRelease(cancelStr);
        }
        if (otherStr != 0) {
            OS.CFRelease(otherStr);
        }
        if (dialogRef[0] != 0) {
            if ((this.style & 0x20000) != 0) {
                int[] nArray = new int[2];
                nArray[1] = 2;
                OS.SetFrontProcessWithOptions(nArray, 1);
            }
            Display display = this.parent != null ? this.parent.getDisplay() : Display.getCurrent();
            Shell[] shells = display.getShells();
            int i = 0;
            while (i < shells.length) {
                Shell shell = shells[i];
                if ((shell.style & 0x4000) != 0 && !shell.isDisposed() && shell.isVisible()) {
                    OS.SetWindowGroup(shell.shellHandle, OS.GetWindowGroupOfClass(5));
                } else {
                    shells[i] = null;
                }
                ++i;
            }
            display.setModalDialog(this);
            short[] outItemHit = new short[1];
            OS.RunStandardAlert(dialogRef[0], 0, outItemHit);
            display.setModalDialog(null);
            int i2 = 0;
            while (i2 < shells.length) {
                Shell shell = shells[i2];
                if (shell != null && !shell.isDisposed()) {
                    OS.SetWindowGroup(shell.shellHandle, shell.getParentGroup());
                }
                ++i2;
            }
            if (outItemHit[0] != 0) {
                switch (bits) {
                    case 32: {
                        return 32;
                    }
                    case 256: {
                        return 256;
                    }
                    case 288: {
                        if (outItemHit[0] == 1) {
                            return 32;
                        }
                        return 256;
                    }
                    case 64: {
                        return 64;
                    }
                    case 128: {
                        return 128;
                    }
                    case 192: {
                        if (outItemHit[0] == 1) {
                            return 64;
                        }
                        return 128;
                    }
                    case 448: {
                        if (outItemHit[0] == 1) {
                            return 64;
                        }
                        if (outItemHit[0] == 3) {
                            return 128;
                        }
                        return 256;
                    }
                    case 1280: {
                        if (outItemHit[0] == 1) {
                            return 1024;
                        }
                        return 256;
                    }
                    case 3584: {
                        if (outItemHit[0] == 1) {
                            return 512;
                        }
                        if (outItemHit[0] == 3) {
                            return 1024;
                        }
                        return 2048;
                    }
                }
            }
        }
        return 256;
    }

    public void setMessage(String string) {
        if (string == null) {
            this.error(4);
        }
        this.message = string;
    }
}

