/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import java.util.ArrayList;
import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.DNDEvent;
import org.eclipse.swt.dnd.DNDListener;
import org.eclipse.swt.dnd.DropTargetEffect;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TableDropTargetEffect;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.dnd.TreeDropTargetEffect;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.cocoa.NSApplication;
import org.eclipse.swt.internal.cocoa.NSArray;
import org.eclipse.swt.internal.cocoa.NSCursor;
import org.eclipse.swt.internal.cocoa.NSEvent;
import org.eclipse.swt.internal.cocoa.NSMutableArray;
import org.eclipse.swt.internal.cocoa.NSObject;
import org.eclipse.swt.internal.cocoa.NSOutlineView;
import org.eclipse.swt.internal.cocoa.NSPasteboard;
import org.eclipse.swt.internal.cocoa.NSPoint;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSScreen;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.NSTableView;
import org.eclipse.swt.internal.cocoa.NSURL;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.SWTTreeItem;
import org.eclipse.swt.internal.cocoa.id;
import org.eclipse.swt.internal.cocoa.objc_super;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class DropTarget
extends Widget {
    static Callback dropTarget2Args;
    static Callback dropTarget3Args;
    static Callback dropTarget6Args;
    static int proc2Args;
    static int proc3Args;
    static int proc6Args;
    static boolean dropNotAllowed;
    Control control;
    Listener controlListener;
    Transfer[] transferAgents = new Transfer[0];
    DropTargetEffect dropEffect;
    int feedback = 0;
    TransferData selectedDataType;
    int selectedOperation;
    int keyOperation = -1;
    static final String DEFAULT_DROP_TARGET_EFFECT = "DEFAULT_DROP_TARGET_EFFECT";
    static final String IS_ACTIVE = "org.eclipse.swt.internal.isActive";
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz;
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.swt.dnd.DropTarget");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((proc2Args = (dropTarget2Args = new Callback(clazz = clazz2, "dropTargetProc", 2)).getAddress()) == 0) {
            SWT.error(3);
        }
        if ((proc3Args = (dropTarget3Args = new Callback(clazz, "dropTargetProc", 3)).getAddress()) == 0) {
            SWT.error(3);
        }
        if ((proc6Args = (dropTarget6Args = new Callback(clazz, "dropTargetProc", 6)).getAddress()) == 0) {
            SWT.error(3);
        }
        dropNotAllowed = false;
    }

    void addDragHandlers() {
        int procPtr;
        int cls = OS.object_getClass(this.control.view.id);
        if (cls == 0) {
            DND.error(2001);
        }
        if ((procPtr = OS.class_getMethodImplementation(cls, OS.sel_draggingEntered_)) == proc3Args) {
            return;
        }
        this.addDragHandlers(cls);
        int imageView = 0;
        imageView = OS.objc_msgSend(this.control.view.id, OS.sel_getImageView);
        if (imageView != 0) {
            cls = OS.object_getClass(imageView);
            this.addDragHandlers(cls);
        }
    }

    void addDragHandlers(int cls) {
        OS.class_addMethod(cls, OS.sel_draggingEntered_, proc3Args, "@:@");
        OS.class_addMethod(cls, OS.sel_draggingUpdated_, proc3Args, "@:@");
        OS.class_addMethod(cls, OS.sel_draggingExited_, proc3Args, "@:@");
        OS.class_addMethod(cls, OS.sel_performDragOperation_, proc3Args, "@:@");
        OS.class_addMethod(cls, OS.sel_wantsPeriodicDraggingUpdates, proc2Args, "@:");
        if (OS.class_getSuperclass(cls) == OS.class_NSOutlineView) {
            OS.class_addMethod(cls, OS.sel_outlineView_acceptDrop_item_childIndex_, proc6Args, "@:@@@i");
            OS.class_addMethod(cls, OS.sel_outlineView_validateDrop_proposedItem_proposedChildIndex_, proc6Args, "@:@@@i");
        } else if (OS.class_getSuperclass(cls) == OS.class_NSTableView) {
            OS.class_addMethod(cls, OS.sel_tableView_acceptDrop_row_dropOperation_, proc6Args, "@:@@@i");
            OS.class_addMethod(cls, OS.sel_tableView_validateDrop_proposedRow_proposedDropOperation_, proc6Args, "@:@@@i");
        }
    }

    public void addDropListener(DropTargetListener listener) {
        if (listener == null) {
            DND.error(4);
        }
        DNDListener typedListener = new DNDListener(listener);
        typedListener.dndWidget = this;
        this.addListener(2002, typedListener);
        this.addListener(2003, typedListener);
        this.addListener(2004, typedListener);
        this.addListener(2005, typedListener);
        this.addListener(2006, typedListener);
        this.addListener(2007, typedListener);
    }

    int dndCallSuper(int id2, int sel, int arg0) {
        objc_super super_struct = new objc_super();
        super_struct.receiver = id2;
        super_struct.super_class = OS.objc_msgSend(id2, OS.sel_superclass);
        return OS.objc_msgSendSuper(super_struct, sel, arg0);
    }

    static int checkStyle(int style) {
        if (style == 0) {
            return 2;
        }
        return style;
    }

    protected void checkSubclass() {
        String validName;
        String name = this.getClass().getName();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.dnd.DropTarget");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (!(validName = clazz.getName()).equals(name)) {
            DND.error(43);
        }
    }

    int draggingEntered(int id2, int sel, NSObject sender) {
        if (sender == null) {
            return 0;
        }
        DNDEvent event = new DNDEvent();
        if (!this.setEventData(sender, event)) {
            this.keyOperation = -1;
            this.setDropNotAllowed();
            return 0;
        }
        int allowedOperations = event.operations;
        TransferData[] allowedDataTypes = new TransferData[event.dataTypes.length];
        System.arraycopy(event.dataTypes, 0, allowedDataTypes, 0, allowedDataTypes.length);
        this.selectedDataType = null;
        this.selectedOperation = 0;
        this.notifyListeners(2002, event);
        if (event.detail == 16) {
            int n = event.detail = (allowedOperations & 2) != 0 ? 2 : 0;
        }
        if (event.dataType != null) {
            int i = 0;
            while (i < allowedDataTypes.length) {
                if (allowedDataTypes[i].type == event.dataType.type) {
                    this.selectedDataType = allowedDataTypes[i];
                    break;
                }
                ++i;
            }
        }
        if (this.selectedDataType != null && (allowedOperations & event.detail) != 0) {
            this.selectedOperation = event.detail;
        }
        if (this.selectedOperation == 0 && OS.PTR_SIZEOF == 4) {
            this.setDropNotAllowed();
        } else if (!((Boolean)this.control.getData(IS_ACTIVE)).booleanValue()) {
            this.setDropNotAllowed();
        } else {
            this.clearDropNotAllowed();
        }
        if (new NSObject(id2).isKindOfClass(OS.class_NSTableView)) {
            return this.dndCallSuper(id2, sel, sender.id);
        }
        return this.opToOsOp(this.selectedOperation);
    }

    void draggingExited(int id2, int sel, NSObject sender) {
        this.clearDropNotAllowed();
        if (this.keyOperation == -1) {
            return;
        }
        this.keyOperation = -1;
        DNDEvent event = new DNDEvent();
        event.widget = this;
        event.time = (int)System.currentTimeMillis();
        event.detail = 0;
        this.notifyListeners(2003, event);
        if (new NSObject(id2).isKindOfClass(OS.class_NSTableView)) {
            this.dndCallSuper(id2, sel, sender.id);
        }
    }

    int draggingUpdated(int id2, int sel, NSObject sender) {
        if (sender == null) {
            return 0;
        }
        int oldKeyOperation = this.keyOperation;
        DNDEvent event = new DNDEvent();
        if (!this.setEventData(sender, event)) {
            this.keyOperation = -1;
            this.setDropNotAllowed();
            return 0;
        }
        int allowedOperations = event.operations;
        TransferData[] allowedDataTypes = new TransferData[event.dataTypes.length];
        System.arraycopy(event.dataTypes, 0, allowedDataTypes, 0, allowedDataTypes.length);
        if (this.keyOperation == oldKeyOperation) {
            event.type = 2004;
            event.dataType = this.selectedDataType;
            event.detail = this.selectedOperation;
        } else {
            event.type = 2005;
            event.dataType = this.selectedDataType;
        }
        this.selectedDataType = null;
        this.selectedOperation = 0;
        this.notifyListeners(event.type, event);
        if (event.detail == 16) {
            int n = event.detail = (allowedOperations & 2) != 0 ? 2 : 0;
        }
        if (event.dataType != null) {
            int i = 0;
            while (i < allowedDataTypes.length) {
                if (allowedDataTypes[i].type == event.dataType.type) {
                    this.selectedDataType = allowedDataTypes[i];
                    break;
                }
                ++i;
            }
        }
        if (this.selectedDataType != null && (event.detail & allowedOperations) != 0) {
            this.selectedOperation = event.detail;
        }
        if (this.selectedOperation == 0 && OS.PTR_SIZEOF == 4) {
            this.setDropNotAllowed();
        } else if (!((Boolean)this.control.getData(IS_ACTIVE)).booleanValue()) {
            this.setDropNotAllowed();
        } else {
            this.clearDropNotAllowed();
        }
        if (new NSObject(id2).isKindOfClass(OS.class_NSTableView)) {
            return this.dndCallSuper(id2, sel, sender.id);
        }
        return this.opToOsOp(this.selectedOperation);
    }

    public DropTarget(Control control, int style) {
        super(control, DropTarget.checkStyle(style));
        this.control = control;
        if (control.getData("DropTarget") != null) {
            DND.error(2001);
        }
        control.setData("DropTarget", this);
        this.controlListener = new Listener(){

            public void handleEvent(Event event) {
                if (!DropTarget.this.isDisposed()) {
                    DropTarget.this.dispose();
                }
            }
        };
        control.addListener(12, this.controlListener);
        this.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                DropTarget.this.onDispose();
            }
        });
        Object effect = control.getData(DEFAULT_DROP_TARGET_EFFECT);
        if (effect instanceof DropTargetEffect) {
            this.dropEffect = (DropTargetEffect)effect;
        } else if (control instanceof Table) {
            this.dropEffect = new TableDropTargetEffect((Table)control);
        } else if (control instanceof Tree) {
            this.dropEffect = new TreeDropTargetEffect((Tree)control);
        }
        this.addDragHandlers();
    }

    static int dropTargetProc(int id2, int sel) {
        Display display = Display.findDisplay(Thread.currentThread());
        if (display == null || display.isDisposed()) {
            return 0;
        }
        Widget widget = display.findWidget(id2);
        if (widget == null) {
            return 0;
        }
        DropTarget dt = (DropTarget)widget.getData("DropTarget");
        if (dt == null) {
            return 0;
        }
        if (sel == OS.sel_wantsPeriodicDraggingUpdates) {
            return dt.wantsPeriodicDraggingUpdates(id2, sel) ? 1 : 0;
        }
        return 0;
    }

    static int dropTargetProc(int id2, int sel, int arg0) {
        Display display = Display.findDisplay(Thread.currentThread());
        if (display == null || display.isDisposed()) {
            return 0;
        }
        Widget widget = display.findWidget(id2);
        if (widget == null) {
            return 0;
        }
        DropTarget dt = (DropTarget)widget.getData("DropTarget");
        if (dt == null) {
            return 0;
        }
        NSObject sender = new NSObject(arg0);
        if (sel == OS.sel_draggingEntered_) {
            return dt.draggingEntered(id2, sel, sender);
        }
        if (sel == OS.sel_draggingUpdated_) {
            return dt.draggingUpdated(id2, sel, sender);
        }
        if (sel == OS.sel_draggingExited_) {
            dt.draggingExited(id2, sel, sender);
        } else if (sel == OS.sel_performDragOperation_) {
            return dt.performDragOperation(id2, sel, sender) ? 1 : 0;
        }
        return 0;
    }

    static int dropTargetProc(int id2, int sel, int arg0, int arg1, int arg2, int arg3) {
        Display display = Display.findDisplay(Thread.currentThread());
        if (display == null || display.isDisposed()) {
            return 0;
        }
        Widget widget = display.findWidget(id2);
        if (widget == null) {
            return 0;
        }
        DropTarget dt = (DropTarget)widget.getData("DropTarget");
        if (dt == null) {
            return 0;
        }
        if (sel == OS.sel_outlineView_acceptDrop_item_childIndex_) {
            return dt.outlineView_acceptDrop_item_childIndex(id2, sel, arg0, arg1, arg2, arg3) ? 1 : 0;
        }
        if (sel == OS.sel_outlineView_validateDrop_proposedItem_proposedChildIndex_) {
            return dt.outlineView_validateDrop_proposedItem_proposedChildIndex(id2, sel, arg0, arg1, arg2, arg3);
        }
        if (sel == OS.sel_tableView_acceptDrop_row_dropOperation_) {
            return dt.tableView_acceptDrop_row_dropOperation(id2, sel, arg0, arg1, arg2, arg3) ? 1 : 0;
        }
        if (sel == OS.sel_tableView_validateDrop_proposedRow_proposedDropOperation_) {
            return dt.tableView_validateDrop_proposedRow_proposedDropOperation(id2, sel, arg0, arg1, arg2, arg3);
        }
        return 0;
    }

    public Control getControl() {
        return this.control;
    }

    public DropTargetListener[] getDropListeners() {
        Listener[] listeners = this.getListeners(2002);
        int length = listeners.length;
        DropTargetListener[] dropListeners = new DropTargetListener[length];
        int count = 0;
        int i = 0;
        while (i < length) {
            Listener listener = listeners[i];
            if (listener instanceof DNDListener) {
                dropListeners[count] = (DropTargetListener)((DNDListener)listener).getEventListener();
                ++count;
            }
            ++i;
        }
        if (count == length) {
            return dropListeners;
        }
        DropTargetListener[] result = new DropTargetListener[count];
        System.arraycopy(dropListeners, 0, result, 0, count);
        return result;
    }

    public DropTargetEffect getDropTargetEffect() {
        return this.dropEffect;
    }

    int getOperationFromKeyState() {
        boolean control;
        NSEvent currEvent = NSApplication.sharedApplication().currentEvent();
        int modifiers = currEvent.modifierFlags();
        boolean option = (modifiers & 0x80000) == 524288;
        boolean bl = control = (modifiers & 0x40000) == 262144;
        if (control && option) {
            return 16;
        }
        if (control) {
            return 4;
        }
        if (option) {
            return 1;
        }
        return 16;
    }

    public Transfer[] getTransfer() {
        return this.transferAgents;
    }

    void onDispose() {
        if (this.control == null) {
            return;
        }
        if (this.controlListener != null) {
            this.control.removeListener(12, this.controlListener);
        }
        this.controlListener = null;
        this.control.setData("DropTarget", null);
        this.transferAgents = null;
        this.control.view.unregisterDraggedTypes();
        this.control = null;
    }

    int opToOsOp(int operation) {
        int osOperation = 0;
        if ((operation & 1) != 0) {
            osOperation |= 1;
        }
        if ((operation & 4) != 0) {
            osOperation |= 2;
        }
        if ((operation & 2) != 0) {
            osOperation |= 0x10;
        }
        if ((operation & 8) != 0) {
            osOperation |= 0x20;
        }
        return osOperation;
    }

    int osOpToOp(int osOperation) {
        int operation = 0;
        if ((osOperation & 1) != 0) {
            operation |= 1;
        }
        if ((osOperation & 2) != 0) {
            operation |= 4;
        }
        if ((osOperation & 0x20) != 0) {
            operation |= 8;
        }
        if ((osOperation & 0x10) != 0) {
            operation |= 2;
        }
        if (osOperation == -1) {
            operation = 7;
        }
        return operation;
    }

    boolean drop(NSObject sender) {
        this.clearDropNotAllowed();
        DNDEvent event = new DNDEvent();
        event.widget = this;
        event.time = (int)System.currentTimeMillis();
        if (this.dropEffect != null) {
            NSPoint mouseLocation = sender.draggingLocation();
            NSPoint globalLoc = sender.draggingDestinationWindow().convertBaseToScreen(mouseLocation);
            event.item = this.dropEffect.getItem((int)globalLoc.x, (int)globalLoc.y);
        }
        event.detail = 0;
        this.notifyListeners(2003, event);
        event = new DNDEvent();
        if (!this.setEventData(sender, event) || !((Boolean)this.control.getData(IS_ACTIVE)).booleanValue()) {
            return false;
        }
        this.keyOperation = -1;
        int allowedOperations = event.operations;
        TransferData[] allowedDataTypes = new TransferData[event.dataTypes.length];
        System.arraycopy(event.dataTypes, 0, allowedDataTypes, 0, event.dataTypes.length);
        event.dataType = this.selectedDataType;
        event.detail = this.selectedOperation;
        this.notifyListeners(2007, event);
        this.selectedDataType = null;
        if (event.dataType != null) {
            int i = 0;
            while (i < allowedDataTypes.length) {
                if (allowedDataTypes[i].type == event.dataType.type) {
                    this.selectedDataType = allowedDataTypes[i];
                    break;
                }
                ++i;
            }
        }
        this.selectedOperation = 0;
        if (this.selectedDataType != null && (event.detail & allowedOperations) != 0) {
            this.selectedOperation = event.detail;
        }
        if (this.selectedOperation == 0) {
            return false;
        }
        NSPasteboard pasteboard = sender.draggingPasteboard();
        NSObject data = null;
        NSMutableArray types = NSMutableArray.arrayWithCapacity(10);
        int i = 0;
        while (i < this.transferAgents.length) {
            Transfer transfer = this.transferAgents[i];
            String[] typeNames = transfer.getTypeNames();
            int[] typeIds = transfer.getTypeIds();
            int j = 0;
            while (j < typeNames.length) {
                if (this.selectedDataType.type == typeIds[j]) {
                    types.addObject(NSString.stringWith(typeNames[j]));
                    break;
                }
                ++j;
            }
            ++i;
        }
        NSString type = pasteboard.availableTypeFromArray(types);
        TransferData tdata = new TransferData();
        if (type != null) {
            tdata.type = Transfer.registerType(type.getString());
            tdata.data = type.isEqual(OS.NSStringPboardType) || type.isEqual(OS.NSHTMLPboardType) || type.isEqual(OS.NSRTFPboardType) ? pasteboard.stringForType(type) : (type.isEqual(OS.NSURLPboardType) ? NSURL.URLFromPasteboard(pasteboard) : (type.isEqual(OS.NSFilenamesPboardType) ? new NSArray(pasteboard.propertyListForType((NSString)type).id) : pasteboard.dataForType(type)));
        }
        if (tdata.data != null) {
            data = tdata.data;
        }
        Object object = null;
        int i2 = 0;
        while (i2 < this.transferAgents.length) {
            Transfer transfer = this.transferAgents[i2];
            if (transfer != null && transfer.isSupportedType(this.selectedDataType)) {
                this.selectedDataType.data = data;
                object = transfer.nativeToJava(this.selectedDataType);
                break;
            }
            ++i2;
        }
        if (object == null) {
            this.selectedOperation = 0;
        }
        event.dataType = this.selectedDataType;
        event.detail = this.selectedOperation;
        event.data = object;
        this.notifyListeners(2006, event);
        this.selectedOperation = 0;
        if ((allowedOperations & event.detail) == event.detail) {
            this.selectedOperation = event.detail;
        }
        return this.selectedOperation != 0;
    }

    boolean performDragOperation(int id2, int sel, NSObject sender) {
        if (new NSObject(id2).isKindOfClass(OS.class_NSTableView)) {
            return this.dndCallSuper(id2, sel, sender.id) != 0;
        }
        return this.drop(sender);
    }

    boolean outlineView_acceptDrop_item_childIndex(int id2, int sel, int outlineView, int info, int item, int index) {
        return this.drop(new NSObject(info));
    }

    int outlineView_validateDrop_proposedItem_proposedChildIndex(int id2, int sel, int outlineView, int info, int item, int index) {
        NSOutlineView widget = new NSOutlineView(outlineView);
        NSObject sender = new NSObject(info);
        NSPoint pt = sender.draggingLocation();
        pt = widget.convertPoint_fromView_(pt, null);
        Tree tree = (Tree)this.getControl();
        TreeItem childItem = tree.getItem(new Point((int)pt.x, (int)pt.y));
        if (this.feedback == 0 || childItem == null) {
            widget.setDropItem(null, -1);
        } else if ((this.feedback & 1) != 0) {
            widget.setDropItem(childItem.handle, -1);
        } else {
            int childIndex;
            TreeItem parentItem = childItem.getParentItem();
            SWTTreeItem parentID = null;
            if (parentItem != null) {
                parentID = parentItem.handle;
                childIndex = parentItem.indexOf(childItem);
            } else {
                childIndex = ((Tree)this.getControl()).indexOf(childItem);
            }
            if ((this.feedback & 4) != 0) {
                widget.setDropItem(parentID, childIndex + 1);
            }
            if ((this.feedback & 2) != 0) {
                widget.setDropItem(parentID, childIndex);
            }
        }
        return this.opToOsOp(this.selectedOperation);
    }

    public void removeDropListener(DropTargetListener listener) {
        if (listener == null) {
            DND.error(4);
        }
        this.removeListener(2002, listener);
        this.removeListener(2003, listener);
        this.removeListener(2004, listener);
        this.removeListener(2005, listener);
        this.removeListener(2006, listener);
        this.removeListener(2007, listener);
    }

    public void setDropTargetEffect(DropTargetEffect effect) {
        this.dropEffect = effect;
    }

    boolean setEventData(NSObject draggingState, DNDEvent event) {
        NSPasteboard dragPBoard;
        NSArray draggedTypes;
        int operation;
        if (draggingState == null) {
            return false;
        }
        int style = this.getStyle();
        int allowedActions = draggingState.draggingSourceOperationMask();
        int operations = this.osOpToOp(allowedActions) & style;
        if (operations == 0) {
            return false;
        }
        this.keyOperation = operation = this.getOperationFromKeyState();
        if (operation == 16) {
            if ((style & 0x10) == 0) {
                operation = (operations & 2) != 0 ? 2 : 0;
            }
        } else if ((operation & operations) == 0) {
            operation = 0;
        }
        if ((draggedTypes = (dragPBoard = draggingState.draggingPasteboard()).types()) == null) {
            return false;
        }
        int draggedTypeCount = draggedTypes.count();
        TransferData[] dataTypes = new TransferData[draggedTypeCount];
        int index = -1;
        int i = 0;
        while (i < draggedTypeCount) {
            id draggedType = draggedTypes.objectAtIndex(i);
            NSString nativeDataType = new NSString(draggedType);
            TransferData data = new TransferData();
            data.type = Transfer.registerType(nativeDataType.getString());
            int j = 0;
            while (j < this.transferAgents.length) {
                Transfer transfer = this.transferAgents[j];
                if (transfer != null && transfer.isSupportedType(data)) {
                    dataTypes[++index] = data;
                    break;
                }
                ++j;
            }
            ++i;
        }
        if (index == -1) {
            return false;
        }
        if (index < dataTypes.length - 1) {
            TransferData[] temp = new TransferData[index + 1];
            System.arraycopy(dataTypes, 0, temp, 0, index + 1);
            dataTypes = temp;
        }
        NSPoint mouse = draggingState.draggingLocation();
        NSPoint globalMouse = draggingState.draggingDestinationWindow().convertBaseToScreen(mouse);
        NSArray screens = NSScreen.screens();
        NSRect screenRect = new NSScreen(screens.objectAtIndex(0)).frame();
        globalMouse.y = screenRect.height - globalMouse.y;
        event.widget = this;
        event.x = (int)globalMouse.x;
        event.y = (int)globalMouse.y;
        event.time = (int)System.currentTimeMillis();
        event.feedback = 1;
        event.dataTypes = dataTypes;
        event.dataType = dataTypes[0];
        event.operations = operations;
        event.detail = operation;
        if (this.dropEffect != null) {
            event.item = this.dropEffect.getItem(event.x, event.y);
        }
        return true;
    }

    public void setTransfer(Transfer[] transferAgents) {
        if (transferAgents == null) {
            DND.error(4);
        }
        this.transferAgents = transferAgents;
        ArrayList<String> typeStrings = new ArrayList<String>();
        int i = 0;
        while (i < this.transferAgents.length) {
            String[] types = transferAgents[i].getTypeNames();
            int j = 0;
            while (j < types.length) {
                typeStrings.add(types[j]);
                ++j;
            }
            ++i;
        }
        int typeStringCount = typeStrings.size();
        NSMutableArray nsTypeStrings = NSMutableArray.arrayWithCapacity(typeStringCount);
        int i2 = 0;
        while (i2 < typeStringCount) {
            nsTypeStrings.addObject(NSString.stringWith((String)typeStrings.get(i2)));
            ++i2;
        }
        this.control.view.registerForDraggedTypes(nsTypeStrings);
    }

    void setDropNotAllowed() {
        if (!dropNotAllowed) {
            NSCursor.currentCursor().push();
            if (OS.PTR_SIZEOF == 4) {
                OS.SetThemeCursor(18);
            }
            dropNotAllowed = true;
        }
    }

    void clearDropNotAllowed() {
        if (dropNotAllowed) {
            NSCursor.pop();
            dropNotAllowed = false;
        }
    }

    boolean tableView_acceptDrop_row_dropOperation(int id2, int sel, int tableView, int info, int row, int operation) {
        return this.drop(new NSObject(info));
    }

    int tableView_validateDrop_proposedRow_proposedDropOperation(int id2, int sel, int tableView, int info, int row, int operation) {
        NSTableView widget = new NSTableView(tableView);
        NSObject sender = new NSObject(info);
        NSPoint pt = sender.draggingLocation();
        int hitRow = widget.rowAtPoint(pt = widget.convertPoint_fromView_(pt, null));
        if (hitRow >= 0 && hitRow < widget.numberOfRows()) {
            if (this.feedback == 0) {
                widget.setDropRow(-1, 0);
            } else if ((this.feedback & 1) != 0) {
                widget.setDropRow(hitRow, 0);
            } else {
                if ((this.feedback & 4) != 0) {
                    widget.setDropRow(hitRow + 1, 1);
                }
                if ((this.feedback & 2) != 0) {
                    widget.setDropRow(hitRow, 1);
                }
            }
        }
        return this.opToOsOp(this.selectedOperation);
    }

    boolean wantsPeriodicDraggingUpdates(int id2, int sel) {
        return true;
    }
}

