/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.databinding.beans;

import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.databinding.beans.IBeanListProperty;
import org.eclipse.core.databinding.beans.IBeanMapProperty;
import org.eclipse.core.databinding.beans.IBeanSetProperty;
import org.eclipse.core.databinding.beans.IBeanValueProperty;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.core.databinding.util.Policy;
import org.eclipse.core.internal.databinding.beans.AnonymousBeanListProperty;
import org.eclipse.core.internal.databinding.beans.AnonymousBeanMapProperty;
import org.eclipse.core.internal.databinding.beans.AnonymousBeanSetProperty;
import org.eclipse.core.internal.databinding.beans.AnonymousBeanValueProperty;
import org.eclipse.core.internal.databinding.beans.AnonymousPojoValueProperty;
import org.eclipse.core.internal.databinding.beans.BeanListProperty;
import org.eclipse.core.internal.databinding.beans.BeanListPropertyDecorator;
import org.eclipse.core.internal.databinding.beans.BeanMapProperty;
import org.eclipse.core.internal.databinding.beans.BeanMapPropertyDecorator;
import org.eclipse.core.internal.databinding.beans.BeanPropertyHelper;
import org.eclipse.core.internal.databinding.beans.BeanSetProperty;
import org.eclipse.core.internal.databinding.beans.BeanSetPropertyDecorator;
import org.eclipse.core.internal.databinding.beans.BeanValueProperty;
import org.eclipse.core.internal.databinding.beans.BeanValuePropertyDecorator;
import org.eclipse.core.internal.databinding.beans.Util;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanProperties {
    public static final boolean DEBUG = true;

    public static IBeanValueProperty<Object, Object> value(String propertyName) {
        return BeanProperties.value(propertyName, null);
    }

    public static <T> IBeanValueProperty<Object, T> value(String propertyName, Class<T> valueType) {
        String[] propertyNames = BeanProperties.splitOffFirst(propertyName);
        if (propertyNames.length == 1) {
            return new BeanValuePropertyDecorator(new AnonymousBeanValueProperty(propertyNames[0], valueType), null);
        }
        AnonymousPojoValueProperty x = new AnonymousPojoValueProperty(propertyNames[0], Object.class);
        IBeanValueProperty<Object, T> remainder = BeanProperties.value(propertyNames[1], valueType);
        IValueProperty y = x.value(remainder);
        return new BeanValuePropertyDecorator(y, null);
    }

    public static <S> IBeanValueProperty<S, ?> value(Class<S> beanClass, String propertyName) {
        String[] propertyNames = BeanProperties.splitOffFirst(propertyName);
        if (beanClass == null) {
            throw new IllegalArgumentException();
        }
        PropertyDescriptor propertyDescriptor = BeanPropertyHelper.getPropertyDescriptor(beanClass, propertyNames[0]);
        if (propertyNames.length == 1) {
            Class<?> valueType = propertyDescriptor.getPropertyType();
            valueType = Util.convertToObjectClass(valueType);
            return BeanProperties.valueUsingActualType(propertyDescriptor, valueType);
        }
        return BeanProperties.valueGivenDescriptor(beanClass, propertyDescriptor, propertyDescriptor.getPropertyType(), propertyNames[1]);
    }

    private static <S, T> IBeanValueProperty<S, T> valueUsingActualType(PropertyDescriptor propertyDescriptor, Class<T> valueType) {
        BeanValueProperty property = new BeanValueProperty(propertyDescriptor, valueType);
        return new BeanValuePropertyDecorator(property, propertyDescriptor);
    }

    public static <S, T> IBeanValueProperty<S, T> value(Class<? extends S> beanClass, String propertyName, Class<T> valueType) {
        String[] propertyNames = BeanProperties.splitOffFirst(propertyName);
        if (beanClass == null) {
            Policy.getLog().log((IStatus)new Status(2, "org.eclipse.core.databinding", "beanClass cannot be null"));
        }
        if (valueType == null) {
            Policy.getLog().log((IStatus)new Status(2, "org.eclipse.core.databinding", "valueType cannot be null"));
        }
        if (beanClass == null && valueType == null) {
            return BeanProperties.value(propertyName);
        }
        if (beanClass == null) {
            return BeanProperties.value(propertyName, valueType);
        }
        if (valueType == null) {
            return BeanProperties.value(beanClass, propertyName);
        }
        PropertyDescriptor propertyDescriptor = BeanPropertyHelper.getPropertyDescriptor(beanClass, propertyNames[0]);
        if (propertyNames.length == 1) {
            BeanValueProperty property = new BeanValueProperty(propertyDescriptor, valueType);
            return new BeanValuePropertyDecorator(property, propertyDescriptor);
        }
        return BeanProperties.valueGivenDescriptor(beanClass, propertyDescriptor, propertyDescriptor.getPropertyType(), propertyNames[1], valueType);
    }

    private static <S, I, T> IBeanValueProperty<S, T> valueGivenDescriptor(Class<? extends S> sourceBeanClass, PropertyDescriptor propertyDescriptor, Class<I> childBeanClass, String propertyName, Class<T> valueType) {
        BeanValueProperty property = new BeanValueProperty(propertyDescriptor, childBeanClass);
        BeanValuePropertyDecorator decoratedProperty = new BeanValuePropertyDecorator(property, propertyDescriptor);
        IBeanValueProperty<I, T> remainder = BeanProperties.value(childBeanClass, propertyName, valueType);
        return decoratedProperty.value(remainder);
    }

    private static <S, I> IBeanValueProperty<S, ?> valueGivenDescriptor(Class<? extends S> sourceBeanClass, PropertyDescriptor propertyDescriptor, Class<I> childBeanClass, String propertyName) {
        BeanValueProperty property = new BeanValueProperty(propertyDescriptor, childBeanClass);
        BeanValuePropertyDecorator decoratedProperty = new BeanValuePropertyDecorator(property, propertyDescriptor);
        IBeanValueProperty<I, ?> remainder = BeanProperties.value(childBeanClass, propertyName);
        return decoratedProperty.value(remainder);
    }

    private static String[] splitOffFirst(String propertyName) {
        int index = propertyName.indexOf(46);
        if (index == -1) {
            return new String[]{propertyName};
        }
        return new String[]{propertyName.substring(0, index), propertyName.substring(index + 1)};
    }

    public static <S> IBeanValueProperty<?, ?>[] values(Class<S> beanClass, String[] propertyNames) {
        IBeanValueProperty[] properties = new IBeanValueProperty[propertyNames.length];
        int i = 0;
        while (i < properties.length) {
            properties[i] = BeanProperties.value(beanClass, propertyNames[i], null);
            ++i;
        }
        return properties;
    }

    public static <S> List<IBeanValueProperty<S, Object>> valuesAsList(Class<S> beanClass, String[] propertyNames) {
        ArrayList<IBeanValueProperty<S, Object>> properties = new ArrayList<IBeanValueProperty<S, Object>>(propertyNames.length);
        int i = 0;
        while (i < propertyNames.length) {
            properties.add(BeanProperties.value(beanClass, propertyNames[i], null));
            ++i;
        }
        return properties;
    }

    public static IBeanValueProperty<?, ?>[] values(String[] propertyNames) {
        IBeanValueProperty[] properties = new IBeanValueProperty[propertyNames.length];
        int i = 0;
        while (i < properties.length) {
            properties[i] = BeanProperties.value(propertyNames[i]);
            ++i;
        }
        return properties;
    }

    public static List<IBeanValueProperty<Object, Object>> valuesAsList(String[] propertyNames) {
        return BeanProperties.valuesAsList(null, propertyNames);
    }

    public static <S, E> IBeanSetProperty<S, E> set(String propertyName) {
        return BeanProperties.set(null, propertyName, null);
    }

    public static <S, E> IBeanSetProperty<S, E> set(String propertyName, Class<E> elementType) {
        return BeanProperties.set(null, propertyName, elementType);
    }

    public static <S, E> IBeanSetProperty<S, E> set(Class<S> beanClass, String propertyName) {
        return BeanProperties.set(beanClass, propertyName, null);
    }

    public static <S, E> IBeanSetProperty<S, E> set(Class<? extends S> beanClass, String propertyName, Class<E> elementType) {
        Object property;
        PropertyDescriptor propertyDescriptor;
        if (beanClass == null) {
            propertyDescriptor = null;
            property = new AnonymousBeanSetProperty(propertyName, elementType);
        } else {
            propertyDescriptor = BeanPropertyHelper.getPropertyDescriptor(beanClass, propertyName);
            property = new BeanSetProperty(propertyDescriptor, elementType);
        }
        return new BeanSetPropertyDecorator(property, propertyDescriptor);
    }

    public static <S, E> IBeanListProperty<S, E> list(String propertyName) {
        return BeanProperties.list(null, propertyName, null);
    }

    public static <S, E> IBeanListProperty<S, E> list(String propertyName, Class<E> elementType) {
        return BeanProperties.list(null, propertyName, elementType);
    }

    public static <S> IBeanListProperty<S, ?> list(Class<S> beanClass, String propertyName) {
        if (beanClass == null) {
            return new BeanListPropertyDecorator(new AnonymousBeanListProperty(propertyName, null), null);
        }
        PropertyDescriptor propertyDescriptor = BeanPropertyHelper.getPropertyDescriptor(beanClass, propertyName);
        Class<Object> elementType = propertyDescriptor.getPropertyType().isArray() ? propertyDescriptor.getPropertyType().getComponentType() : Object.class;
        return BeanProperties.createBeanListProperty(beanClass, propertyDescriptor, elementType);
    }

    private static <S, T> IBeanListProperty<S, T> createBeanListProperty(Class<S> beanClass, PropertyDescriptor propertyDescriptor, Class<T> valueType) {
        return new BeanListPropertyDecorator(new BeanListProperty(propertyDescriptor, valueType), propertyDescriptor);
    }

    public static <S, E> IBeanListProperty<S, E> list(Class<? extends S> beanClass, String propertyName, Class<E> elementType) {
        Object property;
        PropertyDescriptor propertyDescriptor;
        if (beanClass == null) {
            propertyDescriptor = null;
            property = new AnonymousBeanListProperty(propertyName, elementType);
        } else {
            propertyDescriptor = BeanPropertyHelper.getPropertyDescriptor(beanClass, propertyName);
            property = new BeanListProperty(propertyDescriptor, elementType);
        }
        return new BeanListPropertyDecorator(property, propertyDescriptor);
    }

    public static <S, K, V> IBeanMapProperty<S, K, V> map(String propertyName) {
        return BeanProperties.map(null, propertyName, null, null);
    }

    public static <S, K, V> IBeanMapProperty<S, K, V> map(String propertyName, Class<K> keyType, Class<V> valueType) {
        return BeanProperties.map(null, propertyName, keyType, valueType);
    }

    public static <S, K, V> IBeanMapProperty<S, K, V> map(Class<S> beanClass, String propertyName) {
        return BeanProperties.map(beanClass, propertyName, null, null);
    }

    public static <S, K, V> IBeanMapProperty<S, K, V> map(Class<? extends S> beanClass, String propertyName, Class<K> keyType, Class<V> valueType) {
        Object property;
        PropertyDescriptor propertyDescriptor;
        if (beanClass == null) {
            propertyDescriptor = null;
            property = new AnonymousBeanMapProperty(propertyName, keyType, valueType);
        } else {
            propertyDescriptor = BeanPropertyHelper.getPropertyDescriptor(beanClass, propertyName);
            property = new BeanMapProperty(propertyDescriptor, keyType, valueType);
        }
        return new BeanMapPropertyDecorator(property, propertyDescriptor);
    }
}

