/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.databinding.identity;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.internal.databinding.identity.IdentityWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdentitySet<E>
implements Set<E> {
    private final Set<IdentityWrapper<E>> wrappedSet = new HashSet<IdentityWrapper<E>>();

    public IdentitySet() {
    }

    public IdentitySet(Collection<? extends E> collection) {
        this();
        this.addAll(collection);
    }

    @Override
    public boolean add(E o) {
        return this.wrappedSet.add(IdentityWrapper.wrap(o));
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        boolean changed = false;
        for (E element : c) {
            changed |= this.wrappedSet.add(IdentityWrapper.wrap(element));
        }
        return changed;
    }

    @Override
    public void clear() {
        this.wrappedSet.clear();
    }

    @Override
    public boolean contains(Object o) {
        return this.wrappedSet.contains(IdentityWrapper.wrap(o));
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        Iterator<?> iterator = c.iterator();
        while (iterator.hasNext()) {
            if (this.wrappedSet.contains(IdentityWrapper.wrap(iterator.next()))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.wrappedSet.isEmpty();
    }

    @Override
    public Iterator<E> iterator() {
        final Iterator<IdentityWrapper<E>> wrappedIterator = this.wrappedSet.iterator();
        return new Iterator<E>(){

            @Override
            public boolean hasNext() {
                return wrappedIterator.hasNext();
            }

            @Override
            public E next() {
                return ((IdentityWrapper)wrappedIterator.next()).unwrap();
            }

            @Override
            public void remove() {
                wrappedIterator.remove();
            }
        };
    }

    @Override
    public boolean remove(Object o) {
        return this.wrappedSet.remove(IdentityWrapper.wrap(o));
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean changed = false;
        Iterator<?> iterator = c.iterator();
        while (iterator.hasNext()) {
            changed |= this.remove(iterator.next());
        }
        return changed;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean changed = false;
        Object[] retainAll = c.toArray();
        Iterator<E> iterator = this.iterator();
        block0: while (iterator.hasNext()) {
            E element = iterator.next();
            int i = 0;
            while (i < retainAll.length) {
                if (element == retainAll[i]) continue block0;
                ++i;
            }
            iterator.remove();
            changed = true;
        }
        return changed;
    }

    @Override
    public int size() {
        return this.wrappedSet.size();
    }

    @Override
    public Object[] toArray() {
        return this.toArray(new Object[this.wrappedSet.size()]);
    }

    @Override
    public <T> T[] toArray(T[] a) {
        int size = this.wrappedSet.size();
        Object[] result = a;
        if (a.length < size) {
            result = (Object[])Array.newInstance(a.getClass().getComponentType(), size);
        }
        int i = 0;
        for (IdentityWrapper<E> wrapper : this.wrappedSet) {
            result[i++] = wrapper.unwrap();
        }
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Set)) {
            return false;
        }
        Set that = (Set)obj;
        return this.size() == that.size() && this.containsAll(that);
    }

    @Override
    public int hashCode() {
        int hash = 0;
        for (E element : this) {
            hash += element == null ? 0 : element.hashCode();
        }
        return hash;
    }
}

