/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.databinding.property.list;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.ListDiff;
import org.eclipse.core.databinding.observable.list.ListDiffEntry;
import org.eclipse.core.databinding.observable.list.ListDiffVisitor;
import org.eclipse.core.databinding.observable.list.MultiList;
import org.eclipse.core.databinding.property.list.IListProperty;
import org.eclipse.core.databinding.property.list.ListProperty;
import org.eclipse.core.internal.databinding.property.PropertyObservableUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiListProperty<S, E>
extends ListProperty<S, E> {
    private IListProperty<S, E>[] properties;
    private Object elementType;

    public MultiListProperty(IListProperty<S, E>[] properties) {
        this(properties, null);
    }

    public MultiListProperty(IListProperty<S, E>[] properties, Object elementType) {
        this.properties = properties;
        this.elementType = elementType;
    }

    @Override
    public Object getElementType() {
        return this.elementType;
    }

    @Override
    protected List<E> doGetList(S source) {
        ArrayList<E> list = new ArrayList<E>();
        int i = 0;
        while (i < this.properties.length) {
            list.addAll(this.properties[i].getList(source));
            ++i;
        }
        return list;
    }

    @Override
    protected void doUpdateList(final S source, ListDiff<E> diff) {
        diff.accept(new ListDiffVisitor<E>(){

            public void handleAdd(int index, E element) {
                throw new UnsupportedOperationException();
            }

            public void handleMove(int oldIndex, int newIndex, E element) {
                throw new UnsupportedOperationException();
            }

            public void handleReplace(int index, E oldElement, E newElement) {
                int offset = 0;
                int i = 0;
                while (i < MultiListProperty.this.properties.length) {
                    List subList = MultiListProperty.this.properties[i].getList(source);
                    if (index - offset < subList.size()) {
                        int subListIndex = index - offset;
                        ArrayList<ListDiffEntry> entries = new ArrayList<ListDiffEntry>(2);
                        entries.add(Diffs.createListDiffEntry((int)subListIndex, (boolean)false, oldElement));
                        entries.add(Diffs.createListDiffEntry((int)subListIndex, (boolean)true, newElement));
                        ListDiff diff = Diffs.createListDiff(entries);
                        MultiListProperty.this.properties[i].updateList(source, diff);
                        return;
                    }
                    offset += subList.size();
                    ++i;
                }
                throw new IndexOutOfBoundsException("index: " + index + ", size: " + offset);
            }

            public void handleRemove(int index, E element) {
                int offset = 0;
                int i = 0;
                while (i < MultiListProperty.this.properties.length) {
                    int subListIndex = index - offset;
                    List subList = MultiListProperty.this.properties[i].getList(source);
                    if (subListIndex < subList.size()) {
                        ListDiff diff = Diffs.createListDiff((ListDiffEntry)Diffs.createListDiffEntry((int)subListIndex, (boolean)false, element));
                        MultiListProperty.this.properties[i].updateList(source, diff);
                        return;
                    }
                    offset += subList.size();
                    ++i;
                }
                throw new IndexOutOfBoundsException("index: " + index + ", size: " + offset);
            }
        });
    }

    @Override
    public IObservableList<E> observe(Realm realm, S source) {
        ArrayList<IObservableList<E>> lists = new ArrayList<IObservableList<E>>(this.properties.length);
        int i = 0;
        while (i < this.properties.length) {
            lists.add(this.properties[i].observe(realm, source));
            ++i;
        }
        MultiList multiList = new MultiList(lists, this.elementType);
        for (IObservableList iObservableList : lists) {
            PropertyObservableUtil.cascadeDispose((IObservable)multiList, (IObservable)iObservableList);
        }
        return multiList;
    }
}

