/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.databinding.property.set;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.set.SetDiff;
import org.eclipse.core.databinding.observable.set.UnionSet;
import org.eclipse.core.databinding.property.set.ISetProperty;
import org.eclipse.core.databinding.property.set.SetProperty;
import org.eclipse.core.internal.databinding.property.PropertyObservableUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnionSetProperty<S, E>
extends SetProperty<S, E> {
    private final ISetProperty<S, E>[] properties;
    private final Object elementType;

    public UnionSetProperty(ISetProperty<S, E>[] properties) {
        this(properties, null);
    }

    public UnionSetProperty(ISetProperty<S, E>[] properties, Object elementType) {
        this.properties = properties;
        this.elementType = elementType;
    }

    @Override
    public Object getElementType() {
        return this.elementType;
    }

    @Override
    protected Set<E> doGetSet(S source) {
        HashSet<E> set = new HashSet<E>();
        int i = 0;
        while (i < this.properties.length) {
            set.addAll(this.properties[i].getSet(source));
            ++i;
        }
        return set;
    }

    @Override
    protected void doSetSet(S source, Set<E> set) {
        throw new UnsupportedOperationException("UnionSetProperty is unmodifiable");
    }

    @Override
    protected void doUpdateSet(S source, SetDiff<E> diff) {
        throw new UnsupportedOperationException("UnionSetProperty is unmodifiable");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public IObservableSet<E> observe(Realm realm, S source) {
        void var5_8;
        HashSet<IObservableSet<E>> sets = new HashSet<IObservableSet<E>>(this.properties.length);
        ISetProperty<S, E>[] iSetPropertyArray = this.properties;
        int n = this.properties.length;
        boolean n2 = false;
        while (var5_8 < n) {
            ISetProperty<S, E> property = iSetPropertyArray[var5_8];
            sets.add(property.observe(realm, source));
            ++var5_8;
        }
        UnionSet unionSet = new UnionSet(sets, this.elementType);
        for (IObservableSet iObservableSet : sets) {
            PropertyObservableUtil.cascadeDispose((IObservable)unionSet, (IObservable)iObservableSet);
        }
        return unionSet;
    }
}

