/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.databinding.property;

import java.util.Map;
import org.eclipse.core.databinding.observable.ObservableTracker;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.map.MapDiff;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.property.map.IMapProperty;
import org.eclipse.core.databinding.property.map.MapProperty;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.core.internal.databinding.identity.IdentityMap;
import org.eclipse.core.internal.databinding.property.PropertyObservableUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapPropertyDetailValuesMap<S, K, V, T>
extends MapProperty<S, K, T> {
    private final IMapProperty<S, K, V> masterProperty;
    private final IValueProperty<? super V, T> detailProperty;

    public MapPropertyDetailValuesMap(IMapProperty<S, K, V> masterProperty, IValueProperty<? super V, T> detailProperty) {
        this.masterProperty = masterProperty;
        this.detailProperty = detailProperty;
    }

    @Override
    public Object getKeyType() {
        return this.masterProperty.getKeyType();
    }

    @Override
    public Object getValueType() {
        return this.detailProperty.getValueType();
    }

    @Override
    protected Map<K, T> doGetMap(S source) {
        Map<K, V> masterMap = this.masterProperty.getMap(source);
        IdentityMap detailMap = new IdentityMap();
        for (Map.Entry<K, V> entry : masterMap.entrySet()) {
            detailMap.put(entry.getKey(), this.detailProperty.getValue(entry.getValue()));
        }
        return detailMap;
    }

    @Override
    protected void doUpdateMap(S source, MapDiff<K, T> diff) {
        if (!diff.getAddedKeys().isEmpty()) {
            throw new UnsupportedOperationException(String.valueOf(this.toString()) + " does not support entry additions");
        }
        if (!diff.getRemovedKeys().isEmpty()) {
            throw new UnsupportedOperationException(String.valueOf(this.toString()) + " does not support entry removals");
        }
        Map<K, V> masterMap = this.masterProperty.getMap(source);
        for (Object key : diff.getChangedKeys()) {
            V masterValue = masterMap.get(key);
            this.detailProperty.setValue(masterValue, diff.getNewValue(key));
        }
    }

    @Override
    public IObservableMap<K, T> observe(Realm realm, S source) {
        IObservableMap<K, V> masterMap;
        ObservableTracker.setIgnore((boolean)true);
        try {
            masterMap = this.masterProperty.observe(realm, source);
        }
        finally {
            ObservableTracker.setIgnore((boolean)false);
        }
        IObservableMap<K, T> detailMap = this.detailProperty.observeDetail(masterMap);
        PropertyObservableUtil.cascadeDispose(detailMap, masterMap);
        return detailMap;
    }

    @Override
    public <U extends S> IObservableMap<K, T> observeDetail(IObservableValue<U> master) {
        IObservableMap<K, V> masterMap;
        ObservableTracker.setIgnore((boolean)true);
        try {
            masterMap = this.masterProperty.observeDetail(master);
        }
        finally {
            ObservableTracker.setIgnore((boolean)false);
        }
        IObservableMap<K, T> detailMap = this.detailProperty.observeDetail(masterMap);
        PropertyObservableUtil.cascadeDispose(detailMap, masterMap);
        return detailMap;
    }

    public String toString() {
        return this.masterProperty + " => " + this.detailProperty;
    }
}

