/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.databinding;

import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.ListBinding;
import org.eclipse.core.databinding.SetBinding;
import org.eclipse.core.databinding.UpdateListStrategy;
import org.eclipse.core.databinding.UpdateSetStrategy;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.ValueBinding;
import org.eclipse.core.databinding.observable.ObservableTracker;
import org.eclipse.core.databinding.observable.Observables;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.internal.databinding.ValidationStatusMap;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataBindingContext {
    private WritableList<Binding<?, ?>> bindings;
    private WritableList<ValidationStatusProvider> validationStatusProviders;
    private IObservableList<Binding<?, ?>> unmodifiableBindings;
    private IObservableList<ValidationStatusProvider> unmodifiableStatusProviders;
    private IObservableMap<Binding<?, ?>, IStatus> validationStatusMap;
    private Realm validationRealm;

    public DataBindingContext() {
        this(Realm.getDefault());
    }

    public DataBindingContext(Realm validationRealm) {
        Assert.isNotNull((Object)validationRealm, (String)"Validation realm cannot be null");
        this.validationRealm = validationRealm;
        ObservableTracker.setIgnore((boolean)true);
        try {
            this.bindings = new WritableList(validationRealm);
            this.unmodifiableBindings = Observables.unmodifiableObservableList(this.bindings);
            this.validationStatusProviders = new WritableList(validationRealm);
            this.unmodifiableStatusProviders = Observables.unmodifiableObservableList(this.validationStatusProviders);
            this.validationStatusMap = new ValidationStatusMap(validationRealm, this.bindings);
        }
        finally {
            ObservableTracker.setIgnore((boolean)false);
        }
    }

    public final <T> Binding<?, ?> bindValue(IObservableValue<T> targetObservableValue, IObservableValue<T> modelObservableValue) {
        return this.bindValue(targetObservableValue, modelObservableValue, null, null);
    }

    public final <M, T> Binding<?, ?> bindValue(IObservableValue<T> targetObservableValue, IObservableValue<M> modelObservableValue, UpdateValueStrategy<T, M> targetToModel, UpdateValueStrategy<M, T> modelToTarget) {
        UpdateValueStrategy<T, M> targetToModelStrategy = targetToModel != null ? targetToModel : this.createTargetToModelUpdateValueStrategy(targetObservableValue, modelObservableValue);
        UpdateValueStrategy<M, T> modelToTargetStrategy = modelToTarget != null ? modelToTarget : this.createModelToTargetUpdateValueStrategy(modelObservableValue, targetObservableValue);
        targetToModelStrategy.fillDefaults(targetObservableValue, modelObservableValue);
        modelToTargetStrategy.fillDefaults(modelObservableValue, targetObservableValue);
        ValueBinding<M, T> result = new ValueBinding<M, T>(targetObservableValue, modelObservableValue, targetToModelStrategy, modelToTargetStrategy);
        result.init(this);
        return result;
    }

    protected <M, T> UpdateValueStrategy<M, T> createModelToTargetUpdateValueStrategy(IObservableValue<M> fromValue, IObservableValue<T> toValue) {
        return new UpdateValueStrategy();
    }

    protected <M, T> UpdateValueStrategy<T, M> createTargetToModelUpdateValueStrategy(IObservableValue<T> fromValue, IObservableValue<M> toValue) {
        return new UpdateValueStrategy();
    }

    public final <E> Binding<?, ?> bindList(IObservableList<E> targetObservableList, IObservableList<E> modelObservableList) {
        return this.bindList(targetObservableList, modelObservableList, null, null);
    }

    public final <M, T> Binding<?, ?> bindList(IObservableList<T> targetObservableList, IObservableList<M> modelObservableList, UpdateListStrategy<T, M> targetToModel, UpdateListStrategy<M, T> modelToTarget) {
        UpdateListStrategy<T, M> targetToModelStrategy = targetToModel != null ? targetToModel : this.createTargetToModelUpdateListStrategy(targetObservableList, modelObservableList);
        UpdateListStrategy<M, T> modelToTargetStrategy = modelToTarget != null ? modelToTarget : this.createModelToTargetUpdateListStrategy(modelObservableList, targetObservableList);
        targetToModelStrategy.fillDefaults(targetObservableList, modelObservableList);
        modelToTargetStrategy.fillDefaults(modelObservableList, targetObservableList);
        ListBinding<M, T> result = new ListBinding<M, T>(targetObservableList, modelObservableList, targetToModelStrategy, modelToTargetStrategy);
        result.init(this);
        return result;
    }

    protected <M, T> UpdateListStrategy<M, T> createModelToTargetUpdateListStrategy(IObservableList<M> modelObservableList, IObservableList<T> targetObservableList) {
        return new UpdateListStrategy();
    }

    protected <M, T> UpdateListStrategy<T, M> createTargetToModelUpdateListStrategy(IObservableList<T> targetObservableList, IObservableList<M> modelObservableList) {
        return new UpdateListStrategy();
    }

    public final <E> Binding<?, ?> bindSet(IObservableSet<E> targetObservableSet, IObservableSet<E> modelObservableSet) {
        return this.bindSet(targetObservableSet, modelObservableSet, null, null);
    }

    public final <M, T> Binding<IObservableSet<M>, IObservableSet<T>> bindSet(IObservableSet<T> targetObservableSet, IObservableSet<M> modelObservableSet, UpdateSetStrategy<T, M> targetToModel, UpdateSetStrategy<M, T> modelToTarget) {
        if (targetToModel == null) {
            targetToModel = this.createTargetToModelUpdateSetStrategy(targetObservableSet, modelObservableSet);
        }
        if (modelToTarget == null) {
            modelToTarget = this.createModelToTargetUpdateSetStrategy(modelObservableSet, targetObservableSet);
        }
        targetToModel.fillDefaults(targetObservableSet, modelObservableSet);
        modelToTarget.fillDefaults(modelObservableSet, targetObservableSet);
        SetBinding<M, T> result = new SetBinding<M, T>(targetObservableSet, modelObservableSet, targetToModel, modelToTarget);
        result.init(this);
        return result;
    }

    protected <M, T> UpdateSetStrategy<T, M> createTargetToModelUpdateSetStrategy(IObservableSet<T> targetObservableSet, IObservableSet<M> modelObservableSet) {
        return new UpdateSetStrategy();
    }

    protected <M, T> UpdateSetStrategy<M, T> createModelToTargetUpdateSetStrategy(IObservableSet<M> modelObservableSet, IObservableSet<T> targetObservableSet) {
        return new UpdateSetStrategy();
    }

    public final void dispose() {
        Binding[] bindingArray = (Binding[])this.bindings.toArray((Object[])new Binding[this.bindings.size()]);
        int i = 0;
        while (i < bindingArray.length) {
            bindingArray[i].dispose();
            ++i;
        }
        ValidationStatusProvider[] statusProviderArray = (ValidationStatusProvider[])this.validationStatusProviders.toArray((Object[])new ValidationStatusProvider[this.validationStatusProviders.size()]);
        int i2 = 0;
        while (i2 < statusProviderArray.length) {
            if (!statusProviderArray[i2].isDisposed()) {
                statusProviderArray[i2].dispose();
            }
            ++i2;
        }
    }

    public final IObservableList<Binding<?, ?>> getBindings() {
        return this.unmodifiableBindings;
    }

    public final IObservableList<ValidationStatusProvider> getValidationStatusProviders() {
        return this.unmodifiableStatusProviders;
    }

    public final IObservableMap<Binding<?, ?>, IStatus> getValidationStatusMap() {
        return this.validationStatusMap;
    }

    public void addBinding(Binding<?, ?> binding) {
        this.addValidationStatusProvider(binding);
        this.bindings.add(binding);
    }

    public void addValidationStatusProvider(ValidationStatusProvider validationStatusProvider) {
        this.validationStatusProviders.add((Object)validationStatusProvider);
    }

    public final void updateModels() {
        for (Binding binding : this.bindings) {
            binding.updateTargetToModel();
        }
    }

    public final void updateTargets() {
        for (Binding binding : this.bindings) {
            binding.updateModelToTarget();
        }
    }

    public boolean removeBinding(Binding<?, ?> binding) {
        return this.bindings.remove(binding) && this.removeValidationStatusProvider(binding);
    }

    public boolean removeValidationStatusProvider(ValidationStatusProvider validationStatusProvider) {
        return this.validationStatusProviders.remove((Object)validationStatusProvider);
    }

    public final Realm getValidationRealm() {
        return this.validationRealm;
    }
}

