/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.languages.javascript.test;

import java.util.HashMap;
import junit.framework.TestCase;
import org.eclipse.e4.internal.languages.javascript.JSBundleData;
import org.eclipse.e4.internal.languages.javascript.JSBundleImpl;
import org.eclipse.e4.internal.languages.javascript.JSExportPackage;
import org.eclipse.e4.internal.languages.javascript.JSFrameworkImpl;
import org.eclipse.e4.internal.languages.javascript.JSImportPackage;
import org.eclipse.e4.internal.languages.javascript.JSRequireBundle;
import org.eclipse.e4.languages.javascript.JSBundleException;
import org.osgi.framework.Version;

public class JSBundleTest
extends TestCase {
    public JSBundleTest(String name) {
        super(name);
    }

    public void testNullHeaders() {
        JSFrameworkImpl framework = new JSFrameworkImpl();
        try {
            new JSBundleImpl(framework, null);
        }
        catch (NullPointerException nullPointerException) {
            return;
        }
        JSBundleTest.fail();
    }

    public void testNameAndEmptyVersion() throws JSBundleException {
        JSFrameworkImpl framework = new JSFrameworkImpl();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Bundle-SymbolicName", "test");
        JSBundleData data = new JSBundleData(0, "testloc", headers, null);
        JSBundleImpl jsBundle = new JSBundleImpl(framework, data);
        JSBundleTest.assertEquals((String)"test", (String)jsBundle.getSymbolicName());
        JSBundleTest.assertEquals((Object)Version.emptyVersion, (Object)jsBundle.getVersion());
    }

    public void testNameAndVersion() throws JSBundleException {
        JSFrameworkImpl framework = new JSFrameworkImpl();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Bundle-SymbolicName", "test");
        headers.put("Bundle-Version", "1.8");
        JSBundleData data = new JSBundleData(0, "testloc", headers, null);
        JSBundleImpl jsBundle = new JSBundleImpl(framework, data);
        JSBundleTest.assertEquals((String)"test", (String)jsBundle.getSymbolicName());
        JSBundleTest.assertEquals((Object)Version.parseVersion((String)"1.8"), (Object)jsBundle.getVersion());
    }

    public void testNoExportsImportsRequires() throws JSBundleException {
        JSFrameworkImpl framework = new JSFrameworkImpl();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Bundle-SymbolicName", "test");
        headers.put("Bundle-Version", "1.8");
        JSBundleData data = new JSBundleData(0, "testloc", headers, null);
        JSBundleImpl jsBundle = new JSBundleImpl(framework, data);
        JSBundleTest.assertEquals((String)"test", (String)jsBundle.getSymbolicName());
        JSBundleTest.assertEquals((Object)Version.parseVersion((String)"1.8"), (Object)jsBundle.getVersion());
        JSBundleTest.assertEquals((int)0, (int)jsBundle.getExports().size());
        JSBundleTest.assertEquals((int)0, (int)jsBundle.getImports().size());
        JSBundleTest.assertEquals((int)0, (int)jsBundle.getRequires().size());
    }

    public void testOneExportsImportsRequires() throws JSBundleException {
        JSFrameworkImpl framework = new JSFrameworkImpl();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Bundle-SymbolicName", "test");
        headers.put("Bundle-Version", "1.8");
        headers.put("Export-Package", "a.a");
        headers.put("Import-Package", "c.c");
        headers.put("Require-Bundle", "test1");
        JSBundleData data = new JSBundleData(0, "testloc", headers, null);
        JSBundleImpl jsBundle = new JSBundleImpl(framework, data);
        JSBundleTest.assertEquals((String)"test", (String)jsBundle.getSymbolicName());
        JSBundleTest.assertEquals((Object)Version.parseVersion((String)"1.8"), (Object)jsBundle.getVersion());
        JSBundleTest.assertEquals((int)1, (int)jsBundle.getExports().size());
        JSBundleTest.assertEquals((String)"a.a", (String)((JSExportPackage)jsBundle.getExports().get(0)).getName());
        JSBundleTest.assertEquals((int)1, (int)jsBundle.getImports().size());
        JSBundleTest.assertEquals((String)"c.c", (String)((JSImportPackage)jsBundle.getImports().get(0)).getName());
        JSBundleTest.assertEquals((int)1, (int)jsBundle.getRequires().size());
        JSBundleTest.assertEquals((String)"test1", (String)((JSRequireBundle)jsBundle.getRequires().get(0)).getName());
    }

    public void testTwoExportsImportsRequires() throws JSBundleException {
        JSFrameworkImpl framework = new JSFrameworkImpl();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Bundle-SymbolicName", "test");
        headers.put("Bundle-Version", "1.8");
        headers.put("Export-Package", "a.a, b.b");
        headers.put("Import-Package", "c.c, d.d");
        headers.put("Require-Bundle", "test1, test2");
        JSBundleData data = new JSBundleData(0, "testloc", headers, null);
        JSBundleImpl jsBundle = new JSBundleImpl(framework, data);
        JSBundleTest.assertEquals((String)"test", (String)jsBundle.getSymbolicName());
        JSBundleTest.assertEquals((Object)Version.parseVersion((String)"1.8"), (Object)jsBundle.getVersion());
        JSBundleTest.assertEquals((int)2, (int)jsBundle.getExports().size());
        JSBundleTest.assertEquals((String)"a.a", (String)((JSExportPackage)jsBundle.getExports().get(0)).getName());
        JSBundleTest.assertEquals((String)"b.b", (String)((JSExportPackage)jsBundle.getExports().get(1)).getName());
        JSBundleTest.assertEquals((int)2, (int)jsBundle.getImports().size());
        JSBundleTest.assertEquals((String)"c.c", (String)((JSImportPackage)jsBundle.getImports().get(0)).getName());
        JSBundleTest.assertEquals((String)"d.d", (String)((JSImportPackage)jsBundle.getImports().get(1)).getName());
        JSBundleTest.assertEquals((int)2, (int)jsBundle.getRequires().size());
        JSBundleTest.assertEquals((String)"test1", (String)((JSRequireBundle)jsBundle.getRequires().get(0)).getName());
        JSBundleTest.assertEquals((String)"test2", (String)((JSRequireBundle)jsBundle.getRequires().get(1)).getName());
    }
}

