/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.emf.ui.internal.common;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.core.databinding.ObservablesManager;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.map.IMapChangeListener;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.map.MapChangeEvent;
import org.eclipse.core.databinding.observable.masterdetail.IObservableFactory;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.set.ISetChangeListener;
import org.eclipse.core.databinding.observable.set.SetChangeEvent;
import org.eclipse.core.databinding.observable.set.WritableSet;
import org.eclipse.core.databinding.property.list.IListProperty;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.di.extensions.Preference;
import org.eclipse.e4.core.services.contributions.IContributionFactory;
import org.eclipse.e4.internal.tools.wizards.model.ExtractContributionModelWizard;
import org.eclipse.e4.tools.emf.ui.common.EStackLayout;
import org.eclipse.e4.tools.emf.ui.common.IContributionClassCreator;
import org.eclipse.e4.tools.emf.ui.common.IEditorDescriptor;
import org.eclipse.e4.tools.emf.ui.common.IEditorFeature;
import org.eclipse.e4.tools.emf.ui.common.IExtensionLookup;
import org.eclipse.e4.tools.emf.ui.common.IModelResource;
import org.eclipse.e4.tools.emf.ui.common.IScriptingSupport;
import org.eclipse.e4.tools.emf.ui.common.ISelectionProviderService;
import org.eclipse.e4.tools.emf.ui.common.MemoryTransfer;
import org.eclipse.e4.tools.emf.ui.common.Util;
import org.eclipse.e4.tools.emf.ui.common.component.AbstractComponentEditor;
import org.eclipse.e4.tools.emf.ui.internal.Messages;
import org.eclipse.e4.tools.emf.ui.internal.ShadowComposite;
import org.eclipse.e4.tools.emf.ui.internal.common.ComponentLabelProvider;
import org.eclipse.e4.tools.emf.ui.internal.common.ControlHighlighter;
import org.eclipse.e4.tools.emf.ui.internal.common.VirtualEntry;
import org.eclipse.e4.tools.emf.ui.internal.common.component.AddonsEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.ApplicationEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.AreaEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.BindingContextEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.BindingTableEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.CategoryEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.CommandEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.CommandParameterEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.CoreExpressionEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.DefaultEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.DirectMenuItemEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.DirectToolItemEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.DynamicMenuContributionEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.HandledMenuItemEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.HandledToolItemEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.HandlerEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.InputPartEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.KeyBindingEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.MenuContributionEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.MenuEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.MenuSeparatorEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.ModelFragmentsEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.ParameterEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.PartDescriptorEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.PartEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.PartSashContainerEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.PartStackEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.PerspectiveEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.PerspectiveStackEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.PlaceholderEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.PopupMenuEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.RenderedMenuEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.RenderedMenuItem;
import org.eclipse.e4.tools.emf.ui.internal.common.component.RenderedToolBarEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.StringModelFragment;
import org.eclipse.e4.tools.emf.ui.internal.common.component.ToolBarContributionEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.ToolBarEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.ToolBarSeparatorEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.ToolControlEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.TrimBarEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.TrimContributionEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.TrimmedWindowEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.WindowEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.virtual.VApplicationAddons;
import org.eclipse.e4.tools.emf.ui.internal.common.component.virtual.VApplicationCategoriesEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.virtual.VApplicationWindowEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.virtual.VBindingTableEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.virtual.VCommandEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.virtual.VHandlerEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.virtual.VItemParametersEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.virtual.VMenuContributionsEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.virtual.VModelFragmentsEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.virtual.VModelImportsEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.virtual.VPartDescriptor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.virtual.VPartDescriptorMenuEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.virtual.VPartMenuEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.virtual.VPerspectiveControlEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.virtual.VPerspectiveWindowsEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.virtual.VRootBindingContexts;
import org.eclipse.e4.tools.emf.ui.internal.common.component.virtual.VSnippetsEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.virtual.VToolBarContributionsEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.virtual.VTrimContributionsEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.virtual.VWindowControlEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.virtual.VWindowSharedElementsEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.virtual.VWindowTrimEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.virtual.VWindowWindowsEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.properties.ExternalizeStringHandler;
import org.eclipse.e4.tools.emf.ui.internal.common.properties.ProjectOSGiTranslationProvider;
import org.eclipse.e4.tools.emf.ui.internal.common.xml.AnnotationAccess;
import org.eclipse.e4.tools.emf.ui.internal.common.xml.EMFDocumentResourceMediator;
import org.eclipse.e4.tools.emf.ui.internal.common.xml.XMLConfiguration;
import org.eclipse.e4.tools.emf.ui.internal.common.xml.XMLPartitionScanner;
import org.eclipse.e4.tools.services.IClipboardService;
import org.eclipse.e4.tools.services.IResourcePool;
import org.eclipse.e4.tools.services.Translation;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.di.Persist;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.commands.impl.CommandsPackageImpl;
import org.eclipse.e4.ui.model.application.descriptor.basic.impl.BasicPackageImpl;
import org.eclipse.e4.ui.model.application.impl.ApplicationPackageImpl;
import org.eclipse.e4.ui.model.application.ui.MContext;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.impl.AdvancedPackageImpl;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.impl.BasicPackageImpl;
import org.eclipse.e4.ui.model.application.ui.impl.UiPackageImpl;
import org.eclipse.e4.ui.model.application.ui.menu.impl.MenuPackageImpl;
import org.eclipse.e4.ui.model.fragment.MModelFragments;
import org.eclipse.e4.ui.model.fragment.impl.FragmentPackageImpl;
import org.eclipse.e4.ui.model.internal.ModelUtils;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.databinding.EMFProperties;
import org.eclipse.emf.databinding.FeaturePath;
import org.eclipse.emf.databinding.IEMFProperty;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EGenericType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.DeleteCommand;
import org.eclipse.emf.edit.command.MoveCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.databinding.viewers.ObservableListTreeContentProvider;
import org.eclipse.jface.databinding.viewers.TreeStructureAdvisor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.jface.text.source.IAnnotationAccess;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.source.VerticalRuler;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TreeAdapter;
import org.eclipse.swt.events.TreeEvent;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelEditor {
    public static final String CSS_CLASS_KEY = "org.eclipse.e4.ui.css.CssClassName";
    public static final String VIRTUAL_PART_MENU = String.valueOf(ModelEditor.class.getName()) + ".VIRTUAL_PART_MENU";
    public static final String VIRTUAL_HANDLER = String.valueOf(ModelEditor.class.getName()) + ".VIRTUAL_HANDLER";
    public static final String VIRTUAL_BINDING_TABLE = String.valueOf(ModelEditor.class.getName()) + ".VIRTUAL_BINDING_TABLE";
    public static final String VIRTUAL_COMMAND = String.valueOf(ModelEditor.class.getName()) + ".VIRTUAL_COMMAND";
    public static final String VIRTUAL_APPLICATION_WINDOWS = String.valueOf(ModelEditor.class.getName()) + ".VIRTUAL_APPLICATION_WINDOWS";
    public static final String VIRTUAL_PERSPECTIVE_WINDOWS = String.valueOf(ModelEditor.class.getName()) + ".VIRTUAL_PERSPECTIVE_WINDOWS";
    public static final String VIRTUAL_WINDOW_WINDOWS = String.valueOf(ModelEditor.class.getName()) + ".VIRTUAL_WINDOW_WINDOWS";
    public static final String VIRTUAL_WINDOW_CONTROLS = String.valueOf(ModelEditor.class.getName()) + ".VIRTUAL_WINDOW_CONTROLS";
    public static final String VIRTUAL_PART_DESCRIPTORS = String.valueOf(ModelEditor.class.getName()) + ".VIRTUAL_PART_DESCRIPTORS";
    public static final String VIRTUAL_PARTDESCRIPTOR_MENU = String.valueOf(ModelEditor.class.getName()) + ".VIRTUAL_PARTDESCRIPTOR_MENU";
    public static final String VIRTUAL_TRIMMED_WINDOW_TRIMS = String.valueOf(ModelEditor.class.getName()) + ".VIRTUAL_TRIMMED_WINDOW_TRIMS";
    public static final String VIRTUAL_ADDONS = String.valueOf(ModelEditor.class.getName()) + ".VIRTUAL_ADDONS";
    public static final String VIRTUAL_MENU_CONTRIBUTIONS = String.valueOf(ModelEditor.class.getName()) + ".VIRTUAL_MENU_CONTRIBUTIONS";
    public static final String VIRTUAL_TOOLBAR_CONTRIBUTIONS = String.valueOf(ModelEditor.class.getName()) + ".VIRTUAL_TOOLBAR_CONTRIBUTIONS";
    public static final String VIRTUAL_TRIM_CONTRIBUTIONS = String.valueOf(ModelEditor.class.getName()) + ".VIRTUAL_TRIM_CONTRIBUTIONS";
    public static final String VIRTUAL_WINDOW_SHARED_ELEMENTS = String.valueOf(ModelEditor.class.getName()) + ".VIRTUAL_WINDOW_SHARED_ELEMENTS";
    public static final String VIRTUAL_MODEL_FRAGEMENTS = String.valueOf(ModelEditor.class.getName()) + ".VIRTUAL_MODEL_FRAGEMENTS";
    public static final String VIRTUAL_MODEL_IMPORTS = String.valueOf(ModelEditor.class.getName()) + ".VIRTUAL_MODEL_IMPORTS";
    public static final String VIRTUAL_CATEGORIES = String.valueOf(ModelEditor.class.getName()) + ".VIRTUAL_CATEGORIES";
    public static final String VIRTUAL_PARAMETERS = String.valueOf(ModelEditor.class.getName()) + ".VIRTUAL_PARAMETERS";
    public static final String VIRTUAL_MENUELEMENTS = String.valueOf(ModelEditor.class.getName()) + ".VIRTUAL_MENUELEMENTS";
    public static final String VIRTUAL_ROOT_CONTEXTS = String.valueOf(ModelEditor.class.getName()) + ".VIRTUAL_ROOT_CONTEXTS";
    public static final String VIRTUAL_PERSPECTIVE_CONTROLS = String.valueOf(ModelEditor.class.getName()) + "VIRTUAL_PERSPECTIVE_CONTROLS";
    public static final String VIRTUAL_SNIPPETS = String.valueOf(ModelEditor.class.getName()) + "VIRTUAL_SNIPPETS";
    private static final int VERTICAL_RULER_WIDTH = 20;
    private Map<EClass, AbstractComponentEditor> editorMap = new HashMap<EClass, AbstractComponentEditor>();
    private Map<String, AbstractComponentEditor> virtualEditors = new HashMap<String, AbstractComponentEditor>();
    private List<FeaturePath> labelFeaturePaths = new ArrayList<FeaturePath>();
    private List<IEditorFeature> editorFeatures = new ArrayList<IEditorFeature>();
    private List<IContributionClassCreator> contributionCreator = new ArrayList<IContributionClassCreator>();
    private TreeViewer viewer;
    private IModelResource modelProvider;
    private IProject project;
    private ISelectionProviderService selectionService;
    private IEclipseContext context;
    private boolean fragment;
    private IClipboardService.Handler clipboardHandler;
    @Inject
    @Optional
    private IClipboardService clipboardService;
    @Inject
    @Preference(nodePath="org.eclipse.e4.tools.emf.ui", value="autoCreateElementId")
    private boolean autoCreateElementId;
    @Inject
    @Preference(nodePath="org.eclipse.e4.tools.emf.ui", value="showXMIId")
    private boolean showXMIId;
    @Inject
    @Optional
    private IExtensionLookup extensionLookup;
    @Inject
    @Translation
    private Messages messages;
    private ObservablesManager obsManager;
    private final IResourcePool resourcePool;
    private EMFDocumentResourceMediator emfDocumentProvider;
    private AbstractComponentEditor currentEditor;
    private Listener keyListener;
    private CTabFolder editorTabFolder;
    private SourceViewer sourceViewer;
    private boolean mod1Down = false;
    private boolean saving;

    public ModelEditor(Composite composite, IEclipseContext context, IModelResource modelProvider, IProject project, IResourcePool resourcePool) {
        this.resourcePool = resourcePool;
        this.modelProvider = modelProvider;
        this.project = project;
        this.context = context;
        this.context.set(ModelEditor.class, (Object)this);
        this.obsManager = new ObservablesManager();
        if (project != null) {
            ProjectOSGiTranslationProvider translationProvider = new ProjectOSGiTranslationProvider(project){

                protected void clearCache() {
                    super.clearCache();
                    ModelEditor.this.viewer.getControl().getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            ModelEditor.this.viewer.refresh();
                        }
                    });
                }
            };
            context.set(ProjectOSGiTranslationProvider.class, (Object)translationProvider);
        }
        this.labelFeaturePaths.add(FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{UiPackageImpl.Literals.UI_ELEMENT__TO_BE_RENDERED}));
        this.labelFeaturePaths.add(FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{UiPackageImpl.Literals.UI_ELEMENT__VISIBLE}));
    }

    @PostConstruct
    void postCreate(Composite composite) {
        if (this.project == null) {
            this.keyListener = new Listener(){

                public void handleEvent(Event event) {
                    if ((event.stateMask & 0x10000) == 65536) {
                        ModelEditor.this.findAndHighlight(((Display)ModelEditor.this.context.get(Display.class)).getFocusControl());
                    }
                }
            };
            ((Display)this.context.get(Display.class)).addFilter(4, this.keyListener);
        }
        this.context.set(ModelEditor.class, (Object)this);
        this.context.set(IResourcePool.class, (Object)this.resourcePool);
        this.context.set(EditingDomain.class, (Object)this.modelProvider.getEditingDomain());
        this.context.set(IModelResource.class, (Object)this.modelProvider);
        if (this.project != null) {
            this.context.set(IProject.class, (Object)this.project);
        }
        this.registerDefaultEditors();
        this.registerVirtualEditors();
        this.registerContributedEditors();
        this.registerContributedVirtualEditors();
        this.loadEditorFeatures();
        this.loadContributionCreators();
        this.fragment = this.modelProvider.getRoot().get(0) instanceof MModelFragments;
        this.editorTabFolder = new CTabFolder(composite, 1024);
        CTabItem item = new CTabItem(this.editorTabFolder, 0);
        item.setText(this.messages.ModelEditor_Form);
        item.setControl((Control)this.createFormTab((Composite)this.editorTabFolder));
        item.setImage(this.resourcePool.getImageUnchecked("IMG_org.eclipse.e4.tools.emf.ui.obj16.application_form"));
        this.emfDocumentProvider = new EMFDocumentResourceMediator(this.modelProvider);
        item = new CTabItem(this.editorTabFolder, 0);
        item.setText(this.messages.ModelEditor_XMI);
        item.setControl(this.createXMITab((Composite)this.editorTabFolder));
        item.setImage(this.resourcePool.getImageUnchecked("IMG_org.eclipse.e4.tools.emf.ui.obj16.chart_organisation"));
        this.editorTabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ModelEditor.this.editorTabFolder.getSelectionIndex() == 1) {
                    ModelEditor.this.emfDocumentProvider.updateFromEMF();
                }
            }
        });
        this.editorTabFolder.setSelection(0);
    }

    private void findAndHighlight(Control control) {
        if (control != null) {
            MApplicationElement m;
            MApplicationElement o = m = this.findModelElement(control);
            if (m != null) {
                ArrayList<MApplicationElement> l = new ArrayList<MApplicationElement>();
                do {
                    l.add(m);
                } while ((m = (MApplicationElement)((EObject)m).eContainer()) != null);
                if (o instanceof MPart) {
                    System.err.println(String.valueOf(this.getClass().getName()) + ".findAndHighLight: " + o);
                    System.err.println(String.valueOf(this.getClass().getName()) + ".findAndHighLight: " + ((EObject)o).eContainingFeature());
                }
                this.viewer.setSelection((ISelection)new StructuredSelection((Object)o));
            }
        }
    }

    private MApplicationElement findModelElement(Control control) {
        do {
            if (control.getData("modelElement") == null) continue;
            return (MApplicationElement)control.getData("modelElement");
        } while ((control = control.getParent()) != null);
        return null;
    }

    private Control createXMITab(Composite composite) {
        final AnnotationModel model = new AnnotationModel();
        VerticalRuler verticalRuler = new VerticalRuler(20, (IAnnotationAccess)new AnnotationAccess(this.resourcePool));
        int styles = 68354;
        this.sourceViewer = new SourceViewer(composite, (IVerticalRuler)verticalRuler, styles);
        this.sourceViewer.configure((SourceViewerConfiguration)new XMLConfiguration(this.resourcePool));
        this.sourceViewer.setEditable(this.project != null);
        this.sourceViewer.getTextWidget().setFont(JFaceResources.getTextFont());
        Document document = this.emfDocumentProvider.getDocument();
        FastPartitioner partitioner = new FastPartitioner((IPartitionTokenScanner)new XMLPartitionScanner(), new String[]{"__xml_tag", "__xml_comment"});
        partitioner.connect((IDocument)document);
        document.setDocumentPartitioner((IDocumentPartitioner)partitioner);
        this.sourceViewer.setDocument((IDocument)document);
        verticalRuler.setModel((IAnnotationModel)model);
        this.emfDocumentProvider.setValidationChangedCallback(new Runnable((IDocument)document){
            private final /* synthetic */ IDocument val$document;
            {
                this.val$document = iDocument;
            }

            public void run() {
                model.removeAllAnnotations();
                for (Resource.Diagnostic d : ModelEditor.this.emfDocumentProvider.getErrorList()) {
                    Annotation a = new Annotation("e4xmi.error", false, d.getMessage());
                    try {
                        int l = this.val$document.getLineOffset(d.getLine() - 1);
                        model.addAnnotation(a, new Position(l));
                    }
                    catch (BadLocationException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
        return this.sourceViewer.getControl();
    }

    private Composite createFormTab(Composite composite) {
        SashForm form = new SashForm(composite, 256);
        form.setBackground(form.getDisplay().getSystemColor(1));
        this.viewer = this.createTreeViewerArea((Composite)form);
        Composite parent = new Composite((Composite)form, 0);
        parent.setBackground(parent.getDisplay().getSystemColor(1));
        parent.setBackgroundMode(1);
        FillLayout l = new FillLayout();
        l.marginWidth = 5;
        parent.setLayout((Layout)l);
        ShadowComposite editingArea = new ShadowComposite(parent, 0);
        GridLayout gl = new GridLayout();
        gl.marginTop = 0;
        gl.marginHeight = 0;
        editingArea.setLayout((Layout)gl);
        editingArea.setBackgroundMode(1);
        Composite headerContainer = new Composite((Composite)editingArea, 0);
        headerContainer.setBackgroundMode(1);
        headerContainer.setData(CSS_CLASS_KEY, (Object)"headerSectionContainer");
        headerContainer.setLayout((Layout)new GridLayout(3, false));
        headerContainer.setLayoutData((Object)new GridData(768));
        final Label iconLabel = new Label(headerContainer, 0);
        iconLabel.setLayoutData((Object)new GridData(20, 20));
        final Label textLabel = new Label(headerContainer, 0);
        textLabel.setData(CSS_CLASS_KEY, (Object)"sectionHeader");
        textLabel.setLayoutData((Object)new GridData(768));
        final EStackLayout layout = new EStackLayout();
        final Composite contentContainer = new Composite((Composite)editingArea, 0);
        contentContainer.setLayoutData((Object)new GridData(1808));
        contentContainer.setLayout((Layout)layout);
        this.viewer.getTree().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                IStructuredSelection selection;
                if (e.keyCode == 127 && (selection = (IStructuredSelection)ModelEditor.this.viewer.getSelection()).getFirstElement() instanceof EObject) {
                    EObject o = (EObject)selection.getFirstElement();
                    Command cmd = DeleteCommand.create((EditingDomain)ModelEditor.this.modelProvider.getEditingDomain(), (Object)o);
                    if (cmd.canExecute()) {
                        ModelEditor.this.modelProvider.getEditingDomain().getCommandStack().execute(cmd);
                    }
                }
            }
        });
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (!event.getSelection().isEmpty()) {
                    final IStructuredSelection s = (IStructuredSelection)event.getSelection();
                    if (s.getFirstElement() instanceof EObject) {
                        EObject obj = (EObject)s.getFirstElement();
                        final AbstractComponentEditor editor = ModelEditor.this.getEditor(obj.eClass());
                        if (editor != null) {
                            ModelEditor.this.currentEditor = editor;
                            textLabel.setText(editor.getLabel(obj));
                            iconLabel.setImage(editor.getImage(obj, iconLabel.getDisplay()));
                            ModelEditor.this.obsManager.runAndCollect(new Runnable(){

                                public void run() {
                                    Composite comp = editor.getEditor(contentContainer, s.getFirstElement());
                                    comp.setBackgroundMode(1);
                                    layout.topControl = comp;
                                    contentContainer.layout(true);
                                }
                            });
                        }
                    } else {
                        VirtualEntry entry = (VirtualEntry)s.getFirstElement();
                        final AbstractComponentEditor editor = (AbstractComponentEditor)ModelEditor.this.virtualEditors.get(entry.getId());
                        if (editor != null) {
                            ModelEditor.this.currentEditor = editor;
                            textLabel.setText(editor.getLabel(entry));
                            iconLabel.setImage(editor.getImage(entry, iconLabel.getDisplay()));
                            ModelEditor.this.obsManager.runAndCollect(new Runnable(){

                                public void run() {
                                    Composite comp = editor.getEditor(contentContainer, s.getFirstElement());
                                    comp.setBackgroundMode(1);
                                    layout.topControl = comp;
                                    contentContainer.layout(true);
                                }
                            });
                        }
                    }
                    if (ModelEditor.this.selectionService != null) {
                        ModelEditor.this.selectionService.setSelection(s.getFirstElement());
                    }
                }
            }
        });
        form.setWeights(new int[]{3, 4});
        MenuManager mgr = new MenuManager();
        mgr.setRemoveAllWhenShown(true);
        mgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                IExtensionRegistry registry;
                IExtensionPoint extPoint;
                IConfigurationElement[] elements;
                final IStructuredSelection s = (IStructuredSelection)ModelEditor.this.viewer.getSelection();
                boolean addSeparator = false;
                if (!s.isEmpty()) {
                    List<Action> actions;
                    if (s.getFirstElement() instanceof VirtualEntry) {
                        actions = ((AbstractComponentEditor)ModelEditor.this.virtualEditors.get(((VirtualEntry)s.getFirstElement()).getId())).getActions(s.getFirstElement());
                        if (actions.size() > 0) {
                            MenuManager addMenu = new MenuManager(((ModelEditor)ModelEditor.this).messages.ModelEditor_AddChild);
                            for (Action a : actions) {
                                addSeparator = true;
                                addMenu.add((IAction)a);
                            }
                            manager.add((IContributionItem)addMenu);
                        }
                        if ((actions = ((AbstractComponentEditor)ModelEditor.this.virtualEditors.get(((VirtualEntry)s.getFirstElement()).getId())).getActionsImport(s.getFirstElement())).size() > 0) {
                            MenuManager menu = new MenuManager("Import 3x");
                            for (Action a : actions) {
                                addSeparator = true;
                                menu.add((IAction)a);
                            }
                            manager.add((IContributionItem)menu);
                        }
                        if (addSeparator) {
                            manager.add((IContributionItem)new Separator());
                        }
                        if (!((VirtualEntry)s.getFirstElement()).getList().isEmpty() && !ModelEditor.this.isModelFragment()) {
                            manager.add((IAction)new Action(((ModelEditor)ModelEditor.this).messages.ModelEditor_ExtractFragment, ImageDescriptor.createFromImage((Image)ModelEditor.this.resourcePool.getImageUnchecked("IMG_org.eclipse.e4.tools.emf.ui.modelelements.ModelFragments"))){

                                public void run() {
                                    VirtualEntry ve = (VirtualEntry)s.getFirstElement();
                                    EObject container = (EObject)ve.getOriginalParent();
                                    String containerId = ((MApplicationElement)container).getElementId();
                                    if (containerId == null || containerId.length() == 0) {
                                        MessageDialog.openError((Shell)ModelEditor.this.viewer.getControl().getShell(), null, (String)((ModelEditor)(this).ModelEditor.this).messages.ModelEditor_ExtractFragment_NoParentId);
                                        return;
                                    }
                                    ArrayList<MApplicationElement> maes = new ArrayList<MApplicationElement>();
                                    IObservableList list = ve.getList();
                                    Iterator iterator = list.iterator();
                                    while (iterator.hasNext()) {
                                        maes.add((MApplicationElement)iterator.next());
                                    }
                                    ExtractContributionModelWizard extractContributionModelWizard = new ExtractContributionModelWizard(maes);
                                    extractContributionModelWizard.setup(ModelEditor.this.project);
                                    WizardDialog wizardDialog = new WizardDialog(ModelEditor.this.viewer.getControl().getShell(), (IWizard)extractContributionModelWizard);
                                    if (wizardDialog.open() == 0) {
                                        for (MApplicationElement mae : maes) {
                                            Command cmd = DeleteCommand.create((EditingDomain)ModelEditor.this.modelProvider.getEditingDomain(), (Object)mae);
                                            if (!cmd.canExecute()) continue;
                                            ModelEditor.this.modelProvider.getEditingDomain().getCommandStack().execute(cmd);
                                        }
                                    }
                                }
                            });
                        }
                    } else {
                        final EObject o = (EObject)s.getFirstElement();
                        AbstractComponentEditor editor = ModelEditor.this.getEditor(o.eClass());
                        actions = editor != null ? new ArrayList<Action>(editor.getActions(s.getFirstElement())) : new ArrayList<Action>();
                        if (actions.size() > 0) {
                            MenuManager addMenu = new MenuManager(((ModelEditor)ModelEditor.this).messages.ModelEditor_AddChild);
                            for (Action a : actions) {
                                addSeparator = true;
                                addMenu.add((IAction)a);
                            }
                            manager.add((IContributionItem)addMenu);
                        }
                        if ((actions = editor != null ? new ArrayList<Action>(editor.getActionsImport(s.getFirstElement())) : new ArrayList<Action>()).size() > 0) {
                            MenuManager menu = new MenuManager("Import 3x");
                            for (Action a : actions) {
                                addSeparator = true;
                                menu.add((IAction)a);
                            }
                            manager.add((IContributionItem)menu);
                        }
                        if (o.eContainer() != null) {
                            addSeparator = true;
                            manager.add((IAction)new Action(((ModelEditor)ModelEditor.this).messages.ModelEditor_Delete, ImageDescriptor.createFromImage((Image)ModelEditor.this.resourcePool.getImageUnchecked("IMG_org.eclipse.e4.tools.emf.ui.obj16.cross"))){

                                public void run() {
                                    Command cmd = DeleteCommand.create((EditingDomain)ModelEditor.this.modelProvider.getEditingDomain(), (Object)o);
                                    if (cmd.canExecute()) {
                                        ModelEditor.this.modelProvider.getEditingDomain().getCommandStack().execute(cmd);
                                    }
                                }
                            });
                        }
                    }
                }
                if ((elements = (extPoint = (registry = RegistryFactory.getRegistry()).getExtensionPoint("org.eclipse.e4.tools.emf.ui.scripting")).getConfigurationElements()).length > 0 && !s.isEmpty() && s.getFirstElement() instanceof MApplicationElement) {
                    if (addSeparator) {
                        manager.add((IContributionItem)new Separator());
                    }
                    addSeparator = false;
                    MenuManager scriptExecute = new MenuManager(((ModelEditor)ModelEditor.this).messages.ModelEditor_Script);
                    manager.add((IContributionItem)scriptExecute);
                    IConfigurationElement[] iConfigurationElementArray = elements;
                    int n = elements.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IConfigurationElement e;
                        final IConfigurationElement le = e = iConfigurationElementArray[n2];
                        scriptExecute.add((IAction)new Action(e.getAttribute("label")){

                            public void run() {
                                try {
                                    MApplicationElement o = (MApplicationElement)s.getFirstElement();
                                    IScriptingSupport support = (IScriptingSupport)le.createExecutableExtension("class");
                                    IEclipseContext ctx = null;
                                    if (ModelEditor.this.project == null) {
                                        ctx = o instanceof MContext ? ((MContext)o).getContext() : ModelUtils.getContainingContext((MApplicationElement)o);
                                    }
                                    support.openEditor(ModelEditor.this.viewer.getControl().getShell(), s.getFirstElement(), ctx);
                                }
                                catch (CoreException e) {
                                    e.printStackTrace();
                                }
                            }
                        });
                        ++n2;
                    }
                }
                if (ModelEditor.this.project != null) {
                    if (addSeparator) {
                        manager.add((IContributionItem)new Separator());
                    }
                    Action nlsAction = new Action(((ModelEditor)ModelEditor.this).messages.ModelEditor_ExternalizeStrings){

                        public void run() {
                            ExternalizeStringHandler h = (ExternalizeStringHandler)ContextInjectionFactory.make(ExternalizeStringHandler.class, (IEclipseContext)ModelEditor.this.context);
                            ContextInjectionFactory.invoke((Object)h, Execute.class, (IEclipseContext)ModelEditor.this.context);
                        }
                    };
                    manager.add((IAction)nlsAction);
                } else {
                    MUIElement el;
                    if (addSeparator) {
                        manager.add((IContributionItem)new Separator());
                    }
                    if (s.getFirstElement() instanceof MUIElement && (el = (MUIElement)s.getFirstElement()).getWidget() instanceof Control) {
                        manager.add((IAction)new Action(((ModelEditor)ModelEditor.this).messages.ModelEditor_ShowControl){

                            public void run() {
                                ControlHighlighter.show((Control)el.getWidget());
                            }
                        });
                    }
                }
                if (s.getFirstElement() instanceof MApplicationElement && !ModelEditor.this.isModelFragment() && !(s.getFirstElement() instanceof MApplication)) {
                    manager.add((IAction)new Action(((ModelEditor)ModelEditor.this).messages.ModelEditor_ExtractFragment, ImageDescriptor.createFromImage((Image)ModelEditor.this.resourcePool.getImageUnchecked("IMG_org.eclipse.e4.tools.emf.ui.modelelements.ModelFragments"))){

                        public void run() {
                            Command cmd;
                            MApplicationElement oe = (MApplicationElement)s.getFirstElement();
                            EObject container = ((EObject)oe).eContainer();
                            String containerId = ((MApplicationElement)container).getElementId();
                            if (containerId == null || containerId.length() == 0) {
                                MessageDialog.openError((Shell)ModelEditor.this.viewer.getControl().getShell(), null, (String)((ModelEditor)(this).ModelEditor.this).messages.ModelEditor_ExtractFragment_NoParentId);
                                return;
                            }
                            ExtractContributionModelWizard extractContributionModelWizard = new ExtractContributionModelWizard(oe);
                            extractContributionModelWizard.setup(ModelEditor.this.project);
                            WizardDialog wizardDialog = new WizardDialog(ModelEditor.this.viewer.getControl().getShell(), (IWizard)extractContributionModelWizard);
                            if (wizardDialog.open() == 0 && (cmd = DeleteCommand.create((EditingDomain)ModelEditor.this.modelProvider.getEditingDomain(), (Object)oe)).canExecute()) {
                                ModelEditor.this.modelProvider.getEditingDomain().getCommandStack().execute(cmd);
                            }
                        }
                    });
                }
                if (addSeparator) {
                    manager.add((IContributionItem)new Separator());
                }
                Action expandAction = new Action(((ModelEditor)ModelEditor.this).messages.ModelEditor_ExpandSubtree){

                    public void run() {
                        if (!s.isEmpty()) {
                            if (ModelEditor.this.viewer.getExpandedState(s.getFirstElement())) {
                                ModelEditor.this.viewer.collapseToLevel(s.getFirstElement(), -1);
                            } else {
                                ModelEditor.this.viewer.expandToLevel(s.getFirstElement(), -1);
                            }
                        }
                    }
                };
                manager.add((IAction)expandAction);
            }
        });
        this.viewer.getTree().addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                if (ModelEditor.this.mod1Down && (e.keyCode & SWT.MOD1) == SWT.MOD1) {
                    ModelEditor.this.mod1Down = false;
                }
            }

            public void keyPressed(KeyEvent e) {
                if (!ModelEditor.this.mod1Down && (e.keyCode & SWT.MOD1) == SWT.MOD1) {
                    ModelEditor.this.mod1Down = true;
                }
            }
        });
        this.viewer.addTreeListener(new ITreeViewerListener(){

            public void treeExpanded(final TreeExpansionEvent event) {
                if (ModelEditor.this.mod1Down) {
                    ModelEditor.this.viewer.getTree().getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            ModelEditor.this.viewer.expandToLevel(event.getElement(), -1);
                        }
                    });
                }
            }

            public void treeCollapsed(final TreeExpansionEvent event) {
                if (ModelEditor.this.mod1Down) {
                    ModelEditor.this.viewer.getTree().getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            ModelEditor.this.viewer.collapseToLevel(event.getElement(), -1);
                        }
                    });
                }
            }
        });
        this.viewer.getControl().setMenu(mgr.createContextMenu(this.viewer.getControl()));
        this.viewer.setSelection((ISelection)new StructuredSelection((List)this.modelProvider.getRoot()));
        return form;
    }

    public IExtensionLookup getExtensionLookup() {
        return this.extensionLookup;
    }

    public boolean isAutoCreateElementId() {
        return this.autoCreateElementId && this.project != null;
    }

    public IProject getProject() {
        return this.project;
    }

    public boolean isShowXMIId() {
        return this.showXMIId;
    }

    private void loadContributionCreators() {
        IExtensionRegistry registry = RegistryFactory.getRegistry();
        IExtensionPoint extPoint = registry.getExtensionPoint("org.eclipse.e4.tools.emf.ui.editors");
        IConfigurationElement[] iConfigurationElementArray = extPoint.getConfigurationElements();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement el = iConfigurationElementArray[n2];
            if ("contributionClassCreator".equals(el.getName())) {
                try {
                    this.contributionCreator.add((IContributionClassCreator)el.createExecutableExtension("class"));
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
            ++n2;
        }
    }

    public IContributionClassCreator getContributionCreator(EClass eClass) {
        for (IContributionClassCreator c : this.contributionCreator) {
            if (!c.isSupported(eClass)) continue;
            return c;
        }
        return null;
    }

    private void loadEditorFeatures() {
        IExtensionRegistry registry = RegistryFactory.getRegistry();
        IExtensionPoint extPoint = registry.getExtensionPoint("org.eclipse.e4.tools.emf.ui.editors");
        IConfigurationElement[] iConfigurationElementArray = extPoint.getConfigurationElements();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement el = iConfigurationElementArray[n2];
            if ("editorfeature".equals(el.getName())) {
                try {
                    this.editorFeatures.add((IEditorFeature)el.createExecutableExtension("class"));
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
            ++n2;
        }
    }

    public boolean isModelFragment() {
        return this.fragment;
    }

    public boolean isLiveModel() {
        return !this.modelProvider.isSaveable();
    }

    public List<IEditorFeature.FeatureClass> getFeatureClasses(EClass eClass, EStructuralFeature feature) {
        ArrayList<IEditorFeature.FeatureClass> list = new ArrayList<IEditorFeature.FeatureClass>();
        for (IEditorFeature f : this.editorFeatures) {
            list.addAll(f.getFeatureClasses(eClass, feature));
        }
        return list;
    }

    @Inject
    public void setSelectionService(@Optional ISelectionProviderService selectionService) {
        this.selectionService = selectionService;
        if (this.viewer != null && !this.viewer.getControl().isDisposed() && !this.viewer.getSelection().isEmpty() && selectionService != null) {
            selectionService.setSelection(((IStructuredSelection)this.viewer.getSelection()).getFirstElement());
        }
    }

    private TreeViewer createTreeViewerArea(Composite parent) {
        ShadowComposite treeArea = new ShadowComposite(parent, 0);
        treeArea.setLayout((Layout)new FillLayout());
        treeArea.setData(CSS_CLASS_KEY, "formContainer");
        treeArea.setBackgroundMode(1);
        final TreeViewer viewer = new TreeViewer((Composite)treeArea, 66304);
        viewer.setLabelProvider((IBaseLabelProvider)new ComponentLabelProvider(this, this.messages));
        ObservableListTreeContentProvider contentProvider = new ObservableListTreeContentProvider((IObservableFactory)new ObservableFactoryImpl(), (TreeStructureAdvisor)new TreeStructureAdvisorImpl());
        viewer.setContentProvider((IContentProvider)contentProvider);
        final WritableSet clearedSet = new WritableSet();
        contentProvider.getKnownElements().addSetChangeListener(new ISetChangeListener(){

            public void handleSetChange(SetChangeEvent event) {
                for (Object o : event.diff.getAdditions()) {
                    if (!(o instanceof EObject)) continue;
                    clearedSet.add(o);
                }
                for (Object o : event.diff.getRemovals()) {
                    if (!(o instanceof EObject)) continue;
                    clearedSet.remove(o);
                }
            }
        });
        for (FeaturePath p : this.labelFeaturePaths) {
            IObservableMap map = EMFProperties.value((FeaturePath)p).observeDetail((IObservableSet)clearedSet);
            map.addMapChangeListener(new IMapChangeListener(){

                public void handleMapChange(MapChangeEvent event) {
                    viewer.update(event.diff.getChangedKeys().toArray(), null);
                }
            });
        }
        viewer.setInput((Object)this.modelProvider.getRoot());
        viewer.setAutoExpandLevel(2);
        viewer.expandToLevel(viewer.getAutoExpandLevel());
        viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                TreeViewer viewer = (TreeViewer)event.getViewer();
                IStructuredSelection thisSelection = (IStructuredSelection)event.getSelection();
                Object selectedNode = thisSelection.getFirstElement();
                if (ModelEditor.this.mod1Down) {
                    if (viewer.getExpandedState(selectedNode)) {
                        viewer.setExpandedState(selectedNode, false);
                    } else {
                        viewer.expandToLevel(selectedNode, -1);
                    }
                } else {
                    viewer.setExpandedState(selectedNode, !viewer.getExpandedState(selectedNode));
                }
            }
        });
        viewer.getTree().addTreeListener((TreeListener)new TreeAdapter(){

            public void treeCollapsed(TreeEvent e) {
                viewer.expandToLevel(viewer.getAutoExpandLevel());
            }
        });
        int ops = 2;
        viewer.addDragSupport(ops, new Transfer[]{MemoryTransfer.getInstance()}, (DragSourceListener)new DragListener(viewer));
        viewer.addDropSupport(ops, new Transfer[]{MemoryTransfer.getInstance()}, (DropTargetListener)new DropListener((Viewer)viewer, this.modelProvider.getEditingDomain()));
        return viewer;
    }

    private void registerContributedVirtualEditors() {
        IExtensionRegistry registry = RegistryFactory.getRegistry();
        IExtensionPoint extPoint = registry.getExtensionPoint("org.eclipse.e4.tools.emf.ui.editors");
        IConfigurationElement[] iConfigurationElementArray = extPoint.getConfigurationElements();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement el = iConfigurationElementArray[n2];
            if ("virtualeditor".equals(el.getName())) {
                IContributionFactory fact = (IContributionFactory)this.context.get(IContributionFactory.class);
                AbstractComponentEditor editor = (AbstractComponentEditor)fact.create("bundleclass://" + el.getContributor().getName() + "/" + el.getAttribute("class"), this.context);
                this.registerVirtualEditor(el.getAttribute("id"), editor);
            }
            ++n2;
        }
    }

    private void registerVirtualEditors() {
        this.registerVirtualEditor(VIRTUAL_PART_MENU, (AbstractComponentEditor)ContextInjectionFactory.make(VPartMenuEditor.class, (IEclipseContext)this.context));
        this.registerVirtualEditor(VIRTUAL_HANDLER, (AbstractComponentEditor)ContextInjectionFactory.make(VHandlerEditor.class, (IEclipseContext)this.context));
        this.registerVirtualEditor(VIRTUAL_BINDING_TABLE, (AbstractComponentEditor)ContextInjectionFactory.make(VBindingTableEditor.class, (IEclipseContext)this.context));
        this.registerVirtualEditor(VIRTUAL_COMMAND, (AbstractComponentEditor)ContextInjectionFactory.make(VCommandEditor.class, (IEclipseContext)this.context));
        this.registerVirtualEditor(VIRTUAL_APPLICATION_WINDOWS, (AbstractComponentEditor)ContextInjectionFactory.make(VApplicationWindowEditor.class, (IEclipseContext)this.context));
        this.registerVirtualEditor(VIRTUAL_WINDOW_WINDOWS, (AbstractComponentEditor)ContextInjectionFactory.make(VWindowWindowsEditor.class, (IEclipseContext)this.context));
        this.registerVirtualEditor(VIRTUAL_PERSPECTIVE_WINDOWS, (AbstractComponentEditor)ContextInjectionFactory.make(VPerspectiveWindowsEditor.class, (IEclipseContext)this.context));
        this.registerVirtualEditor(VIRTUAL_WINDOW_CONTROLS, (AbstractComponentEditor)ContextInjectionFactory.make(VWindowControlEditor.class, (IEclipseContext)this.context));
        this.registerVirtualEditor(VIRTUAL_PART_DESCRIPTORS, (AbstractComponentEditor)ContextInjectionFactory.make(VPartDescriptor.class, (IEclipseContext)this.context));
        this.registerVirtualEditor(VIRTUAL_PARTDESCRIPTOR_MENU, (AbstractComponentEditor)ContextInjectionFactory.make(VPartDescriptorMenuEditor.class, (IEclipseContext)this.context));
        this.registerVirtualEditor(VIRTUAL_TRIMMED_WINDOW_TRIMS, (AbstractComponentEditor)ContextInjectionFactory.make(VWindowTrimEditor.class, (IEclipseContext)this.context));
        this.registerVirtualEditor(VIRTUAL_ADDONS, (AbstractComponentEditor)ContextInjectionFactory.make(VApplicationAddons.class, (IEclipseContext)this.context));
        this.registerVirtualEditor(VIRTUAL_MENU_CONTRIBUTIONS, (AbstractComponentEditor)ContextInjectionFactory.make(VMenuContributionsEditor.class, (IEclipseContext)this.context));
        this.registerVirtualEditor(VIRTUAL_TOOLBAR_CONTRIBUTIONS, (AbstractComponentEditor)ContextInjectionFactory.make(VToolBarContributionsEditor.class, (IEclipseContext)this.context));
        this.registerVirtualEditor(VIRTUAL_TRIM_CONTRIBUTIONS, (AbstractComponentEditor)ContextInjectionFactory.make(VTrimContributionsEditor.class, (IEclipseContext)this.context));
        this.registerVirtualEditor(VIRTUAL_WINDOW_SHARED_ELEMENTS, (AbstractComponentEditor)ContextInjectionFactory.make(VWindowSharedElementsEditor.class, (IEclipseContext)this.context));
        this.registerVirtualEditor(VIRTUAL_MODEL_FRAGEMENTS, (AbstractComponentEditor)ContextInjectionFactory.make(VModelFragmentsEditor.class, (IEclipseContext)this.context));
        this.registerVirtualEditor(VIRTUAL_MODEL_IMPORTS, (AbstractComponentEditor)ContextInjectionFactory.make(VModelImportsEditor.class, (IEclipseContext)this.context));
        this.registerVirtualEditor(VIRTUAL_CATEGORIES, (AbstractComponentEditor)ContextInjectionFactory.make(VApplicationCategoriesEditor.class, (IEclipseContext)this.context));
        this.registerVirtualEditor(VIRTUAL_PARAMETERS, (AbstractComponentEditor)ContextInjectionFactory.make(VItemParametersEditor.class, (IEclipseContext)this.context));
        this.registerVirtualEditor(VIRTUAL_ROOT_CONTEXTS, (AbstractComponentEditor)ContextInjectionFactory.make(VRootBindingContexts.class, (IEclipseContext)this.context));
        this.registerVirtualEditor(VIRTUAL_PERSPECTIVE_CONTROLS, (AbstractComponentEditor)ContextInjectionFactory.make(VPerspectiveControlEditor.class, (IEclipseContext)this.context));
        this.registerVirtualEditor(VIRTUAL_SNIPPETS, (AbstractComponentEditor)ContextInjectionFactory.make(VSnippetsEditor.class, (IEclipseContext)this.context));
    }

    private void registerVirtualEditor(String id, AbstractComponentEditor editor) {
        this.virtualEditors.put(id, editor);
    }

    public void setSelection(Object element) {
        this.viewer.setSelection((ISelection)new StructuredSelection(element));
    }

    private void registerContributedEditors() {
        IExtensionRegistry registry = RegistryFactory.getRegistry();
        IExtensionPoint extPoint = registry.getExtensionPoint("org.eclipse.e4.tools.emf.ui.editors");
        IConfigurationElement[] iConfigurationElementArray = extPoint.getConfigurationElements();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement el = iConfigurationElementArray[n2];
            if ("editor".equals(el.getName())) {
                try {
                    IEditorDescriptor desc = (IEditorDescriptor)el.createExecutableExtension("descriptorClass");
                    EClass eClass = desc.getEClass();
                    IContributionFactory fact = (IContributionFactory)this.context.get(IContributionFactory.class);
                    AbstractComponentEditor editor = (AbstractComponentEditor)fact.create("bundleclass://" + el.getContributor().getName() + "/" + desc.getEditorClass().getName(), this.context);
                    this.registerEditor(eClass, editor);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
            ++n2;
        }
    }

    private void registerDefaultEditors() {
        System.err.println(String.valueOf(this.getClass().getName()) + ".registerDefaultEditors: " + this.resourcePool);
        this.registerEditor(ApplicationPackageImpl.Literals.APPLICATION, (AbstractComponentEditor)ContextInjectionFactory.make(ApplicationEditor.class, (IEclipseContext)this.context));
        this.registerEditor(ApplicationPackageImpl.Literals.ADDON, (AbstractComponentEditor)ContextInjectionFactory.make(AddonsEditor.class, (IEclipseContext)this.context));
        this.registerEditor(CommandsPackageImpl.Literals.KEY_BINDING, (AbstractComponentEditor)ContextInjectionFactory.make(KeyBindingEditor.class, (IEclipseContext)this.context));
        this.registerEditor(CommandsPackageImpl.Literals.HANDLER, (AbstractComponentEditor)ContextInjectionFactory.make(HandlerEditor.class, (IEclipseContext)this.context));
        this.registerEditor(CommandsPackageImpl.Literals.COMMAND, (AbstractComponentEditor)ContextInjectionFactory.make(CommandEditor.class, (IEclipseContext)this.context));
        this.registerEditor(CommandsPackageImpl.Literals.COMMAND_PARAMETER, (AbstractComponentEditor)ContextInjectionFactory.make(CommandParameterEditor.class, (IEclipseContext)this.context));
        this.registerEditor(CommandsPackageImpl.Literals.PARAMETER, (AbstractComponentEditor)ContextInjectionFactory.make(ParameterEditor.class, (IEclipseContext)this.context));
        this.registerEditor(CommandsPackageImpl.Literals.BINDING_TABLE, (AbstractComponentEditor)ContextInjectionFactory.make(BindingTableEditor.class, (IEclipseContext)this.context));
        this.registerEditor(CommandsPackageImpl.Literals.BINDING_CONTEXT, (AbstractComponentEditor)ContextInjectionFactory.make(BindingContextEditor.class, (IEclipseContext)this.context));
        this.registerEditor(CommandsPackageImpl.Literals.CATEGORY, (AbstractComponentEditor)ContextInjectionFactory.make(CategoryEditor.class, (IEclipseContext)this.context));
        this.registerEditor(MenuPackageImpl.Literals.TOOL_BAR, (AbstractComponentEditor)ContextInjectionFactory.make(ToolBarEditor.class, (IEclipseContext)this.context));
        this.registerEditor(MenuPackageImpl.Literals.RENDERED_TOOL_BAR, (AbstractComponentEditor)ContextInjectionFactory.make(RenderedToolBarEditor.class, (IEclipseContext)this.context));
        this.registerEditor(MenuPackageImpl.Literals.DIRECT_TOOL_ITEM, (AbstractComponentEditor)ContextInjectionFactory.make(DirectToolItemEditor.class, (IEclipseContext)this.context));
        this.registerEditor(MenuPackageImpl.Literals.HANDLED_TOOL_ITEM, (AbstractComponentEditor)ContextInjectionFactory.make(HandledToolItemEditor.class, (IEclipseContext)this.context));
        this.registerEditor(MenuPackageImpl.Literals.TOOL_BAR_SEPARATOR, (AbstractComponentEditor)ContextInjectionFactory.make(ToolBarSeparatorEditor.class, (IEclipseContext)this.context));
        this.registerEditor(MenuPackageImpl.Literals.TOOL_CONTROL, (AbstractComponentEditor)ContextInjectionFactory.make(ToolControlEditor.class, (IEclipseContext)this.context));
        this.registerEditor(MenuPackageImpl.Literals.MENU, (AbstractComponentEditor)ContextInjectionFactory.make(MenuEditor.class, (IEclipseContext)this.context));
        this.registerEditor(MenuPackageImpl.Literals.RENDERED_MENU, (AbstractComponentEditor)ContextInjectionFactory.make(RenderedMenuEditor.class, (IEclipseContext)this.context));
        this.registerEditor(MenuPackageImpl.Literals.POPUP_MENU, (AbstractComponentEditor)ContextInjectionFactory.make(PopupMenuEditor.class, (IEclipseContext)this.context));
        this.registerEditor(MenuPackageImpl.Literals.MENU_SEPARATOR, (AbstractComponentEditor)ContextInjectionFactory.make(MenuSeparatorEditor.class, (IEclipseContext)this.context));
        this.registerEditor(MenuPackageImpl.Literals.HANDLED_MENU_ITEM, (AbstractComponentEditor)ContextInjectionFactory.make(HandledMenuItemEditor.class, (IEclipseContext)this.context));
        this.registerEditor(MenuPackageImpl.Literals.DIRECT_MENU_ITEM, (AbstractComponentEditor)ContextInjectionFactory.make(DirectMenuItemEditor.class, (IEclipseContext)this.context));
        this.registerEditor(MenuPackageImpl.Literals.RENDERED_MENU_ITEM, (AbstractComponentEditor)ContextInjectionFactory.make(RenderedMenuItem.class, (IEclipseContext)this.context));
        this.registerEditor(MenuPackageImpl.Literals.MENU_CONTRIBUTION, (AbstractComponentEditor)ContextInjectionFactory.make(MenuContributionEditor.class, (IEclipseContext)this.context));
        this.registerEditor(MenuPackageImpl.Literals.TOOL_BAR_CONTRIBUTION, (AbstractComponentEditor)ContextInjectionFactory.make(ToolBarContributionEditor.class, (IEclipseContext)this.context));
        this.registerEditor(MenuPackageImpl.Literals.TRIM_CONTRIBUTION, (AbstractComponentEditor)ContextInjectionFactory.make(TrimContributionEditor.class, (IEclipseContext)this.context));
        this.registerEditor(MenuPackageImpl.Literals.DYNAMIC_MENU_CONTRIBUTION, (AbstractComponentEditor)ContextInjectionFactory.make(DynamicMenuContributionEditor.class, (IEclipseContext)this.context));
        this.registerEditor(UiPackageImpl.Literals.CORE_EXPRESSION, (AbstractComponentEditor)ContextInjectionFactory.make(CoreExpressionEditor.class, (IEclipseContext)this.context));
        this.registerEditor(BasicPackageImpl.Literals.PART, (AbstractComponentEditor)ContextInjectionFactory.make(PartEditor.class, (IEclipseContext)this.context));
        this.registerEditor(BasicPackageImpl.Literals.WINDOW, (AbstractComponentEditor)ContextInjectionFactory.make(WindowEditor.class, (IEclipseContext)this.context));
        this.registerEditor(BasicPackageImpl.Literals.TRIMMED_WINDOW, (AbstractComponentEditor)ContextInjectionFactory.make(TrimmedWindowEditor.class, (IEclipseContext)this.context));
        this.registerEditor(BasicPackageImpl.Literals.PART_SASH_CONTAINER, (AbstractComponentEditor)ContextInjectionFactory.make(PartSashContainerEditor.class, (IEclipseContext)this.context));
        this.registerEditor(AdvancedPackageImpl.Literals.AREA, (AbstractComponentEditor)ContextInjectionFactory.make(AreaEditor.class, (IEclipseContext)this.context));
        this.registerEditor(BasicPackageImpl.Literals.PART_STACK, (AbstractComponentEditor)ContextInjectionFactory.make(PartStackEditor.class, (IEclipseContext)this.context));
        this.registerEditor(BasicPackageImpl.Literals.INPUT_PART, (AbstractComponentEditor)ContextInjectionFactory.make(InputPartEditor.class, (IEclipseContext)this.context));
        this.registerEditor(BasicPackageImpl.Literals.TRIM_BAR, (AbstractComponentEditor)ContextInjectionFactory.make(TrimBarEditor.class, (IEclipseContext)this.context));
        this.registerEditor(BasicPackageImpl.Literals.PART_DESCRIPTOR, (AbstractComponentEditor)ContextInjectionFactory.make(PartDescriptorEditor.class, (IEclipseContext)this.context));
        this.registerEditor(AdvancedPackageImpl.Literals.PERSPECTIVE_STACK, (AbstractComponentEditor)ContextInjectionFactory.make(PerspectiveStackEditor.class, (IEclipseContext)this.context));
        this.registerEditor(AdvancedPackageImpl.Literals.PERSPECTIVE, (AbstractComponentEditor)ContextInjectionFactory.make(PerspectiveEditor.class, (IEclipseContext)this.context));
        this.registerEditor(AdvancedPackageImpl.Literals.PLACEHOLDER, (AbstractComponentEditor)ContextInjectionFactory.make(PlaceholderEditor.class, (IEclipseContext)this.context));
        this.registerEditor(FragmentPackageImpl.Literals.MODEL_FRAGMENTS, (AbstractComponentEditor)ContextInjectionFactory.make(ModelFragmentsEditor.class, (IEclipseContext)this.context));
        this.registerEditor(FragmentPackageImpl.Literals.STRING_MODEL_FRAGMENT, (AbstractComponentEditor)ContextInjectionFactory.make(StringModelFragment.class, (IEclipseContext)this.context));
    }

    @Inject
    public void setNotVisibleColor(@Preference(value="notVisibleColor") String color) {
        RGB current = JFaceResources.getColorRegistry().getRGB("NOT_VISIBLE_KEY");
        if (current == null || !current.equals((Object)color)) {
            JFaceResources.getColorRegistry().put("NOT_VISIBLE_KEY", StringConverter.asRGB((String)color, (RGB)new RGB(200, 200, 200)));
        }
        if (this.viewer != null) {
            this.viewer.refresh();
            this.viewer.getControl().redraw();
        }
    }

    @Inject
    public void setNotRenderedColor(@Preference(value="notRenderedColor") String color) {
        RGB current = JFaceResources.getColorRegistry().getRGB("NOT_RENDERED_STYLER");
        if (current == null || !current.equals((Object)color)) {
            JFaceResources.getColorRegistry().put("NOT_RENDERED_STYLER", StringConverter.asRGB((String)color, (RGB)new RGB(200, 200, 200)));
        }
        if (this.viewer != null) {
            this.viewer.refresh();
            this.viewer.getControl().redraw();
        }
    }

    @Inject
    public void setNotVisibleRenderedColor(@Preference(value="notVisibleAndRenderedColor") String color) {
        RGB current = JFaceResources.getColorRegistry().getRGB("NOT_VISIBLE_AND_RENDERED_KEY");
        if (current == null || !current.equals((Object)color)) {
            JFaceResources.getColorRegistry().put("NOT_VISIBLE_AND_RENDERED_KEY", StringConverter.asRGB((String)color, (RGB)new RGB(200, 200, 200)));
        }
        if (this.viewer != null) {
            this.viewer.refresh();
            this.viewer.getControl().redraw();
        }
    }

    public void registerEditor(EClass eClass, AbstractComponentEditor editor) {
        this.editorMap.put(eClass, editor);
        FeaturePath[] featurePathArray = editor.getLabelProperties();
        int n = featurePathArray.length;
        int n2 = 0;
        while (n2 < n) {
            FeaturePath p = featurePathArray[n2];
            boolean found = false;
            for (FeaturePath tmp : this.labelFeaturePaths) {
                if (!this.equalsPaths(p, tmp)) continue;
                found = true;
                break;
            }
            if (!found) {
                this.labelFeaturePaths.add(p);
            }
            ++n2;
        }
    }

    private boolean equalsPaths(FeaturePath p1, FeaturePath p2) {
        if (p1.getFeaturePath().length == p2.getFeaturePath().length) {
            int i = 0;
            while (i < p1.getFeaturePath().length) {
                if (!p1.getFeaturePath()[i].equals(p2.getFeaturePath()[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public AbstractComponentEditor getEditor(EClass eClass) {
        AbstractComponentEditor editor = this.editorMap.get(eClass);
        if (editor == null) {
            for (EClass cl : eClass.getESuperTypes()) {
                editor = this.getEditor(cl);
                if (editor == null) continue;
                return editor;
            }
            if (editor == null) {
                editor = (AbstractComponentEditor)ContextInjectionFactory.make(DefaultEditor.class, (IEclipseContext)this.context);
            }
        }
        return editor;
    }

    @Persist
    public void doSave(@Optional IProgressMonitor monitor) {
        try {
            this.setSaving(true);
            if (this.modelProvider.isSaveable()) {
                this.modelProvider.save();
            }
        }
        finally {
            this.setSaving(false);
        }
    }

    private void setSaving(boolean saving) {
        this.saving = saving;
    }

    protected boolean isSaving() {
        return this.saving;
    }

    @Focus
    public void setFocus() {
        if (this.clipboardHandler == null) {
            this.clipboardHandler = new ClipboardHandler();
        }
        if (this.clipboardService != null) {
            this.clipboardService.setHandler(this.clipboardHandler);
        }
        this.viewer.getControl().setFocus();
    }

    @PreDestroy
    void dispose() {
        try {
            this.obsManager.dispose();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.project == null) {
            ((Display)this.context.get(Display.class)).removeFilter(4, this.keyListener);
        }
    }

    public IModelResource getModelProvider() {
        return this.modelProvider;
    }

    class ClipboardHandler
    implements IClipboardService.Handler {
        ClipboardHandler() {
        }

        public void paste() {
            if (ModelEditor.this.editorTabFolder.getSelectionIndex() == 0) {
                if (ModelEditor.this.viewer.getControl().getDisplay().getFocusControl() == ModelEditor.this.viewer.getControl()) {
                    this.handleStructurePaste();
                } else if (ModelEditor.this.currentEditor != null) {
                    ModelEditor.this.currentEditor.handlePaste();
                }
            } else {
                ModelEditor.this.sourceViewer.getTextWidget().paste();
            }
        }

        private void handleStructurePaste() {
            Command cmd;
            Clipboard clip = new Clipboard(ModelEditor.this.viewer.getControl().getDisplay());
            Object o = clip.getContents((Transfer)MemoryTransfer.getInstance());
            clip.dispose();
            if (o == null) {
                return;
            }
            o = EcoreUtil.copy((EObject)((EObject)o));
            Object parent = ((IStructuredSelection)ModelEditor.this.viewer.getSelection()).getFirstElement();
            EReference feature = null;
            EObject container = null;
            if (parent instanceof VirtualEntry) {
                VirtualEntry v = (VirtualEntry)parent;
                feature = ((IEMFProperty)v.getProperty()).getStructuralFeature();
                container = (EObject)v.getOriginalParent();
            } else if (parent instanceof MElementContainer) {
                feature = UiPackageImpl.Literals.ELEMENT_CONTAINER__CHILDREN;
                container = (EObject)parent;
            } else if (parent instanceof EObject) {
                container = (EObject)parent;
                EClass eClass = container.eClass();
                for (EStructuralFeature f : eClass.getEAllStructuralFeatures()) {
                    if (!ModelUtils.getTypeArgument((EClass)eClass, (EGenericType)f.getEGenericType()).isInstance(o)) continue;
                    feature = f;
                    break;
                }
            }
            if (feature == FragmentPackageImpl.Literals.MODEL_FRAGMENTS__IMPORTS && container != null) {
                MApplicationElement el = (MApplicationElement)EcoreUtil.create((EClass)((EObject)o).eClass());
                el.setElementId(((MApplicationElement)o).getElementId());
                Command cmd2 = AddCommand.create((EditingDomain)ModelEditor.this.getModelProvider().getEditingDomain(), (Object)container, (Object)feature, (Object)el);
                if (cmd2.canExecute()) {
                    ModelEditor.this.getModelProvider().getEditingDomain().getCommandStack().execute(cmd2);
                }
                return;
            }
            if (feature != null && container != null && (cmd = AddCommand.create((EditingDomain)ModelEditor.this.getModelProvider().getEditingDomain(), (Object)container, (Object)feature, (Object)o)).canExecute()) {
                ModelEditor.this.getModelProvider().getEditingDomain().getCommandStack().execute(cmd);
                if (ModelEditor.this.isLiveModel() && container instanceof MElementContainer && o instanceof MUIElement) {
                    ((MElementContainer)container).setSelectedElement((MUIElement)o);
                }
            }
        }

        public void copy() {
            if (ModelEditor.this.editorTabFolder.getSelectionIndex() == 0) {
                if (ModelEditor.this.viewer.getControl().getDisplay().getFocusControl() == ModelEditor.this.viewer.getControl()) {
                    this.handleStructureCopy();
                } else if (ModelEditor.this.currentEditor != null) {
                    ModelEditor.this.currentEditor.handleCopy();
                }
            } else {
                ModelEditor.this.sourceViewer.getTextWidget().copy();
            }
        }

        private void handleStructureCopy() {
            Object o = ((IStructuredSelection)ModelEditor.this.viewer.getSelection()).getFirstElement();
            if (o != null && o instanceof EObject) {
                Clipboard clip = new Clipboard(ModelEditor.this.viewer.getControl().getDisplay());
                clip.setContents(new Object[]{EcoreUtil.copy((EObject)((EObject)o))}, new Transfer[]{MemoryTransfer.getInstance()});
                clip.dispose();
            }
        }

        public void cut() {
            if (ModelEditor.this.editorTabFolder.getSelectionIndex() == 0) {
                if (ModelEditor.this.viewer.getControl().getDisplay().getFocusControl() == ModelEditor.this.viewer.getControl()) {
                    this.handleStructureCut();
                } else if (ModelEditor.this.currentEditor != null) {
                    ModelEditor.this.currentEditor.handleCut();
                }
            } else {
                ModelEditor.this.sourceViewer.getTextWidget().cut();
            }
        }

        private void handleStructureCut() {
            Object o = ((IStructuredSelection)ModelEditor.this.viewer.getSelection()).getFirstElement();
            if (o != null && o instanceof EObject) {
                Clipboard clip = new Clipboard(ModelEditor.this.viewer.getControl().getDisplay());
                clip.setContents(new Object[]{o}, new Transfer[]{MemoryTransfer.getInstance()});
                clip.dispose();
                EObject eObj = (EObject)o;
                Command cmd = RemoveCommand.create((EditingDomain)ModelEditor.this.getModelProvider().getEditingDomain(), (Object)eObj.eContainer(), (Object)eObj.eContainingFeature(), (Object)eObj);
                if (cmd.canExecute()) {
                    ModelEditor.this.getModelProvider().getEditingDomain().getCommandStack().execute(cmd);
                }
            }
        }
    }

    static class DragListener
    extends DragSourceAdapter {
        private final TreeViewer viewer;

        public DragListener(TreeViewer viewer) {
            this.viewer = viewer;
        }

        public void dragStart(DragSourceEvent event) {
            IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
            event.doit = !selection.isEmpty() && selection.getFirstElement() instanceof MApplicationElement;
        }

        public void dragSetData(DragSourceEvent event) {
            Object o;
            IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
            event.data = o = selection.getFirstElement();
        }
    }

    class DropListener
    extends ViewerDropAdapter {
        private EditingDomain domain;

        protected DropListener(Viewer viewer, EditingDomain domain) {
            super(viewer);
            this.domain = domain;
        }

        public boolean performDrop(Object data) {
            block29: {
                block25: {
                    Command cmd;
                    EObject parent;
                    EReference feature;
                    block27: {
                        block28: {
                            block26: {
                                if (this.getCurrentLocation() != 3) break block25;
                                feature = null;
                                parent = null;
                                if (!(this.getCurrentTarget() instanceof MElementContainer)) break block26;
                                feature = UiPackageImpl.Literals.ELEMENT_CONTAINER__CHILDREN;
                                parent = (EObject)this.getCurrentTarget();
                                break block27;
                            }
                            if (!(this.getCurrentTarget() instanceof VirtualEntry)) break block28;
                            VirtualEntry entry = (VirtualEntry)this.getCurrentTarget();
                            IListProperty prop = entry.getProperty();
                            if (!(prop instanceof IEMFProperty)) break block27;
                            feature = ((IEMFProperty)prop).getStructuralFeature();
                            parent = (EObject)entry.getOriginalParent();
                            break block27;
                        }
                        if (this.getCurrentTarget() instanceof EObject) {
                            parent = (EObject)this.getCurrentTarget();
                            for (EStructuralFeature f : parent.eClass().getEAllStructuralFeatures()) {
                                EClassifier cl = ModelUtils.getTypeArgument((EClass)parent.eClass(), (EGenericType)f.getEGenericType());
                                if (!cl.isInstance(data)) continue;
                                feature = f;
                                break;
                            }
                        }
                    }
                    if (feature != null && parent != null && (cmd = AddCommand.create((EditingDomain)this.domain, (Object)parent, (Object)feature, (Object)data)).canExecute()) {
                        this.domain.getCommandStack().execute(cmd);
                        if (ModelEditor.this.isLiveModel() && parent instanceof MElementContainer && data instanceof MUIElement) {
                            ((MElementContainer)parent).setSelectedElement((MUIElement)data);
                        }
                    }
                    break block29;
                }
                if (this.getCurrentLocation() == 2 || this.getCurrentLocation() == 1) {
                    EReference feature = null;
                    EObject parent = null;
                    TreeItem item = (TreeItem)this.getCurrentEvent().item;
                    if (item != null) {
                        TreeItem parentItem = item.getParentItem();
                        if (item != null) {
                            if (parentItem.getData() instanceof VirtualEntry) {
                                VirtualEntry vE = (VirtualEntry)parentItem.getData();
                                parent = (EObject)vE.getOriginalParent();
                                feature = ((IEMFProperty)vE.getProperty()).getStructuralFeature();
                            } else if (parentItem.getData() instanceof MElementContainer) {
                                parent = (EObject)parentItem.getData();
                                feature = UiPackageImpl.Literals.ELEMENT_CONTAINER__CHILDREN;
                            } else if (parentItem.getData() instanceof EObject) {
                                parent = (EObject)parentItem.getData();
                                for (EStructuralFeature f : parent.eClass().getEAllStructuralFeatures()) {
                                    EClassifier cl = ModelUtils.getTypeArgument((EClass)parent.eClass(), (EGenericType)f.getEGenericType());
                                    if (!cl.isInstance(data)) continue;
                                    feature = f;
                                    break;
                                }
                            }
                        }
                    }
                    if (feature == FragmentPackageImpl.Literals.MODEL_FRAGMENTS__IMPORTS && parent != null) {
                        MApplicationElement el = (MApplicationElement)EcoreUtil.create((EClass)((EObject)data).eClass());
                        el.setElementId(((MApplicationElement)data).getElementId());
                        Command cmd = AddCommand.create((EditingDomain)this.domain, (Object)parent, (Object)feature, (Object)el);
                        if (cmd.canExecute()) {
                            this.domain.getCommandStack().execute(cmd);
                        }
                        return true;
                    }
                    if (feature != null && parent != null && parent.eGet(feature) instanceof List) {
                        Command cmd;
                        List list = (List)parent.eGet(feature);
                        int index = list.indexOf(this.getCurrentTarget());
                        if (index >= list.size()) {
                            index = -1;
                        }
                        if (parent == ((EObject)data).eContainer()) {
                            if (parent instanceof MElementContainer && data instanceof MUIElement) {
                                Util.moveElementByIndex(this.domain, (MUIElement)data, ModelEditor.this.isLiveModel(), index);
                            } else {
                                cmd = MoveCommand.create((EditingDomain)this.domain, (Object)parent, (Object)feature, (Object)data, (int)index);
                                if (cmd.canExecute()) {
                                    this.domain.getCommandStack().execute(cmd);
                                    return true;
                                }
                            }
                        } else {
                            if (parent.eResource() != ((EObject)data).eResource()) {
                                data = EcoreUtil.copy((EObject)((EObject)data));
                            }
                            if ((cmd = AddCommand.create((EditingDomain)this.domain, (Object)parent, (Object)feature, (Object)data, (int)index)).canExecute()) {
                                this.domain.getCommandStack().execute(cmd);
                                if (ModelEditor.this.isLiveModel() && parent instanceof MElementContainer && data instanceof MUIElement) {
                                    ((MElementContainer)parent).setSelectedElement((MUIElement)data);
                                }
                                return true;
                            }
                        }
                    }
                }
            }
            return false;
        }

        public boolean validateDrop(Object target, int operation, TransferData transferType) {
            boolean rv = false;
            if (this.getSelectedObject() instanceof MApplicationElement) {
                TreeItem item;
                if (this.getCurrentLocation() == 3) {
                    rv = this.isValidDrop(target, (MApplicationElement)this.getSelectedObject(), false);
                } else if ((this.getCurrentLocation() == 2 || this.getCurrentLocation() == 1) && (item = (TreeItem)this.getCurrentEvent().item) != null && (item = item.getParentItem()) != null) {
                    rv = this.isValidDrop(item.getData(), (MApplicationElement)this.getSelectedObject(), true);
                }
            }
            return rv;
        }

        private boolean isValidDrop(Object target, MApplicationElement instance, boolean isIndex) {
            if (target instanceof MElementContainer) {
                MElementContainer container = (MElementContainer)target;
                if (isIndex || !container.getChildren().contains(instance)) {
                    EClassifier classifier = ModelUtils.getTypeArgument((EClass)((EObject)container).eClass(), (EGenericType)UiPackageImpl.Literals.ELEMENT_CONTAINER__CHILDREN.getEGenericType());
                    return classifier.isInstance((Object)instance);
                }
            } else if (target instanceof VirtualEntry) {
                VirtualEntry vTarget = (VirtualEntry)target;
                if ((isIndex || !vTarget.getList().contains((Object)instance)) && vTarget.getProperty() instanceof IEMFProperty) {
                    EStructuralFeature feature = ((IEMFProperty)vTarget.getProperty()).getStructuralFeature();
                    EObject parent = (EObject)vTarget.getOriginalParent();
                    EClassifier classifier = ModelUtils.getTypeArgument((EClass)parent.eClass(), (EGenericType)feature.getEGenericType());
                    return classifier.isInstance((Object)instance);
                }
            } else if (target instanceof EObject) {
                EObject eObj = (EObject)target;
                for (EStructuralFeature f : eObj.eClass().getEAllStructuralFeatures()) {
                    EClassifier cl = ModelUtils.getTypeArgument((EClass)eObj.eClass(), (EGenericType)f.getEGenericType());
                    if (!cl.isInstance((Object)instance)) continue;
                    return true;
                }
            }
            return false;
        }
    }

    class ObservableFactoryImpl
    implements IObservableFactory {
        ObservableFactoryImpl() {
        }

        public IObservable createObservable(Object target) {
            if (target instanceof IObservableList) {
                return (IObservable)target;
            }
            if (target instanceof VirtualEntry) {
                return ((VirtualEntry)target).getList();
            }
            AbstractComponentEditor editor = ModelEditor.this.getEditor(((EObject)target).eClass());
            if (editor != null) {
                return editor.getChildList(target);
            }
            return null;
        }
    }

    static class TreeStructureAdvisorImpl
    extends TreeStructureAdvisor {
        TreeStructureAdvisorImpl() {
        }
    }
}

