/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.databinding.viewers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.core.databinding.observable.map.IMapChangeListener;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.map.MapChangeEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.swt.graphics.Image;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObservableMapLabelProvider<T, E>
extends LabelProvider
implements ILabelProvider,
ITableLabelProvider {
    protected IObservableMap<?, ?>[] attributeMaps;
    protected List<IObservableMap<T, E>> attributeMapsList;
    private IMapChangeListener<T, E> mapChangeListener = new IMapChangeListener<T, E>(){

        public void handleMapChange(MapChangeEvent<T, E> event) {
            Set affectedElements = event.diff.getChangedKeys();
            LabelProviderChangedEvent newEvent = new LabelProviderChangedEvent((IBaseLabelProvider)ObservableMapLabelProvider.this, affectedElements.toArray());
            ObservableMapLabelProvider.this.fireLabelProviderChanged(newEvent);
        }
    };

    public ObservableMapLabelProvider(IObservableMap<T, E> attributeMap) {
        this(Collections.singletonList(attributeMap));
    }

    public ObservableMapLabelProvider(IObservableMap<T, E>[] attributeMaps) {
        this(Arrays.asList(attributeMaps));
    }

    public ObservableMapLabelProvider(List<IObservableMap<T, E>> attributeMapsList) {
        this.attributeMapsList = new ArrayList<IObservableMap<IObservableMap, IObservableMap<T, E>>>(attributeMapsList);
        this.attributeMaps = attributeMapsList.toArray(new IObservableMap[attributeMapsList.size()]);
        for (IObservableMap<IObservableMap, E> iObservableMap : attributeMapsList) {
            iObservableMap.addMapChangeListener(this.mapChangeListener);
        }
    }

    public void dispose() {
        for (IObservableMap<T, E> map : this.attributeMapsList) {
            map.removeMapChangeListener(this.mapChangeListener);
        }
        super.dispose();
        this.attributeMapsList = null;
        this.mapChangeListener = null;
    }

    public Image getImage(Object element) {
        return this.getColumnImage(element, 0);
    }

    public String getText(Object element) {
        return this.getColumnText(element, 0);
    }

    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        if (columnIndex < this.attributeMapsList.size()) {
            Object result = this.attributeMapsList.get(columnIndex).get(element);
            return result == null ? "" : result.toString();
        }
        return null;
    }
}

