/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.core.test.unit.internal;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.platform.discovery.core.test.unit.internal.SearchFavoritesControllerTestFixture;
import org.eclipse.platform.discovery.runtime.internal.persistence.MementoContentManagerException;
import org.eclipse.platform.discovery.testutils.utils.jmock.MockObjectTestCase;
import org.eclipse.ui.WorkbenchException;
import org.jmock.core.Constraint;

public class SearchFavoritesControllerDeleteTest
extends MockObjectTestCase {
    private SearchFavoritesControllerTestFixture fixture;
    private Set<Object> itemsToDelete = new HashSet<Object>();

    public void setUp() {
        this.fixture = new SearchFavoritesControllerTestFixture(this);
        this.fixture.favoritesView.expects(this.once()).method("showFavorites").with(this.collectionWithElements(1, new Object[]{this.fixture.expectedObjectToShowInView}));
    }

    public void testFavoriteItemsDelete() {
        this.fixture.persistenceUtil.expects(this.once()).method("deleteItems").with((Constraint)this.same(this.itemsToDelete), (Constraint)this.same(this.fixture.opRunner.proxy()));
        this.fixture.controller.deleteItems(this.itemsToDelete);
    }

    public void testDeleteItemsWithWbExc() {
        WorkbenchException exc = new WorkbenchException("test");
        this.testDeleteWithExceptionFromPersistenceUtil((Exception)exc);
    }

    public void testDeleteItemsWithIOExc() {
        IOException exc = new IOException();
        this.testDeleteWithExceptionFromPersistenceUtil(exc);
    }

    public void testDeleteItemsWithMementoExc() {
        MementoContentManagerException exc = new MementoContentManagerException();
        this.testDeleteWithExceptionFromPersistenceUtil((Exception)((Object)exc));
    }

    private void testDeleteWithExceptionFromPersistenceUtil(Exception exc) {
        this.fixture.persistenceUtil.expects(this.once()).method("deleteItems").withAnyArguments().will(this.throwException(exc));
        this.fixture.errorHandler.expects(this.once()).method("handleException").with((Constraint)this.eq(exc));
        this.fixture.controller.deleteItems(this.itemsToDelete);
    }
}

