/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.ui.test.comp.internal.pageobjects.swtbot.utils;

import java.awt.AWTException;
import java.awt.Robot;
import org.eclipse.platform.discovery.ui.test.comp.internal.pageobjects.swtbot.utils.LocationUtils;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.swtbot.swt.finder.finders.UIThreadRunnable;
import org.eclipse.swtbot.swt.finder.results.VoidResult;
import org.eclipse.swtbot.swt.finder.utils.SWTUtils;
import org.eclipse.swtbot.swt.finder.widgets.AbstractSWTBot;

public class MouseUtils {
    private static final int MOVE_TO_WIDGET_OFFSET = 2;
    private static final long HOVER_TIMEOUT = 2000L;
    private final Display display;

    public MouseUtils(Display display) {
        this.display = display;
    }

    public void moveMouseTo(AbstractSWTBot<? extends Widget> widget) {
        this.moveMouseTo(widget, 2, 2);
    }

    public void moveMouseTo(AbstractSWTBot<? extends Widget> widget, int x_offset, int y_offset) {
        Point targetPoint = this.topLeftCorner(widget);
        this.moveMouseTo(new Point(targetPoint.x + x_offset, targetPoint.y + y_offset));
    }

    private void moveMouseTo(final Point point) {
        final Robot awtRobot = this.awtRobot();
        this.syncExec(new VoidResult(){

            public void run() {
                awtRobot.mouseMove(point.x, point.y);
            }
        });
        this.forceAsynchronousEventsToBeProcessed();
    }

    public void clickOn(AbstractSWTBot<? extends Widget> widget) {
        this.moveMouseTo(widget);
        this.click();
    }

    public void clickOn(AbstractSWTBot<? extends Widget> widget, int x_offset, int y_offset) {
        this.moveMouseTo(widget, x_offset, y_offset);
        this.click();
    }

    public void hoverOn(AbstractSWTBot<? extends Widget> widget) {
        this.moveMouseTo(widget);
        SWTUtils.sleep((long)2000L);
    }

    public void moveAwayFrom(AbstractSWTBot<? extends Widget> widget) {
        Rectangle widgetLocation = this.location(widget);
        int targetX = widgetLocation.x > 2 ? widgetLocation.x - 2 : widgetLocation.x + widgetLocation.width + 2;
        int targetY = widgetLocation.y > 2 ? widgetLocation.y - 2 : widgetLocation.y + widgetLocation.height + 2;
        this.moveMouseTo(new Point(targetX, targetY));
    }

    public void click() {
        final Robot awtRobot = this.awtRobot();
        this.syncExec(new VoidResult(){

            public void run() {
                awtRobot.mousePress(16);
                awtRobot.mouseRelease(16);
            }
        });
        this.forceAsynchronousEventsToBeProcessed();
    }

    private Robot awtRobot() {
        try {
            return new Robot();
        }
        catch (AWTException e) {
            throw new RuntimeException(e);
        }
    }

    private Point topLeftCorner(AbstractSWTBot<? extends Widget> widget) {
        Rectangle widgetLocation = this.location(widget);
        return new Point(widgetLocation.x, widgetLocation.y);
    }

    private Rectangle location(AbstractSWTBot<? extends Widget> widget) {
        return LocationUtils.absoluteLocation(widget);
    }

    private void syncExec(VoidResult toExecute) {
        UIThreadRunnable.syncExec((Display)this.display, (VoidResult)toExecute);
    }

    void forceAsynchronousEventsToBeProcessed() {
        this.display.syncExec(new Runnable(){

            @Override
            public void run() {
            }
        });
    }
}

