/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.ui.internal.view.impl;

import org.eclipse.platform.discovery.core.internal.IPropertyControl;
import org.eclipse.platform.discovery.ui.internal.view.IGetControlObject;
import org.eclipse.platform.discovery.util.internal.property.IPropertyAttributeListener;
import org.eclipse.platform.discovery.util.internal.property.Property;
import org.eclipse.platform.discovery.util.internal.property.PropertyAttributeChangedEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class TextControl
implements IPropertyControl<String>,
IGetControlObject<Text> {
    private final Property<String> textValue;
    private final Property<String> messageValue;
    private final Text text;
    private final Label associatedLabel;

    public TextControl(Text text, Label associatedLabel) {
        this.text = text;
        this.associatedLabel = associatedLabel;
        this.textValue = new Property();
        this.messageValue = new Property();
        this.messageValue.set((Object)"");
        this.messageValue.registerValueListener((IPropertyAttributeListener)new MessageChangeListener(){}, false);
        this.textValue.set((Object)text.getText());
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!TextControl.this.text.isEnabled()) {
                    return;
                }
                TextControl.this.textValue.set((Object)TextControl.this.text.getText());
            }
        });
    }

    public String get() {
        return this.text.getText();
    }

    public void set(String value) {
        this.text.setText(value);
    }

    public boolean isEnabled() {
        return this.text.isEnabled();
    }

    public void setEnabled(boolean enabled) {
        this.text.setEnabled(enabled);
        this.associatedLabel.setEnabled(enabled);
        if (enabled) {
            this.text.setText(enabled ? (String)this.textValue.get() : "");
            this.text.setMessage((String)this.messageValue.get());
        } else {
            this.text.setText((String)this.messageValue.get());
            this.text.setMessage("");
        }
    }

    @Override
    public Text getControl() {
        return this.text;
    }

    public void setMessage(String message) {
        this.messageValue.set((Object)message);
    }

    private class MessageChangeListener
    implements IPropertyAttributeListener<String> {
        private MessageChangeListener() {
        }

        public void attributeChanged(PropertyAttributeChangedEvent<String> event) {
            if (TextControl.this.text.isEnabled()) {
                TextControl.this.text.setMessage((String)event.getNewAttribute());
            } else {
                TextControl.this.text.setText((String)event.getNewAttribute());
            }
        }
    }
}

