/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.ui.internal.util;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;

public class ControlBackgroundImageManager {
    private final Control control;
    private final StatefulImageFactory imageFactory;

    public ControlBackgroundImageManager(Control control) {
        this.control = control;
        this.imageFactory = new StatefulImageFactory();
    }

    public void setBackground(Color color) {
        this.control.setBackgroundImage(this.createSolidColourImage(color));
    }

    public void setBackgroundGradient(Color foreground, Color background, boolean vertical) {
        this.control.setBackgroundImage(this.createGradientImage(foreground, background, vertical));
    }

    private Image createSolidColourImage(Color color) {
        Rectangle rectangle = this.control.getBounds();
        Image img = this.imageFactory.createNewImage(rectangle);
        if (img != null) {
            GC graphic = new GC((Drawable)img);
            try {
                graphic.setBackground(color);
                graphic.fillRectangle(0, 0, rectangle.width, rectangle.height);
            }
            finally {
                graphic.dispose();
            }
        }
        return img;
    }

    private Image createGradientImage(Color foreground, Color background, boolean vertical) {
        Rectangle rectangle = this.control.getBounds();
        Image img = this.imageFactory.createNewImage(rectangle);
        if (img != null) {
            GC graphic = new GC((Drawable)img);
            try {
                graphic.setForeground(foreground);
                graphic.setBackground(background);
                graphic.fillGradientRectangle(0, 0, rectangle.width, rectangle.height, vertical);
            }
            finally {
                graphic.dispose();
            }
        }
        return img;
    }

    public void disposeResources() {
        this.imageFactory.disposeImage();
    }

    private class StatefulImageFactory {
        private Image _img;

        private StatefulImageFactory() {
        }

        public Image createNewImage(Rectangle rectangle) {
            Image oldImage = this._img;
            if (oldImage != null && !oldImage.isDisposed()) {
                oldImage.dispose();
            }
            this._img = this.shouldDrawImage(rectangle) ? new Image((Device)ControlBackgroundImageManager.this.control.getDisplay(), rectangle.width, rectangle.height) : null;
            return this._img;
        }

        private boolean shouldDrawImage(Rectangle rectangle) {
            return rectangle.height != 0 && rectangle.width != 0;
        }

        public void disposeImage() {
            if (this._img != null && !this._img.isDisposed()) {
                this._img.dispose();
            }
        }
    }
}

