/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.databinding.observable.set;

import java.util.HashSet;
import java.util.List;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.list.IListChangeListener;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.ListChangeEvent;
import org.eclipse.core.databinding.observable.list.ListDiff;
import org.eclipse.core.databinding.observable.list.ListDiffEntry;
import org.eclipse.core.databinding.observable.set.ObservableSet;
import org.eclipse.core.databinding.observable.set.SetDiff;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListToSetAdapter<E>
extends ObservableSet<E> {
    private final IObservableList<E> list;
    private IListChangeListener<E> listener = new IListChangeListener<E>(){

        @Override
        public void handleListChange(ListChangeEvent<E> event) {
            SetDiff newDiff = this.createSetDiff(event.diff);
            ListToSetAdapter.this.fireSetChange(newDiff);
        }

        private <E2 extends E> SetDiff<E2> createSetDiff(ListDiff<E2> diff) {
            HashSet<E2> added = new HashSet<E2>();
            HashSet<E2> removed = new HashSet<E2>();
            List<ListDiffEntry<E2>> differences = diff.getDifferencesAsList();
            for (ListDiffEntry<E2> entry : differences) {
                E2 element = entry.getElement();
                if (entry.isAddition()) {
                    if (!ListToSetAdapter.this.wrappedSet.add(element) || removed.remove(element)) continue;
                    added.add(element);
                    continue;
                }
                if (!ListToSetAdapter.this.wrappedSet.remove(element)) continue;
                removed.add(element);
                added.remove(element);
            }
            return Diffs.createSetDiff(added, removed);
        }
    };

    public ListToSetAdapter(IObservableList<E> list) {
        super(list.getRealm(), new HashSet(), list.getElementType());
        this.list = list;
        this.wrappedSet.addAll(list);
        this.list.addListChangeListener(this.listener);
    }

    @Override
    public synchronized void dispose() {
        super.dispose();
        if (this.list != null && this.listener != null) {
            this.list.removeListChangeListener(this.listener);
            this.listener = null;
        }
    }
}

