/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.databinding.observable.list;

import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.list.ListDiff;
import org.eclipse.core.databinding.observable.list.ListDiffEntry;
import org.eclipse.core.databinding.observable.list.ObservableList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WritableList<E>
extends ObservableList<E> {
    public WritableList() {
        this(Realm.getDefault());
    }

    public WritableList(Realm realm) {
        this(realm, (List<E>)new ArrayList(), (Class<E>)null);
    }

    public WritableList(List<E> toWrap, Object elementType) {
        this(Realm.getDefault(), toWrap, elementType);
    }

    public WritableList(List<E> toWrap, Class<E> elementType) {
        this(Realm.getDefault(), toWrap, elementType);
    }

    public WritableList(Collection<E> collection, Object elementType) {
        this(Realm.getDefault(), (List<E>)new ArrayList<E>(collection), elementType);
    }

    public WritableList(Collection<E> collection, Class<E> elementType) {
        this(Realm.getDefault(), (List<E>)new ArrayList<E>(collection), elementType);
    }

    public WritableList(Realm realm, List<E> toWrap, Object elementType) {
        super(realm, toWrap, elementType);
    }

    public WritableList(Realm realm, List<E> toWrap, Class<E> elementType) {
        super(realm, toWrap, elementType);
    }

    public WritableList(Realm realm, Collection<E> collection, Object elementType) {
        super(realm, new ArrayList<E>(collection), elementType);
    }

    public WritableList(Realm realm, Collection<E> collection, Class<E> elementType) {
        super(realm, new ArrayList<E>(collection), elementType);
    }

    @Override
    public E set(int index, E element) {
        this.checkRealm();
        E oldElement = this.wrappedList.set(index, element);
        this.fireListChange(Diffs.createListDiff(Diffs.createListDiffEntry(index, false, oldElement), Diffs.createListDiffEntry(index, true, element)));
        return oldElement;
    }

    @Override
    public E move(int oldIndex, int newIndex) {
        this.checkRealm();
        int size = this.wrappedList.size();
        if (oldIndex < 0 || oldIndex >= size) {
            throw new IndexOutOfBoundsException("oldIndex: " + oldIndex + ", size:" + size);
        }
        if (newIndex < 0 || newIndex >= size) {
            throw new IndexOutOfBoundsException("newIndex: " + newIndex + ", size:" + size);
        }
        if (oldIndex == newIndex) {
            return this.wrappedList.get(oldIndex);
        }
        Object element = this.wrappedList.remove(oldIndex);
        this.wrappedList.add(newIndex, element);
        this.fireListChange(Diffs.createListDiff(Diffs.createListDiffEntry(oldIndex, false, element), Diffs.createListDiffEntry(newIndex, true, element)));
        return element;
    }

    @Override
    public E remove(int index) {
        this.checkRealm();
        Object oldElement = this.wrappedList.remove(index);
        this.fireListChange(Diffs.createListDiff(Diffs.createListDiffEntry(index, false, oldElement)));
        return oldElement;
    }

    @Override
    public boolean add(E element) {
        this.checkRealm();
        boolean added = this.wrappedList.add(element);
        if (added) {
            this.fireListChange(Diffs.createListDiff(Diffs.createListDiffEntry(this.wrappedList.size() - 1, true, element)));
        }
        return added;
    }

    @Override
    public void add(int index, E element) {
        this.checkRealm();
        this.wrappedList.add(index, element);
        this.fireListChange(Diffs.createListDiff(Diffs.createListDiffEntry(index, true, element)));
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        this.checkRealm();
        ArrayList<ListDiffEntry<ListDiffEntry<E>>> entries = new ArrayList<ListDiffEntry<ListDiffEntry<E>>>(c.size());
        int addIndex = this.wrappedList.size();
        for (E element : c) {
            entries.add(Diffs.createListDiffEntry(addIndex++, true, element));
        }
        boolean added = this.wrappedList.addAll(c);
        this.fireListChange(Diffs.createListDiff(entries));
        return added;
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        this.checkRealm();
        ArrayList<ListDiffEntry<ListDiffEntry<E>>> entries = new ArrayList<ListDiffEntry<ListDiffEntry<E>>>(c.size());
        int addIndex = index;
        for (E element : c) {
            entries.add(Diffs.createListDiffEntry(addIndex++, true, element));
        }
        boolean added = this.wrappedList.addAll(index, c);
        this.fireListChange(Diffs.createListDiff(entries));
        return added;
    }

    @Override
    public boolean remove(Object o) {
        this.checkRealm();
        int index = this.wrappedList.indexOf(o);
        if (index == -1) {
            return false;
        }
        Object typedO = this.wrappedList.get(index);
        this.wrappedList.remove(index);
        this.fireListChange(Diffs.createListDiff(Diffs.createListDiffEntry(index, false, typedO)));
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        this.checkRealm();
        ArrayList entries = new ArrayList();
        for (Object element : c) {
            int removeIndex = this.wrappedList.indexOf(element);
            if (removeIndex == -1) continue;
            Object removedElement = this.wrappedList.get(removeIndex);
            entries.add(Diffs.createListDiffEntry(removeIndex, false, removedElement));
        }
        this.wrappedList.removeAll(c);
        if (entries.size() > 0) {
            this.fireListChange(Diffs.createListDiff(entries));
        }
        return entries.size() > 0;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        this.checkRealm();
        ArrayList entries = new ArrayList();
        int removeIndex = 0;
        Iterator it = this.wrappedList.iterator();
        while (it.hasNext()) {
            Object element = it.next();
            if (!c.contains(element)) {
                entries.add(Diffs.createListDiffEntry(removeIndex, false, element));
                it.remove();
                continue;
            }
            ++removeIndex;
        }
        if (entries.size() > 0) {
            this.fireListChange(Diffs.createListDiff(entries));
        }
        return entries.size() > 0;
    }

    @Override
    public void clear() {
        this.checkRealm();
        if (this.wrappedList.isEmpty()) {
            return;
        }
        ArrayList entries = new ArrayList(this.wrappedList.size());
        ListIterator it = this.wrappedList.listIterator(this.wrappedList.size());
        while (it.hasPrevious()) {
            int elementIndex = it.previousIndex();
            Object element = it.previous();
            entries.add(Diffs.createListDiffEntry(elementIndex, false, element));
        }
        this.wrappedList.clear();
        this.fireListChange(Diffs.createListDiff(entries));
    }

    @Override
    public Iterator<E> iterator() {
        this.getterCalled();
        final List list = this.wrappedList;
        final ListIterator wrappedIterator = list.listIterator();
        return new Iterator<E>(){
            E last = null;

            @Override
            public boolean hasNext() {
                WritableList.this.getterCalled();
                this.checkForComodification();
                return wrappedIterator.hasNext();
            }

            @Override
            public E next() {
                WritableList.this.getterCalled();
                this.checkForComodification();
                this.last = wrappedIterator.next();
                return this.last;
            }

            @Override
            public void remove() {
                WritableList.this.checkRealm();
                this.checkForComodification();
                int index = wrappedIterator.previousIndex();
                wrappedIterator.remove();
                ListDiff diff = Diffs.createListDiff(Diffs.createListDiffEntry(index, false, this.last));
                WritableList.this.fireListChange(diff);
            }

            private void checkForComodification() {
                if (list != WritableList.this.wrappedList) {
                    throw new ConcurrentModificationException();
                }
            }
        };
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.listIterator(0);
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        this.getterCalled();
        final List list = this.wrappedList;
        final ListIterator wrappedIterator = list.listIterator(index);
        return new ListIterator<E>(){
            int lastIndex = -1;
            E last = null;

            @Override
            public void add(E o) {
                WritableList.this.checkRealm();
                this.checkForComodification();
                wrappedIterator.add(o);
                this.lastIndex = this.previousIndex();
                ListDiff diff = Diffs.createListDiff(Diffs.createListDiffEntry(this.lastIndex, true, o));
                WritableList.this.fireListChange(diff);
            }

            @Override
            public boolean hasNext() {
                WritableList.this.getterCalled();
                this.checkForComodification();
                return wrappedIterator.hasNext();
            }

            @Override
            public boolean hasPrevious() {
                WritableList.this.getterCalled();
                this.checkForComodification();
                return wrappedIterator.hasPrevious();
            }

            @Override
            public E next() {
                WritableList.this.getterCalled();
                this.checkForComodification();
                this.last = wrappedIterator.next();
                this.lastIndex = this.previousIndex();
                return this.last;
            }

            @Override
            public int nextIndex() {
                WritableList.this.getterCalled();
                this.checkForComodification();
                return wrappedIterator.nextIndex();
            }

            @Override
            public E previous() {
                WritableList.this.getterCalled();
                this.checkForComodification();
                this.last = wrappedIterator.previous();
                this.lastIndex = this.nextIndex();
                return this.last;
            }

            @Override
            public int previousIndex() {
                WritableList.this.getterCalled();
                this.checkForComodification();
                return wrappedIterator.previousIndex();
            }

            @Override
            public void remove() {
                WritableList.this.checkRealm();
                this.checkForComodification();
                wrappedIterator.remove();
                ListDiff diff = Diffs.createListDiff(Diffs.createListDiffEntry(this.lastIndex, false, this.last));
                this.lastIndex = -1;
                WritableList.this.fireListChange(diff);
            }

            @Override
            public void set(E o) {
                WritableList.this.checkRealm();
                this.checkForComodification();
                wrappedIterator.set(o);
                ListDiff diff = Diffs.createListDiff(Diffs.createListDiffEntry(this.lastIndex, false, this.last), Diffs.createListDiffEntry(this.lastIndex, true, o));
                this.last = o;
                WritableList.this.fireListChange(diff);
            }

            private void checkForComodification() {
                if (list != WritableList.this.wrappedList) {
                    throw new ConcurrentModificationException();
                }
            }
        };
    }

    public static WritableList<Object> withElementType(Object elementType) {
        return new WritableList<Object>(Realm.getDefault(), (List<Object>)new ArrayList(), elementType);
    }

    public static <E> WritableList<E> withElementType(Class<E> elementType) {
        return new WritableList(Realm.getDefault(), new ArrayList(), elementType);
    }
}

