/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.databinding.property.set;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.set.SetDiff;
import org.eclipse.core.databinding.property.INativePropertyListener;
import org.eclipse.core.databinding.property.ISimplePropertyListener;
import org.eclipse.core.databinding.property.set.SetProperty;
import org.eclipse.core.internal.databinding.property.set.SimplePropertyObservableSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SimpleSetProperty<S, E>
extends SetProperty<S, E> {
    @Override
    public IObservableSet<E> observe(Realm realm, S source) {
        return new SimplePropertyObservableSet(realm, source, this);
    }

    @Override
    protected abstract Set<E> doGetSet(S var1);

    public final void setSet(S source, Set<E> set, SetDiff<E> diff) {
        if (source != null && !diff.isEmpty()) {
            this.doSetSet(source, set, diff);
        }
    }

    protected abstract void doSetSet(S var1, Set<E> var2, SetDiff<E> var3);

    @Override
    protected void doSetSet(S source, Set<E> set) {
        SetDiff diff = Diffs.computeLazySetDiff(this.doGetSet(source), set);
        this.doSetSet(source, set, diff);
    }

    @Override
    protected void doUpdateSet(S source, SetDiff<E> diff) {
        HashSet<E> set = new HashSet<E>(this.doGetSet(source));
        diff.applyTo(set);
        this.doSetSet(source, set, diff);
    }

    public abstract INativePropertyListener<S> adaptListener(ISimplePropertyListener<SetDiff<E>> var1);
}

