/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.databinding.conversion;

import com.ibm.icu.text.NumberFormat;
import org.eclipse.core.databinding.conversion.Converter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntegerToStringConverter
extends Converter<Object, Object> {
    private final boolean primitive;
    private final NumberFormat numberFormat;
    private final Class<?> boxedType;

    private IntegerToStringConverter(NumberFormat numberFormat, Class<?> fromType, Class<?> boxedType) {
        super(fromType, String.class);
        this.primitive = fromType.isPrimitive();
        this.numberFormat = numberFormat;
        this.boxedType = boxedType;
    }

    @Override
    public Object convert(Object fromObject) {
        if (fromObject == null && !this.primitive) {
            return "";
        }
        if (!this.boxedType.isInstance(fromObject)) {
            throw new IllegalArgumentException("'fromObject' is not of type [" + this.boxedType + "].");
        }
        return this.numberFormat.format(((Number)fromObject).longValue());
    }

    public static IntegerToStringConverter fromShort(boolean primitive) {
        return IntegerToStringConverter.fromShort(NumberFormat.getIntegerInstance(), primitive);
    }

    public static IntegerToStringConverter fromShort(NumberFormat numberFormat, boolean primitive) {
        return new IntegerToStringConverter(numberFormat, primitive ? Short.TYPE : Short.class, Short.class);
    }

    public static IntegerToStringConverter fromByte(boolean primitive) {
        return IntegerToStringConverter.fromByte(NumberFormat.getIntegerInstance(), primitive);
    }

    public static IntegerToStringConverter fromByte(NumberFormat numberFormat, boolean primitive) {
        return new IntegerToStringConverter(numberFormat, primitive ? Byte.TYPE : Byte.class, Byte.class);
    }
}

