/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.databinding.provisional.bind;

import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.internal.databinding.provisional.bind.IOneWayModelBinding;
import org.eclipse.core.internal.databinding.provisional.bind.ITargetBinding;
import org.eclipse.core.internal.databinding.provisional.bind.OneWayBinding;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OneWayConversionBinding<T2, T1>
extends OneWayBinding<T2>
implements ITargetBinding<T1> {
    private final IOneWayModelBinding<T1> modelBinding;
    private final IConverter<T1, T2> converter;

    public OneWayConversionBinding(IOneWayModelBinding<T1> modelBinding, IConverter<T1, T2> converter) {
        this.modelBinding = modelBinding;
        this.converter = converter;
    }

    @Override
    public T2 getModelValue() {
        T1 modelValue = this.modelBinding.getModelValue();
        return this.converter.convert(modelValue);
    }

    @Override
    public void setTargetValue(T1 valueOnModelSide) {
        T2 valueOnTargetSide = this.converter.convert(valueOnModelSide);
        this.targetBinding.setTargetValue(valueOnTargetSide);
    }

    @Override
    public void removeModelListener() {
        this.modelBinding.removeModelListener();
    }
}

