/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources.semantic;

import org.eclipse.core.internal.resources.semantic.Messages;
import org.eclipse.core.resources.semantic.ISemanticResourceInfo;
import org.eclipse.core.resources.semantic.spi.ISemanticSpiResourceInfo;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.osgi.util.NLS;

public class SemanticResourceInfo
implements ISemanticResourceInfo {
    private final ISemanticSpiResourceInfo info;
    private final boolean isLocalOnly;
    private final int options;

    SemanticResourceInfo(int options, ISemanticSpiResourceInfo info, boolean isLocalOnly) {
        this.options = options;
        this.isLocalOnly = isLocalOnly;
        this.info = info;
    }

    public boolean isLocalOnly() {
        this.assertCorrectOption(8);
        return this.isLocalOnly;
    }

    public String getRemoteURIString() {
        return this.info.getRemoteUriString();
    }

    public String getContentType() throws CoreException {
        return this.info.getContentType();
    }

    public boolean isReadOnly() {
        return this.info.isReadOnly();
    }

    public boolean isLocked() {
        return this.info.isLocked();
    }

    public boolean isLockingSupported() throws CoreException {
        return this.info.isLockingSupported();
    }

    public boolean existsRemotely() {
        return this.info.existsRemotely();
    }

    private void assertCorrectOption(int option) {
        boolean ok;
        boolean bl = ok = this.options == 0 || (this.options & option) > 0;
        if (!ok) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.SemanticResourceInfo_OptionNotSpecified_XMSG, (Object)option));
        }
    }
}

