/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.internal.languages.javascript;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.e4.internal.languages.javascript.JSBundleImpl;
import org.eclipse.e4.internal.languages.javascript.JSVersionRange;

public class JSRequireBundle {
    private String name;
    private Map attributes = new HashMap();
    private Map directives = new HashMap();
    private boolean optional = false;
    private JSVersionRange bundleVersionRange = JSVersionRange.emptyRange;
    private JSBundleImpl wiredBundle;

    public JSRequireBundle(String header) {
        if (header == null) {
            throw new IllegalArgumentException("header cannot be null");
        }
        this.parseRequire(header);
    }

    private void parseRequire(String header) {
        StringTokenizer tokenizer = new StringTokenizer(header, ";");
        this.name = tokenizer.nextToken().trim();
        while (tokenizer.hasMoreTokens()) {
            String token = (String)tokenizer.nextElement();
            if (token.indexOf(":=") != -1) {
                this.parseDirective(token);
                continue;
            }
            if (token.indexOf("=") == -1) continue;
            this.parseAttribute(token);
        }
    }

    private void parseAttribute(String token) {
        int index = token.indexOf("=");
        String attributeName = token.substring(0, index).trim();
        if (attributeName.length() == 0) {
            return;
        }
        String value = token.substring(index + "=".length()).trim();
        if (attributeName.equals("bundle-version")) {
            this.bundleVersionRange = new JSVersionRange(value);
        }
        this.attributes.put(attributeName, value);
    }

    private void parseDirective(String token) {
        int index = token.indexOf(":=");
        String directiveName = token.substring(0, index).trim();
        if (directiveName.length() == 0) {
            return;
        }
        String value = token.substring(index + ":=".length()).trim();
        if (directiveName.equals("resolution")) {
            this.optional = "optional".equals(value);
        }
        this.directives.put(directiveName, value);
    }

    public boolean isOptional() {
        return this.optional;
    }

    public String getName() {
        return this.name;
    }

    public JSVersionRange getBundleVersionRange() {
        return this.bundleVersionRange;
    }

    public Map getAttributes() {
        return this.attributes;
    }

    public Map getDirectives() {
        return this.directives;
    }

    public boolean wire(JSBundleImpl candidate) {
        if (!this.name.equals(candidate.getSymbolicName())) {
            return false;
        }
        Iterator iterator = this.attributes.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String key = (String)entry.getKey();
            if (!key.equals("bundle-version") || this.bundleVersionRange.isIncluded(candidate.getVersion())) continue;
            return false;
        }
        this.wiredBundle = candidate;
        return true;
    }

    public JSBundleImpl getWiredBundle() {
        return this.wiredBundle;
    }

    public void unwire() {
        this.wiredBundle = null;
    }
}

