/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.internal.languages.javascript;

import org.osgi.framework.Version;

public class JSVersionRange {
    private static final Version versionMax = new Version(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
    public static final JSVersionRange emptyRange = new JSVersionRange(null);
    private final Version minVersion;
    private final boolean includeMin;
    private final Version maxVersion;
    private final boolean includeMax;

    public JSVersionRange(Version minVersion, boolean includeMin, Version maxVersion, boolean includeMax) {
        this.minVersion = minVersion;
        this.includeMin = includeMin;
        this.maxVersion = maxVersion;
        this.includeMax = includeMax;
    }

    public JSVersionRange(String versionRange) {
        if (versionRange == null || versionRange.length() == 0) {
            this.minVersion = Version.emptyVersion;
            this.includeMin = true;
            this.maxVersion = versionMax;
            this.includeMax = true;
            return;
        }
        if ((versionRange = versionRange.trim()).charAt(0) == '[' || versionRange.charAt(0) == '(') {
            int comma = versionRange.indexOf(44);
            if (comma < 0) {
                throw new IllegalArgumentException();
            }
            char last = versionRange.charAt(versionRange.length() - 1);
            if (last != ']' && last != ')') {
                throw new IllegalArgumentException();
            }
            this.minVersion = Version.parseVersion((String)versionRange.substring(1, comma).trim());
            this.includeMin = versionRange.charAt(0) == '[';
            this.maxVersion = Version.parseVersion((String)versionRange.substring(comma + 1, versionRange.length() - 1).trim());
            this.includeMax = last == ']';
        } else {
            this.minVersion = Version.parseVersion((String)versionRange.trim());
            this.includeMin = true;
            this.maxVersion = versionMax;
            this.includeMax = true;
        }
    }

    public Version getMinimum() {
        return this.minVersion;
    }

    public boolean getIncludeMinimum() {
        return this.includeMin;
    }

    public Version getMaximum() {
        return this.maxVersion;
    }

    public boolean getIncludeMaximum() {
        return this.includeMax;
    }

    public boolean isIncluded(Version version) {
        int maxCheck;
        Version minRequired = this.getMinimum();
        if (minRequired == null) {
            return true;
        }
        if (version == null) {
            return false;
        }
        Version maxRequired = this.getMaximum() == null ? versionMax : this.getMaximum();
        int minCheck = this.includeMin ? 0 : 1;
        int n = maxCheck = this.includeMax ? 0 : -1;
        return version.compareTo(minRequired) >= minCheck && version.compareTo(maxRequired) <= maxCheck;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        if (!(object instanceof JSVersionRange)) {
            return false;
        }
        JSVersionRange vr = (JSVersionRange)object;
        if (this.minVersion == null || vr.getMinimum() == null) return this.minVersion == vr.getMinimum();
        if (!this.minVersion.equals((Object)vr.getMinimum()) || this.includeMin != vr.includeMin) return false;
        if (this.maxVersion == null || vr.getMaximum() == null) return this.maxVersion == vr.getMaximum();
        if (!this.maxVersion.equals((Object)vr.getMaximum()) || this.includeMax != vr.includeMax) return false;
        return true;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.maxVersion != null ? this.maxVersion.hashCode() : versionMax.hashCode());
        result = 31 * result + (this.minVersion != null ? this.minVersion.hashCode() : Version.emptyVersion.hashCode());
        result = 31 * result + (this.includeMax ? 1231 : 1237);
        result = 31 * result + (this.includeMin ? 1231 : 1237);
        return result;
    }

    public String toString() {
        if (this.minVersion == null) {
            return Version.emptyVersion.toString();
        }
        if (versionMax.equals((Object)this.maxVersion)) {
            return this.minVersion.toString();
        }
        StringBuffer result = new StringBuffer();
        result.append(this.includeMin ? (char)'[' : '(');
        result.append(this.minVersion);
        result.append(',');
        result.append(this.maxVersion);
        result.append(this.includeMax ? (char)']' : ')');
        return result.toString();
    }
}

