/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.emf.ui.internal.common.xml;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.e4.tools.emf.ui.common.IModelResource;
import org.eclipse.e4.ui.internal.workbench.E4XMIResource;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocumentListener;
import org.xml.sax.InputSource;

public class EMFDocumentResourceMediator {
    private IModelResource modelResource;
    private Document document;
    private boolean updateFromEMF;
    private List<Resource.Diagnostic> errorList = new ArrayList<Resource.Diagnostic>();
    private Runnable documentValidationChanged;

    public EMFDocumentResourceMediator(final IModelResource modelResource) {
        this.modelResource = modelResource;
        this.document = new Document();
        this.document.addDocumentListener(new IDocumentListener(){

            public void documentChanged(DocumentEvent event) {
                block4: {
                    if (EMFDocumentResourceMediator.this.updateFromEMF) {
                        return;
                    }
                    String doc = EMFDocumentResourceMediator.this.document.get();
                    E4XMIResource res = new E4XMIResource();
                    try {
                        res.load(new InputSource(new StringReader(doc)), null);
                        modelResource.replaceRoot((EObject)res.getContents().get(0));
                        EMFDocumentResourceMediator.this.errorList.clear();
                        if (EMFDocumentResourceMediator.this.documentValidationChanged != null) {
                            EMFDocumentResourceMediator.this.documentValidationChanged.run();
                        }
                    }
                    catch (IOException iOException) {
                        EMFDocumentResourceMediator.this.errorList = (List)res.getErrors();
                        if (EMFDocumentResourceMediator.this.documentValidationChanged == null) break block4;
                        EMFDocumentResourceMediator.this.documentValidationChanged.run();
                    }
                }
            }

            public void documentAboutToBeChanged(DocumentEvent event) {
            }
        });
        this.updateFromEMF();
    }

    public void setValidationChangedCallback(Runnable runnable) {
        this.documentValidationChanged = runnable;
    }

    public List<Resource.Diagnostic> getErrorList() {
        return Collections.unmodifiableList(this.errorList);
    }

    public void updateFromEMF() {
        try {
            this.updateFromEMF = true;
            this.document.set(this.toXMI((EObject)this.modelResource.getRoot().get(0)));
        }
        finally {
            this.updateFromEMF = false;
        }
    }

    public Document getDocument() {
        return this.document;
    }

    private String toXMI(EObject root) {
        E4XMIResource resource = (E4XMIResource)root.eResource();
        StringWriter writer = new StringWriter();
        try {
            resource.save((Writer)writer, null);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return writer.toString();
    }
}

