/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.event.spy.internal.ui;

import java.util.ArrayList;
import org.eclipse.core.databinding.beans.PojoObservables;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.masterdetail.IObservableFactory;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.e4.tools.event.spy.internal.model.CapturedEvent;
import org.eclipse.e4.tools.event.spy.internal.model.IEventItem;
import org.eclipse.e4.tools.event.spy.internal.model.ItemToFilter;
import org.eclipse.e4.tools.event.spy.internal.ui.ICapturedEventTreeListener;
import org.eclipse.e4.tools.event.spy.internal.util.JDTUtils;
import org.eclipse.jface.databinding.viewers.ObservableListTreeContentProvider;
import org.eclipse.jface.databinding.viewers.ObservableMapLabelProvider;
import org.eclipse.jface.databinding.viewers.TreeStructureAdvisor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;

public class CapturedEventTree
extends TreeViewer {
    private ICapturedEventTreeListener listener;
    private WritableList capturedEvents;
    private Clipboard clipboard;
    private TreeItemCursor treeItemCursor;
    private TreeItemForeground treeItemForeground;
    private TreeItemBackground treeItemBackground;
    private TreeItemFont treeItemFont;
    private SelectedTreeItem selectedClassNameTreeItem;
    private SelectedTreeItem selectedTreeItem;

    public CapturedEventTree(Composite parent) {
        super(parent, 68352);
        this.getTree().setHeaderVisible(true);
        this.getTree().setLinesVisible(true);
        TreeColumn column = new TreeColumn(this.getTree(), 16384);
        column.setText(ItemToFilter.Topic.toString());
        column.setWidth(350);
        column = new TreeColumn(this.getTree(), 16384);
        column.setText(ItemToFilter.Publisher.toString());
        column.setWidth(150);
        column = new TreeColumn(this.getTree(), 16384);
        column.setText(ItemToFilter.ChangedElement.toString());
        column.setWidth(150);
        ObservableListTreeContentProvider contentProvider = new ObservableListTreeContentProvider((IObservableFactory)new CapturedEventsObservableFactory(), (TreeStructureAdvisor)new CapturedEventsTreeStructureAdvisor());
        this.setContentProvider((IContentProvider)contentProvider);
        IObservableMap[] attributes = PojoObservables.observeMaps((IObservableSet)contentProvider.getKnownElements(), IEventItem.class, (String[])new String[]{"name", "param1", "param2"});
        this.setLabelProvider((IBaseLabelProvider)new ObservableMapLabelProvider(attributes));
        this.capturedEvents = new WritableList(new ArrayList(), CapturedEvent.class);
        this.setInput(this.capturedEvents);
        this.clipboard = new Clipboard(this.getTree().getDisplay());
        this.createTreeItemResources();
        this.addTreeEventListeners();
    }

    private void createTreeItemResources() {
        Display display = this.getTree().getDisplay();
        this.treeItemCursor = new TreeItemCursor(this.getTree().getCursor(), display.getSystemCursor(21));
        this.treeItemForeground = new TreeItemForeground(new Color((Device)display, new RGB(0, 0, 120)), display.getSystemColor(27), display.getSystemColor(2));
        this.treeItemBackground = new TreeItemBackground(display.getSystemColor(26), this.getTree().getBackground());
        Font currentFont = this.getTree().getFont();
        FontData currentFontData = currentFont.getFontData()[0];
        this.treeItemFont = new TreeItemFont(currentFont, new Font((Device)display, currentFontData.getName(), currentFontData.getHeight(), 2));
        this.selectedClassNameTreeItem = new SelectedTreeItem(){

            public void clear() {
                CapturedEventTree.this.redrawTreeItem(this.getTreeItem(), this.getColumnIndex());
                super.clear();
                Tree tree = CapturedEventTree.this.getTree();
                if (tree.getCursor() != CapturedEventTree.this.treeItemCursor.getDefaultCursor()) {
                    tree.setCursor(CapturedEventTree.this.treeItemCursor.getDefaultCursor());
                }
            }
        };
        this.selectedTreeItem = new SelectedTreeItem(){

            public void clear() {
                CapturedEventTree.this.redrawTreeItem(this.getTreeItem(), this.getColumnIndex());
                super.clear();
            }
        };
    }

    private void addTreeEventListeners() {
        this.getTree().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (CapturedEventTree.this.clipboard != null && !CapturedEventTree.this.clipboard.isDisposed()) {
                    CapturedEventTree.this.clipboard.dispose();
                }
                this.disposeResource((Resource)CapturedEventTree.this.treeItemForeground.getParamColor());
                this.disposeResource((Resource)CapturedEventTree.this.treeItemFont.getSelectedClassNameFont());
            }

            private void disposeResource(Resource resource) {
                if (resource != null && !resource.isDisposed()) {
                    resource.dispose();
                }
            }
        });
        this.getTree().addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                String text;
                CapturedEventTree.this.selectedClassNameTreeItem.clear();
                if ((e.stateMask & 0x40000) != 262144) {
                    return;
                }
                TreeItem item = CapturedEventTree.this.getTree().getItem(new Point(e.x, e.y));
                int index = CapturedEventTree.this.getSelectedColumnIndex(item, e.x, e.y);
                if (index > 0 && item.getParentItem() == null && JDTUtils.containsClassName(text = item.getText(index))) {
                    CapturedEventTree.this.selectedClassNameTreeItem.setText(text);
                    CapturedEventTree.this.selectedClassNameTreeItem.setColumnIndex(index);
                    CapturedEventTree.this.selectedClassNameTreeItem.setTreeItem(item);
                    CapturedEventTree.this.getTree().setCursor(CapturedEventTree.this.treeItemCursor.getPointerCursor());
                    CapturedEventTree.this.redrawTreeItem(item, index);
                }
            }
        });
        this.getTree().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                TreeItem item = CapturedEventTree.this.getTree().getItem(new Point(e.x, e.y));
                CapturedEventTree.this.updateSelectedTreeItem(item, CapturedEventTree.this.getSelectedColumnIndex(item, e.x, e.y));
                if (CapturedEventTree.this.listener != null && (e.stateMask & 0x40000) == 262144 && CapturedEventTree.this.selectedClassNameTreeItem.getText() != null) {
                    CapturedEventTree.this.listener.treeItemWithClassNameClicked(CapturedEventTree.this.selectedClassNameTreeItem.getText());
                }
            }
        });
        this.getTree().addListener(40, new Listener(){

            public void handleEvent(Event event) {
                if ((event.detail & 0x10) == 16) {
                    event.detail &= 0xFFFFFFEF;
                }
                if ((event.detail & 2) == 2) {
                    event.detail &= 0xFFFFFFFD;
                }
            }
        });
        this.getTree().addListener(42, new Listener(){

            public void handleEvent(Event event) {
                TreeItem item = (TreeItem)event.item;
                String text = item.getText(event.index);
                int xOffset = item.getParentItem() != null ? 10 : 2;
                Rectangle rec = item.getBounds(event.index);
                event.gc.setFont(CapturedEventTree.this.getFont(item, event.index));
                event.gc.setForeground(CapturedEventTree.this.getForeground(item, event.index));
                event.gc.setBackground(CapturedEventTree.this.getBackground(item, event.index));
                event.gc.fillRectangle(rec.x, rec.y, rec.width, rec.height);
                event.gc.drawText(text, event.x + xOffset, event.y, true);
            }
        });
        this.getTree().addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                String text = CapturedEventTree.this.selectedTreeItem.getText();
                if (text == null || (e.stateMask & 0x40000) != 262144) {
                    return;
                }
                if (e.keyCode == 99 && text.trim().length() > 0) {
                    CapturedEventTree.this.clipboard.setContents(new Object[]{text}, new Transfer[]{TextTransfer.getInstance()});
                } else if (e.keyCode == 0x1000003) {
                    CapturedEventTree.this.updateSelectedTreeItem(CapturedEventTree.this.selectedTreeItem.getTreeItem(), Math.max(0, CapturedEventTree.this.selectedTreeItem.getColumnIndex() - 1));
                } else if (e.keyCode == 0x1000004) {
                    CapturedEventTree.this.updateSelectedTreeItem(CapturedEventTree.this.selectedTreeItem.getTreeItem(), Math.min(CapturedEventTree.this.getTree().getColumnCount() - 1, CapturedEventTree.this.selectedTreeItem.getColumnIndex() + 1));
                }
            }

            public void keyReleased(KeyEvent e) {
                CapturedEventTree.this.selectedClassNameTreeItem.clear();
            }
        });
        this.getTree().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if ((e.stateMask & 0x80000) != 524288) {
                    CapturedEventTree.this.updateSelectedTreeItem((TreeItem)e.item, CapturedEventTree.this.selectedTreeItem.getText() != null ? CapturedEventTree.this.selectedTreeItem.getColumnIndex() : 0);
                }
            }
        });
        this.getTree().addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                CapturedEventTree.this.selectedClassNameTreeItem.clear();
            }
        });
    }

    private void updateSelectedTreeItem(TreeItem item, int columnIndex) {
        if (columnIndex > -1) {
            this.selectedTreeItem.clear();
            this.selectedTreeItem.setTreeItem(item);
            this.selectedTreeItem.setColumnIndex(columnIndex);
            this.selectedTreeItem.setText(item.getText(columnIndex));
            this.redrawTreeItem(item, columnIndex);
        }
    }

    private Color getForeground(TreeItem item, int index) {
        if (this.selectedTreeItem.getTreeItem() == item && this.selectedTreeItem.getColumnIndex() == index) {
            return this.treeItemForeground.getSelectedColor();
        }
        if (item.getParentItem() != null) {
            return this.treeItemForeground.getParamColor();
        }
        return this.treeItemForeground.getDefaultColor();
    }

    private Color getBackground(TreeItem item, int index) {
        if (this.selectedTreeItem.getTreeItem() == item && this.selectedTreeItem.getColumnIndex() == index) {
            return this.treeItemBackground.getSelectedColor();
        }
        return this.treeItemBackground.getDefaultColor();
    }

    private Font getFont(TreeItem item, int columnIndex) {
        if (this.selectedClassNameTreeItem.getTreeItem() == item && this.selectedClassNameTreeItem.getColumnIndex() == columnIndex) {
            return this.treeItemFont.getSelectedClassNameFont();
        }
        return this.treeItemFont.getDefaultFont();
    }

    private void redrawTreeItem(TreeItem item, int columnIndex) {
        if (item != null && !item.isDisposed()) {
            Rectangle rec = item.getBounds(columnIndex);
            this.getTree().redraw(rec.x, rec.y, rec.width, rec.height, true);
        }
    }

    private int getSelectedColumnIndex(TreeItem item, int mouseX, int mouseY) {
        int i = 0;
        while (item != null && i < this.getTree().getColumnCount()) {
            Rectangle rec = item.getBounds(i);
            if (mouseX >= rec.x && mouseX <= rec.x + rec.width) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void addEvent(CapturedEvent event) {
        this.capturedEvents.add((Object)event);
    }

    public void setListener(ICapturedEventTreeListener listener) {
        this.listener = listener;
    }

    public void removeAll() {
        this.capturedEvents.clear();
    }

    private static class CapturedEventsObservableFactory
    implements IObservableFactory {
        private CapturedEventsObservableFactory() {
        }

        public IObservable createObservable(Object target) {
            if (target instanceof IObservableList) {
                return (IObservableList)target;
            }
            if (target instanceof CapturedEvent) {
                return PojoObservables.observeList((Object)target, (String)"parameters");
            }
            return null;
        }
    }

    private static class CapturedEventsTreeStructureAdvisor
    extends TreeStructureAdvisor {
        private CapturedEventsTreeStructureAdvisor() {
        }

        public Boolean hasChildren(Object element) {
            if (element instanceof CapturedEvent) {
                return !((CapturedEvent)element).getParameters().isEmpty();
            }
            return false;
        }
    }

    private static class SelectedTreeItem {
        private TreeItem treeItem;
        private int columnIndex;
        private String text;

        public SelectedTreeItem() {
            this.clear();
        }

        public void setTreeItem(TreeItem treeItem) {
            this.treeItem = treeItem;
        }

        public TreeItem getTreeItem() {
            return this.treeItem;
        }

        public void setColumnIndex(int columnIndex) {
            this.columnIndex = columnIndex;
        }

        public int getColumnIndex() {
            return this.columnIndex;
        }

        public void setText(String text) {
            this.text = text;
        }

        public String getText() {
            return this.text;
        }

        public void clear() {
            this.treeItem = null;
            this.columnIndex = -1;
            this.text = null;
        }
    }

    private static class TreeItemBackground {
        private final Color selectedColor;
        private final Color defaultColor;

        public TreeItemBackground(Color selectedColor, Color defaultColor) {
            this.selectedColor = selectedColor;
            this.defaultColor = defaultColor;
        }

        public Color getSelectedColor() {
            return this.selectedColor;
        }

        public Color getDefaultColor() {
            return this.defaultColor;
        }
    }

    private static class TreeItemCursor {
        private final Cursor defaultCursor;
        private final Cursor pointerCursor;

        public TreeItemCursor(Cursor defaultCursor, Cursor pointerCursor) {
            this.defaultCursor = defaultCursor;
            this.pointerCursor = pointerCursor;
        }

        public Cursor getDefaultCursor() {
            return this.defaultCursor;
        }

        public Cursor getPointerCursor() {
            return this.pointerCursor;
        }
    }

    private static class TreeItemFont {
        private final Font defaultFont;
        private final Font selectedClassNameFont;

        public TreeItemFont(Font defaultFont, Font selectedClassNameFont) {
            this.defaultFont = defaultFont;
            this.selectedClassNameFont = selectedClassNameFont;
        }

        public Font getDefaultFont() {
            return this.defaultFont;
        }

        public Font getSelectedClassNameFont() {
            return this.selectedClassNameFont;
        }
    }

    private static class TreeItemForeground {
        private final Color paramColor;
        private final Color selectedColor;
        private final Color defaultColor;

        public TreeItemForeground(Color paramColor, Color selectedColor, Color defaultColor) {
            this.paramColor = paramColor;
            this.selectedColor = selectedColor;
            this.defaultColor = defaultColor;
        }

        public Color getParamColor() {
            return this.paramColor;
        }

        public Color getSelectedColor() {
            return this.selectedColor;
        }

        public Color getDefaultColor() {
            return this.defaultColor;
        }
    }
}

