/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.css.swt.properties.css2;

import org.eclipse.e4.ui.css.core.dom.properties.css2.AbstractCSSPropertyClassificationHandler;
import org.eclipse.e4.ui.css.core.dom.properties.css2.ICSSPropertyClassificationHandler;
import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.css.swt.helpers.SWTElementHelpers;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.widgets.Control;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.w3c.dom.css.CSSValue;

public class CSSPropertyClassificationSWTHandler
extends AbstractCSSPropertyClassificationHandler {
    public static final ICSSPropertyClassificationHandler INSTANCE = new CSSPropertyClassificationSWTHandler();

    public boolean applyCSSProperty(Object element, String property, CSSValue value, String pseudo, CSSEngine engine) throws Exception {
        Control control = SWTElementHelpers.getControl(element);
        if (control != null) {
            super.applyCSSProperty((Object)control, property, value, pseudo, engine);
            return true;
        }
        return false;
    }

    public String retrieveCSSProperty(Object element, String property, String pseudo, CSSEngine engine) throws Exception {
        Control control = SWTElementHelpers.getControl(element);
        if (control != null) {
            return super.retrieveCSSProperty((Object)control, property, pseudo, engine);
        }
        return null;
    }

    public void applyCSSPropertyCursor(Object element, CSSValue value, String pseudo, CSSEngine engine) throws Exception {
        if (value.getCssValueType() == 1) {
            Control control = (Control)element;
            Cursor cursor = (Cursor)engine.convert(value, Cursor.class, (Object)control.getDisplay());
            control.setCursor(cursor);
        }
    }

    public void applyCSSPropertyVisibility(Object element, CSSValue value, String pseudo, CSSEngine engine) throws Exception {
        if (value.getCssValueType() == 1) {
            Control control = (Control)element;
            CSSPrimitiveValue primitiveValue = (CSSPrimitiveValue)value;
            String visibility = primitiveValue.getStringValue();
            if ("hidden".equals(visibility)) {
                control.setVisible(false);
            } else if ("collapse".equals(visibility)) {
                control.setVisible(false);
            } else {
                control.setVisible(true);
            }
        }
    }

    public String retrieveCSSPropertyCursor(Object element, String pseudo, CSSEngine engine) throws Exception {
        Control control = (Control)element;
        Cursor cursor = null;
        try {
            cursor = control.getCursor();
        }
        catch (Throwable throwable) {}
        return engine.convert((Object)cursor, Cursor.class, null);
    }

    public String retrieveCSSPropertyVisibility(Object element, String pseudo, CSSEngine engine) throws Exception {
        return "visible";
    }
}

