/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.databinding.swt;

import java.util.Calendar;
import java.util.Date;
import org.eclipse.jface.databinding.swt.WidgetValueProperty;
import org.eclipse.swt.widgets.DateTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DateTimeSelectionProperty
extends WidgetValueProperty<DateTime, Date> {
    private static final ThreadLocal<Calendar> calendar = new ThreadLocal<Calendar>(){

        @Override
        protected Calendar initialValue() {
            return Calendar.getInstance();
        }
    };

    public DateTimeSelectionProperty() {
        super(13);
    }

    public Object getValueType() {
        return Date.class;
    }

    protected Date doGetValue(DateTime dateTime) {
        Calendar cal = calendar.get();
        cal.clear();
        if ((dateTime.getStyle() & 0x80) != 0) {
            cal.set(11, dateTime.getHours());
            cal.set(12, dateTime.getMinutes());
            cal.set(13, dateTime.getSeconds());
        } else {
            cal.set(1, dateTime.getYear());
            cal.set(2, dateTime.getMonth());
            cal.set(5, dateTime.getDay());
        }
        return cal.getTime();
    }

    protected void doSetValue(DateTime dateTime, Date value) {
        if (value == null) {
            throw new IllegalArgumentException("Cannot set null selection on DateTime");
        }
        Calendar cal = calendar.get();
        cal.setTime(value);
        if ((dateTime.getStyle() & 0x80) != 0) {
            dateTime.setTime(cal.get(11), cal.get(12), cal.get(13));
        } else {
            dateTime.setDate(cal.get(1), cal.get(2), cal.get(5));
        }
    }
}

