/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.destprefs.test.unit;

import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.platform.discovery.destprefs.internal.DestinationsManager;
import org.eclipse.platform.discovery.destprefs.internal.IPreferenceDialogCreator;
import org.eclipse.platform.discovery.destprefs.internal.xpparser.ISearchDestinationsConfiguratorDescription;
import org.eclipse.platform.discovery.destprefs.internal.xpparser.SearchDestinationsConfiguratorXPParser;
import org.eclipse.platform.discovery.runtime.internal.ISearchProviderConfiguration;
import org.eclipse.platform.discovery.runtime.internal.SearchProviderConfigurationFactory;
import org.eclipse.platform.discovery.runtime.internal.model.descriptions.IDestinationCategoryDescription;
import org.eclipse.platform.discovery.runtime.internal.xp.impl.AbstractExtensionPointParser;
import org.eclipse.platform.discovery.testutils.utils.registry.ExtensionRegistryBuilder;
import org.eclipse.swt.widgets.Shell;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class DestinationsManagerTest {
    private static final String PREFPAGE_ID = "prefpage_id";
    private static final String DEST_CATEGORY_ID = "category";
    private DestinationsManager destinationsManager;
    @Mock
    private AbstractExtensionPointParser<ISearchDestinationsConfiguratorDescription> destConfigurator;
    @Mock
    private IPreferenceDialogCreator preferenceDialogCreator;
    @Mock
    private Shell shell;
    private ExtensionRegistryBuilder registryBuilder;
    private ISearchProviderConfiguration searchConfig;

    @Before
    public void setup() {
        MockitoAnnotations.initMocks((Object)this);
        this.registryBuilder = new ExtensionRegistryBuilder();
    }

    @Test
    public void noPreferencePages() {
        IExtensionRegistry registry = this.registryBuilder.getRegistry();
        this.init(registry);
        this.destinationsManager.manageDestinations(this.shell, null);
        ((IPreferenceDialogCreator)Mockito.verify((Object)this.preferenceDialogCreator)).openPreferenceDialog((Shell)Matchers.same((Object)this.shell), (String)Matchers.eq((Object)"org.eclipse.platform.discovery.destprefs.preferencepage"), (String[])Matchers.argThat((Matcher)org.eclipse.platform.discovery.testutils.utils.matchers.Matchers.arrayEqualsWithoutOrder((Object[])new String[]{"org.eclipse.platform.discovery.destprefs.preferencepage"})));
    }

    @Test
    public void onePreferencePageNoSelection() {
        this.registryBuilder.addDestinationCategory(DEST_CATEGORY_ID, DEST_CATEGORY_ID);
        this.registryBuilder.addDestinationsProvider("destprovider", DEST_CATEGORY_ID, PREFPAGE_ID, "foo", null);
        IExtensionRegistry registry = this.registryBuilder.getRegistry();
        this.init(registry);
        this.destinationsManager.manageDestinations(this.shell, null);
        ((IPreferenceDialogCreator)Mockito.verify((Object)this.preferenceDialogCreator)).openPreferenceDialog((Shell)Matchers.same((Object)this.shell), (String)Matchers.eq((Object)"org.eclipse.platform.discovery.destprefs.preferencepage"), (String[])Matchers.argThat((Matcher)org.eclipse.platform.discovery.testutils.utils.matchers.Matchers.arrayEqualsWithoutOrder((Object[])new String[]{"org.eclipse.platform.discovery.destprefs.preferencepage", PREFPAGE_ID})));
    }

    @Test
    public void onePreferencePageAndDestCategorySelected() {
        this.registryBuilder.addDestinationCategory(DEST_CATEGORY_ID, DEST_CATEGORY_ID);
        this.registryBuilder.addDestinationsProvider("destprovider", DEST_CATEGORY_ID, PREFPAGE_ID, "foo", null);
        IExtensionRegistry registry = this.registryBuilder.getRegistry();
        this.init(registry);
        IDestinationCategoryDescription category = this.getCategory(DEST_CATEGORY_ID);
        this.destinationsManager.manageDestinations(this.shell, category);
        ((IPreferenceDialogCreator)Mockito.verify((Object)this.preferenceDialogCreator)).openPreferenceDialog((Shell)Matchers.same((Object)this.shell), (String)Matchers.eq((Object)PREFPAGE_ID), (String[])Matchers.argThat((Matcher)org.eclipse.platform.discovery.testutils.utils.matchers.Matchers.arrayEqualsWithoutOrder((Object[])new String[]{"org.eclipse.platform.discovery.destprefs.preferencepage", PREFPAGE_ID})));
    }

    @Test
    public void oneDestinationNoPreferencePageAndDestCategorySelected() {
        this.registryBuilder.addDestinationCategory(DEST_CATEGORY_ID, DEST_CATEGORY_ID);
        this.registryBuilder.addDestinationsProvider("destprovider", DEST_CATEGORY_ID, null, "foo", null);
        IExtensionRegistry registry = this.registryBuilder.getRegistry();
        this.init(registry);
        IDestinationCategoryDescription category = this.getCategory(DEST_CATEGORY_ID);
        this.destinationsManager.manageDestinations(this.shell, category);
        ((IPreferenceDialogCreator)Mockito.verify((Object)this.preferenceDialogCreator)).openPreferenceDialog((Shell)Matchers.same((Object)this.shell), (String)Matchers.eq((Object)"org.eclipse.platform.discovery.destprefs.preferencepage"), (String[])Matchers.argThat((Matcher)org.eclipse.platform.discovery.testutils.utils.matchers.Matchers.arrayEqualsWithoutOrder((Object[])new String[]{"org.eclipse.platform.discovery.destprefs.preferencepage"})));
    }

    @Test
    public void oneConfiguratorNoSelection() {
        this.registryBuilder.addDestinationCategory(DEST_CATEGORY_ID, DEST_CATEGORY_ID);
        this.registryBuilder.addDestinationsProvider("destprovider", DEST_CATEGORY_ID, null, "foo", null);
        this.registryBuilder.addSearchDestinationsConfigurator("configurator", "destprovider", "bar", null);
        IExtensionRegistry registry = this.registryBuilder.getRegistry();
        this.init(registry);
        this.destinationsManager.manageDestinations(this.shell, null);
        ((IPreferenceDialogCreator)Mockito.verify((Object)this.preferenceDialogCreator)).openPreferenceDialog((Shell)Matchers.same((Object)this.shell), (String)Matchers.eq((Object)"org.eclipse.platform.discovery.destprefs.preferencepage"), (String[])Matchers.argThat((Matcher)org.eclipse.platform.discovery.testutils.utils.matchers.Matchers.arrayEqualsWithoutOrder((Object[])new String[]{"org.eclipse.platform.discovery.destprefs.preferencepage"})));
    }

    @Test
    public void oneConfiguratorAndDestCategorySelected() {
        this.registryBuilder.addDestinationCategory(DEST_CATEGORY_ID, DEST_CATEGORY_ID);
        this.registryBuilder.addDestinationsProvider("destprovider", DEST_CATEGORY_ID, null, "foo", null);
        this.registryBuilder.addSearchDestinationsConfigurator("configurator", "destprovider", "bar", null);
        IExtensionRegistry registry = this.registryBuilder.getRegistry();
        this.init(registry);
        IDestinationCategoryDescription category = this.getCategory(DEST_CATEGORY_ID);
        this.destinationsManager.manageDestinations(this.shell, category);
        ((IPreferenceDialogCreator)Mockito.verify((Object)this.preferenceDialogCreator)).openPreferenceDialog((Shell)Matchers.same((Object)this.shell), (String)Matchers.eq((Object)"org.eclipse.platform.discovery.destprefs.preferencepage"), (String[])Matchers.argThat((Matcher)org.eclipse.platform.discovery.testutils.utils.matchers.Matchers.arrayEqualsWithoutOrder((Object[])new String[]{"org.eclipse.platform.discovery.destprefs.preferencepage"})));
    }

    @Test
    public void configuratorTakesPrecedenceOverPrefPage() {
        this.registryBuilder.addDestinationCategory(DEST_CATEGORY_ID, DEST_CATEGORY_ID);
        this.registryBuilder.addDestinationsProvider("destprovider", DEST_CATEGORY_ID, PREFPAGE_ID, "foo", null);
        this.registryBuilder.addSearchDestinationsConfigurator("configurator", "destprovider", "bar", null);
        IExtensionRegistry registry = this.registryBuilder.getRegistry();
        this.init(registry);
        IDestinationCategoryDescription category = this.getCategory(DEST_CATEGORY_ID);
        this.destinationsManager.manageDestinations(this.shell, category);
        ((IPreferenceDialogCreator)Mockito.verify((Object)this.preferenceDialogCreator)).openPreferenceDialog((Shell)Matchers.same((Object)this.shell), (String)Matchers.eq((Object)"org.eclipse.platform.discovery.destprefs.preferencepage"), (String[])Matchers.argThat((Matcher)org.eclipse.platform.discovery.testutils.utils.matchers.Matchers.arrayEqualsWithoutOrder((Object[])new String[]{"org.eclipse.platform.discovery.destprefs.preferencepage", PREFPAGE_ID})));
    }

    private IDestinationCategoryDescription getCategory(String destCategoryId) {
        for (IDestinationCategoryDescription desc : this.searchConfig.getDestinationCategories()) {
            if (!desc.getId().equals(destCategoryId)) continue;
            return desc;
        }
        Assert.fail((String)("dest category not found:" + destCategoryId));
        return null;
    }

    private void init(IExtensionRegistry registry) {
        this.searchConfig = new SearchProviderConfigurationFactory().getSearchProviderConfiguration(registry);
        this.destinationsManager = new DestinationsManager((AbstractExtensionPointParser)new SearchDestinationsConfiguratorXPParser(registry), this.preferenceDialogCreator, this.searchConfig);
    }
}

