/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.runtime.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.platform.discovery.runtime.api.IConflict;
import org.eclipse.platform.discovery.runtime.api.ISearchSubdestination;
import org.eclipse.platform.discovery.runtime.internal.ISubdestinationsActivationConfig;
import org.eclipse.platform.discovery.runtime.internal.model.descriptions.IDestinationCategoryDescription;
import org.eclipse.platform.discovery.runtime.internal.model.descriptions.IObjectTypeDescription;
import org.eclipse.platform.discovery.runtime.internal.model.descriptions.ISearchProviderDescription;
import org.eclipse.platform.discovery.runtime.internal.xp.ISearchSubdestinationExtensionParser;

public class SubdestinationsActivationConfig
implements ISubdestinationsActivationConfig {
    private final ISearchSubdestinationExtensionParser subdestinationsParser;
    private final Map<String, Boolean> checkedState = new HashMap<String, Boolean>();
    private final Map<String, List<String>> conflictsMap = new HashMap<String, List<String>>();

    public SubdestinationsActivationConfig(ISearchSubdestinationExtensionParser subdestinationsParser) {
        this.subdestinationsParser = subdestinationsParser;
    }

    @Override
    public void activateSubdestination(IObjectTypeDescription searchObjectType, IDestinationCategoryDescription destinationCategory, ISearchProviderDescription searchProviderDescription, ISearchSubdestination subDestination, boolean activate) {
        List<ISearchSubdestination> availableSearchSubdestinations = this.getAvailableSearchSubdestinations(searchObjectType, destinationCategory, searchProviderDescription);
        Map<String, ISearchSubdestination> subdMap = this.getIdToSubdestinationMap(availableSearchSubdestinations);
        if (activate) {
            List<Object> conflicts;
            if (this.conflictsMap.containsKey(subDestination.getId())) {
                conflicts = this.conflictsMap.get(subDestination.getId());
                for (String string : conflicts) {
                    this.checkedState.put(string, false);
                }
            } else {
                conflicts = new LinkedList();
                for (IConflict iConflict : subDestination.getConflictingSubd()) {
                    conflicts.add(iConflict.getconflictingSubdID());
                    if (!this.checkedState.containsKey(iConflict.getconflictingSubdID())) continue;
                    this.checkedState.put(iConflict.getconflictingSubdID(), false);
                }
                for (String string : subdMap.keySet()) {
                    LinkedList<String> otherConflicts = new LinkedList<String>();
                    if (this.checkedState.get(string) == null || !this.checkedState.get(string).booleanValue()) continue;
                    ISearchSubdestination otherSubD = subdMap.get(string);
                    assert (otherSubD != null);
                    for (IConflict conflict : otherSubD.getConflictingSubd()) {
                        otherConflicts.add(conflict.getconflictingSubdID());
                        if (!conflict.getconflictingSubdID().equals(subDestination.getId())) continue;
                        conflicts.add(otherSubD.getId());
                        this.checkedState.put(otherSubD.getId(), false);
                    }
                    this.conflictsMap.put(string, otherConflicts);
                }
                this.conflictsMap.put(subDestination.getId(), conflicts);
            }
        }
        for (ISearchSubdestination sd : availableSearchSubdestinations) {
            if (!sd.getId().equals(subDestination.getId())) continue;
            this.checkedState.put(sd.getId(), activate);
        }
    }

    @Override
    public List<ISearchSubdestination> getAvailableSearchSubdestinations(IObjectTypeDescription objectType, IDestinationCategoryDescription destinationCategory, ISearchProviderDescription searchProvider) {
        ArrayList<ISearchSubdestination> result = new ArrayList<ISearchSubdestination>();
        for (ISearchSubdestination subDest : this.subdestinationsParser.readContributions()) {
            if (!subDest.getObjectTypeId().equals(objectType.getId()) || !subDest.getDestinationCategoryId().equals(destinationCategory.getId())) continue;
            result.add(subDest);
        }
        return result;
    }

    @Override
    public boolean isSubdestinationActive(ISearchSubdestination subdestination, IObjectTypeDescription objectType, IDestinationCategoryDescription destCategory, ISearchProviderDescription searchProvider) {
        Boolean active = this.checkedState.get(subdestination.getId());
        if (active != null) {
            return active;
        }
        this.activateSubdestination(objectType, destCategory, searchProvider, subdestination, subdestination.isDefaultSelected());
        active = this.checkedState.get(subdestination.getId());
        return active == null ? false : active;
    }

    private Map<String, ISearchSubdestination> getIdToSubdestinationMap(List<ISearchSubdestination> subdestinations) {
        HashMap<String, ISearchSubdestination> retVal = new HashMap<String, ISearchSubdestination>();
        for (ISearchSubdestination current : subdestinations) {
            retVal.put(current.getId(), current);
        }
        return retVal;
    }
}

