/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.ui.test.comp.internal;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import junit.framework.Assert;
import org.eclipse.platform.discovery.runtime.api.ISearchDestination;
import org.eclipse.platform.discovery.runtime.api.ISearchSubdestination;
import org.eclipse.platform.discovery.runtime.internal.ISearchProviderConfiguration;
import org.eclipse.platform.discovery.runtime.internal.ProviderNotFoundException;
import org.eclipse.platform.discovery.runtime.internal.model.descriptions.IDestinationCategoryDescription;
import org.eclipse.platform.discovery.runtime.internal.model.descriptions.IObjectTypeDescription;
import org.eclipse.platform.discovery.runtime.internal.model.descriptions.ISearchProviderDescription;
import org.eclipse.platform.discovery.ui.api.ISearchParametersUI;
import org.eclipse.platform.discovery.ui.test.comp.internal.pageobjects.SubdestinationsSelectorPageObject;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class SubdestinationsSelectorTest {
    @Mock
    private ISearchProviderConfiguration providerConfiguration;
    @Mock
    private IObjectTypeDescription searchObjectType;
    @Mock
    private IDestinationCategoryDescription destinationCategory;
    @Mock
    private ISearchProviderDescription searchProviderDescription;
    @Mock
    private ISearchSubdestination subDestination_1;
    @Mock
    private ISearchSubdestination subDestination_2;
    @Mock
    private ISearchSubdestination subDestination_3;
    @Mock
    private ISearchDestination searchDestination;
    private static final String SUBDESTINATION_NAME_1 = "Subdestination 1";
    private static final String SUBDESTINATION_NAME_2 = "Subdestination 2";
    private static final String SUBDESTINATION_NAME_3 = "Subdestination 3";
    private SubdestinationsSelectorPageObject subdestinationsSelector;
    private Map<ISearchSubdestination, Boolean> subdestinationsActivationState;

    @Before
    public void setUp() throws ProviderNotFoundException {
        MockitoAnnotations.initMocks((Object)this);
        this.subdestinationsActivationState = new HashMap<ISearchSubdestination, Boolean>();
        this.setupSubdestinations();
        this.setupProviderConfiguration();
        this.subdestinationsSelector = new SubdestinationsSelectorPageObject(this.createConsoleContext());
    }

    @After
    public void tearDown() {
        this.subdestinationsSelector.close();
    }

    private ISearchParametersUI.IConsoleContext createConsoleContext() {
        ISearchParametersUI.IConsoleContext context = (ISearchParametersUI.IConsoleContext)Mockito.mock(ISearchParametersUI.IConsoleContext.class);
        Mockito.stub((Object)context.destinationCategory()).toReturn((Object)this.destinationCategory);
        Mockito.stub((Object)context.searchDestination()).toReturn((Object)this.searchDestination);
        Mockito.stub((Object)context.searchProvider()).toReturn((Object)this.searchProviderDescription);
        Mockito.stub((Object)context.searchProviderConfiguration()).toReturn((Object)this.providerConfiguration);
        Mockito.stub((Object)context.selectedObjectType()).toReturn((Object)this.searchObjectType);
        ((ISearchParametersUI.IConsoleContext)Mockito.doAnswer((Answer)new ActivationChangeAnswer()).when((Object)context)).notifySubdestinationActivationChange((ISearchSubdestination)Mockito.isA(ISearchSubdestination.class), Mockito.anyBoolean());
        return context;
    }

    private void setupSubdestinations() {
        Mockito.stub((Object)this.subDestination_1.getDisplayName()).toReturn((Object)SUBDESTINATION_NAME_1);
        Mockito.stub((Object)this.subDestination_2.getDisplayName()).toReturn((Object)SUBDESTINATION_NAME_2);
        Mockito.stub((Object)this.subDestination_3.getDisplayName()).toReturn((Object)SUBDESTINATION_NAME_3);
    }

    private void setupProviderConfiguration() throws ProviderNotFoundException {
        List<ISearchSubdestination> subDestinations = Arrays.asList(this.subDestination_1, this.subDestination_2, this.subDestination_3);
        Mockito.stub((Object)this.providerConfiguration.getAvailableSearchSubdestinations(this.searchObjectType, this.destinationCategory, this.searchProviderDescription)).toReturn(subDestinations);
        Mockito.when((Object)this.providerConfiguration.isSubdestinationActive((ISearchSubdestination)Mockito.isA(ISearchSubdestination.class), (IObjectTypeDescription)Mockito.same((Object)this.searchObjectType), (IDestinationCategoryDescription)Mockito.same((Object)this.destinationCategory), (ISearchProviderDescription)Mockito.same((Object)this.searchProviderDescription))).thenAnswer((Answer)new Answer<Boolean>(){

            public Boolean answer(InvocationOnMock invocation) throws Throwable {
                ISearchSubdestination subdest = (ISearchSubdestination)invocation.getArguments()[0];
                Boolean isActive = (Boolean)SubdestinationsSelectorTest.this.subdestinationsActivationState.get(subdest);
                return isActive == null ? false : isActive;
            }
        });
    }

    @Test
    public void testAllSubdestinationsAreShown() {
        this.subdestinationsSelector.open();
        this.verifySubdestinationDisplayed(SUBDESTINATION_NAME_1);
        this.verifySubdestinationDisplayed(SUBDESTINATION_NAME_2);
        this.verifySubdestinationDisplayed(SUBDESTINATION_NAME_3);
    }

    @Test
    public void testInitiallySelectedSubdestinationsAreChecked() {
        this.setActive(this.subDestination_1, true);
        this.setActive(this.subDestination_2, false);
        this.setActive(this.subDestination_3, true);
        this.subdestinationsSelector.open();
        Assert.assertTrue((String)"Subdestination 1 should be selected", (boolean)this.subdestinationsSelector.isSelected(SUBDESTINATION_NAME_1));
        Assert.assertFalse((String)"Subdestination 2 should be selected", (boolean)this.subdestinationsSelector.isSelected(SUBDESTINATION_NAME_2));
        Assert.assertTrue((String)"Subdestination 3 should not be selected", (boolean)this.subdestinationsSelector.isSelected(SUBDESTINATION_NAME_3));
    }

    @Test
    public void testToggleSelectedSubdestination() {
        this.setActive(this.subDestination_1, true);
        this.subdestinationsSelector.open();
        this.subdestinationsSelector.toggle(SUBDESTINATION_NAME_1);
        this.verifySubdestinationActivationSet(this.subDestination_1, false);
    }

    @Test
    public void testToggleUnselectedSubdestinations() {
        this.setActive(this.subDestination_3, false);
        this.subdestinationsSelector.open();
        this.subdestinationsSelector.toggle(SUBDESTINATION_NAME_3);
        this.verifySubdestinationActivationSet(this.subDestination_3, true);
    }

    @Test
    public void testSelectWithConflicting() {
        this.setActive(this.subDestination_1, true);
        this.setActive(this.subDestination_2, false);
        this.subdestinationsSelector.open();
        this.subdestinationsSelector.toggle(SUBDESTINATION_NAME_2);
        Assert.assertFalse((String)"Button for subd1 should be deselected because it conflicts with subd2", (boolean)this.subdestinationsSelector.isSelected(SUBDESTINATION_NAME_1));
        Assert.assertTrue((String)"Button for subd2 should be selected", (boolean)this.subdestinationsSelector.isSelected(SUBDESTINATION_NAME_2));
    }

    private void verifySubdestinationDisplayed(String subdestinationName) {
        Assert.assertTrue((String)MessageFormat.format("Subdestination {0} not displayed", subdestinationName), (boolean)this.subdestinationsSelector.isDisplayed(subdestinationName));
    }

    private void verifySubdestinationActivationSet(ISearchSubdestination subDestination, Boolean expectedState) {
        Assert.assertEquals((String)MessageFormat.format("Unexpected subdestination {0} activation state", subDestination.getDisplayName()), (Object)expectedState, (Object)this.subdestinationsActivationState.get(subDestination));
    }

    private void setActive(ISearchSubdestination subd, boolean activationState) {
        this.subdestinationsActivationState.put(subd, activationState);
    }

    private class ActivationChangeAnswer
    implements Answer<Void> {
        private ActivationChangeAnswer() {
        }

        public Void answer(InvocationOnMock invocation) throws Throwable {
            ISearchSubdestination subdest = (ISearchSubdestination)invocation.getArguments()[0];
            SubdestinationsSelectorTest.this.subdestinationsActivationState.put(subdest, (Boolean)invocation.getArguments()[1]);
            if (subdest == SubdestinationsSelectorTest.this.subDestination_2) {
                SubdestinationsSelectorTest.this.subdestinationsActivationState.put(SubdestinationsSelectorTest.this.subDestination_1, false);
            }
            return null;
        }
    }
}

